/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.AttributeStripper;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.ElementSkipperFactory;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.RunPropertyFactory;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class RunPropertiesParser {
    private StartElement startEvent;
    private XMLEventReader events;
    private ConditionalParameters params;
    private StartElement runPropsStartElement;
    private EndElement runPropsEndElement;
    private List<RunProperty> runProperties = new ArrayList<RunProperty>();
    private XMLEventFactory eventFactory;
    private ElementSkipper generalElementSkipper;

    RunPropertiesParser(StartElement startEvent, XMLEventReader events, ConditionalParameters params, XMLEventFactory eventFactory) {
        this.startEvent = startEvent;
        this.events = events;
        this.params = params;
        this.eventFactory = eventFactory;
        this.generalElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(params, ElementSkipper.RevisionPropertySkippableElement.RUN_PROPERTIES_CHANGE, ElementSkipper.RunPropertySkippableElement.RUN_PROPERTY_LANGUAGE, ElementSkipper.RunPropertySkippableElement.RUN_PROPERTY_NO_SPELLING_OR_GRAMMAR);
    }

    RunProperties parse() throws XMLStreamException {
        this.startRunProps(AttributeStripper.GeneralAttributeStripper.stripGeneralAttributes(this.eventFactory, AttributeStripper.RevisionAttributeStripper.stripRunRevisionAttributes(this.eventFactory, this.startEvent)));
        while (this.events.hasNext()) {
            XMLEvent e = this.events.nextEvent();
            if (XMLEventHelpers.isEndElement(e, this.startEvent)) {
                this.endRunProps(e.asEndElement());
                return this.buildRunProperties();
            }
            if (e.isStartElement()) {
                if (this.generalElementSkipper.isSkippableElement(e.asStartElement())) {
                    this.generalElementSkipper.skipElement(this.events, e.asStartElement());
                    continue;
                }
                this.addRunProp(e.asStartElement(), this.events, this.isHiddenPropertyElement(e.asStartElement()));
                continue;
            }
            if (!e.isCharacters() || XMLEventHelpers.isWhitespace(e)) continue;
            throw new IllegalStateException("Discarding non-whitespace rPr characters " + e.asCharacters().getData());
        }
        throw new IllegalStateException("Invalid content? Unterminated run properties");
    }

    private void startRunProps(StartElement e) {
        this.runPropsStartElement = e;
        if (e.getName().getNamespaceURI().equals(Namespaces.DrawingML.getURI())) {
            Iterator<Attribute> attrs = e.getAttributes();
            while (attrs.hasNext()) {
                this.runProperties.add(RunPropertyFactory.createRunProperty(attrs.next()));
            }
        }
    }

    private void addRunProp(StartElement startEl, XMLEventReader events, boolean isHidden) throws XMLStreamException {
        this.runProperties.add(RunPropertyFactory.createRunProperty(this.eventFactory, startEl, events, isHidden));
    }

    private void endRunProps(EndElement e) {
        this.runPropsEndElement = e;
    }

    private RunProperties buildRunProperties() {
        if (this.runPropsStartElement == null) {
            return RunProperties.emptyRunProperties();
        }
        if (this.runPropsEndElement == null) {
            throw new IllegalStateException("Incomplete run property markup: " + this.runPropsStartElement.getName());
        }
        return new RunProperties.DefaultRunProperties(this.runPropsStartElement, this.runPropsEndElement, this.runProperties);
    }

    private boolean isHiddenPropertyElement(StartElement el) {
        String style;
        if (this.params.getTranslateWordHidden()) {
            return false;
        }
        if (el.getName().equals(XMLEventHelpers.WPML_PROPERTY_VANISH)) {
            return XMLEventHelpers.getBooleanAttributeValue(el, XMLEventHelpers.WPML_VAL, XMLEventHelpers.DEFAULT_BOOLEAN_ATTRIBUTE_TRUE_VALUE);
        }
        return el.getName().equals(XMLEventHelpers.RUN_STYLE) && (style = XMLEventHelpers.getAttributeValue(el, XMLEventHelpers.WPML_VAL)) != null && this.params.tsExcludeWordStyles.contains(style);
    }
}

