/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.SharedStringMap;

public class SharedStringsDenormalizer {
    private XMLEventFactory factory;
    private SharedStringMap sharedStringMap;
    private List<SharedString> stringData = new ArrayList<SharedString>();
    private static final QName TABLE = Namespaces.SpreadsheetML.getQName("sst");
    private static final QName ENTRY = Namespaces.SpreadsheetML.getQName("si");
    private static final QName COUNT_ATTR = new QName("count");
    private static final QName UNIQUE_ATTR = new QName("uniqueCount");

    public SharedStringsDenormalizer(XMLEventFactory factory, SharedStringMap sharedStringMap) {
        this.factory = factory;
        this.sharedStringMap = sharedStringMap;
    }

    public void process(XMLEventReader reader, XMLEventWriter writer) throws IOException, XMLStreamException {
        this.readTable(reader);
        this.writeTable(writer);
        writer.close();
    }

    private void readTable(XMLEventReader reader) throws XMLStreamException {
        SharedString currentSSI = null;
        int currentIndex = 0;
        while (reader.hasNext()) {
            XMLEvent el;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                el = event.asStartElement();
                if (ENTRY.equals(el.getName())) {
                    currentSSI = new SharedString(currentIndex++);
                }
                if (currentSSI == null) continue;
                currentSSI.addEvent(event);
                continue;
            }
            if (event.isEndElement()) {
                el = event.asEndElement();
                if (currentSSI != null) {
                    currentSSI.addEvent(event);
                }
                if (!ENTRY.equals(el.getName())) continue;
                this.stringData.add(currentSSI);
                currentSSI = null;
                continue;
            }
            if (!event.isCharacters() || currentSSI == null) continue;
            currentSSI.addEvent(event);
        }
    }

    private void writeTable(XMLEventWriter writer) throws XMLStreamException {
        writer.add(this.factory.createStartDocument("UTF-8", "1.0", true));
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        List<SharedStringMap.Entry> entries = this.sharedStringMap.getEntries();
        String count = String.valueOf(entries.size());
        attrs.add(this.factory.createAttribute(COUNT_ATTR, count));
        attrs.add(this.factory.createAttribute(UNIQUE_ATTR, count));
        StartElement sstStart = this.factory.createStartElement(TABLE, attrs.iterator(), Collections.singleton(this.factory.createNamespace(Namespaces.SpreadsheetML.getURI())).iterator());
        writer.add(sstStart);
        int newIndex = 0;
        for (SharedStringMap.Entry e : entries) {
            if (newIndex++ != e.getNewIndex()) {
                throw new IllegalStateException("Index mismatch: expected " + e.getNewIndex() + " found " + newIndex);
            }
            this.stringData.get(e.getOriginalIndex()).writeEvents(writer);
        }
        writer.add(this.factory.createEndElement(TABLE, null));
        writer.add(this.factory.createEndDocument());
    }

    static class SharedString {
        private List<XMLEvent> events = new ArrayList<XMLEvent>();
        private int originalIndex;

        SharedString(int originalIndex) {
            this.originalIndex = originalIndex;
        }

        void addEvent(XMLEvent e) {
            this.events.add(e);
        }

        void writeEvents(XMLEventWriter writer) throws XMLStreamException {
            for (XMLEvent e : this.events) {
                writer.add(e);
            }
        }

        public int getOriginalIndex() {
            return this.originalIndex;
        }
    }
}

