/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.Reader;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleType;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

public class WordProcessingStylesParser {
    private static final QName RPR_DEFAULT = Namespaces.WordProcessingML.getQName("rPrDefault");
    private static final QName RPR = Namespaces.WordProcessingML.getQName("rPr");
    private static final QName STYLE = Namespaces.WordProcessingML.getQName("style");
    private static final QName STYLE_TYPE = Namespaces.WordProcessingML.getQName("type");
    private static final QName STYLE_ID = Namespaces.WordProcessingML.getQName("styleId");
    private static final QName STYLE_DEFAULT = Namespaces.WordProcessingML.getQName("default");
    private static final QName STYLE_BASED_ON = Namespaces.WordProcessingML.getQName("basedOn");
    private static final QName STYLE_LINK = Namespaces.WordProcessingML.getQName("link");
    private static final EnumSet<StyleType> PARSABLE_STYLE_TYPES = EnumSet.range(StyleType.PARAGRAPH, StyleType.CHARACTER);
    private XMLEventFactory eventFactory;
    private XMLInputFactory inputFactory;
    private Reader reader;
    private ConditionalParameters conditionalParameters;

    public WordProcessingStylesParser(XMLEventFactory eventFactory, XMLInputFactory inputFactory, Reader reader, ConditionalParameters conditionalParameters) {
        this.eventFactory = eventFactory;
        this.inputFactory = inputFactory;
        this.reader = reader;
        this.conditionalParameters = conditionalParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleDefinitions parse() throws XMLStreamException, IOException {
        XMLEventReader eventReader = this.inputFactory.createXMLEventReader(this.reader);
        RunProperties documentDefaultRunProperties = null;
        EnumMap<StyleType, String> defaultStylesByStyleTypes = new EnumMap<StyleType, String>(StyleType.class);
        HashMap<String, StyleType> styleTypesByStyleIds = new HashMap<String, StyleType>();
        HashMap<String, String> parentStylesByStyleIds = new HashMap<String, String>();
        HashMap<String, String> linkedStylesByStyleIds = new HashMap<String, String>();
        HashMap<String, RunProperties> runPropertiesByStyleIds = new HashMap<String, RunProperties>();
        try {
            while (eventReader.hasNext()) {
                StyleData styleData;
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement()) continue;
                StartElement element = event.asStartElement();
                if (RPR_DEFAULT.equals(element.getName())) {
                    documentDefaultRunProperties = this.parseDefaultRunProperties(element, eventReader);
                    continue;
                }
                if (!STYLE.equals(element.getName()) || null == (styleData = this.parseStyle(element, eventReader))) continue;
                if (styleData.shouldBeDefault()) {
                    defaultStylesByStyleTypes.put(styleData.getType(), styleData.getId());
                }
                styleTypesByStyleIds.put(styleData.getId(), styleData.getType());
                parentStylesByStyleIds.put(styleData.getId(), styleData.getParentId());
                linkedStylesByStyleIds.put(styleData.getId(), styleData.getLinkedStyleId());
                runPropertiesByStyleIds.put(styleData.getId(), styleData.getRunProperties());
            }
        }
        finally {
            this.reader.close();
        }
        if (null == documentDefaultRunProperties) {
            documentDefaultRunProperties = RunProperties.emptyRunProperties();
        }
        return new StyleDefinitions(documentDefaultRunProperties, defaultStylesByStyleTypes, styleTypesByStyleIds, parentStylesByStyleIds, linkedStylesByStyleIds, runPropertiesByStyleIds);
    }

    private RunProperties parseDefaultRunProperties(StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        RunProperties runProperties = null;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && event.asEndElement().getName().equals(startElement.getName()))) {
            StartElement element;
            if (!event.isStartElement() || !RPR.equals((element = event.asStartElement()).getName())) continue;
            runProperties = this.parseRunProperties(element, eventReader);
        }
        if (null == runProperties) {
            runProperties = RunProperties.emptyRunProperties();
        }
        return runProperties;
    }

    private RunProperties parseRunProperties(StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        return new RunPropertiesParser(startElement, eventReader, this.conditionalParameters, this.eventFactory).parse();
    }

    private StyleData parseStyle(StartElement startElement, XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event;
        StyleType styleType;
        String attributeValue = XMLEventHelpers.getAttributeValue(startElement, STYLE_TYPE);
        StyleType styleType2 = styleType = null == attributeValue ? StyleType.PARAGRAPH : StyleType.fromValue(attributeValue);
        if (!PARSABLE_STYLE_TYPES.contains((Object)styleType)) {
            return null;
        }
        boolean shouldBeDefault = XMLEventHelpers.getBooleanAttributeValue(startElement, STYLE_DEFAULT, XMLEventHelpers.DEFAULT_BOOLEAN_ATTRIBUTE_FALSE_VALUE);
        String styleId = XMLEventHelpers.getAttributeValue(startElement, STYLE_ID);
        String parentStyleId = null;
        String linkedStyleId = null;
        RunProperties runProperties = null;
        while (!(!eventReader.hasNext() || (event = eventReader.nextEvent()).isEndElement() && event.asEndElement().getName().equals(startElement.getName()))) {
            if (!event.isStartElement()) continue;
            StartElement element = event.asStartElement();
            if (STYLE_BASED_ON.equals(element.getName())) {
                parentStyleId = XMLEventHelpers.getAttributeValue(element, XMLEventHelpers.WPML_VAL);
                continue;
            }
            if (STYLE_LINK.equals(element.getName())) {
                linkedStyleId = XMLEventHelpers.getAttributeValue(element, XMLEventHelpers.WPML_VAL);
                continue;
            }
            if (!RPR.equals(element.getName())) continue;
            runProperties = this.parseRunProperties(element, eventReader);
        }
        if (null == runProperties) {
            runProperties = RunProperties.emptyRunProperties();
        }
        return new StyleData(styleType, shouldBeDefault, styleId, parentStyleId, linkedStyleId, runProperties);
    }

    private static class StyleData {
        private final StyleType type;
        private final boolean shouldBeDefault;
        private final String id;
        private final String parentId;
        private final String linkedStyleId;
        private final RunProperties runProperties;

        public StyleData(StyleType type, boolean shouldBeDefault, String id, String parentId, String linkedStyleId, RunProperties runProperties) {
            this.type = type;
            this.shouldBeDefault = shouldBeDefault;
            this.id = id;
            this.parentId = parentId;
            this.linkedStyleId = linkedStyleId;
            this.runProperties = runProperties;
        }

        public StyleType getType() {
            return this.type;
        }

        public boolean shouldBeDefault() {
            return this.shouldBeDefault;
        }

        public String getId() {
            return this.id;
        }

        public String getParentId() {
            return this.parentId;
        }

        public String getLinkedStyleId() {
            return this.linkedStyleId;
        }

        public RunProperties getRunProperties() {
            return this.runProperties;
        }
    }
}

