/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.segmentation;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.RegexUtil;

@Deprecated
class RuleInfo {
    private static final String WB_GROUP = "(.{0})";
    private static final String WB_STR = Character.toString('\ue011');
    private static final Pattern WB = Pattern.compile(WB_STR);
    private static final String NON_WB_STR = Character.toString('\ue012');
    private static final Pattern NON_WB = Pattern.compile(NON_WB_STR);
    private static final Pattern G_PATTERN = Pattern.compile("\\\\G(.+)");
    private List<Range> setAreas = new ArrayList<Range>();
    private List<Range> quotedAreas = new ArrayList<Range>();
    private List<Integer> wbGroups = new ArrayList<Integer>();
    private List<Integer> nonWbGroups = new ArrayList<Integer>();
    private String rule;

    public RuleInfo(String rule) {
        int newGroup;
        int startBeforePos = rule.indexOf(57363);
        rule = rule.replace(Character.toString('\ue013'), "");
        int endBeforePos = rule.indexOf(57364);
        rule = rule.replace(Character.toString('\ue014'), "");
        int startAfterPos = rule.indexOf(57365);
        rule = rule.replace(Character.toString('\ue015'), "");
        int endAfterPos = rule.indexOf(57366);
        rule = rule.replace(Character.toString('\ue016'), "");
        rule = this.processGPattern(rule, startAfterPos, endAfterPos);
        rule = this.processGPattern(rule, startBeforePos, endBeforePos);
        Matcher m = WB.matcher(rule);
        while (m.find()) {
            newGroup = RegexUtil.getGroupAtPos(rule, m.start()) + 1;
            this.wbGroups.add(newGroup);
            rule = RegexUtil.updateGroupReferences(rule, newGroup);
        }
        m = NON_WB.matcher(rule);
        while (m.find()) {
            newGroup = RegexUtil.getGroupAtPos(rule, m.start()) + 1;
            this.nonWbGroups.add(newGroup);
            rule = RegexUtil.updateGroupReferences(rule, newGroup);
        }
        rule = rule.replace(WB_STR, WB_GROUP);
        rule = rule.replace(NON_WB_STR, WB_GROUP);
        this.quotedAreas = RegexUtil.getQuotedAreas(rule);
        boolean ignoreNext = false;
        int level = 0;
        int start = 0;
        block7: for (int i = 0; i < rule.length(); ++i) {
            char ch = rule.charAt(i);
            switch (ch) {
                case '[': {
                    if (ignoreNext) {
                        ignoreNext = false;
                        continue block7;
                    }
                    if (level++ != 0) continue block7;
                    start = i + 1;
                    continue block7;
                }
                case ']': {
                    if (ignoreNext) {
                        ignoreNext = false;
                        continue block7;
                    }
                    if (--level != 0) continue block7;
                    this.setAreas.add(new Range(start, i - 1));
                    continue block7;
                }
                case '\\': {
                    if (this.isQuotedArea(i)) continue block7;
                    ignoreNext = true;
                    continue block7;
                }
                default: {
                    ignoreNext = false;
                }
            }
        }
        this.rule = rule;
    }

    private String processGPattern(String rule, int startPos, int endPos) {
        if (startPos == -1 || endPos == -1) {
            return rule;
        }
        String part = rule.substring(startPos, endPos);
        Matcher m = G_PATTERN.matcher(part);
        if (m.find()) {
            String replacement = String.format("(%s)+", m.group(1));
            StringBuilder sb = new StringBuilder(rule);
            sb.replace(startPos + m.start(), endPos, replacement);
            rule = sb.toString();
            int newGroup = RegexUtil.getGroupAtPos(rule, m.start()) + 1;
            rule = RegexUtil.updateGroupReferences(rule, newGroup);
        }
        return rule;
    }

    public boolean isQuotedArea(int pos) {
        for (Range area : this.quotedAreas) {
            if (!area.contains(pos)) continue;
            return true;
        }
        return false;
    }

    public boolean isSetArea(int pos) {
        for (Range area : this.setAreas) {
            if (!area.contains(pos)) continue;
            return true;
        }
        return false;
    }

    public boolean hasWbPatterns() {
        return this.wbGroups.size() > 0 || this.nonWbGroups.size() > 0;
    }

    public boolean verifyPos(int pos, Matcher matcher, List<Integer> boundaries) {
        int groupPos;
        if (!this.hasWbPatterns()) {
            return true;
        }
        int numGroups = matcher.groupCount();
        for (int groupNum : this.wbGroups) {
            if (groupNum >= numGroups) {
                return true;
            }
            groupPos = matcher.start(groupNum);
            if (boundaries.contains(groupPos)) continue;
            return false;
        }
        for (int groupNum : this.nonWbGroups) {
            if (groupNum >= numGroups) {
                return true;
            }
            groupPos = matcher.start(groupNum);
            if (!boundaries.contains(groupPos)) continue;
            return false;
        }
        return true;
    }

    public String getRule() {
        return this.rule;
    }
}

