/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.reader;

import java.io.InputStream;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.reader.AllowedModules;
import net.sf.okapi.lib.xliff2.reader.XLIFFReaderException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class LocationValidator {
    public static final int ALLOWED = 0;
    public static final int NO_MODULES = 1;
    public static final int NOT_ALLOWED = 2;
    public static final int TOO_MANY = 3;
    private HashMap<String, AllowedModules> map;

    LocationValidator() {
    }

    public void load(InputStream inputStream) {
        try {
            this.map = new HashMap();
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(inputStream);
            NodeList list1 = doc.getDocumentElement().getElementsByTagName("location");
            if (list1 == null || list1.getLength() == 0) {
                return;
            }
            for (int i = 0; i < list1.getLength(); ++i) {
                String qString;
                Element elem2;
                int j;
                Element elem = (Element)list1.item(i);
                String name = elem.getAttribute("name");
                if (name.isEmpty()) {
                    throw new XLIFFReaderException("Invalid empty name in modules file.");
                }
                AllowedModules mods = new AllowedModules();
                NodeList list2 = elem.getElementsByTagName("attribute");
                for (j = 0; j < list2.getLength(); ++j) {
                    elem2 = (Element)list2.item(j);
                    qString = elem2.getAttribute("name");
                    mods.addAttribute(qString);
                }
                list2 = elem.getElementsByTagName("element");
                for (j = 0; j < list2.getLength(); ++j) {
                    elem2 = (Element)list2.item(j);
                    qString = elem2.getAttribute("name");
                    boolean zeroOrMore = elem2.getAttribute("zeroOrMore").equals("yes");
                    mods.addElement(qString, zeroOrMore);
                }
                this.map.put(name, mods);
            }
        }
        catch (Throwable e) {
            throw new XLIFFException(e.getLocalizedMessage());
        }
    }

    public int verify(String parentName, QName qName, boolean attribute) {
        if (!qName.getNamespaceURI().startsWith("urn:oasis:names:tc:xliff:")) {
            return 0;
        }
        AllowedModules mods = this.map.get(parentName);
        if (mods == null) {
            return 1;
        }
        if (attribute) {
            return mods.isAllowedAttribute(qName);
        }
        return mods.isAllowedElement(qName);
    }

    public void reset() {
        for (AllowedModules mods : this.map.values()) {
            mods.reset();
        }
    }
}

