/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.validation;

import java.text.Normalizer;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.IWithExtAttributes;

public class Rule
implements IWithExtAttributes {
    private Type type = null;
    private String data;
    private String effectiveData;
    private int occurs;
    private boolean existsInSource = false;
    private boolean caseSensitive = true;
    private boolean enable = true;
    private Normalization normalization = Normalization.NFC;
    private ExtAttributes xattrs;
    private boolean inherited = false;

    public Rule(String type, String data) {
        this.type = Type.fromString(type);
        this.data = data;
    }

    public Rule(Rule original) {
        this.type = original.type;
        this.caseSensitive = original.caseSensitive;
        this.normalization = original.normalization;
        this.data = original.data;
        this.effectiveData = original.effectiveData;
        this.enable = original.enable;
        this.existsInSource = original.existsInSource;
        this.occurs = original.occurs;
        this.inherited = original.inherited;
        if (original.hasExtAttribute()) {
            this.xattrs = new ExtAttributes(original.xattrs);
        }
    }

    public String getDisplay() {
        StringBuilder tmp = new StringBuilder(this.type.toString() + "='" + this.data + "'" + " caseSensitive=" + (this.caseSensitive ? "yes" : "no") + " normalization=" + this.normalization.toString());
        switch (this.type) {
            case ISPRESENT: {
                tmp.append(this.occurs > 1 ? " occurs=" + this.occurs : " occurs=once-or-more");
            }
            case ENDSWITH: 
            case STARTSWITH: {
                tmp.append(" existsInSource=" + (this.existsInSource ? "yes" : "no"));
                break;
            }
        }
        tmp.append(this.inherited ? " (inherited-rule)" : "");
        return tmp.toString();
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getEffectiveData() {
        return this.effectiveData;
    }

    public int getOccurs() {
        return this.occurs;
    }

    public void setOccurs(int occurs) {
        this.occurs = occurs;
    }

    public boolean getExistsInSource() {
        return this.existsInSource;
    }

    public void setExistsInSource(boolean existsInSource) {
        this.existsInSource = existsInSource;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public Normalization getNormalization() {
        return this.normalization;
    }

    public void setNormalization(Normalization normalization) {
        this.normalization = normalization;
    }

    @Override
    public void setExtAttributes(ExtAttributes attributes) {
        this.xattrs = attributes;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    @Override
    public ExtAttributes getExtAttributes() {
        if (this.xattrs == null) {
            this.xattrs = new ExtAttributes();
        }
        return this.xattrs;
    }

    @Override
    public boolean hasExtAttribute() {
        if (this.xattrs == null) {
            return false;
        }
        return !this.xattrs.isEmpty();
    }

    @Override
    public String getExtAttributeValue(String namespaceURI, String localName) {
        if (this.xattrs == null) {
            return null;
        }
        return this.xattrs.getAttributeValue(namespaceURI, localName);
    }

    public void prepare() {
        this.verify();
        if (this.type == Type.CUSTOM) {
            return;
        }
        this.effectiveData = this.data;
        if (!this.isCaseSensitive()) {
            this.effectiveData = this.effectiveData.toLowerCase();
        }
        switch (this.normalization) {
            case NFC: {
                this.effectiveData = Normalizer.normalize(this.effectiveData, Normalizer.Form.NFC);
                break;
            }
            case NFD: {
                this.effectiveData = Normalizer.normalize(this.effectiveData, Normalizer.Form.NFD);
                break;
            }
        }
    }

    public void verify() {
        if (this.type == null) {
            throw new XLIFFException("You must specify a type of rule (e.g. isPresent, startsWith, etc.)");
        }
        switch (this.type) {
            case CUSTOM: {
                break;
            }
            case ENDSWITH: {
                break;
            }
            case ISNOTPRESENT: {
                break;
            }
            case ISPRESENT: {
                break;
            }
        }
    }

    public static enum Normalization {
        NONE("none"),
        NFC("nfc"),
        NFD("nfd");

        private String name;

        private Normalization(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Normalization fromString(String name) {
            if (name == null) {
                throw new InvalidParameterException("A normalization value must not be null");
            }
            switch (name) {
                case "none": {
                    return NONE;
                }
                case "nfc": {
                    return NFC;
                }
                case "nfd": {
                    return NFD;
                }
            }
            throw new InvalidParameterException(String.format("Invalid normalization value: '%s'.", name));
        }
    }

    public static enum Type {
        ISPRESENT("isPresent"),
        ISNOTPRESENT("isNotPresent"),
        STARTSWITH("startsWith"),
        ENDSWITH("endsWith"),
        CUSTOM("custom");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Type fromString(String name) {
            if (name == null) {
                throw new InvalidParameterException("A rule type must not be null");
            }
            switch (name) {
                case "isPresent": {
                    return ISPRESENT;
                }
                case "isNotPresent": {
                    return ISNOTPRESENT;
                }
                case "startsWith": {
                    return STARTSWITH;
                }
                case "endsWith": {
                    return ENDSWITH;
                }
            }
            throw new InvalidParameterException(String.format("Invalid rule type value: '%s'.", name));
        }
    }
}

