/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;

public abstract class Device
implements Drawable {
    protected static final int CHANGE_SCALEFACTOR = 1;
    long gsettingsProc;
    Callback gsettingsCallback;
    boolean isConnected = false;
    long displaySettings;
    protected long xDisplay;
    long shellHandle;
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    GdkColor[] gdkColors;
    int[] colorRefCount;
    boolean disposed;
    long logProc;
    Callback logCallback;
    String[] log_domains = new String[]{"", "GLib-GObject", "GLib", "GObject", "Pango", "ATK", "GdkPixbuf", "Gdk", "Gtk", "GnomeVFS", "GIO"};
    int[] handler_ids = new int[this.log_domains.length];
    int warningLevel;
    static Callback XErrorCallback;
    static Callback XIOErrorCallback;
    static long XErrorProc;
    static long XIOErrorProc;
    static long XNullErrorProc;
    static long XNullIOErrorProc;
    static Device[] Devices;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_TRANSPARENT;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    Point dpi;
    protected int scaleFactor;
    long emptyTab;
    boolean useXRender;
    static boolean CAIRO_LOADED;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData deviceData) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (deviceData != null) {
                this.debug = deviceData.debug;
                this.tracking = deviceData.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            this.create(deviceData);
            this.init();
            Device.register(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void checkCairo() {
        if (CAIRO_LOADED) {
            return;
        }
        try {
            byte[] byArray;
            int n = OS.RTLD_LAZY;
            if (OS.IsAIX) {
                byArray = Converter.wcsToMbcs(null, "libcairo.a(libcairo.so.2)", true);
                n |= 0x40000;
            } else {
                byArray = OS.IsHPUX ? Converter.wcsToMbcs(null, "libcairo.so", true) : Converter.wcsToMbcs(null, "libcairo.so.2", true);
            }
            long l = OS.dlopen(byArray, n);
            if (l != 0L) {
                OS.dlclose(l);
            } else {
                try {
                    System.loadLibrary("cairo-swt");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
            }
            Class.forName("org.eclipse.swt.internal.cairo.Cairo");
            CAIRO_LOADED = true;
        }
        catch (Throwable throwable) {
            SWT.error(16, throwable, " [Cairo is required]");
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData deviceData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            Device.deregister(this);
            this.xDisplay = 0L;
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i] != object) continue;
                this.objects[i] = null;
                this.errors[i] = null;
                return;
            }
        }
    }

    static synchronized Device findDevice(long l) {
        for (int i = 0; i < Devices.length; ++i) {
            Device device = Devices[i];
            if (device == null || device.xDisplay != l) continue;
            return device;
        }
        return null;
    }

    static synchronized void deregister(Device device) {
        for (int i = 0; i < Devices.length; ++i) {
            if (device != Devices[i]) continue;
            Device.Devices[i] = null;
        }
    }

    protected void destroy() {
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    private Rectangle getBoundsInPixels() {
        return new Rectangle(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int n;
                int n2 = 0;
                int n3 = this.objects.length;
                for (n = 0; n < n3; ++n) {
                    if (this.objects[n] == null) continue;
                    ++n2;
                }
                n = 0;
                deviceData.objects = new Object[n2];
                deviceData.errors = new Error[n2];
                for (int i = 0; i < n3; ++i) {
                    if (this.objects[i] == null) continue;
                    deviceData.objects[n] = this.objects[i];
                    deviceData.errors[n] = this.errors[i];
                    ++n;
                }
            }
        } else {
            deviceData.objects = new Object[0];
            deviceData.errors = new Error[0];
        }
        return deviceData;
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        return 0;
    }

    public Point getDPI() {
        this.checkDevice();
        return this.getScreenDPI();
    }

    public FontData[] getFontList(String string, boolean bl) {
        this.checkDevice();
        if (!bl) {
            return new FontData[0];
        }
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        long[] lArray3 = new long[1];
        int[] nArray = new int[1];
        long[] lArray4 = new long[1];
        int[] nArray2 = new int[1];
        long l = OS.gdk_pango_context_get();
        OS.pango_context_list_families(l, lArray3, nArray);
        int n = 0;
        FontData[] fontDataArray = new FontData[string != null ? 4 : nArray[0]];
        for (int i = 0; i < nArray[0]; ++i) {
            Object object;
            Object object2;
            OS.memmove(lArray, lArray3[0] + (long)(i * OS.PTR_SIZEOF), (long)OS.PTR_SIZEOF);
            boolean bl2 = true;
            if (string != null) {
                long l2 = OS.pango_font_family_get_name(lArray[0]);
                int n2 = OS.strlen(l2);
                object2 = new byte[n2];
                OS.memmove((byte[])object2, l2, (long)n2);
                object = new String(Converter.mbcsToWcs(null, (byte[])object2));
                bl2 = string.equalsIgnoreCase((String)object);
            }
            if (!bl2) continue;
            OS.pango_font_family_list_faces(lArray[0], lArray4, nArray2);
            for (int j = 0; j < nArray2[0]; ++j) {
                OS.memmove(lArray2, lArray4[0] + (long)(j * OS.PTR_SIZEOF), (long)OS.PTR_SIZEOF);
                long l3 = OS.pango_font_face_describe(lArray2[0]);
                object2 = Font.gtk_new(this, l3);
                object = ((Font)object2).getFontData()[0];
                if (n == fontDataArray.length) {
                    FontData[] fontDataArray2 = new FontData[fontDataArray.length + nArray[0]];
                    System.arraycopy(fontDataArray, 0, fontDataArray2, 0, n);
                    fontDataArray = fontDataArray2;
                }
                fontDataArray[n++] = object;
                OS.pango_font_description_free(l3);
            }
            OS.g_free(lArray4[0]);
            if (string != null) break;
        }
        OS.g_free(lArray3[0]);
        OS.g_object_unref(l);
        if (n == fontDataArray.length) {
            return fontDataArray;
        }
        FontData[] fontDataArray3 = new FontData[n];
        System.arraycopy(fontDataArray, 0, fontDataArray3, 0, n);
        return fontDataArray3;
    }

    Point getScreenDPI() {
        int n = OS.gdk_screen_width_mm();
        int n2 = OS.gdk_screen_width();
        int n3 = Compatibility.round(254 * n2, n * 10);
        return new Point(n3, n3);
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        switch (n) {
            case 37: {
                return this.COLOR_TRANSPARENT;
            }
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this.warningLevel == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void init() {
        long l;
        long l2;
        boolean bl;
        Object[] objectArray;
        int[] nArray;
        Object object;
        int[] nArray2;
        this.dpi = this.getDPI();
        this.scaleFactor = this.getDeviceZoom();
        DPIUtil.setDeviceZoom(this.scaleFactor);
        if (this.xDisplay != 0L && !OS.USE_CAIRO && OS.XRenderQueryExtension(this.xDisplay, nArray2 = new int[1], object = new int[1])) {
            nArray = new int[1];
            objectArray = new int[1];
            OS.XRenderQueryVersion(this.xDisplay, nArray, objectArray);
            this.useXRender = nArray[0] > 0 || nArray[0] == 0 && objectArray[0] >= 8;
        }
        boolean bl2 = bl = OS.IsAIX && OS.PTR_SIZEOF == 8;
        if ((this.debug || bl) && this.xDisplay != 0L) {
            int n;
            object = this.getClass();
            nArray = object;
            // MONITORENTER : object
            for (n = 0; n < Devices.length && Devices[n] == null; ++n) {
            }
            if (n == Devices.length) {
                XErrorCallback = new Callback(object, "XErrorProc", 2);
                XNullErrorProc = XErrorCallback.getAddress();
                if (XNullErrorProc == 0L) {
                    SWT.error(3);
                }
                if ((XNullIOErrorProc = (XIOErrorCallback = new Callback(object, "XIOErrorProc", 1)).getAddress()) == 0L) {
                    SWT.error(3);
                }
                XErrorProc = OS.XSetErrorHandler(XNullErrorProc);
                XIOErrorProc = OS.XSetIOErrorHandler(XNullIOErrorProc);
            }
            // MONITOREXIT : nArray
            if (this.debug) {
                OS.XSynchronize(this.xDisplay, true);
            }
        }
        if (this.xDisplay != 0L) {
            this.logCallback = new Callback(this, "logProc", 4);
            this.logProc = this.logCallback.getAddress();
            if (this.logProc == 0L) {
                SWT.error(3);
            }
            if (this.debug) {
                int n = -1;
                for (int i = 0; i < this.log_domains.length; ++i) {
                    objectArray = Converter.wcsToMbcs(null, this.log_domains[i], true);
                    this.handler_ids[i] = OS.g_log_set_handler((byte[])objectArray, n, this.logProc, 0L);
                }
            }
        }
        this.COLOR_TRANSPARENT = new Color(this, 255, 255, 255, 0);
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
        this.emptyTab = OS.pango_tab_array_new(1, false);
        if (this.emptyTab == 0L) {
            SWT.error(2);
        }
        OS.pango_tab_array_set_tab(this.emptyTab, 0, 0L, 1);
        this.shellHandle = OS.gtk_window_new(0);
        if (this.shellHandle == 0L) {
            SWT.error(2);
        }
        OS.gtk_widget_realize(this.shellHandle);
        if (OS.GTK3) {
            l2 = OS.gtk_widget_get_style_context(this.shellHandle);
            l = OS.gtk_style_context_get_font(l2, 0);
        } else {
            l2 = OS.gtk_widget_get_style(this.shellHandle);
            l = OS.gtk_style_get_font_desc(l2);
        }
        l = OS.pango_font_description_copy(l);
        Point point = this.getDPI();
        Point point2 = this.getScreenDPI();
        if (point.y != point2.y) {
            int n = OS.pango_font_description_get_size(l);
            OS.pango_font_description_set_size(l, n * point.y / point2.y);
        }
        this.systemFont = Font.gtk_new(this, l);
        if (!OS.GTK3) return;
        long l3 = OS.gdk_screen_get_default();
        long l4 = OS.gtk_css_provider_new();
        String string = "";
        if (l3 == 0L) return;
        if (l4 == 0L) return;
        if (OS.GTK_VERSION < OS.VERSION(3, 20, 0)) {
            string = "GtkToolbar {padding-top: 4px; padding-bottom: 4px;}\nGtkToolbar GtkButton {padding: 2px 4px 3px 4px;}\n.undershoot.top, .undershoot.right, .undershoot.bottom, .undershoot.left {background-image: none;}\nGtkToolbar GtkMenuButton {padding: 1px 0px 1px 0px;}\n";
        } else {
            string = "toolbar {padding-top: 2px; padding-bottom: 2px;}\ntoolbar button {padding: 2px;}toolbar button.popup {padding: 0px;}\ntoolbar toolbutton button {padding: 0px 0px 0px 0px;}scrolledwindow undershoot.top, scrolledwindow undershoot.right, scrolledwindow undershoot.bottom, scrolledwindow undershoot.left {background-image: none;}\n";
            string = string + "entry {min-height: 26px;}";
        }
        if (string == null) return;
        OS.gtk_style_context_add_provider_for_screen(l3, l4, 600);
        OS.gtk_css_provider_load_from_data(l4, Converter.wcsToMbcs(null, string, true), -1L, null);
    }

    @Override
    public abstract long internal_new_GC(GCData var1);

    @Override
    public abstract void internal_dispose_GC(long var1, GCData var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String string) {
        this.checkDevice();
        if (string == null) {
            SWT.error(4);
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        return OS.FcConfigAppFontAddFile(0L, byArray);
    }

    long logProc(long l, long l2, long l3, long l4) {
        if (DEBUG) {
            new Error().printStackTrace();
        }
        if (this.warningLevel == 0) {
            if (DEBUG || this.debug) {
                new Error().printStackTrace();
            }
            OS.g_log_default_handler(l, (int)l2, l3, 0L);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (this.objects[i] != null) continue;
                this.objects[i] = object;
                this.errors[i] = new Error();
                return;
            }
            Object[] objectArray = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
            objectArray[this.objects.length] = object;
            this.objects = objectArray;
            Error[] errorArray = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
            errorArray[this.errors.length] = new Error();
            this.errors = errorArray;
        }
    }

    static synchronized void register(Device device) {
        for (int i = 0; i < Devices.length; ++i) {
            if (Devices[i] != null) continue;
            Device.Devices[i] = device;
            return;
        }
        Device[] deviceArray = new Device[Devices.length + 4];
        System.arraycopy(Devices, 0, deviceArray, 0, Devices.length);
        deviceArray[Device.Devices.length] = device;
        Devices = deviceArray;
    }

    protected void release() {
        if (this.shellHandle != 0L) {
            OS.gtk_widget_destroy(this.shellHandle);
        }
        this.shellHandle = 0L;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
        if (this.gdkColors != null && !OS.GTK3) {
            long l = OS.gdk_colormap_get_system();
            for (int i = 0; i < this.gdkColors.length; ++i) {
                GdkColor gdkColor = this.gdkColors[i];
                if (gdkColor == null) continue;
                while (this.colorRefCount[i] > 0) {
                    OS.gdk_colormap_free_colors(l, gdkColor, 1);
                    int n = i;
                    this.colorRefCount[n] = this.colorRefCount[n] - 1;
                }
            }
        }
        this.gdkColors = null;
        this.colorRefCount = null;
        if (this.COLOR_BLACK != null) {
            this.COLOR_BLACK.dispose();
        }
        if (this.COLOR_DARK_RED != null) {
            this.COLOR_DARK_RED.dispose();
        }
        if (this.COLOR_DARK_GREEN != null) {
            this.COLOR_DARK_GREEN.dispose();
        }
        if (this.COLOR_DARK_YELLOW != null) {
            this.COLOR_DARK_YELLOW.dispose();
        }
        if (this.COLOR_DARK_BLUE != null) {
            this.COLOR_DARK_BLUE.dispose();
        }
        if (this.COLOR_DARK_MAGENTA != null) {
            this.COLOR_DARK_MAGENTA.dispose();
        }
        if (this.COLOR_DARK_CYAN != null) {
            this.COLOR_DARK_CYAN.dispose();
        }
        if (this.COLOR_GRAY != null) {
            this.COLOR_GRAY.dispose();
        }
        if (this.COLOR_DARK_GRAY != null) {
            this.COLOR_DARK_GRAY.dispose();
        }
        if (this.COLOR_RED != null) {
            this.COLOR_RED.dispose();
        }
        if (this.COLOR_GREEN != null) {
            this.COLOR_GREEN.dispose();
        }
        if (this.COLOR_YELLOW != null) {
            this.COLOR_YELLOW.dispose();
        }
        if (this.COLOR_BLUE != null) {
            this.COLOR_BLUE.dispose();
        }
        if (this.COLOR_MAGENTA != null) {
            this.COLOR_MAGENTA.dispose();
        }
        if (this.COLOR_CYAN != null) {
            this.COLOR_CYAN.dispose();
        }
        if (this.COLOR_WHITE != null) {
            this.COLOR_WHITE.dispose();
        }
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
        if (this.emptyTab != 0L) {
            OS.pango_tab_array_free(this.emptyTab);
        }
        this.emptyTab = 0L;
        if (this.xDisplay != 0L) {
            for (int i = 0; i < this.handler_ids.length; ++i) {
                if (this.handler_ids[i] == 0) continue;
                byte[] byArray = Converter.wcsToMbcs(null, this.log_domains[i], true);
                OS.g_log_remove_handler(byArray, this.handler_ids[i]);
                this.handler_ids[i] = 0;
            }
            this.logCallback.dispose();
            this.logCallback = null;
            this.handler_ids = null;
            this.log_domains = null;
            this.logProc = 0L;
        }
        if (this.gsettingsCallback != null) {
            this.gsettingsCallback.dispose();
            this.gsettingsCallback = null;
        }
        this.gsettingsProc = 0L;
    }

    public void setWarnings(boolean bl) {
        block8: {
            block7: {
                this.checkDevice();
                if (!bl) break block7;
                if (--this.warningLevel != 0) break block8;
                if (this.debug) {
                    return;
                }
                if (this.logProc != 0L) {
                    for (int i = 0; i < this.handler_ids.length; ++i) {
                        if (this.handler_ids[i] == 0) continue;
                        byte[] byArray = Converter.wcsToMbcs(null, this.log_domains[i], true);
                        OS.g_log_remove_handler(byArray, this.handler_ids[i]);
                        this.handler_ids[i] = 0;
                    }
                }
                break block8;
            }
            if (this.warningLevel++ == 0) {
                if (this.debug) {
                    return;
                }
                if (this.logProc != 0L) {
                    int n = -1;
                    for (int i = 0; i < this.log_domains.length; ++i) {
                        byte[] byArray = Converter.wcsToMbcs(null, this.log_domains[i], true);
                        this.handler_ids[i] = OS.g_log_set_handler(byArray, n, this.logProc, 0L);
                    }
                }
            }
        }
    }

    static long XErrorProc(long l, long l2) {
        Device device = Device.findDevice(l);
        if (device != null) {
            if (device.warningLevel == 0) {
                boolean bl;
                if (DEBUG || device.debug) {
                    new SWTError().printStackTrace();
                }
                boolean bl2 = bl = OS.IsAIX && OS.PTR_SIZEOF == 8;
                if (!bl) {
                    OS.Call(XErrorProc, l, l2);
                }
            }
        } else {
            if (DEBUG) {
                new SWTError().printStackTrace();
            }
            OS.Call(XErrorProc, l, l2);
        }
        return 0L;
    }

    static long XIOErrorProc(long l) {
        Device device = Device.findDevice(l);
        if (device != null) {
            if (DEBUG || device.debug) {
                new SWTError().printStackTrace();
            }
        } else if (DEBUG) {
            new SWTError().printStackTrace();
        }
        OS.Call(XIOErrorProc, l, 0L);
        return 0L;
    }

    int _getDPIx() {
        return this.scaleFactor * 96 / 100;
    }

    protected int getDeviceZoom() {
        long l = OS.gdk_screen_get_default();
        int n = (int)OS.gdk_screen_get_resolution(l);
        if (n <= 0) {
            n = 96;
        }
        if (OS.GTK_VERSION > OS.VERSION(3, 9, 0)) {
            int n2 = OS.gdk_screen_get_monitor_at_point(l, 0, 0);
            int n3 = OS.gdk_screen_get_monitor_scale_factor(l, n2);
            n *= n3;
        }
        return DPIUtil.mapDPIToZoom(n);
    }

    protected long gsettingsProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 1: {
                this.scaleFactor = this.getDeviceZoom();
                DPIUtil.setDeviceZoom(this.scaleFactor);
            }
        }
        return 0L;
    }

    static {
        Devices = new Device[4];
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

