/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.RegexUtil;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.Util;

public class LocaleFilter {
    private FilterType type;
    private final List<LocaleId> includes = new ArrayList<LocaleId>();
    private final List<LocaleId> excludes = new ArrayList<LocaleId>();
    private final List<String> languageIncludes = new ArrayList<String>();
    private final List<String> regionIncludes = new ArrayList<String>();
    private final List<String> userPartIncludes = new ArrayList<String>();
    private final List<String> languageExcludes = new ArrayList<String>();
    private final List<String> regionExcludes = new ArrayList<String>();
    private final List<String> userPartExcludes = new ArrayList<String>();
    private final List<Pattern> patternIncludes = new ArrayList<Pattern>();
    private final List<Pattern> patternExcludes = new ArrayList<Pattern>();

    private LocaleFilter(FilterType type) {
        this.type = type;
    }

    public LocaleFilter() {
        this(FilterType.Any);
    }

    public LocaleFilter(String string) {
        this();
        this.fromString(string);
    }

    public static LocaleFilter any() {
        return new LocaleFilter();
    }

    public static LocaleFilter none() {
        return new LocaleFilter(FilterType.None);
    }

    public static LocaleFilter anyOf(LocaleId ... localeIds) {
        if (Util.isEmpty(localeIds)) {
            return LocaleFilter.none();
        }
        LocaleFilter filter = LocaleFilter.none();
        filter.include(localeIds);
        return filter;
    }

    public static LocaleFilter anyExcept(LocaleId ... localeIds) {
        LocaleFilter filter = LocaleFilter.any();
        filter.exclude(localeIds);
        return filter;
    }

    public static LocaleFilter build(String string) {
        return new LocaleFilter(string);
    }

    private void removeFromExcludes(LocaleId localeId) {
        for (int i = this.excludes.size() - 1; i >= 0; --i) {
            LocaleId item = this.excludes.get(i);
            if (item == null || !item.equals(localeId)) continue;
            this.excludes.remove(i);
        }
    }

    private void removeFromExcludes(List<LocaleId> localeIds) {
        if (localeIds == null) {
            return;
        }
        for (LocaleId localeId : localeIds) {
            this.removeFromExcludes(localeId);
        }
    }

    private void removeFromLanguageExcludes(String languageMask) {
        this.languageExcludes.remove(languageMask);
    }

    private void removeFromLanguageExcludes(List<String> languageMasks) {
        if (languageMasks == null) {
            return;
        }
        for (String languageMask : languageMasks) {
            this.removeFromLanguageExcludes(languageMask);
        }
    }

    private void removeFromRegionExcludes(String regionMask) {
        this.regionExcludes.remove(regionMask);
    }

    private void removeFromRegionExcludes(List<String> regionMasks) {
        if (regionMasks == null) {
            return;
        }
        for (String regionMask : regionMasks) {
            this.removeFromRegionExcludes(regionMask);
        }
    }

    private void removeFromUserPartExcludes(String userPartMask) {
        this.userPartExcludes.remove(userPartMask);
    }

    private void removeFromUserPartExcludes(List<String> userPartMasks) {
        if (userPartMasks == null) {
            return;
        }
        for (String userPartMask : userPartMasks) {
            this.removeFromUserPartExcludes(userPartMask);
        }
    }

    private void removeFromPatternExcludes(String regex, int flags) {
        for (int i = this.patternExcludes.size() - 1; i >= 0; --i) {
            Pattern item = this.patternExcludes.get(i);
            if (item == null || !item.toString().equals(regex) || item.flags() != flags) continue;
            this.patternExcludes.remove(i);
        }
    }

    private void removeFromPatternExcludes(List<Pattern> patterns) {
        if (patterns == null) {
            return;
        }
        for (Pattern pattern : patterns) {
            if (pattern == null) continue;
            this.removeFromPatternExcludes(pattern.toString(), pattern.flags());
        }
    }

    public LocaleFilter include(LocaleId localeId) {
        if (localeId == null) {
            return this;
        }
        this.removeFromExcludes(localeId);
        this.includes.add(0, localeId);
        return this;
    }

    public LocaleFilter include(LocaleId ... localeIds) {
        if (Util.isEmpty(localeIds)) {
            return this;
        }
        for (LocaleId localeId : localeIds) {
            this.include(localeId);
        }
        return this;
    }

    public LocaleFilter include(Set<LocaleId> localeIds) {
        if (localeIds == null) {
            return this;
        }
        for (LocaleId localeId : localeIds) {
            this.include(localeId);
        }
        return this;
    }

    public LocaleFilter include(List<LocaleId> localeIds) {
        if (localeIds == null) {
            return this;
        }
        for (LocaleId localeId : localeIds) {
            this.include(localeId);
        }
        return this;
    }

    public LocaleFilter include(LocaleFilter filter) {
        if (filter == null) {
            return this;
        }
        this.includes.addAll(0, filter.getIncludes());
        this.removeFromExcludes(filter.getIncludes());
        this.languageIncludes.addAll(0, filter.getLanguageIncludes());
        this.removeFromLanguageExcludes(filter.getLanguageIncludes());
        this.regionIncludes.addAll(0, filter.getRegionIncludes());
        this.removeFromRegionExcludes(filter.getRegionIncludes());
        this.userPartIncludes.addAll(0, filter.getUserPartIncludes());
        this.removeFromUserPartExcludes(filter.getUserPartIncludes());
        this.patternIncludes.addAll(0, filter.getPatternIncludes());
        this.removeFromPatternExcludes(filter.getPatternIncludes());
        return this;
    }

    public LocaleFilter includePattern(String regex, int flags) {
        if (Util.isEmpty(regex)) {
            return this;
        }
        this.removeFromPatternExcludes(regex, flags);
        this.patternIncludes.add(0, Pattern.compile(regex, flags));
        return this;
    }

    public LocaleFilter includePattern(String regex) {
        return this.includePattern(regex, 0);
    }

    public LocaleFilter includeLanguage(String ... languages) {
        if (Util.isEmpty(languages)) {
            return this;
        }
        for (String language : languages) {
            this.includeLanguage(language);
        }
        return this;
    }

    public LocaleFilter includeLanguage(String language) {
        if (Util.isEmpty(language)) {
            return this;
        }
        String languageMask = language;
        this.removeFromLanguageExcludes(languageMask);
        this.languageIncludes.add(languageMask);
        return this;
    }

    public LocaleFilter includeRegion(String ... regions) {
        if (Util.isEmpty(regions)) {
            return this;
        }
        for (String region : regions) {
            this.includeRegion(region);
        }
        return this;
    }

    public LocaleFilter includeRegion(String region) {
        if (Util.isEmpty(region)) {
            return this;
        }
        String regionMask = "xx-" + region;
        this.removeFromRegionExcludes(regionMask);
        this.regionIncludes.add(regionMask);
        return this;
    }

    public LocaleFilter includeUserPart(String ... userParts) {
        if (Util.isEmpty(userParts)) {
            return this;
        }
        for (String userPart : userParts) {
            this.includeUserPart(userPart);
        }
        return this;
    }

    public LocaleFilter includeUserPart(String userPart) {
        if (Util.isEmpty(userPart)) {
            return this;
        }
        String userPartMask = "xx-xx-x-" + userPart;
        this.removeFromUserPartExcludes(userPartMask);
        this.userPartIncludes.add(userPartMask);
        return this;
    }

    public LocaleFilter exclude(LocaleId localeId) {
        if (localeId == null) {
            return this;
        }
        this.excludes.add(0, localeId);
        return this;
    }

    public LocaleFilter exclude(LocaleId ... localeIds) {
        if (Util.isEmpty(localeIds)) {
            return this;
        }
        for (LocaleId localeId : localeIds) {
            this.exclude(localeId);
        }
        return this;
    }

    public LocaleFilter exclude(Set<LocaleId> localeIds) {
        if (localeIds == null) {
            return this;
        }
        for (LocaleId localeId : localeIds) {
            this.exclude(localeId);
        }
        return this;
    }

    public LocaleFilter exclude(List<LocaleId> localeIds) {
        if (localeIds == null) {
            return this;
        }
        for (LocaleId localeId : localeIds) {
            this.exclude(localeId);
        }
        return this;
    }

    public LocaleFilter exclude(LocaleFilter filter) {
        if (filter == null) {
            return this;
        }
        this.excludes.addAll(0, filter.getIncludes());
        this.languageExcludes.addAll(0, filter.getLanguageIncludes());
        this.regionExcludes.addAll(0, filter.getRegionIncludes());
        this.userPartExcludes.addAll(0, filter.getUserPartIncludes());
        this.patternExcludes.addAll(0, filter.getPatternIncludes());
        return this;
    }

    public LocaleFilter excludePattern(String regex, int flags) {
        if (Util.isEmpty(regex)) {
            return this;
        }
        this.patternExcludes.add(0, Pattern.compile(regex, flags));
        return this;
    }

    public LocaleFilter excludePattern(String regex) {
        return this.excludePattern(regex, 0);
    }

    public LocaleFilter excludeLanguage(String ... languages) {
        if (Util.isEmpty(languages)) {
            return this;
        }
        for (String language : languages) {
            this.excludeLanguage(language);
        }
        return this;
    }

    public LocaleFilter excludeLanguage(String language) {
        if (Util.isEmpty(language)) {
            return this;
        }
        this.languageExcludes.add(language);
        return this;
    }

    public LocaleFilter excludeRegion(String ... regions) {
        if (Util.isEmpty(regions)) {
            return this;
        }
        for (String region : regions) {
            this.excludeRegion(region);
        }
        return this;
    }

    public LocaleFilter excludeRegion(String region) {
        if (Util.isEmpty(region)) {
            return this;
        }
        this.regionExcludes.add("xx-" + region);
        return this;
    }

    public LocaleFilter excludeUserPart(String ... userParts) {
        if (Util.isEmpty(userParts)) {
            return this;
        }
        for (String userPart : userParts) {
            this.excludeUserPart(userPart);
        }
        return this;
    }

    public LocaleFilter excludeUserPart(String userPart) {
        if (Util.isEmpty(userPart)) {
            return this;
        }
        this.userPartExcludes.add("xx-xx-x-" + userPart);
        return this;
    }

    public LocaleFilter reset() {
        this.includes.clear();
        this.excludes.clear();
        this.languageIncludes.clear();
        this.regionIncludes.clear();
        this.userPartIncludes.clear();
        this.languageExcludes.clear();
        this.regionExcludes.clear();
        this.userPartExcludes.clear();
        this.patternIncludes.clear();
        this.patternExcludes.clear();
        return this;
    }

    public boolean matches(LocaleId localeId) {
        Matcher matcher;
        for (LocaleId item : this.excludes) {
            if (!item.equals(localeId)) continue;
            return false;
        }
        for (Pattern pattern : this.patternExcludes) {
            matcher = pattern.matcher(localeId.toString());
            if (!matcher.matches()) continue;
            return false;
        }
        for (String language : this.languageExcludes) {
            if (!localeId.sameLanguageAs(language)) continue;
            return false;
        }
        for (String region : this.regionExcludes) {
            if (!localeId.sameRegionAs(region)) continue;
            return false;
        }
        for (String userPart : this.userPartExcludes) {
            if (!localeId.sameUserPartAs(userPart)) continue;
            return false;
        }
        for (LocaleId item : this.includes) {
            if (!item.equals(localeId)) continue;
            return true;
        }
        for (Pattern pattern : this.patternIncludes) {
            matcher = pattern.matcher(localeId.toString());
            if (!matcher.matches()) continue;
            return true;
        }
        for (String language : this.languageIncludes) {
            if (!localeId.sameLanguageAs(language)) continue;
            return true;
        }
        for (String region : this.regionIncludes) {
            if (!localeId.sameRegionAs(region)) continue;
            return true;
        }
        for (String userPart : this.userPartIncludes) {
            if (!localeId.sameUserPartAs(userPart)) continue;
            return true;
        }
        switch (this.type) {
            case Any: {
                return true;
            }
            case None: {
                return false;
            }
        }
        return false;
    }

    public Set<LocaleId> filter(LocaleId ... localeIds) {
        HashSet<LocaleId> locales = new HashSet<LocaleId>();
        for (LocaleId localeId : localeIds) {
            if (!this.matches(localeId)) continue;
            locales.add(localeId);
        }
        return locales;
    }

    public List<LocaleId> getIncludes() {
        return this.includes;
    }

    public List<LocaleId> getExcludes() {
        return this.excludes;
    }

    public List<String> getLanguageIncludes() {
        return this.languageIncludes;
    }

    public List<String> getRegionIncludes() {
        return this.regionIncludes;
    }

    public List<String> getUserPartIncludes() {
        return this.userPartIncludes;
    }

    public List<String> getLanguageExcludes() {
        return this.languageExcludes;
    }

    public List<String> getRegionExcludes() {
        return this.regionExcludes;
    }

    public List<String> getUserPartExcludes() {
        return this.userPartExcludes;
    }

    public List<Pattern> getPatternIncludes() {
        return this.patternIncludes;
    }

    public List<Pattern> getPatternExcludes() {
        return this.patternExcludes;
    }

    protected FilterType getType() {
        return this.type;
    }

    protected void setType(FilterType type) {
        this.type = type;
    }

    public boolean isEmpty() {
        return Util.isEmpty(this.includes) && Util.isEmpty(this.excludes) && Util.isEmpty(this.languageIncludes) && Util.isEmpty(this.regionIncludes) && Util.isEmpty(this.userPartIncludes) && Util.isEmpty(this.languageExcludes) && Util.isEmpty(this.regionExcludes) && Util.isEmpty(this.userPartExcludes) && Util.isEmpty(this.patternIncludes) && Util.isEmpty(this.patternExcludes);
    }

    private void setFilterType(boolean excludeMode) {
        if (excludeMode) {
            this.setType(FilterType.None);
        } else {
            this.setType(FilterType.Any);
        }
    }

    private void setLanguage(boolean excludeMode, String language) {
        if (Util.isEmpty(language)) {
            return;
        }
        if (excludeMode) {
            this.excludeLanguage(language);
        } else {
            this.includeLanguage(language);
        }
    }

    private void setRegion(boolean excludeMode, String region) {
        if (Util.isEmpty(region)) {
            return;
        }
        if (excludeMode) {
            this.excludeRegion(region);
        } else {
            this.includeRegion(region);
        }
    }

    private void setUserPart(boolean excludeMode, String userPart) {
        if (Util.isEmpty(userPart)) {
            return;
        }
        if (excludeMode) {
            this.excludeUserPart(userPart);
        } else {
            this.includeUserPart(userPart);
        }
    }

    private void setPattern(boolean excludeMode, String pattern, int flags) {
        if (Util.isEmpty(pattern)) {
            return;
        }
        if (excludeMode) {
            this.excludePattern(pattern, flags);
        } else {
            this.includePattern(pattern, flags);
        }
    }

    private void setLocale(boolean excludeMode, String language, String region) {
        if (Util.isEmpty(language)) {
            return;
        }
        if (Util.isEmpty(region)) {
            return;
        }
        if (excludeMode) {
            this.exclude(new LocaleId(language, region));
        } else {
            this.include(new LocaleId(language, region));
        }
    }

    private void setLocale(boolean excludeMode, String language, String region, String userPart) {
        if (Util.isEmpty(language)) {
            return;
        }
        if (Util.isEmpty(region)) {
            return;
        }
        if (Util.isEmpty(userPart)) {
            return;
        }
        if (excludeMode) {
            this.exclude(new LocaleId(language, region, userPart));
        } else {
            this.include(new LocaleId(language, region, userPart));
        }
    }

    public LocaleFilter fromString(String string) {
        int i;
        String commaPlaceholder = "<comma>";
        string = RegexUtil.replaceAll(string, "\\{.*?(,).*?\\}", 1, commaPlaceholder);
        String[] commaChunks = StringUtil.split(string, ",\\p{Space}*");
        String[] spaceChunks = StringUtil.split(string, "[^,\\p{Space}](\\p{Space}+)", 1);
        String[] chunks = commaChunks;
        if (commaChunks.length < spaceChunks.length) {
            chunks = spaceChunks;
        }
        for (i = 0; i < chunks.length; ++i) {
            if (!chunks[i].contains(commaPlaceholder)) continue;
            chunks[i] = chunks[i].replaceAll(commaPlaceholder, ",");
        }
        this.reset();
        if (chunks.length > 0 && !chunks[0].startsWith("!")) {
            this.setType(FilterType.None);
        } else {
            this.setType(FilterType.Any);
        }
        for (i = 0; i < chunks.length; ++i) {
            boolean regexMode;
            String chunk = chunks[i];
            boolean excludeMode = chunk.startsWith("!");
            if (excludeMode) {
                chunk = chunk.substring(1);
            }
            if (regexMode = chunk.startsWith("@")) {
                chunk = chunk.substring(1);
            }
            if (!regexMode) {
                String[] fields = chunk.split("-");
                String language = "";
                String region = "";
                String userPart = "";
                if (fields.length > 3) {
                    fields[2] = ListUtil.merge(fields, 2, fields.length - 1, "-");
                }
                if (fields.length > 0) {
                    language = fields[0];
                }
                if (fields.length > 1) {
                    region = fields[1];
                }
                if (fields.length > 2) {
                    userPart = fields[2];
                }
                boolean anyLanguage = language.equals("*");
                boolean anyRegion = region.equals("*");
                boolean anyUserPart = userPart.equals("*");
                if (fields.length == 1) {
                    if (anyLanguage) {
                        this.setFilterType(excludeMode);
                        continue;
                    }
                    this.setLanguage(excludeMode, language);
                    continue;
                }
                if (fields.length == 2) {
                    if (anyLanguage && anyRegion) {
                        this.setFilterType(excludeMode);
                        continue;
                    }
                    if (anyLanguage && !anyRegion) {
                        this.setRegion(excludeMode, region);
                        continue;
                    }
                    if (!anyLanguage && anyRegion) {
                        this.setLanguage(excludeMode, language);
                        continue;
                    }
                    if (anyLanguage || anyRegion) continue;
                    this.setLocale(excludeMode, language, region);
                    continue;
                }
                if (fields.length != 3) continue;
                if (anyLanguage && anyRegion && anyUserPart) {
                    this.setFilterType(excludeMode);
                    continue;
                }
                if (anyLanguage && anyRegion && !anyUserPart) {
                    this.setUserPart(excludeMode, userPart);
                    continue;
                }
                if (anyLanguage && !anyRegion && anyUserPart) {
                    this.setRegion(excludeMode, region);
                    continue;
                }
                if (anyLanguage && !anyRegion && !anyUserPart) {
                    this.setPattern(excludeMode, "[^-]+-" + region + "-x-" + userPart, 0);
                    continue;
                }
                if (!anyLanguage && anyRegion && anyUserPart) {
                    this.setLanguage(excludeMode, language);
                    continue;
                }
                if (!anyLanguage && anyRegion && !anyUserPart) {
                    this.setPattern(excludeMode, language + "-[^-]+-x-" + userPart, 0);
                    continue;
                }
                if (!anyLanguage && !anyRegion && anyUserPart) {
                    this.setPattern(excludeMode, language + "-" + region + "-x-[^-]+", 0);
                    continue;
                }
                if (anyLanguage || anyRegion || anyUserPart) continue;
                this.setLocale(excludeMode, language, region, userPart);
                continue;
            }
            if (i < chunks.length - 1) {
                String flagsChunk = chunks[i + 1];
                int flags = 0;
                if (flagsChunk.startsWith("^")) {
                    flags = Util.strToInt(flagsChunk.substring(1), 0);
                    ++i;
                }
                this.setPattern(excludeMode, chunk, flags);
                continue;
            }
            this.setPattern(excludeMode, chunk, 0);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean hasIncludes = this.includes.size() != 0 || this.patternIncludes.size() != 0 || this.languageIncludes.size() != 0 || this.regionIncludes.size() != 0 || this.userPartIncludes.size() != 0;
        boolean hasExcludes = this.excludes.size() != 0 || this.patternExcludes.size() != 0 || this.languageExcludes.size() != 0 || this.regionExcludes.size() != 0 || this.userPartExcludes.size() != 0;
        switch (this.type) {
            case Any: {
                if (!hasExcludes && hasIncludes) {
                    sb.append("*");
                    sb.append(" ");
                }
                this.processExcludes(sb);
                this.processPatternExcludes(sb);
                this.processLanguageExcludes(sb);
                this.processRegionExcludes(sb);
                this.processUserPartExcludes(sb);
                this.processIncludes(sb);
                this.processPatternIncludes(sb);
                this.processLanguageIncludes(sb);
                this.processRegionIncludes(sb);
                this.processUserPartIncludes(sb);
                break;
            }
            case None: {
                if (!hasIncludes) {
                    sb.append("!*");
                    sb.append(" ");
                }
                this.processIncludes(sb);
                this.processPatternIncludes(sb);
                this.processLanguageIncludes(sb);
                this.processRegionIncludes(sb);
                this.processUserPartIncludes(sb);
                this.processExcludes(sb);
                this.processPatternExcludes(sb);
                this.processLanguageExcludes(sb);
                this.processRegionExcludes(sb);
                this.processUserPartExcludes(sb);
            }
        }
        return sb.toString().trim();
    }

    private void processUserPartIncludes(StringBuilder sb) {
        if (sb == null) {
            return;
        }
        for (String userPart : ListUtil.invert(this.userPartIncludes)) {
            sb.append("*-*-");
            sb.append(userPart);
            sb.append(" ");
        }
    }

    private void processRegionIncludes(StringBuilder sb) {
        if (sb == null) {
            return;
        }
        for (String region : ListUtil.invert(this.regionIncludes)) {
            sb.append("*-");
            sb.append(region);
            sb.append(" ");
        }
    }

    private void processLanguageIncludes(StringBuilder sb) {
        if (sb == null) {
            return;
        }
        for (String language : ListUtil.invert(this.languageIncludes)) {
            sb.append(language);
            sb.append(" ");
        }
    }

    private void processPatternIncludes(StringBuilder sb) {
        if (sb == null) {
            return;
        }
        for (Pattern pattern : ListUtil.invert(this.patternIncludes)) {
            sb.append("@");
            sb.append(pattern.toString());
            sb.append(" ");
            if (pattern.flags() == 0) continue;
            sb.append("^");
            sb.append(pattern.flags());
            sb.append(" ");
        }
    }

    private void processIncludes(StringBuilder sb) {
        if (sb == null) {
            return;
        }
        for (LocaleId localeId : ListUtil.invert(this.includes)) {
            sb.append(localeId.getLanguage());
            if (!Util.isEmpty(localeId.getRegion())) {
                sb.append("-");
                sb.append(localeId.getRegion());
                if (!Util.isEmpty(localeId.getUserPart())) {
                    sb.append("-");
                    sb.append(localeId.getUserPart());
                }
            }
            sb.append(" ");
        }
    }

    private void processUserPartExcludes(StringBuilder sb) {
        if (sb == null) {
            return;
        }
        for (String userPart : ListUtil.invert(this.userPartExcludes)) {
            sb.append("!");
            sb.append("*-*-");
            sb.append(userPart);
            sb.append(" ");
        }
    }

    private void processRegionExcludes(StringBuilder sb) {
        if (sb == null) {
            return;
        }
        for (String region : ListUtil.invert(this.regionExcludes)) {
            sb.append("!");
            sb.append("*-");
            sb.append(region);
            sb.append(" ");
        }
    }

    private void processLanguageExcludes(StringBuilder sb) {
        if (sb == null) {
            return;
        }
        for (String language : ListUtil.invert(this.languageExcludes)) {
            sb.append("!");
            sb.append(language);
            sb.append(" ");
        }
    }

    private void processPatternExcludes(StringBuilder sb) {
        if (sb == null) {
            return;
        }
        for (Pattern pattern : ListUtil.invert(this.patternExcludes)) {
            sb.append("!");
            sb.append("@");
            sb.append(pattern.toString());
            sb.append(" ");
            if (pattern.flags() == 0) continue;
            sb.append("^");
            sb.append(pattern.flags());
            sb.append(" ");
        }
    }

    private void processExcludes(StringBuilder sb) {
        if (sb == null) {
            return;
        }
        for (LocaleId localeId : ListUtil.invert(this.excludes)) {
            sb.append("!");
            sb.append(localeId.getLanguage());
            if (!Util.isEmpty(localeId.getRegion())) {
                sb.append("-");
                sb.append(localeId.getRegion());
                if (!Util.isEmpty(localeId.getUserPart())) {
                    sb.append("-");
                    sb.append(localeId.getUserPart());
                }
            }
            sb.append(" ");
        }
    }

    public List<String> getExplicitLocaleIds() {
        ArrayList<String> res = new ArrayList<String>();
        if (this.patternIncludes.size() != 0 || this.regionIncludes.size() != 0 || this.userPartIncludes.size() != 0 || this.excludes.size() != 0 || this.patternExcludes.size() != 0 || this.languageExcludes.size() != 0 || this.regionExcludes.size() != 0 || this.userPartExcludes.size() != 0) {
            return res;
        }
        for (LocaleId localeId : this.includes) {
            res.add(localeId.toString());
        }
        for (String language : this.languageIncludes) {
            res.add(language);
        }
        return res;
    }

    public static String getExplicitLocaleIds(String string) {
        LocaleFilter filter = new LocaleFilter(string);
        return ListUtil.listAsString(filter.getExplicitLocaleIds(), " ");
    }

    protected static enum FilterType {
        None,
        Any;

    }
}

