/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.google;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.connectors.google.GoogleMTAPI;
import net.sf.okapi.connectors.google.GoogleMTv2Parameters;
import net.sf.okapi.connectors.google.GoogleResponseParser;
import net.sf.okapi.connectors.google.TranslationResponse;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleMTAPIImpl
implements GoogleMTAPI {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleMTAPIImpl.class);
    private final String baseUrl;
    private GoogleMTv2Parameters params;

    public GoogleMTAPIImpl(String baseUrl, GoogleMTv2Parameters params) {
        this.baseUrl = baseUrl;
        this.params = params;
    }

    @Override
    public List<TranslationResponse> translate(String srcCode, String tgtCode, List<String> sourceTexts) throws IOException, ParseException {
        QueryBuilder qb = new QueryBuilder(srcCode, tgtCode);
        ArrayList<TranslationResponse> responses = new ArrayList<TranslationResponse>();
        for (String sourceText : sourceTexts) {
            if (qb.hasCapacity(sourceText)) {
                qb.addQuery(sourceText);
                continue;
            }
            if (qb.getSourceCount() > 0) {
                LOG.debug("Flushing batch query of length {}, '{}'", (Object)qb.getQuery().length(), (Object)qb.getQuery());
                responses.addAll(this.query(qb));
                qb.reset();
            }
            if (qb.hasCapacity(sourceText)) {
                qb.addQuery(sourceText);
                continue;
            }
            responses.add(this.querySingleSegment(qb, sourceText));
        }
        if (qb.getSourceCount() > 0) {
            responses.addAll(this.query(qb));
        }
        return responses;
    }

    private List<TranslationResponse> query(QueryBuilder qb) throws IOException, ParseException {
        URL url = new URL(qb.getQuery());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        GoogleResponseParser parser = new GoogleResponseParser();
        int code = conn.getResponseCode();
        if (code == 200) {
            List<String> translatedTexts = parser.parseResponse(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            ArrayList<TranslationResponse> responses = new ArrayList<TranslationResponse>();
            if (qb.getSourceCount() != translatedTexts.size()) {
                LOG.error("Received {} translations for {} sources in query {}", translatedTexts.size(), qb.getSourceCount(), qb.getQuery());
                throw new OkapiException("API returned incorrect number of translations (expected " + qb.getSourceCount() + ", got " + translatedTexts.size());
            }
            for (int i = 0; i < qb.getSourceCount(); ++i) {
                responses.add(new TranslationResponse(qb.getSources().get(i), translatedTexts.get(i)));
            }
            return responses;
        }
        String errorBody = StreamUtil.streamUtf8AsString(conn.getErrorStream());
        String error = parser.parseError(new StringReader(errorBody));
        LOG.error("Error {} - {} for query {}; full response: {}", code, error, qb.getQuery(), errorBody);
        throw new OkapiException(String.format("Error: response code %d - %s\n" + conn.getResponseMessage(), code, error));
    }

    private TranslationResponse querySingleSegment(QueryBuilder qb, String sourceText) throws IOException, ParseException {
        LOG.debug("Using POST query for source '{}...' of length {}", (Object)sourceText.substring(0, 32), (Object)sourceText.length());
        URL url = new URL(qb.getQuery());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setDoOutput(true);
        JSONObject json = new JSONObject();
        json.put("q", sourceText);
        try (OutputStreamWriter w = new OutputStreamWriter(conn.getOutputStream(), StandardCharsets.UTF_8);){
            w.write(json.toJSONString());
        }
        GoogleResponseParser parser = new GoogleResponseParser();
        int code = conn.getResponseCode();
        if (code == 200) {
            List<String> translatedTexts = parser.parseResponse(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            if (translatedTexts.size() != 1) {
                LOG.error("Received {} translations for {} sources in POST query {} with body '{}'", translatedTexts.size(), 1, qb.getQuery(), sourceText);
                throw new OkapiException("API returned incorrect number of translations (expected 1, got " + translatedTexts.size());
            }
            return new TranslationResponse(sourceText, translatedTexts.get(0));
        }
        String errorBody = StreamUtil.streamUtf8AsString(conn.getErrorStream());
        String error = parser.parseError(new StringReader(errorBody));
        LOG.error("Error {} - {} for query {}; full response: {}", code, error, qb.getQuery(), errorBody);
        throw new OkapiException(String.format("Error: response code %d - %s\n" + conn.getResponseMessage(), code, error));
    }

    class QueryBuilder {
        private static final int QUERY_LIMIT = 2048;
        private static final String QPARAM = "&q=";
        private StringBuilder sb;
        private final String srcCode;
        private final String tgtCode;
        private List<String> sources = new ArrayList<String>();

        public QueryBuilder(String srcCode, String tgtCode) {
            this.srcCode = srcCode;
            this.tgtCode = tgtCode;
            this.reset();
        }

        public void reset() {
            this.sb = new StringBuilder(GoogleMTAPIImpl.this.baseUrl).append("?key=").append(GoogleMTAPIImpl.this.params.getApiKey()).append("&source=").append(this.srcCode).append("&target=").append(this.tgtCode);
            this.sources.clear();
        }

        public boolean hasCapacity(String sourceText) {
            int additionalLen = QPARAM.length() + Util.URLEncodeUTF8(sourceText).length();
            return this.sb.length() + additionalLen < 2048;
        }

        public void addQuery(String sourceText) {
            if (!this.hasCapacity(sourceText)) {
                throw new IllegalStateException("Query too long to add '" + sourceText + "'");
            }
            this.sb.append(QPARAM).append(Util.URLEncodeUTF8(sourceText));
            this.sources.add(sourceText);
        }

        public List<String> getSources() {
            return this.sources;
        }

        public int getSourceCount() {
            return this.sources.size();
        }

        public String getQuery() {
            return this.sb.toString();
        }
    }
}

