/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.google;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class GoogleResponseParser {
    private JSONParser parser = new JSONParser();

    public List<String> parseResponse(Reader r) throws IOException, ParseException {
        JSONObject json = (JSONObject)this.parser.parse(r);
        JSONArray array = this.requireArray(this.require(json, "data"), "translations");
        ArrayList<String> translations = new ArrayList<String>();
        for (Object o : array) {
            if (!(o instanceof JSONObject)) continue;
            translations.add(this.unescapeTranslation(this.requireString((JSONObject)o, "translatedText")));
        }
        return translations;
    }

    public String parseError(Reader r) throws IOException, ParseException {
        JSONObject json = (JSONObject)this.parser.parse(r);
        return this.requireString(this.require(json, "error"), "message");
    }

    private String unescapeTranslation(String text) {
        text = text.replace("&#39;", "'");
        text = text.replace("&lt;", "<");
        text = text.replace("&gt;", ">");
        text = text.replace("&quot;", "\"");
        return text.replace("&amp;", "&");
    }

    private JSONObject require(JSONObject json, String key) {
        Object o = json.get(key);
        if (o == null || !(o instanceof JSONObject)) {
            throw new IllegalArgumentException("JSON didn't contain expected object " + key);
        }
        return (JSONObject)o;
    }

    private String requireString(JSONObject json, String key) {
        Object o = json.get(key);
        if (o == null || !(o instanceof String)) {
            throw new IllegalArgumentException("JSON didn't contain expected object " + key);
        }
        return (String)o;
    }

    private JSONArray requireArray(JSONObject json, String key) {
        Object o = json.get(key);
        if (o == null || !(o instanceof JSONArray)) {
            throw new IllegalArgumentException("JSON didn't contain expected array " + key);
        }
        return (JSONArray)o;
    }
}

