/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String AZUREKEY = "azureKey";
    private static final String CATEGORY = "category";

    public String getAzureKey() {
        return this.getString(AZUREKEY);
    }

    public void setAzureKey(String azureKey) {
        this.setString(AZUREKEY, azureKey);
    }

    public String getCategory() {
        return this.getString(CATEGORY);
    }

    public void setCategory(String category) {
        this.setString(CATEGORY, category == null ? "" : category);
    }

    @Override
    public void reset() {
        super.reset();
        this.setAzureKey("");
        this.setCategory("");
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(AZUREKEY, "Azure Key (See https://translatorbusiness.uservoice.com/knowledgebase/articles/1078534-microsoft-translator-on-azure#signup)", "Microsoft Azure subscription key");
        desc.add(CATEGORY, "Category (See http://hub.microsofttranslator.com", "A category code for an MT system trained by user data, if any");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Microsoft MT Connector Settings", true, false);
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(AZUREKEY));
        tip.setPassword(true);
        tip = desc.addTextInputPart(paramsDesc.get(CATEGORY));
        tip.setAllowEmpty(true);
        return desc;
    }
}

