/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.segmentation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UserConfiguration;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.ui.AboutDialog;
import net.sf.okapi.common.ui.CharacterInfoDialog;
import net.sf.okapi.common.ui.ConstrainedSashForm;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.InputDialog;
import net.sf.okapi.common.ui.ResourceManager;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.lib.segmentation.LanguageMap;
import net.sf.okapi.lib.segmentation.Rule;
import net.sf.okapi.lib.segmentation.SRXDocument;
import net.sf.okapi.lib.ui.segmentation.FileProcessingDialog;
import net.sf.okapi.lib.ui.segmentation.FileProcessor;
import net.sf.okapi.lib.ui.segmentation.GroupsAndOptionsDialog;
import net.sf.okapi.lib.ui.segmentation.Res;
import net.sf.okapi.lib.ui.segmentation.RuleDialog;
import net.sf.okapi.lib.ui.segmentation.RulesTableModel;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SRXEditor {
    private static final String OPT_BOUNDS = "bounds";
    private static final String OPT_MAXIMIZED = "maximized";
    private static final String APPNAME = "Ratel";
    private static final String CFG_TESTINPUTPATH = "testInputPath";
    private static final String CFG_TESTOUTPUTPATH = "testOutputPath";
    private static final String CFG_HTMLOUTPUT = "htmlOutput";
    private Shell shell;
    private Text edSampleText;
    private Text edResults;
    private Table tblRules;
    private RulesTableModel rulesTableMod;
    private Combo cbGroup;
    private SRXDocument srxDoc;
    private ISegmenter segmenter;
    private String srxPath;
    private TextContainer sampleText;
    private Button btAddRule;
    private Button btEditRule;
    private Button btRemoveRule;
    private Button btMoveUpRule;
    private Button btMoveDownRule;
    private Button rdTestOnLanguage;
    private Button rdTestOnSelectedGroup;
    private Text edSampleLanguage;
    private GenericContent sampleOutput;
    private Font sampleFont;
    private ResourceManager rm;
    private FileProcessor fileProc;
    private String testInputPath;
    private String testOutputPath;
    private boolean htmlOutput;
    private UserConfiguration config = new UserConfiguration();
    private IHelp help;

    protected void finalize() {
        this.dispose();
    }

    public SRXEditor(Shell parent, boolean asDialog, IHelp helpParam) {
        this.config.load(APPNAME);
        this.testInputPath = this.config.getProperty(CFG_TESTINPUTPATH);
        this.testOutputPath = this.config.getProperty(CFG_TESTOUTPUTPATH);
        this.htmlOutput = this.config.getBoolean(CFG_HTMLOUTPUT);
        this.help = helpParam;
        this.srxDoc = new SRXDocument();
        this.srxPath = null;
        this.sampleText = new TextContainer();
        this.sampleOutput = new GenericContent();
        this.fileProc = new FileProcessor();
        this.shell = asDialog ? new Shell(parent, 66800) : parent;
        this.rm = new ResourceManager(SRXEditor.class, this.shell.getDisplay());
        this.rm.loadCommands("net.sf.okapi.lib.ui.segmentation.Commands");
        this.rm.addImages("ratel", "ratel16", "ratel32");
        this.shell.setImages(this.rm.getImages("ratel"));
        GridLayout layout = new GridLayout();
        this.shell.setLayout(layout);
        this.createMenus();
        ConstrainedSashForm sashForm = new ConstrainedSashForm((Composite)this.shell, false);
        sashForm.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        sashForm.setSashWidth(3);
        sashForm.setBackground(this.shell.getDisplay().getSystemColor(18));
        Composite cmpTmp = new Composite(sashForm, 2048);
        cmpTmp.setLayoutData(new GridData(1808));
        GridLayout layTmp = new GridLayout(6, false);
        cmpTmp.setLayout(layTmp);
        Label label = new Label(cmpTmp, 0);
        label.setText(Res.getString("edit.currentLangRules"));
        GridData gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 4;
        label.setLayoutData(gdTmp);
        this.cbGroup = new Combo(cmpTmp, 2060);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 5;
        this.cbGroup.setLayoutData(gdTmp);
        this.cbGroup.setVisibleItemCount(15);
        this.cbGroup.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SRXEditor.this.updateRules(0, false);
            }
        });
        int topButtonsWidth = 180;
        Button btTmp = new Button(cmpTmp, 8);
        btTmp.setText(Res.getString("edit.groupAndOptions"));
        gdTmp = new GridData();
        btTmp.setLayoutData(gdTmp);
        UIUtil.ensureWidth(btTmp, topButtonsWidth);
        btTmp.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SRXEditor.this.editGroupsAndOptions();
            }
        });
        this.tblRules = new Table(cmpTmp, 67620);
        this.tblRules.setHeaderVisible(true);
        this.tblRules.setLinesVisible(true);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 6;
        gdTmp.minimumHeight = 40;
        gdTmp.grabExcessVerticalSpace = true;
        this.tblRules.setLayoutData(gdTmp);
        this.tblRules.addControlListener(new ControlAdapter(){

            @Override
            public void controlResized(ControlEvent e) {
                Rectangle rect = SRXEditor.this.tblRules.getClientArea();
                int typeColWidth = 90;
                int nHalf = (rect.width - typeColWidth) / 2;
                SRXEditor.this.tblRules.getColumn(0).setWidth(typeColWidth);
                SRXEditor.this.tblRules.getColumn(1).setWidth(nHalf);
                SRXEditor.this.tblRules.getColumn(2).setWidth(nHalf);
            }
        });
        this.tblRules.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
                SRXEditor.this.editRule(false);
            }

            @Override
            public void mouseDown(MouseEvent e) {
            }

            @Override
            public void mouseUp(MouseEvent e) {
            }
        });
        this.tblRules.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    SRXEditor.this.tblRules.setSelection((TableItem)e.item);
                    int n = SRXEditor.this.tblRules.getSelectionIndex();
                    if (n < 0) {
                        return;
                    }
                    String ruleName = SRXEditor.this.cbGroup.getItem(SRXEditor.this.cbGroup.getSelectionIndex());
                    ((Rule)SRXEditor.this.srxDoc.getLanguageRules(ruleName).get(n)).setActive(((TableItem)e.item).getChecked());
                    SRXEditor.this.srxDoc.setModified(true);
                    SRXEditor.this.updateResults(true);
                }
                SRXEditor.this.updateRulesButtons();
            }
        });
        this.rulesTableMod = new RulesTableModel();
        this.rulesTableMod.linkTable(this.tblRules);
        Composite cmpGroup = new Composite(cmpTmp, 0);
        layTmp = new GridLayout(7, true);
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        cmpGroup.setLayout(layTmp);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 6;
        cmpGroup.setLayoutData(gdTmp);
        this.btAddRule = new Button(cmpGroup, 8);
        this.btAddRule.setLayoutData(new GridData(768));
        this.btAddRule.setText(Res.getString("edit.btAddRule"));
        this.btAddRule.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SRXEditor.this.editRule(true);
            }
        });
        this.btEditRule = new Button(cmpGroup, 8);
        this.btEditRule.setLayoutData(new GridData(768));
        this.btEditRule.setText(Res.getString("edit.btEditRule"));
        this.btEditRule.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SRXEditor.this.editRule(false);
            }
        });
        this.btRemoveRule = new Button(cmpGroup, 8);
        this.btRemoveRule.setLayoutData(new GridData(768));
        this.btRemoveRule.setText(Res.getString("edit.btRemoveRule"));
        this.btRemoveRule.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SRXEditor.this.removeRule();
            }
        });
        this.btMoveUpRule = new Button(cmpGroup, 8);
        this.btMoveUpRule.setLayoutData(new GridData(768));
        this.btMoveUpRule.setText(Res.getString("edit.moveUp"));
        this.btMoveUpRule.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SRXEditor.this.moveUpRule();
            }
        });
        this.btMoveDownRule = new Button(cmpGroup, 8);
        this.btMoveDownRule.setLayoutData(new GridData(768));
        this.btMoveDownRule.setText(Res.getString("edit.moveDown"));
        this.btMoveDownRule.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SRXEditor.this.moveDownRule();
            }
        });
        Button btMaskRule = new Button(cmpGroup, 8);
        btMaskRule.setLayoutData(new GridData(768));
        btMaskRule.setText(Res.getString("edit.maskRule"));
        btMaskRule.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SRXEditor.this.editMaskRule();
            }
        });
        Button btCharInfo = new Button(cmpGroup, 8);
        btCharInfo.setLayoutData(new GridData(768));
        btCharInfo.setText(Res.getString("edit.charInfo"));
        btCharInfo.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SRXEditor.this.showCharInfo();
            }
        });
        Composite cmpSample = new Composite(sashForm, 2048);
        cmpSample.setLayoutData(new GridData(1808));
        cmpSample.setLayout(new GridLayout(3, false));
        label = new Label(cmpSample, 0);
        label.setText(Res.getString("edit.sampleNote"));
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 3;
        label.setLayoutData(gdTmp);
        int sampleMinHeight = 40;
        this.edSampleText = new Text(cmpSample, 2626);
        gdTmp = new GridData(1808);
        gdTmp.minimumHeight = sampleMinHeight;
        gdTmp.horizontalSpan = 3;
        this.edSampleText.setLayoutData(gdTmp);
        Font font = this.edSampleText.getFont();
        FontData[] fontData = font.getFontData();
        fontData[0].setHeight(fontData[0].getHeight() + 2);
        this.sampleFont = new Font(font.getDevice(), fontData[0]);
        this.edSampleText.setFont(this.sampleFont);
        this.rdTestOnSelectedGroup = new Button(cmpSample, 16);
        this.rdTestOnSelectedGroup.setText(Res.getString("edit.testOnlyGroup"));
        this.rdTestOnSelectedGroup.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SRXEditor.this.edSampleLanguage.setEnabled(SRXEditor.this.rdTestOnLanguage.getSelection());
                SRXEditor.this.updateRules(SRXEditor.this.tblRules.getSelectionIndex(), true);
            }
        });
        this.rdTestOnLanguage = new Button(cmpSample, 16);
        this.rdTestOnLanguage.setText(Res.getString("edit.testLanguage"));
        this.rdTestOnLanguage.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SRXEditor.this.edSampleLanguage.setEnabled(SRXEditor.this.rdTestOnLanguage.getSelection());
                SRXEditor.this.updateRules(SRXEditor.this.tblRules.getSelectionIndex(), true);
            }
        });
        this.edSampleLanguage = new Text(cmpSample, 2052);
        gdTmp = new GridData();
        gdTmp.widthHint = 40;
        this.edSampleLanguage.setLayoutData(gdTmp);
        this.edSampleLanguage.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                SRXEditor.this.updateResults(false);
            }
        });
        this.edResults = new Text(cmpSample, 2626);
        gdTmp = new GridData(1808);
        this.edResults.setLayoutData(gdTmp);
        gdTmp.minimumHeight = sampleMinHeight;
        gdTmp.horizontalSpan = 3;
        this.edResults.setEditable(false);
        this.edResults.setFont(this.sampleFont);
        sashForm.setWeights(new int[]{1, 1});
        this.edSampleText.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent e) {
                SRXEditor.this.updateResults(false);
            }
        });
        this.shell.addShellListener(new ShellListener(){

            @Override
            public void shellActivated(ShellEvent event) {
            }

            @Override
            public void shellClosed(ShellEvent event) {
                if (!SRXEditor.this.checkIfRulesNeedSaving()) {
                    event.doit = false;
                }
            }

            @Override
            public void shellDeactivated(ShellEvent event) {
            }

            @Override
            public void shellDeiconified(ShellEvent event) {
            }

            @Override
            public void shellIconified(ShellEvent event) {
            }
        });
        DropTarget dropTarget = new DropTarget(this.shell, 19);
        dropTarget.setTransfer(new FileTransfer[]{FileTransfer.getInstance()});
        dropTarget.addDropListener(new DropTargetAdapter(){

            @Override
            public void drop(DropTargetEvent e) {
                String[] paths;
                FileTransfer FT = FileTransfer.getInstance();
                if (FT.isSupportedType(e.currentDataType) && (paths = (String[])e.data) != null) {
                    SRXEditor.this.loadSRXDocument(paths[0]);
                }
            }
        });
        if (!this.shell.getMaximized()) {
            Point startSize = this.shell.getSize();
            this.shell.pack();
            this.shell.setMinimumSize(this.shell.getSize());
            this.shell.setSize(startSize);
            this.shell.setMaximized(true);
            this.shell.setMaximized(false);
            UIUtil.centerShell(this.shell);
            if (this.config.getBoolean(OPT_MAXIMIZED)) {
                this.shell.setMaximized(true);
            } else {
                this.shell.setMaximized(false);
                Rectangle ar = UIUtil.StringToRectangle(this.config.getProperty(OPT_BOUNDS));
                if (ar != null) {
                    Rectangle dr = this.shell.getDisplay().getBounds();
                    if (dr.contains(ar.x + ar.width, ar.y + ar.height) && dr.contains(ar.x, ar.y)) {
                        this.shell.setBounds(ar);
                    }
                } else if (asDialog) {
                    Dialogs.centerWindow(this.shell, parent);
                }
            }
        }
        this.newSRXDocument(1, false);
    }

    private void createMenus() {
        Menu menuBar = new Menu(this.shell, 2);
        this.shell.setMenuBar(menuBar);
        MenuItem topItem = new MenuItem(menuBar, 64);
        topItem.setText(this.rm.getCommandLabel("file"));
        Menu dropMenu = new Menu(this.shell, 4);
        topItem.setMenu(dropMenu);
        MenuItem menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.new");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                SRXEditor.this.newSRXDocument(1, true);
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.newWithSample");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                SRXEditor.this.newSRXDocument(2, true);
            }
        });
        new MenuItem(dropMenu, 2);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.open");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                SRXEditor.this.loadSRXDocument(null);
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.loadFromClipboard");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                SRXEditor.this.loadSRXDocumentfromClipboard();
            }
        });
        new MenuItem(dropMenu, 2);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.save");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                SRXEditor.this.saveSRXDocument(SRXEditor.this.srxPath);
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.saveas");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                SRXEditor.this.saveSRXDocument(null);
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.copyToClipboard");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                SRXEditor.this.copySRXDocumentToClipboard();
            }
        });
        new MenuItem(dropMenu, 2);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.exit");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                SRXEditor.this.shell.close();
            }
        });
        topItem = new MenuItem(menuBar, 64);
        topItem.setText(this.rm.getCommandLabel("tools"));
        dropMenu = new Menu(this.shell, 4);
        topItem.setMenu(dropMenu);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "tools.segfile");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                SRXEditor.this.segmentTextFile();
            }
        });
        topItem = new MenuItem(menuBar, 64);
        topItem.setText(this.rm.getCommandLabel("help"));
        dropMenu = new Menu(this.shell, 4);
        topItem.setMenu(dropMenu);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.topics");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (SRXEditor.this.help != null) {
                    SRXEditor.this.help.showWiki(SRXEditor.APPNAME);
                }
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.howtouse");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (SRXEditor.this.help != null) {
                    SRXEditor.this.help.showWiki("Ratel - Usage");
                }
            }
        });
        new MenuItem(dropMenu, 2);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.update");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                UIUtil.start("http://okapiframework.org/updates.html?" + this.getClass().getPackage().getImplementationTitle() + "=" + this.getClass().getPackage().getImplementationVersion());
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.feedback");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                UIUtil.start("mailto:okapitools@opentag.com&subject=Feedback (Ratel: SRX Editor)");
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.bugreport");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                UIUtil.start("https://bitbucket.org/okapiframework/okapi/issues");
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.featurerequest");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                UIUtil.start("https://bitbucket.org/okapiframework/okapi/issues");
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.users");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                UIUtil.start("http://groups.yahoo.com/group/okapitools/");
            }
        });
        menuItem = new MenuItem(dropMenu, 2);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.srx20");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                UIUtil.start("http://www.gala-global.org/oscarStandards/srx/srx20.html");
            }
        });
        menuItem = new MenuItem(dropMenu, 2);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.about");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                AboutDialog dlg = new AboutDialog(SRXEditor.this.shell, Res.getString("SRXEditor.aboutCaption"), Res.getString("SRXEditor.aboutDescription"), this.getClass().getPackage().getImplementationVersion());
                dlg.showDialog();
            }
        });
    }

    public void dispose() {
        if (this.sampleFont != null) {
            this.sampleFont.dispose();
            this.sampleFont = null;
        }
        if (this.rm != null) {
            this.rm.dispose();
            this.rm = null;
        }
    }

    private void showCharInfo() {
        try {
            CharacterInfoDialog charInfoDlg = new CharacterInfoDialog(this.shell, Res.getString("edit.charInfoCaption"), this.help);
            int codePoint = 225;
            String tmp = this.edSampleText.getSelectionText();
            if (tmp.length() > 0) {
                codePoint = tmp.codePointAt(0);
            }
            charInfoDlg.showDialog(codePoint);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    public void showDialog(String path) {
        this.shell.open();
        if (path != null) {
            this.loadSRXDocument(path);
        }
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        this.dispose();
    }

    public String getPath() {
        return this.srxPath;
    }

    private void updateResults(boolean forceReset) {
        try {
            if (this.cbGroup.getSelectionIndex() != -1) {
                if (this.rdTestOnSelectedGroup.getSelection()) {
                    this.segmenter = this.srxDoc.compileSingleLanguageRule(this.cbGroup.getText(), forceReset ? null : this.segmenter);
                } else {
                    if (this.edSampleLanguage.getText().length() == 0) {
                        this.edSampleLanguage.setText("en");
                    }
                    this.segmenter = this.srxDoc.compileLanguageRules(LocaleId.fromString((String)this.edSampleLanguage.getText()), forceReset ? null : this.segmenter);
                }
            } else {
                this.segmenter = null;
            }
            if (this.segmenter != null && this.segmenter.getLanguage() != null) {
                this.fileProc.populateTextContainer(this.edSampleText.getText().replace("\r", ""), this.sampleText);
                this.segmenter.computeSegments(this.sampleText);
                this.sampleText.getSegments().create(this.segmenter.getRanges());
                this.edResults.setText(this.sampleOutput.printSegmentedContent(this.sampleText, true, true));
            } else {
                this.edResults.setText("");
            }
        }
        catch (Throwable e) {
            this.edResults.setText(Res.getString("edit.error") + e.getMessage());
        }
    }

    private void updateLanguageRuleList() {
        this.cbGroup.removeAll();
        LinkedHashMap langRules = this.srxDoc.getAllLanguageRules();
        for (String ruleName : langRules.keySet()) {
            this.cbGroup.add(ruleName);
        }
        if (this.cbGroup.getItemCount() > 0) {
            this.cbGroup.select(0);
        }
        this.updateRules(0, true);
    }

    private void updateRules(int selection, boolean forceReset) {
        this.rulesTableMod.setLanguageRules(this.srxDoc.getLanguageRules(this.cbGroup.getText()));
        this.rulesTableMod.updateTable(selection);
        this.updateResults(forceReset);
        this.updateRulesButtons();
    }

    private void updateRulesButtons() {
        int n = this.tblRules.getSelectionIndex();
        this.btAddRule.setEnabled(this.cbGroup.getSelectionIndex() > -1);
        this.btEditRule.setEnabled(n != -1);
        this.btRemoveRule.setEnabled(n != -1);
        this.btMoveUpRule.setEnabled(n > 0);
        this.btMoveDownRule.setEnabled(n < this.tblRules.getItemCount() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editGroupsAndOptions() {
        try {
            this.getSurfaceData();
            GroupsAndOptionsDialog dlg = new GroupsAndOptionsDialog(this.shell, this.srxDoc, this.help);
            dlg.showDialog();
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
        }
        finally {
            this.updateAll();
        }
    }

    private void setSurfaceData() {
        this.edSampleText.setText(this.srxDoc.getSampleText());
        this.edSampleLanguage.setText(this.srxDoc.getSampleLanguage());
        this.rdTestOnSelectedGroup.setSelection(this.srxDoc.testOnSelectedGroup());
        this.rdTestOnLanguage.setSelection(!this.srxDoc.testOnSelectedGroup());
        this.edSampleLanguage.setEnabled(this.rdTestOnLanguage.getSelection());
    }

    private void getSurfaceData() {
        this.srxDoc.setSampleText(this.edSampleText.getText().replace("\r", ""));
        this.srxDoc.setSampleLanguage(this.edSampleLanguage.getText());
        this.srxDoc.setTestOnSelectedGroup(this.rdTestOnSelectedGroup.getSelection());
    }

    private void updateCaption() {
        String filename = this.srxPath != null ? this.updateCaption_getFileName(this.srxPath) : Res.getString("SRXEditor.untitled");
        String text = Res.getString("edit.captionApp");
        this.shell.setText(filename + " - " + text);
    }

    protected String updateCaption_getFileName(String srxPath) {
        return Util.getFilename((String)srxPath, (boolean)true);
    }

    private void updateAll() {
        this.cbGroup.removeAll();
        this.setSurfaceData();
        this.updateLanguageRuleList();
    }

    private boolean newSRXDocument(int defaultContent, boolean checkIfNeedSaving) {
        if (checkIfNeedSaving && !this.checkIfRulesNeedSaving()) {
            return false;
        }
        this.srxDoc = new SRXDocument();
        this.srxPath = null;
        this.updateCaption();
        switch (defaultContent) {
            case 1: {
                this.srxDoc.addLanguageRule(Res.getString("SRXEditor.defaultSetName"), new ArrayList());
                this.srxDoc.addLanguageMap(new LanguageMap(".*", Res.getString("SRXEditor.defaultSetName")));
                this.srxDoc.setModified(false);
                break;
            }
            case 2: {
                ArrayList<Rule> list = new ArrayList<Rule>();
                list.add(new Rule("([A-Z]\\.){2,}", "\\s", false));
                list.add(new Rule("\\.", "\\s", true));
                this.srxDoc.addLanguageRule(Res.getString("SRXEditor.defaultSetName"), list);
                this.srxDoc.addLanguageMap(new LanguageMap(".*", Res.getString("SRXEditor.defaultSetName")));
                this.srxDoc.setModified(false);
            }
        }
        this.updateAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSRXDocumentfromClipboard() {
        try {
            if (!this.checkIfRulesNeedSaving()) {
                return;
            }
            this.getSurfaceData();
            Clipboard clipboard = new Clipboard(this.shell.getDisplay());
            TransferData[] transferDatas = clipboard.getAvailableTypes();
            boolean found = false;
            for (int i = 0; i < transferDatas.length; ++i) {
                if (!TextTransfer.getInstance().isSupportedType(transferDatas[i])) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
            this.srxDoc.loadRules((CharSequence)clipboard.getContents(TextTransfer.getInstance()));
            if (this.srxDoc.hasWarning()) {
                MessageBox dlg = new MessageBox(this.shell, 328);
                dlg.setText(this.shell.getText());
                dlg.setMessage(this.srxDoc.getWarning());
                dlg.open();
            }
            this.srxPath = null;
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
        }
        finally {
            this.updateCaption();
            this.updateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSRXDocument(String path) {
        try {
            if (!this.checkIfRulesNeedSaving()) {
                return;
            }
            this.getSurfaceData();
            if (path == null) {
                String[] paths = Dialogs.browseFilenames(this.shell, Res.getString("edit.loadDocCaption"), false, null, Res.getString("edit.loadDocFileTypes"), Res.getString("edit.loadDocFilters"));
                if (paths == null) {
                    return;
                }
                path = paths[0];
            }
            this.srxPath = null;
            this.srxDoc.loadRules(path);
            if (this.srxDoc.hasWarning()) {
                MessageBox dlg = new MessageBox(this.shell, 328);
                dlg.setText(this.shell.getText());
                dlg.setMessage(this.srxDoc.getWarning());
                dlg.open();
            }
            this.srxPath = path;
            this.loadSRXDocument_rulesLoaded(this.srxPath);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
        }
        finally {
            this.updateCaption();
            this.updateAll();
        }
    }

    protected void loadSRXDocument_rulesLoaded(String path) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySRXDocumentToClipboard() {
        if (!this.srxDoc.getVersion().equals("2.0")) {
            MessageBox dlg = new MessageBox(this.shell, 452);
            dlg.setText(this.shell.getText());
            dlg.setMessage(Res.getString("edit.saveDocVersionWarning"));
            if (dlg.open() != 64) {
                return;
            }
        }
        this.getSurfaceData();
        Clipboard clipboard = null;
        try {
            clipboard = new Clipboard(this.shell.getDisplay());
            TextTransfer textTransfer = TextTransfer.getInstance();
            clipboard.setContents(new String[]{this.srxDoc.saveRulesToString(false, false)}, new Transfer[]{textTransfer});
        }
        finally {
            if (clipboard != null) {
                clipboard.dispose();
            }
        }
    }

    private boolean saveSRXDocument(String path) {
        try {
            boolean saveAsMode;
            if (!this.srxDoc.getVersion().equals("2.0")) {
                MessageBox dlg = new MessageBox(this.shell, 452);
                dlg.setText(this.shell.getText());
                dlg.setMessage(Res.getString("edit.saveDocVersionWarning"));
                if (dlg.open() != 64) {
                    return false;
                }
            }
            boolean bl = saveAsMode = path == null;
            if (saveAsMode && (path = this.saveSRXDocument_getPath()) == null) {
                return false;
            }
            this.getSurfaceData();
            this.srxDoc.saveRules(path, true, false);
            this.srxPath = path;
            this.updateCaption();
            this.saveSRXDocument_afterSave(path, saveAsMode);
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
        }
        return true;
    }

    protected String saveSRXDocument_getPath() {
        return Dialogs.browseFilenamesForSave(this.shell, Res.getString("edit.saveDocCaption"), null, null, Res.getString("edit.saveDocFileTypes"), Res.getString("edit.saveDocFilters"));
    }

    protected void saveSRXDocument_afterSave(String path, boolean saveAsMode) {
    }

    private void editRule(boolean createNewRule) {
        Rule rule;
        if (this.cbGroup.getSelectionIndex() < 0) {
            return;
        }
        String ruleName = this.cbGroup.getItem(this.cbGroup.getSelectionIndex());
        int n = -1;
        if (createNewRule) {
            rule = new Rule("", "", true);
        } else {
            n = this.tblRules.getSelectionIndex();
            if (n == -1) {
                return;
            }
            rule = (Rule)this.srxDoc.getLanguageRules(ruleName).get(n);
        }
        RuleDialog dlg = new RuleDialog(this.shell, rule, this.help);
        rule = dlg.showDialog();
        if (rule == null) {
            return;
        }
        if (createNewRule) {
            this.srxDoc.getLanguageRules(ruleName).add(rule);
            n = this.srxDoc.getLanguageRules(ruleName).size() - 1;
        } else {
            this.srxDoc.getLanguageRules(ruleName).set(n, rule);
        }
        this.srxDoc.setModified(true);
        this.updateRules(n, true);
    }

    private void removeRule() {
        int n = this.tblRules.getSelectionIndex();
        if (n == -1) {
            return;
        }
        String ruleName = this.cbGroup.getItem(this.cbGroup.getSelectionIndex());
        this.srxDoc.getLanguageRules(ruleName).remove(n);
        this.srxDoc.setModified(true);
        this.tblRules.remove(n);
        if (n > this.tblRules.getItemCount() - 1) {
            n = this.tblRules.getItemCount() - 1;
        }
        if (this.tblRules.getItemCount() > 0) {
            this.tblRules.select(n);
        }
        this.updateRulesButtons();
        this.updateResults(true);
    }

    private void moveUpRule() {
        int n = this.tblRules.getSelectionIndex();
        if (n < 1) {
            return;
        }
        String ruleName = this.cbGroup.getItem(this.cbGroup.getSelectionIndex());
        Rule tmp = (Rule)this.srxDoc.getLanguageRules(ruleName).get(n - 1);
        this.srxDoc.getLanguageRules(ruleName).set(n - 1, this.srxDoc.getLanguageRules(ruleName).get(n));
        this.srxDoc.getLanguageRules(ruleName).set(n, tmp);
        this.srxDoc.setModified(true);
        this.updateRules(n - 1, true);
    }

    private void moveDownRule() {
        int n = this.tblRules.getSelectionIndex();
        if (n > this.tblRules.getItemCount() - 2) {
            return;
        }
        String ruleName = this.cbGroup.getItem(this.cbGroup.getSelectionIndex());
        Rule tmp = (Rule)this.srxDoc.getLanguageRules(ruleName).get(n + 1);
        this.srxDoc.getLanguageRules(ruleName).set(n + 1, this.srxDoc.getLanguageRules(ruleName).get(n));
        this.srxDoc.getLanguageRules(ruleName).set(n, tmp);
        this.srxDoc.setModified(true);
        this.updateRules(n + 1, true);
    }

    private void editMaskRule() {
        try {
            String pattern = this.srxDoc.getMaskRule();
            while (true) {
                InputDialog dlg = new InputDialog(this.shell, Res.getString("edit.maskRuleCaption"), Res.getString("edit.maskRuleDesc"), "", null, 0, -1, -1);
                dlg.setInputValue(pattern);
                dlg.setAllowEmptyValue(true);
                pattern = dlg.showDialog();
                if (pattern == null) {
                    return;
                }
                try {
                    Pattern.compile(pattern.replace("\\Y", SRXDocument.INLINECODE_PATTERN));
                }
                catch (PatternSyntaxException e) {
                    Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
                    continue;
                }
                break;
            }
            this.srxDoc.setMaskRule(pattern);
            this.updateResults(true);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
        }
    }

    private boolean checkIfRulesNeedSaving() {
        this.config.setProperty(CFG_TESTINPUTPATH, this.testInputPath);
        this.config.setProperty(CFG_TESTOUTPUTPATH, this.testOutputPath);
        this.config.setProperty(CFG_HTMLOUTPUT, this.htmlOutput);
        this.config.setProperty(OPT_MAXIMIZED, this.shell.getMaximized());
        Rectangle r = this.shell.getBounds();
        this.config.setProperty(OPT_BOUNDS, String.format("%d,%d,%d,%d", r.x, r.y, r.width, r.height));
        this.config.save(APPNAME, this.getClass().getPackage().getImplementationVersion());
        this.getSurfaceData();
        if (this.srxDoc.isModified()) {
            MessageBox dlg = new MessageBox(this.shell, 452);
            dlg.setText(this.shell.getText());
            dlg.setMessage(Res.getString("edit.confirmSave"));
            switch (dlg.open()) {
                case 256: {
                    return false;
                }
                case 64: {
                    return this.saveSRXDocument(this.srxPath);
                }
            }
        }
        return true;
    }

    private void segmentTextFile() {
        try {
            String[] result = this.segmentTextFile_getPaths(this.testInputPath, this.testOutputPath, this.htmlOutput);
            if (result == null) {
                return;
            }
            this.testInputPath = result[0];
            this.testOutputPath = result[1];
            this.htmlOutput = result[2] != null;
            this.fileProc.process(this.testInputPath, this.testOutputPath, this.htmlOutput, this.segmenter);
            this.segmentTextFile_processResult(this.testOutputPath);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
        }
    }

    protected String[] segmentTextFile_getPaths(String testInputPath, String testOutputPath, boolean htmlOutput) {
        FileProcessingDialog dlg = new FileProcessingDialog(this.shell, this.help);
        String[] result = dlg.showDialog(testInputPath, testOutputPath, htmlOutput);
        return result;
    }

    protected void segmentTextFile_processResult(String testOutputPath) {
        UIUtil.start(testOutputPath);
    }
}

