/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.utilities.alignment;

import java.io.File;
import java.io.OutputStream;
import java.util.Stack;
import net.sf.okapi.applications.rainbow.utilities.alignment.DbStore;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

class DbStoreBuilder
implements IFilterWriter {
    private Stack<Integer> groupStack;
    private int lastGroupKey;
    private DbStore dbs = new DbStore();
    private ISegmenter segmenter;
    private LocaleId language;
    private boolean useSource;

    public DbStore getDbStore() {
        return this.dbs;
    }

    public void setSegmenter(ISegmenter segmenter) {
        this.segmenter = segmenter;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument((StartDocument)event.getResource());
                break;
            }
            case START_GROUP: 
            case START_SUBFILTER: {
                this.processStartGroup();
                break;
            }
            case END_GROUP: 
            case END_SUBFILTER: {
                this.processEndGroup();
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event.getTextUnit());
                break;
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId language, String defaultEncoding) {
        this.language = language;
    }

    @Override
    public void setOutput(String path) {
    }

    @Override
    public void setOutput(OutputStream output) {
    }

    @Override
    public void setParameters(IParameters params) {
    }

    private void processEndGroup() {
        this.groupStack.pop();
    }

    private void processTextUnit(ITextUnit tu) {
        TextContainer tc;
        if (this.useSource) {
            tc = tu.getSource();
        } else {
            tc = tu.getTarget(this.language);
            if (tc == null) {
                return;
            }
        }
        if (this.segmenter != null) {
            this.segmenter.computeSegments(tc);
            tc.getSegments().create(this.segmenter.getRanges());
        }
        this.dbs.addSourceEntry(tc, this.groupStack.peek(), tu.getId(), tu.getName(), tu.getType());
    }

    private void processStartGroup() {
        this.groupStack.push(++this.lastGroupKey);
    }

    private void processStartDocument(StartDocument resource) {
        this.groupStack = new Stack();
        this.lastGroupKey = 0;
        this.groupStack.push(0);
        this.useSource = !resource.isMultilingual();
        String path = Util.getTempDirectory() + File.separatorChar + "tmpDB";
        this.dbs.create(path, "tmpDB", true);
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }
}

