/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.utilities.merging;

import net.sf.okapi.applications.rainbow.packages.Manifest;
import net.sf.okapi.applications.rainbow.packages.ManifestItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class ManifestTableModel {
    private Table table;
    private Manifest manifest;

    ManifestTableModel() {
    }

    public void linkTable(Table newTable) {
        this.table = newTable;
        TableColumn col = new TableColumn(this.table, 0);
        col.setText("Documents to Post-Process");
        col = new TableColumn(this.table, 0);
        col.setText("Missing?");
        col = new TableColumn(this.table, 0);
        col.setText("Output");
    }

    public void setManifest(Manifest newManifest) {
        this.manifest = newManifest;
        this.updateTable(null, 0);
    }

    void updateTable(int[] selection, int index) {
        this.table.removeAll();
        for (int i : this.manifest.getItems().keySet()) {
            ManifestItem mi = this.manifest.getItem(i);
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, mi.getRelativeWorkPath());
            if (!mi.exists()) {
                item.setText(1, "missing");
            }
            item.setText(2, mi.getRelativeOutputPath());
            item.setChecked(mi.selected());
        }
        if (selection == null) {
            if (this.table.getItemCount() > 0) {
                if (index > -1) {
                    if (index > this.table.getItemCount() - 1) {
                        index = this.table.getItemCount() - 1;
                    }
                } else {
                    index = 0;
                }
                this.table.setSelection(index);
            }
        } else {
            this.table.setSelection(selection);
        }
    }

    public void saveData() {
        for (int i = 0; i < this.table.getItemCount(); ++i) {
            ManifestItem mi = this.manifest.getItem(i + 1);
            if (mi == null) continue;
            mi.setSelected(this.table.getItem(i).getChecked());
        }
    }
}

