/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.connectors.microsoft.GetTranslateOptions;
import net.sf.okapi.connectors.microsoft.GetTranslationsArrayRequest;
import net.sf.okapi.connectors.microsoft.GetTranslationsResponseParser;
import net.sf.okapi.connectors.microsoft.MicrosoftMTAPI;
import net.sf.okapi.connectors.microsoft.Parameters;
import net.sf.okapi.connectors.microsoft.TokenProvider;
import net.sf.okapi.connectors.microsoft.TranslationResponse;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MicrosoftMTAPIImpl
implements MicrosoftMTAPI {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params;
    private HttpClient httpClient;
    private TokenProvider tokenProvider;
    public static final String MSMT_BASE_URL = "http://api.microsofttranslator.com/v2/Http.svc";

    MicrosoftMTAPIImpl(Parameters params, HttpClient httpClient, TokenProvider tokenProvider) {
        this.params = params;
        this.httpClient = httpClient;
        this.tokenProvider = tokenProvider;
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public List<TranslationResponse> getTranslations(String query, String srcLang, String trgLang, int maxHits, int threshold) {
        String xml;
        String options = new GetTranslateOptions(this.params.getCategory()).toXML();
        StringEntity body = new StringEntity(options, StandardCharsets.UTF_8);
        HttpUriRequest request = RequestBuilder.post("http://api.microsofttranslator.com/v2/Http.svc/GetTranslations").addParameter("text", query).addParameter("from", srcLang).addParameter("to", trgLang).addParameter("maxTranslations", String.valueOf(maxHits)).addHeader("Content-Type", "text/xml").addHeader("Authorization", "Bearer " + this.tokenProvider.get()).setEntity(body).build();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getTranslation options: " + options);
        }
        return (xml = this.getXmlResponse(request, options)) != null ? new GetTranslationsResponseParser().parseGetTranslationsResponse(xml, maxHits, threshold) : null;
    }

    @Override
    public List<List<TranslationResponse>> getTranslationsArray(GetTranslationsArrayRequest data, String srcLang, String trgLang, int maxHits, int threshold) {
        String xml;
        String queryXml = data.toXML();
        StringEntity body = new StringEntity(queryXml, StandardCharsets.UTF_8);
        HttpUriRequest request = RequestBuilder.post("http://api.microsofttranslator.com/v2/Http.svc/GetTranslationsArray").addParameter("from", srcLang).addParameter("to", trgLang).addParameter("maxTranslations", String.valueOf(maxHits)).addHeader("Content-Type", "text/xml").addHeader("Authorization", "Bearer " + this.tokenProvider.get()).setEntity(body).build();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getTranslationsArray options: " + queryXml);
        }
        return (xml = this.getXmlResponse(request, queryXml)) != null ? new GetTranslationsResponseParser().parseGetTranslationsArrayResponse(xml, maxHits, threshold) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getXmlResponse(HttpUriRequest request, String queryXml) {
        HttpResponse response = null;
        try {
            response = this.execute(request);
            StatusLine status = response.getStatusLine();
            try (InputStream is = response.getEntity().getContent();){
                String responseBody = StreamUtil.streamUtf8AsString(is);
                if (status.getStatusCode() == 200) {
                    String string = responseBody;
                    return string;
                }
                this.logger.error("Query response code: {}: {}\nBody: {}\nFor query {} with body {}", status.getStatusCode(), status.getReasonPhrase(), responseBody, request.toString(), queryXml);
                if (response.containsHeader("X-MS-Trans-Info")) {
                    for (Header h : response.getHeaders("X-MS-Trans-Info")) {
                        this.logger.error("X-MS-Trans-Info Header: {}", (Object)h.getValue());
                    }
                }
            }
        }
        catch (IOException e) {
            this.logger.error("Query failed: {}, for query {} with body {}", e.getMessage(), request.toString(), queryXml);
            this.logger.error("Full failure trace: ", e);
        }
        finally {
            if (response != null) {
                try {
                    response.getEntity().getContent().close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    private HttpResponse execute(HttpUriRequest request) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(request.toString());
        }
        HttpResponse response = this.httpClient.execute(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(response.toString());
        }
        return response;
    }
}

