/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.icml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.icml.ICMLSkeleton;
import net.sf.okapi.filters.icml.NodeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ICMLFilterWriter
implements IFilterWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DocumentBuilder docBuilder;
    private Document docOriginal;
    private String outputPath;
    private LocaleId trgLoc;
    private File tempFile;
    private byte[] buffer;
    private Transformer xformer;
    private Document doc;
    private OutputStream xmlOutStream;
    private int group;
    private Stack<IReferenceable> referents;
    private ArrayList<String> storiesLeft;
    private StringBuilder xml;
    private boolean reconstructing;
    private OutputStream outputStream;

    public ICMLFilterWriter() {
        try {
            DocumentBuilderFactory docFact = DocumentBuilderFactory.newInstance();
            docFact.setValidating(false);
            try {
                docFact.setFeature("http://xml.org/sax/features/external-general-entities", false);
                docFact.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (ParserConfigurationException e) {
                this.logger.warn("Unsupported DocumentBuilderFactory feature. Possible security vulnerabilities.", e);
            }
            this.docBuilder = docFact.newDocumentBuilder();
            this.xformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error initializing.\n" + e.getMessage(), e);
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
        try {
            this.docOriginal = null;
            if (this.xmlOutStream == null) {
                return;
            }
            this.xmlOutStream.close();
            this.xmlOutStream = null;
            this.buffer = null;
            if (this.tempFile != null) {
                StreamUtil.copy((InputStream)new FileInputStream(this.tempFile), this.outputPath);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing ICML outpiut.\n" + e.getMessage(), e);
        }
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    @Override
    public String getName() {
        return "ICMLFilterWriter";
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event.getStartDocument());
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case START_GROUP: 
            case START_SUBFILTER: {
                this.processStartGroup(event.getStartGroup());
                break;
            }
            case END_GROUP: 
            case END_SUBFILTER: {
                this.processEndGroup(event.getEndGroup());
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event.getTextUnit());
                break;
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.trgLoc = locale;
    }

    @Override
    public void setOutput(String path) {
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    private void processStartDocument(StartDocument res) {
        try {
            ICMLSkeleton skel = (ICMLSkeleton)res.getSkeleton();
            this.docOriginal = skel.getOriginal();
            this.group = 0;
            this.referents = new Stack();
            this.storiesLeft = new ArrayList();
            this.reconstructing = false;
            this.tempFile = null;
            boolean useTemp = false;
            this.xmlOutStream = this.outputStream;
            if (this.xmlOutStream == null) {
                File f = new File(this.outputPath);
                if (f.exists()) {
                    boolean bl = useTemp = !f.delete();
                }
                if (useTemp) {
                    this.tempFile = File.createTempFile("icmlTmp", null);
                    this.xmlOutStream = new FileOutputStream(this.tempFile.getAbsolutePath());
                } else {
                    Util.createDirectories(this.outputPath);
                    this.xmlOutStream = new FileOutputStream(this.outputPath);
                }
            }
            this.buffer = new byte[2048];
            this.storiesLeft.add(this.docOriginal.getBaseURI());
        }
        catch (IOException e) {
            throw new OkapiIOException("Error creating output ICML.\n" + e.getMessage(), e);
        }
    }

    private InputStream document2InputStream(Document document) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DOMSource xmlSource = new DOMSource(document);
        StreamResult outputTarget = new StreamResult(outputStream);
        try {
            TransformerFactory.newInstance().newTransformer().transform(xmlSource, outputTarget);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        ByteArrayInputStream is = new ByteArrayInputStream(outputStream.toByteArray());
        return is;
    }

    private void processEndDocument() {
        try {
            if (this.storiesLeft != null && this.storiesLeft.contains(this.docOriginal.getBaseURI())) {
                int len;
                InputStream input = this.document2InputStream(this.docOriginal);
                while ((len = input.read(this.buffer)) > 0) {
                    this.xmlOutStream.write(this.buffer, 0, len);
                }
                input.close();
                this.storiesLeft.remove(this.docOriginal.getBaseURI());
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writting out non-extracted stories.", e);
        }
        this.close();
    }

    private void processTextUnit(ITextUnit tu) {
        if (tu.isReferent()) {
            this.referents.push(tu);
        } else {
            while (!this.referents.isEmpty()) {
                this.mergeTextUnit((ITextUnit)this.referents.pop());
            }
            this.mergeTextUnit(tu);
        }
    }

    private void mergeTextUnit(ITextUnit tu) {
        block11: {
            ICMLSkeleton skel = (ICMLSkeleton)tu.getSkeleton();
            TextContainer tc = tu.getTarget(this.trgLoc);
            if (tc == null) {
                tc = tu.getSource();
            }
            TextFragment tf = tc.getUnSegmentedContentCopy();
            String ctext = tf.getCodedText();
            ctext = Util.escapeToXML(ctext, 3, false, null);
            tf.setCodedText(ctext);
            if (!this.reconstructing) {
                this.xml = new StringBuilder("<r>");
            }
            this.reconstructing = skel.getForced();
            TextFragment[] res = skel.getMovedParts();
            if (res != null && res[0] != null) {
                this.xml.append(res[0].toText());
            }
            this.xml.append(tf.toText());
            if (res != null && res[1] != null) {
                this.xml.append(res[1].toText());
            }
            if (this.reconstructing) {
                return;
            }
            this.xml.append("</r>");
            try {
                Document tmpDoc = this.docBuilder.parse(new InputSource(new StringReader(this.xml.toString())));
                Document docWhereToImport = skel.getScopeNode().getOwnerDocument();
                DocumentFragment docFrag = docWhereToImport.createDocumentFragment();
                Node imp = docWhereToImport.importNode(tmpDoc.getDocumentElement(), true);
                while (imp.hasChildNodes()) {
                    docFrag.appendChild(imp.removeChild(imp.getFirstChild()));
                }
                HashMap<String, Node> map = this.collectLiveReferents(skel);
                Node node = skel.getScopeNode();
                while (node.hasChildNodes()) {
                    node.removeChild(node.getFirstChild());
                }
                node.appendChild(docFrag);
                if (map == null) break block11;
                NodeList list = ((Element)node).getElementsByTagName("SKLREF");
                while (list.getLength() > 0) {
                    Element marker = (Element)list.item(0);
                    String key = marker.getAttribute("id");
                    Node original = map.get(key);
                    if (original == null) {
                        this.logger.error(String.format("Missing original node for a reference in text unit id='%s'.", tu.getId()));
                        break;
                    }
                    Element parent = (Element)marker.getParentNode();
                    parent.replaceChild(original, marker);
                }
            }
            catch (Throwable e) {
                throw new OkapiIOException(String.format("Error when parsing XML of text unit id='%s'.\n" + e.getMessage(), tu.getId()), e);
            }
        }
    }

    private HashMap<String, Node> collectLiveReferents(ICMLSkeleton skel) {
        if (!skel.hasReferences()) {
            return null;
        }
        HashMap<String, Node> map = new HashMap<String, Node>();
        Element elem = (Element)skel.getTopNode();
        HashMap<String, NodeReference> refs = skel.getReferences();
        for (String key : refs.keySet()) {
            NodeReference ref = refs.get(key);
            NodeList list = elem.getElementsByTagName(ref.name);
            Node ori = list.item(ref.position).cloneNode(true);
            map.put(key, ori);
        }
        return map;
    }

    private void processStartGroup(StartGroup res) {
        this.reconstructing = false;
        this.xml = null;
        ++this.group;
        ICMLSkeleton skel = (ICMLSkeleton)res.getSkeleton();
        if (skel == null) {
            return;
        }
        this.doc = skel.getDocument();
    }

    private void processEndGroup(Ending ending) {
        while (!this.referents.isEmpty()) {
            this.mergeTextUnit((ITextUnit)this.referents.pop());
        }
        --this.group;
        try {
            if (this.group != 1) {
                return;
            }
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new OkapiIOException("Transform configuration error.\n" + e.getMessage(), e);
        }
    }
}

