/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.Collections;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.MarkupRange;

class SpecialCharacter
extends MarkupRange {
    SpecialCharacter(XMLEvent event) {
        super(Collections.singletonList(event));
    }

    static SpecialCharacter fromXmlEvent(XMLEvent event) {
        return new SpecialCharacter(event);
    }

    XMLEvent getEvent() {
        return (XMLEvent)this.events.get(0);
    }

    static class Instruction
    extends SpecialCharacter {
        Instruction(XMLEvent event) {
            super(event);
        }

        static Instruction fromXmlEvent(XMLEvent event) {
            return new Instruction(event);
        }

        static enum InstructionType {
            ALIGNMENT("0"),
            END_NESTED_STYLE("3"),
            FOOTNOTE_MARKER("4"),
            INDENT_HERE_TAB("7"),
            RIGHT_INDENT_TAB("8"),
            AUTO_PAGE_NUMBER("18"),
            SECTION_MARKER("19"),
            UNSUPPORTED("");

            String value;

            private InstructionType(String value) {
                this.value = value;
            }

            static InstructionType fromInstruction(Instruction instruction) {
                for (InstructionType instructionType : InstructionType.values()) {
                    if (!instructionType.getValue().equals(((ProcessingInstruction)instruction.getEvent()).getData())) continue;
                    return instructionType;
                }
                return UNSUPPORTED;
            }

            String getValue() {
                return this.value;
            }
        }
    }

    static enum SpecialCharacterType {
        FIXED_WIDTH_NON_BREAKING_SPACE('\u202f'),
        HAIR_SPACE('\u200a'),
        THIN_SPACE('\u2009'),
        PUNCTUATION_SPACE('\u2008'),
        FIGURE_SPACE('\u2007'),
        SIXTH_SPACE('\u2006'),
        QUARTER_SPACE('\u2005'),
        THIRD_SPACE('\u2004'),
        FLUSH_SPACE('\u2001'),
        FORCED_LINE_BREAK('\u2028'),
        DISCRETIONARY_LINE_BRAKE('\u200b'),
        ZERO_WIDTH_NON_JOINER('\u200c'),
        DISCRETIONARY_HYPHEN('\u00ad'),
        NON_BREAKING_HYPHEN('\u2011'),
        ZERO_WIDTH_NO_BREAK_SPACE('\ufeff'),
        UNSUPPORTED(' ');

        char value;

        private SpecialCharacterType(char value) {
            this.value = value;
        }

        static SpecialCharacterType fromChar(char character) {
            for (SpecialCharacterType specialCharacterType : SpecialCharacterType.values()) {
                if (specialCharacterType.getValue() != character) continue;
                return specialCharacterType;
            }
            return UNSUPPORTED;
        }

        static SpecialCharacterType fromSpecialCharacter(SpecialCharacter specialCharacter) {
            char characterValue = specialCharacter.getEvent().asCharacters().getData().toCharArray()[0];
            return SpecialCharacterType.fromChar(characterValue);
        }

        char getValue() {
            return this.value;
        }
    }
}

