/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.filters.idml.Builder;
import net.sf.okapi.filters.idml.Property;
import net.sf.okapi.filters.idml.SpreadItemHolder;
import net.sf.okapi.filters.idml.State;
import net.sf.okapi.filters.idml.TextPath;

class SpreadItem {
    private final String id;
    private final String layerId;
    private final boolean visible;
    private final String transformation;
    private final List<Property> properties;

    SpreadItem(String id, String layerId, boolean visible, String transformation, List<Property> properties) {
        this.id = id;
        this.layerId = layerId;
        this.visible = visible;
        this.transformation = transformation;
        this.properties = properties;
    }

    String getId() {
        return this.id;
    }

    String getLayerId() {
        return this.layerId;
    }

    boolean isVisible() {
        return this.visible;
    }

    String getTransformation() {
        return this.transformation;
    }

    List<Property> getProperties() {
        return this.properties;
    }

    static class TextBox
    extends SpreadItem {
        private final List<SpreadItem> spreadItems;

        TextBox(String id, String layerId, boolean visible, String transformation, List<Property> properties, List<SpreadItem> spreadItems) {
            super(id, layerId, visible, transformation, properties);
            this.spreadItems = spreadItems;
        }

        List<SpreadItem> getSpreadItems() {
            return this.spreadItems;
        }

        static class TextBoxBuilder
        extends SpreadItemBuilder
        implements SpreadItemHolder {
            private List<SpreadItem> spreadItems = new ArrayList<SpreadItem>();

            TextBoxBuilder() {
            }

            @Override
            public TextBoxBuilder addSpreadItem(SpreadItem spreadItem) {
                this.spreadItems.add(spreadItem);
                return this;
            }

            @Override
            public String getActiveLayerId() {
                return this.layerId;
            }

            @Override
            public TextBox build() {
                return new TextBox(this.id, this.layerId, this.visible, this.transformation, this.properties, this.spreadItems);
            }
        }
    }

    static class Button
    extends MultiStateObject {
        Button(String id, String layerId, boolean visible, String transformation, List<Property> properties, List<State> states) {
            super(id, layerId, visible, transformation, properties, states);
        }

        static class ButtonBuilder
        extends MultiStateObject.MultiStateObjectBuilder {
            ButtonBuilder() {
            }

            @Override
            public Button build() {
                return new Button(this.id, this.layerId, this.visible, this.transformation, this.properties, this.states);
            }
        }
    }

    static class MultiStateObject
    extends SpreadItem {
        private final List<State> states;

        MultiStateObject(String id, String layerId, boolean visible, String transformation, List<Property> properties, List<State> states) {
            super(id, layerId, visible, transformation, properties);
            this.states = states;
        }

        List<State> getStates() {
            return this.states;
        }

        static class MultiStateObjectBuilder
        extends SpreadItemBuilder {
            protected List<State> states = new ArrayList<State>();

            MultiStateObjectBuilder() {
            }

            MultiStateObjectBuilder addState(State state) {
                this.states.add(state);
                return this;
            }

            @Override
            public MultiStateObject build() {
                return new MultiStateObject(this.id, this.layerId, this.visible, this.transformation, this.properties, this.states);
            }
        }
    }

    static class Group
    extends SpreadItem {
        private final List<SpreadItem> spreadItems;

        Group(String id, String layerId, boolean visible, String transformation, List<Property> properties, List<SpreadItem> spreadItems) {
            super(id, layerId, visible, transformation, properties);
            this.spreadItems = spreadItems;
        }

        List<SpreadItem> getSpreadItems() {
            return this.spreadItems;
        }

        static class GroupBuilder
        extends SpreadItemBuilder
        implements SpreadItemHolder {
            private List<SpreadItem> spreadItems = new ArrayList<SpreadItem>();

            GroupBuilder() {
            }

            @Override
            public GroupBuilder addSpreadItem(SpreadItem spreadItem) {
                this.spreadItems.add(spreadItem);
                return this;
            }

            @Override
            public String getActiveLayerId() {
                return this.layerId;
            }

            @Override
            public Group build() {
                return new Group(this.id, this.layerId, this.visible, this.transformation, this.properties, this.spreadItems);
            }
        }
    }

    static class Polygon
    extends TextualSpreadItem {
        Polygon(String id, String layerId, boolean visible, String transformation, List<Property> properties, List<TextPath> textPaths) {
            super(id, layerId, visible, transformation, properties, textPaths);
        }

        static class PolygonBuilder
        extends TextualSpreadItem.TextualSpreadItemBuilder {
            PolygonBuilder() {
            }

            @Override
            public Polygon build() {
                return new Polygon(this.id, this.layerId, this.visible, this.transformation, this.properties, this.textPaths);
            }
        }
    }

    static class Oval
    extends TextualSpreadItem {
        Oval(String id, String layerId, boolean visible, String transformation, List<Property> properties, List<TextPath> textPaths) {
            super(id, layerId, visible, transformation, properties, textPaths);
        }

        static class OvalBuilder
        extends TextualSpreadItem.TextualSpreadItemBuilder {
            OvalBuilder() {
            }

            @Override
            public Oval build() {
                return new Oval(this.id, this.layerId, this.visible, this.transformation, this.properties, this.textPaths);
            }
        }
    }

    static class Rectangle
    extends TextualSpreadItem {
        Rectangle(String id, String layerId, boolean visible, String transformation, List<Property> properties, List<TextPath> textPaths) {
            super(id, layerId, visible, transformation, properties, textPaths);
        }

        static class RectangleBuilder
        extends TextualSpreadItem.TextualSpreadItemBuilder {
            RectangleBuilder() {
            }

            @Override
            public Rectangle build() {
                return new Rectangle(this.id, this.layerId, this.visible, this.transformation, this.properties, this.textPaths);
            }
        }
    }

    static class GraphicLine
    extends TextualSpreadItem {
        GraphicLine(String id, String layerId, boolean visible, String transformation, List<Property> properties, List<TextPath> textPaths) {
            super(id, layerId, visible, transformation, properties, textPaths);
        }

        static class GraphicLineBuilder
        extends TextualSpreadItem.TextualSpreadItemBuilder {
            GraphicLineBuilder() {
            }

            @Override
            public GraphicLine build() {
                return new GraphicLine(this.id, this.layerId, this.visible, this.transformation, this.properties, this.textPaths);
            }
        }
    }

    static class TextFrame
    extends TextualSpreadItem {
        private final String storyId;
        private final String previousTextFrameId;
        private final String nextTextFrameId;

        TextFrame(String id, String layerId, boolean visible, String transformation, List<Property> properties, List<TextPath> textPaths, String storyId, String previousTextFrameId, String nextTextFrameId) {
            super(id, layerId, visible, transformation, properties, textPaths);
            this.storyId = storyId;
            this.previousTextFrameId = previousTextFrameId;
            this.nextTextFrameId = nextTextFrameId;
        }

        String getStoryId() {
            return this.storyId;
        }

        String getPreviousTextFrameId() {
            return this.previousTextFrameId;
        }

        String getNextTextFrameId() {
            return this.nextTextFrameId;
        }

        static class TextFrameBuilder
        extends TextualSpreadItem.TextualSpreadItemBuilder {
            private String storyId;
            private String previousTextFrameId;
            private String nextTextFrameId;

            TextFrameBuilder() {
            }

            TextFrameBuilder setStoryId(String storyId) {
                this.storyId = storyId;
                return this;
            }

            TextFrameBuilder setPreviousTextFrameId(String previousTextFrameId) {
                this.previousTextFrameId = previousTextFrameId;
                return this;
            }

            TextFrameBuilder setNextTextFrameId(String nextTextFrameId) {
                this.nextTextFrameId = nextTextFrameId;
                return this;
            }

            @Override
            public TextFrame build() {
                return new TextFrame(this.id, this.layerId, this.visible, this.transformation, this.properties, this.textPaths, this.storyId, this.previousTextFrameId, this.nextTextFrameId);
            }
        }
    }

    static class TextualSpreadItem
    extends SpreadItem {
        private final List<TextPath> textPaths;

        TextualSpreadItem(String id, String layerId, boolean visible, String transformation, List<Property> properties, List<TextPath> textPaths) {
            super(id, layerId, visible, transformation, properties);
            this.textPaths = textPaths;
        }

        List<TextPath> getTextPaths() {
            return this.textPaths;
        }

        static class TextualSpreadItemBuilder
        extends SpreadItemBuilder {
            protected List<TextPath> textPaths = new ArrayList<TextPath>();

            TextualSpreadItemBuilder() {
            }

            SpreadItemBuilder addTextPath(TextPath textPath) {
                this.textPaths.add(textPath);
                return this;
            }

            @Override
            public TextualSpreadItem build() {
                return new TextualSpreadItem(this.id, this.layerId, this.visible, this.transformation, this.properties, this.textPaths);
            }
        }
    }

    static abstract class SpreadItemBuilder
    implements Builder<SpreadItem> {
        protected String id;
        protected String layerId;
        protected boolean visible;
        protected String transformation;
        protected List<Property> properties = new ArrayList<Property>();

        SpreadItemBuilder() {
        }

        SpreadItemBuilder setId(String id) {
            this.id = id;
            return this;
        }

        SpreadItemBuilder setLayerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        SpreadItemBuilder setVisible(boolean visible) {
            this.visible = visible;
            return this;
        }

        SpreadItemBuilder setTransformation(String transformation) {
            this.transformation = transformation;
            return this;
        }

        SpreadItemBuilder addProperty(Property property) {
            this.properties.add(property);
            return this;
        }
    }
}

