/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Objects;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import net.sf.okapi.filters.idml.Properties;
import net.sf.okapi.filters.idml.Property;
import net.sf.okapi.filters.idml.StyleRange;

class StyleDefinitions {
    private final StyleRange paragraphStyleRange;
    private final StyleRange characterStyleRange;

    StyleDefinitions(StyleRange paragraphStyleRange, StyleRange characterStyleRange) {
        this.paragraphStyleRange = paragraphStyleRange;
        this.characterStyleRange = characterStyleRange;
    }

    static StyleDefinitions getDefaultStyleDefinitions(XMLEventFactory eventFactory) {
        return new StyleDefinitions(StyleRange.getDefaultParagraphStyleRange(eventFactory), StyleRange.getDefaultCharacterStyleRange(eventFactory));
    }

    StyleRange getParagraphStyleRange() {
        return this.paragraphStyleRange;
    }

    StyleRange getCharacterStyleRange() {
        return this.characterStyleRange;
    }

    StyleRange getCombinedStyleRange() {
        StyleRange.StyleRangeBuilder styleRangeBuilder = new StyleRange.StyleRangeBuilder();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (Attribute attribute : this.paragraphStyleRange.getAttributes()) {
            if ("AppliedParagraphStyle".equals(attribute.getName().getLocalPart())) continue;
            attributes.add(attribute);
        }
        for (Attribute attribute : this.characterStyleRange.getAttributes()) {
            if ("AppliedCharacterStyle".equals(attribute.getName().getLocalPart())) continue;
            attributes.add(attribute);
        }
        styleRangeBuilder.setAttributes(attributes);
        ArrayList<Property> properties = new ArrayList<Property>(this.paragraphStyleRange.getProperties().getProperties());
        properties.addAll(this.characterStyleRange.getProperties().getProperties());
        Properties.PropertiesBuilder propertiesBuilder = new Properties.PropertiesBuilder();
        propertiesBuilder.setStartElement(this.paragraphStyleRange.getProperties().getStartElement()).setEndElement(this.paragraphStyleRange.getProperties().getEndElement()).addProperties(properties);
        return styleRangeBuilder.setProperties(propertiesBuilder.build()).build();
    }

    boolean isSubsetOf(StyleDefinitions other) {
        return this.getParagraphStyleRange().isSubsetOf(other.getParagraphStyleRange()) && this.getCharacterStyleRange().isSubsetOf(other.getCharacterStyleRange());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || this.getClass() != o.getClass()) {
            return false;
        }
        StyleDefinitions that = (StyleDefinitions)o;
        return Objects.equals(this.getParagraphStyleRange(), that.getParagraphStyleRange()) && Objects.equals(this.getCharacterStyleRange(), that.getCharacterStyleRange());
    }

    public int hashCode() {
        return Objects.hash(this.getParagraphStyleRange(), this.getCharacterStyleRange());
    }
}

