/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import java.nio.charset.CharsetEncoder;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.mif.FrameRomanCharsetProvider;

public class MIFFilterWriter
extends GenericFilterWriter {
    public MIFFilterWriter(ISkeletonWriter skelWriter, EncoderManager encoderManager) {
        super(skelWriter, encoderManager);
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        if (!Util.isEmpty(defaultEncoding) && defaultEncoding.startsWith("UTF-16")) {
            super.setOptions(locale, defaultEncoding);
        } else {
            super.setOptions(locale, null);
        }
    }

    @Override
    protected CharsetEncoder createCharsetEncoder(String encodingtoUse) {
        if (encodingtoUse.equals("x-FrameRoman")) {
            return new FrameRomanCharsetProvider().charsetForName(encodingtoUse).newEncoder();
        }
        return null;
    }
}

