/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MarkupSkeleton;
import net.sf.okapi.filters.openxml.OpenXMLPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;

abstract class GenericPartHandler
implements OpenXMLPartHandler {
    protected OpenXMLZipFile zipFile;
    protected ZipEntry entry;
    protected ConditionalParameters params;
    protected String partName;
    protected List<Event> filterEvents = new ArrayList<Event>();
    protected List<XMLEvent> documentPartEvents = new ArrayList<XMLEvent>();
    protected Markup markup;
    protected IdGenerator documentPartIdGenerator;

    GenericPartHandler(ConditionalParameters params, String partName) {
        this.params = params;
        this.partName = partName;
        this.documentPartIdGenerator = new IdGenerator(partName, "dp");
    }

    protected Event createStartSubDocumentEvent(String documentId, String subDocumentId) {
        StartSubDocument sd = new StartSubDocument(documentId, subDocumentId);
        sd.setName(this.partName);
        if (this.zipFile != null) {
            ZipSkeleton zs = new ZipSkeleton(this.zipFile.getZip(), this.entry);
            sd.setSkeleton(zs);
        }
        ConditionalParameters clonedParams = this.params.clone();
        sd.setFilterParameters(clonedParams);
        return new Event(EventType.START_SUBDOCUMENT, sd);
    }

    protected void addEventToDocumentPart(XMLEvent e) {
        this.documentPartEvents.add(e);
    }

    protected void flushDocumentPart() {
        if (!this.documentPartEvents.isEmpty()) {
            this.markup.addComponent(MarkupComponentFactory.createGeneralMarkupComponent(this.documentPartEvents));
            this.documentPartEvents = new ArrayList<XMLEvent>();
        }
        if (!this.markup.getComponents().isEmpty()) {
            DocumentPart documentPart = new DocumentPart(this.documentPartIdGenerator.createId(), false);
            documentPart.setSkeleton(new MarkupSkeleton(this.markup));
            this.markup = new Block.BlockMarkup();
            this.filterEvents.add(new Event(EventType.DOCUMENT_PART, documentPart));
        }
    }
}

