/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.GenericPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

class MasterAndPagePartHandler
extends GenericPartHandler {
    private static final String UNEXPECTED_NUMBER_OF_XML_EVENTS = "Unexpected number of XML events";
    private static final String TEXT = "Text";
    private static final String CHARACTER_PROPERTIES_MARKER = "cp";
    private static final String TEXT_FIELD_INSERTION_POINT = "fld";
    private static final String PARAGRAPH_PROPERTIES_MARKER = "pp";
    private static final String TAB_PROPERTIES_MARKER = "tp";
    private final IdGenerator textUnitIdGenerator;
    private String subDocumentId;
    private XMLEventReader xmlEventReader;
    private Iterator<Event> filterEventIterator;

    public MasterAndPagePartHandler(ConditionalParameters params, OpenXMLZipFile zipFile, ZipEntry entry) {
        super(params, entry.getName());
        this.zipFile = zipFile;
        this.entry = entry;
        this.partName = entry.getName();
        this.textUnitIdGenerator = new IdGenerator(entry.getName(), "tu");
    }

    @Override
    public Event open(String documentId, String subDocumentId, LocaleId srcLang) throws IOException, XMLStreamException {
        this.subDocumentId = subDocumentId;
        this.xmlEventReader = this.zipFile.getInputFactory().createXMLEventReader(new InputStreamReader((InputStream)new BufferedInputStream(this.zipFile.getInputStream(this.entry)), StandardCharsets.UTF_8));
        this.handlePart();
        return this.createStartSubDocumentEvent(documentId, subDocumentId);
    }

    private void handlePart() throws XMLStreamException {
        while (this.xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (!XMLEventHelpers.isStartElement(xmlEvent, TEXT)) {
                this.addEventToDocumentPart(xmlEvent);
                continue;
            }
            this.flushDocumentPart();
            TextUnit textUnit = this.parseText(xmlEvent);
            this.filterEvents.add(new Event(EventType.TEXT_UNIT, textUnit));
        }
        this.flushDocumentPart();
        this.filterEvents.add(new Event(EventType.END_DOCUMENT, new Ending(this.subDocumentId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    @Override
    protected void flushDocumentPart() {
        DocumentPart documentPart = new DocumentPart(this.documentPartIdGenerator.createId(), false, new GenericSkeleton(XMLEventSerializer.serialize(this.documentPartEvents)));
        this.filterEvents.add(new Event(EventType.DOCUMENT_PART, documentPart));
        this.documentPartEvents = new ArrayList();
    }

    private TextUnit parseText(XMLEvent event) throws XMLStreamException {
        GenericSkeleton skeleton = new GenericSkeleton(XMLEventSerializer.serialize(event));
        TextUnit textUnit = new TextUnit(this.textUnitIdGenerator.createId());
        textUnit.setPreserveWhitespaces(true);
        TextFragment textFragment = new TextFragment();
        XMLEvent nextEvent = null;
        while (this.xmlEventReader.hasNext()) {
            Code code;
            String codeType;
            XMLEvent xmlEvent;
            XMLEvent xMLEvent = xmlEvent = null == nextEvent ? this.xmlEventReader.nextEvent() : nextEvent;
            if (XMLEventHelpers.isEndElement(xmlEvent, event.asStartElement())) {
                textUnit.setSourceContent(textFragment);
                skeleton.addContentPlaceholder(textUnit);
                skeleton.append(XMLEventSerializer.serialize(xmlEvent));
                textUnit.setSkeleton(skeleton);
                return textUnit;
            }
            if (XMLEventHelpers.isStartElement(xmlEvent, CHARACTER_PROPERTIES_MARKER) || XMLEventHelpers.isStartElement(xmlEvent, TEXT_FIELD_INSERTION_POINT) || XMLEventHelpers.isStartElement(xmlEvent, PARAGRAPH_PROPERTIES_MARKER) || XMLEventHelpers.isStartElement(xmlEvent, TAB_PROPERTIES_MARKER)) {
                codeType = xmlEvent.asStartElement().getName().getLocalPart();
                if (!this.xmlEventReader.hasNext()) {
                    throw new OkapiBadFilterInputException(UNEXPECTED_NUMBER_OF_XML_EVENTS);
                }
                nextEvent = this.xmlEventReader.nextEvent();
                if (!nextEvent.isEndElement() || !nextEvent.asEndElement().getName().equals(xmlEvent.asStartElement().getName())) {
                    code = new Code(TextFragment.TagType.OPENING, codeType, XMLEventSerializer.serialize(xmlEvent));
                    textFragment.append(code);
                    continue;
                }
                code = new Code(TextFragment.TagType.PLACEHOLDER, codeType, XMLEventSerializer.serialize(Arrays.asList(xmlEvent, nextEvent)));
                textFragment.append(code);
                nextEvent = null;
                continue;
            }
            if (XMLEventHelpers.isEndElement(xmlEvent, CHARACTER_PROPERTIES_MARKER) || XMLEventHelpers.isEndElement(xmlEvent, TEXT_FIELD_INSERTION_POINT) || XMLEventHelpers.isEndElement(xmlEvent, PARAGRAPH_PROPERTIES_MARKER) || XMLEventHelpers.isEndElement(xmlEvent, TAB_PROPERTIES_MARKER)) {
                codeType = xmlEvent.asEndElement().getName().getLocalPart();
                code = new Code(TextFragment.TagType.CLOSING, codeType, XMLEventSerializer.serialize(xmlEvent));
                textFragment.append(code);
                nextEvent = null;
                continue;
            }
            textFragment.append(XMLEventSerializer.serialize(xmlEvent));
            nextEvent = null;
        }
        throw new OkapiBadFilterInputException();
    }

    @Override
    public boolean hasNext() {
        return this.filterEventIterator.hasNext();
    }

    @Override
    public Event next() {
        return this.filterEventIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }
}

