/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.filters.openxml.ClarifiablePartHandler;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.DocumentType;
import net.sf.okapi.filters.openxml.EmptyStyleDefinitions;
import net.sf.okapi.filters.openxml.MasterPartHandler;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.NonTranslatablePartHandler;
import net.sf.okapi.filters.openxml.OpenXMLContentFilter;
import net.sf.okapi.filters.openxml.OpenXMLPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.Presentation;
import net.sf.okapi.filters.openxml.PresentationNotesStylesParser;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.RelationshipsPartHandler;
import net.sf.okapi.filters.openxml.StandardPartHandler;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyledTextPartHandler;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

class PowerpointDocument
extends DocumentType {
    private static final String COMMENTS_REL = Namespaces.DocumentRelationships.getDerivedURI("/comments");
    private static final String NOTES_SLIDE_REL = Namespaces.DocumentRelationships.getDerivedURI("/notesSlide");
    private static final String NOTES_MASTER_REL = Namespaces.DocumentRelationships.getDerivedURI("/notesMaster");
    private static final String CHART_REL = Namespaces.DocumentRelationships.getDerivedURI("/chart");
    private static final String DIAGRAM_DATA_REL = Namespaces.DocumentRelationships.getDerivedURI("/diagramData");
    private List<String> slideNames = new ArrayList<String>();
    private List<String> slideLayoutNames = new ArrayList<String>();
    private static final Pattern RELS_NAME_PATTERN = Pattern.compile(".+slide\\d+\\.xml\\.rels");
    private Matcher relsNameMatcher = RELS_NAME_PATTERN.matcher("").reset();
    private static final String SLIDE_LAYOUT_REL = Namespaces.DocumentRelationships.getDerivedURI("/slideLayout");
    private StyleDefinitions presentationNotesStyleDefinitions;
    private Map<String, String> slidesByComment = new HashMap<String, String>();
    private Map<String, String> slidesByNote = new HashMap<String, String>();
    private Map<String, String> slidesByChart = new HashMap<String, String>();
    private Map<String, String> slidesByDiagramData = new HashMap<String, String>();

    PowerpointDocument(OpenXMLZipFile zipFile, ConditionalParameters params) {
        super(zipFile, params);
    }

    @Override
    boolean isClarifiablePart(String contentType) {
        return "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml".equals(contentType);
    }

    @Override
    boolean isStyledTextPart(String entryName, String type) {
        if (type.equals("application/vnd.openxmlformats-officedocument.presentationml.slide+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml")) {
            return true;
        }
        if (this.isMasterPart(entryName, type)) {
            return true;
        }
        if (this.getParams().getTranslatePowerpointNotes() && type.equals("application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml")) {
            return true;
        }
        return type.equals("application/vnd.openxmlformats-officedocument.drawingml.chart+xml");
    }

    boolean isMasterPart(String entryName, String type) {
        if (this.getParams().getTranslatePowerpointMasters()) {
            if (type.equals("application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml")) {
                return true;
            }
            if (type.equals("application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml") && this.slideLayoutNames.contains(entryName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    void initialize() throws IOException, XMLStreamException {
        this.presentationNotesStyleDefinitions = this.parsePresentationNotesStyleDefinitions();
        this.slideNames = this.findSlides();
        this.slideLayoutNames = this.findSlideLayouts(this.slideNames);
        this.slidesByComment = this.findComments(this.slideNames);
        this.slidesByNote = this.findNotes(this.slideNames);
        this.slidesByChart = this.findCharts(this.slideNames);
        this.slidesByDiagramData = this.findDiagramDatas(this.slideNames);
    }

    private StyleDefinitions parsePresentationNotesStyleDefinitions() throws IOException, XMLStreamException {
        String relationshipTarget = this.getRelationshipTarget(NOTES_MASTER_REL);
        if (null == relationshipTarget) {
            return new EmptyStyleDefinitions();
        }
        Reader reader = this.getZipFile().getPartReader(relationshipTarget);
        return new PresentationNotesStylesParser(this.getZipFile().getEventFactory(), this.getZipFile().getInputFactory(), reader, this.getParams()).parse();
    }

    @Override
    OpenXMLPartHandler getHandlerForFile(ZipEntry entry, String contentType) {
        ParseType parseType;
        this.relsNameMatcher.reset(entry.getName());
        if (PowerpointDocument.isRelationshipsPart(contentType) && this.relsNameMatcher.matches() && this.getParams().getExtractExternalHyperlinks()) {
            return new RelationshipsPartHandler(this.getParams(), this.getZipFile(), entry);
        }
        if (!this.isTranslatableType(entry.getName(), contentType)) {
            if (this.isClarifiablePart(contentType)) {
                return new ClarifiablePartHandler(this.getZipFile(), entry);
            }
            return new NonTranslatablePartHandler(this.getZipFile(), entry);
        }
        if (this.isMasterPart(entry.getName(), contentType)) {
            return new MasterPartHandler(this.getParams(), this.getZipFile(), entry, (StyleDefinitions)new EmptyStyleDefinitions());
        }
        if (this.isStyledTextPart(entry.getName(), contentType)) {
            StyleDefinitions styleDefinitions;
            switch (contentType) {
                case "application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml": {
                    styleDefinitions = this.presentationNotesStyleDefinitions;
                    break;
                }
                default: {
                    styleDefinitions = new EmptyStyleDefinitions();
                }
            }
            return new StyledTextPartHandler(this.getParams(), this.getZipFile(), entry, styleDefinitions);
        }
        OpenXMLContentFilter openXMLContentFilter = new OpenXMLContentFilter(this.getParams(), entry.getName());
        this.getParams().nFileType = parseType = this.getParseType(contentType);
        openXMLContentFilter.setUpConfig(parseType);
        return new StandardPartHandler(openXMLContentFilter, this.getParams(), this.getZipFile(), entry);
    }

    private boolean isExcluded(String entryName, String contentType) {
        return this.isExcludedSlide(entryName, contentType) || this.isExcludedNote(entryName, contentType) || this.isExcludedComment(entryName, contentType) || this.isExcludedChart(entryName, contentType) || this.isExcludedDiagramData(entryName, contentType);
    }

    private ParseType getParseType(String contentType) {
        ParseType parseType;
        if (contentType.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
            parseType = ParseType.MSWORDDOCPROPERTIES;
        } else if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.comments+xml")) {
            parseType = ParseType.MSPOWERPOINTCOMMENTS;
        } else {
            throw new IllegalStateException("Unexpected content type " + contentType);
        }
        return parseType;
    }

    private boolean isTranslatableType(String entryName, String type) {
        if (!entryName.endsWith(".xml")) {
            return false;
        }
        if (this.isExcluded(entryName, type)) {
            return false;
        }
        if (this.isStyledTextPart(entryName, type)) {
            return true;
        }
        if (this.getParams().getTranslateDocProperties() && type.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
            return true;
        }
        if (this.getParams().getTranslateComments() && type.equals("application/vnd.openxmlformats-officedocument.presentationml.comments+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml")) {
            return true;
        }
        return this.getParams().getTranslatePowerpointNotes() && type.equals("application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml");
    }

    @Override
    Enumeration<? extends ZipEntry> getZipFileEntries() throws IOException, XMLStreamException {
        OpenXMLZipFile zipFile = this.getZipFile();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<? extends ZipEntry> entryList = Collections.list(entries);
        Collections.sort(entryList, new ZipEntryComparator(this.slideNames));
        return Collections.enumeration(entryList);
    }

    List<String> findSlides() throws IOException, XMLStreamException {
        OpenXMLZipFile zipFile = this.getZipFile();
        Relationships rels = zipFile.getRelationships("ppt/_rels/presentation.xml.rels");
        Presentation pres = new Presentation(zipFile.getInputFactory(), rels);
        pres.parseFromXML(zipFile.getPartReader("ppt/presentation.xml"));
        return pres.getSlidePartNames();
    }

    List<String> findSlideLayouts(List<String> slideNames) throws IOException, XMLStreamException {
        ArrayList<String> layouts = new ArrayList<String>();
        OpenXMLZipFile zipFile = this.getZipFile();
        for (String slideName : slideNames) {
            List<Relationships.Rel> rels = zipFile.getRelationshipsForTarget(slideName).getRelByType(SLIDE_LAYOUT_REL);
            if (rels.isEmpty()) continue;
            layouts.add(rels.get((int)0).target);
        }
        return layouts;
    }

    private boolean isExcludedSlide(String entryName, String contentType) {
        if (!"application/vnd.openxmlformats-officedocument.presentationml.slide+xml".equals(contentType)) {
            return false;
        }
        if (!this.getParams().getPowerpointIncludedSlideNumbersOnly()) {
            return false;
        }
        int slideIndex = this.slideNames.indexOf(entryName);
        if (slideIndex == -1) {
            return false;
        }
        int slideNumber = slideIndex + 1;
        return !this.getParams().tsPowerpointIncludedSlideNumbers.contains(slideNumber);
    }

    private boolean isExcludedNote(String entryName, String contentType) {
        if (!"application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml".equals(contentType) || !this.slidesByNote.containsKey(entryName)) {
            return false;
        }
        String slideName = this.slidesByNote.get(entryName);
        return this.isExcludedSlide(slideName, "application/vnd.openxmlformats-officedocument.presentationml.slide+xml");
    }

    private boolean isExcludedComment(String entryName, String contentType) {
        if (!"application/vnd.openxmlformats-officedocument.presentationml.comments+xml".equals(contentType) || !this.slidesByComment.containsKey(entryName)) {
            return false;
        }
        String slideName = this.slidesByComment.get(entryName);
        return this.isExcludedSlide(slideName, "application/vnd.openxmlformats-officedocument.presentationml.slide+xml");
    }

    private boolean isExcludedChart(String entryName, String contentType) {
        if (!"application/vnd.openxmlformats-officedocument.drawingml.chart+xml".equals(contentType) || !this.slidesByChart.containsKey(entryName)) {
            return false;
        }
        String slideName = this.slidesByChart.get(entryName);
        return this.isExcludedSlide(slideName, "application/vnd.openxmlformats-officedocument.presentationml.slide+xml");
    }

    private boolean isExcludedDiagramData(String entryName, String contentType) {
        if (!"application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml".equals(contentType) || !this.slidesByDiagramData.containsKey(entryName)) {
            return false;
        }
        String slideName = this.slidesByDiagramData.get(entryName);
        return this.isExcludedSlide(slideName, "application/vnd.openxmlformats-officedocument.presentationml.slide+xml");
    }

    private Map<String, String> findNotes(List<String> slideNames) throws IOException, XMLStreamException {
        return this.initializeRelsBySlide(slideNames, NOTES_SLIDE_REL);
    }

    private Map<String, String> findComments(List<String> slideNames) throws IOException, XMLStreamException {
        return this.initializeRelsBySlide(slideNames, COMMENTS_REL);
    }

    private Map<String, String> findCharts(List<String> slideNames) throws IOException, XMLStreamException {
        return this.initializeRelsBySlide(slideNames, CHART_REL);
    }

    private Map<String, String> findDiagramDatas(List<String> slideNames) throws IOException, XMLStreamException {
        return this.initializeRelsBySlide(slideNames, DIAGRAM_DATA_REL);
    }

    private Map<String, String> initializeRelsBySlide(List<String> slideNames, String relType) throws IOException, XMLStreamException {
        HashMap<String, String> result = new HashMap<String, String>();
        OpenXMLZipFile zipFile = this.getZipFile();
        for (String slideName : slideNames) {
            List<Relationships.Rel> rels = zipFile.getRelationshipsForTarget(slideName).getRelByType(relType);
            if (rels == null || rels.isEmpty()) continue;
            for (Relationships.Rel rel : rels) {
                result.put(rel.target, slideName);
            }
        }
        return result;
    }
}

