/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.GenericPartHandler;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

class RelationshipsPartHandler
extends GenericPartHandler {
    private static final QName RELATIONSHIP_TAG_NAME = new QName(Namespaces.Relationships.getURI(), "Relationship");
    private static final QName RELATIONSHIP_TYPE = new QName("Type");
    private static final QName RELATIONSHIP_TARGET_MODE = new QName("TargetMode");
    private static final QName RELATIONSHIP_TARGET = new QName("Target");
    private final IdGenerator textUnitIdGenerator;
    private String subDocumentId;
    private XMLEventReader xmlEventReader;
    private Iterator<Event> filterEventIterator;
    private static final String HYPERLINK_TYPE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink";
    private static final String TARGET_MODE_EXTERNAL = "External";

    public RelationshipsPartHandler(ConditionalParameters params, OpenXMLZipFile zipFile, ZipEntry entry) {
        super(params, entry.getName());
        this.zipFile = zipFile;
        this.entry = entry;
        this.partName = entry.getName();
        this.textUnitIdGenerator = new IdGenerator(entry.getName(), "tu");
        this.markup = new Markup();
    }

    @Override
    public Event open(String documentId, String subDocumentId, LocaleId srcLang) throws IOException, XMLStreamException {
        this.subDocumentId = subDocumentId;
        this.xmlEventReader = this.zipFile.getInputFactory().createXMLEventReader(new InputStreamReader((InputStream)new BufferedInputStream(this.zipFile.getInputStream(this.entry)), StandardCharsets.UTF_8));
        this.handlePart();
        return this.createStartSubDocumentEvent(documentId, subDocumentId);
    }

    private void handlePart() throws XMLStreamException {
        while (this.xmlEventReader.hasNext()) {
            XMLEvent e = this.xmlEventReader.nextEvent();
            if (!e.isStartElement() || !e.asStartElement().getName().equals(RELATIONSHIP_TAG_NAME)) {
                this.filterEvents.add(new Event(EventType.DOCUMENT_PART, this.createDocumentPart(e)));
                continue;
            }
            Attribute type = e.asStartElement().getAttributeByName(RELATIONSHIP_TYPE);
            Attribute targetMode = e.asStartElement().getAttributeByName(RELATIONSHIP_TARGET_MODE);
            Attribute target = e.asStartElement().getAttributeByName(RELATIONSHIP_TARGET);
            if (null == type || targetMode == null || target == null || !HYPERLINK_TYPE.equals(type.getValue()) || !TARGET_MODE_EXTERNAL.equals(targetMode.getValue()) || target.getValue().isEmpty()) {
                this.filterEvents.add(new Event(EventType.DOCUMENT_PART, this.createDocumentPart(e)));
                continue;
            }
            TextUnit textUnit = this.createTextUnit(e);
            this.filterEvents.add(new Event(EventType.TEXT_UNIT, textUnit));
        }
        this.filterEvents.add(new Event(EventType.END_DOCUMENT, new Ending(this.subDocumentId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    private DocumentPart createDocumentPart(XMLEvent e) {
        return new DocumentPart(this.documentPartIdGenerator.createId(), false, new GenericSkeleton(XMLEventSerializer.serialize(e)));
    }

    private TextUnit createTextUnit(XMLEvent event) throws XMLStreamException {
        String serializedEvent = XMLEventSerializer.serialize(event);
        String attributeName = !RELATIONSHIP_TARGET.getPrefix().isEmpty() ? RELATIONSHIP_TARGET.getPrefix() + ":" + RELATIONSHIP_TARGET.getLocalPart() : RELATIONSHIP_TARGET.getLocalPart();
        String attributeValue = event.asStartElement().getAttributeByName(RELATIONSHIP_TARGET).getValue();
        String[] eventParts = serializedEvent.split(attributeName + "=\"" + attributeValue + "\"");
        GenericSkeleton skel = new GenericSkeleton();
        skel.append(eventParts[0]);
        skel.append(attributeName + "=\"");
        TextUnit textUnit = new TextUnit(this.textUnitIdGenerator.createId());
        skel.addContentPlaceholder(textUnit);
        skel.append("\"" + eventParts[1]);
        textUnit.setSkeleton(skel);
        textUnit.setSourceContent(new TextFragment(attributeValue));
        return textUnit;
    }

    @Override
    public boolean hasNext() {
        return this.filterEventIterator.hasNext();
    }

    @Override
    public Event next() {
        return this.filterEventIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }
}

