/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ChunkContainer;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunMerger;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

class RunContainer
implements Block.BlockChunk,
ChunkContainer {
    static final EnumSet<Type> RUN_CONTAINER_TYPES = EnumSet.of(Type.HYPERLINK, Type.SMARTTAG);
    private StartElement startElement;
    private EndElement endElement;
    private Type type;
    private List<Block.BlockChunk> chunks = new ArrayList<Block.BlockChunk>();
    private MarkupComponent properties;

    RunContainer() {
    }

    void addChunks(RunMerger runMerger) throws XMLStreamException {
        this.chunks.addAll(runMerger.getRuns());
        runMerger.reset();
    }

    @Override
    public void addChunk(Block.BlockChunk chunk) throws XMLStreamException {
        this.chunks.add(chunk);
    }

    List<Block.BlockChunk> getChunks() {
        return this.chunks;
    }

    StartElement getStartElement() {
        return this.startElement;
    }

    EndElement getEndElement() {
        return this.endElement;
    }

    Type getType() {
        return this.type;
    }

    MarkupComponent getProperties() {
        return this.properties;
    }

    void setProperties(MarkupComponent properties) {
        this.properties = properties;
    }

    void setStartElement(StartElement startElement) {
        this.startElement = startElement;
    }

    void setEndElement(EndElement endElement) {
        this.endElement = endElement;
    }

    void setType(Type type) {
        this.type = type;
    }

    boolean containsVisibleText() {
        for (Chunk chunk : this.getChunks()) {
            if (!(chunk instanceof Run) || !((Run)chunk).containsVisibleText()) continue;
            return true;
        }
        return false;
    }

    RunProperties getDefaultRunProperties() {
        return this.chunks.size() > 0 && this.chunks.get(0) instanceof Run ? ((Run)this.chunks.get(0)).getProperties() : RunProperties.emptyRunProperties();
    }

    RunProperties getDefaultCombinedRunProperties() {
        return this.chunks.size() > 0 && this.chunks.get(0) instanceof Run ? ((Run)this.chunks.get(0)).getCombinedProperties() : RunProperties.emptyRunProperties();
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(this.startElement);
        for (Block.BlockChunk chunk : this.chunks) {
            events.addAll(chunk.getEvents());
        }
        events.add(this.endElement);
        return events;
    }

    public String toString() {
        return "RunContainer(" + XMLEventSerializer.serialize(this.startElement) + ", " + this.chunks.size() + ")[" + this.chunks + "]";
    }

    static enum Type {
        HYPERLINK("hyperlink"),
        SMARTTAG("smartTag"),
        UNSUPPORTED("");

        String value;

        private Type(String value) {
            this.value = value;
        }

        String getValue() {
            return this.value;
        }

        static Type fromValue(String tagName) {
            if (tagName == null) {
                return UNSUPPORTED;
            }
            for (Type type : Type.values()) {
                if (!type.getValue().equals(tagName)) continue;
                return type;
            }
            return UNSUPPORTED;
        }
    }
}

