/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SharedStringMap {
    private ArrayList<Entry> entries = new ArrayList();
    private int nextIndex = 0;

    public Entry createEntryForString(int origIndex, boolean excluded) {
        Entry e = new Entry(origIndex, this.nextIndex++, excluded);
        this.entries.ensureCapacity(this.nextIndex);
        this.entries.add(e.newIndex, e);
        return e;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public boolean isStringVisible(int index) {
        return !this.entries.get(index).excluded;
    }

    public static class Entry {
        private int origIndex;
        private int newIndex;
        private boolean excluded;

        Entry(int origIndex, int newIndex, boolean excluded) {
            this.origIndex = origIndex;
            this.newIndex = newIndex;
            this.excluded = excluded;
        }

        public int getOriginalIndex() {
            return this.origIndex;
        }

        public int getNewIndex() {
            return this.newIndex;
        }

        public boolean getExcluded() {
            return this.excluded;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return this.origIndex == e.origIndex && this.newIndex == e.newIndex && this.excluded == e.excluded;
        }

        public int hashCode() {
            return Objects.hash(this.origIndex, this.newIndex, this.excluded);
        }

        public String toString() {
            return "SS Entry(" + this.origIndex + " --> " + this.newIndex + ", " + (this.excluded ? "excluded" : "visible") + ")";
        }
    }
}

