/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.transifex;

import java.io.OutputStream;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.transifex.FilterWriterAnnotation;
import net.sf.okapi.lib.transifex.TransifexClient;

public class TransifexFilterWriter
implements IFilterWriter {
    private IFilterWriter writer;
    private LocaleId trgLoc;
    FilterWriterAnnotation ann;
    private TransifexClient cli;
    private String outputPath;

    @Override
    public void cancel() {
        if (this.writer != null) {
            this.writer.cancel();
        }
    }

    @Override
    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.writer == null) {
            return null;
        }
        return this.writer.getEncoderManager();
    }

    @Override
    public String getName() {
        return "TransifexFilterWriter";
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        if (this.writer == null) {
            return null;
        }
        return this.writer.getSkeletonWriter();
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                return this.processStartDocument(event);
            }
            case END_DOCUMENT: {
                return this.processEndDocument(event);
            }
        }
        return this.writer.handleEvent(event);
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.trgLoc = locale;
    }

    @Override
    public void setOutput(String path) {
    }

    @Override
    public void setOutput(OutputStream output) {
    }

    @Override
    public void setParameters(IParameters params) {
    }

    private Event processStartDocument(Event event) {
        StartDocument sd = event.getStartDocument();
        this.ann = sd.getAnnotation(FilterWriterAnnotation.class);
        if (this.ann == null) {
            throw new OkapiBadFilterInputException("Missing filter-writer annotation.");
        }
        this.writer = this.ann.getFilterWriter();
        this.writer.setOptions(this.trgLoc, "UTF-8");
        this.outputPath = sd.getName() + ".out";
        this.writer.setOutput(this.outputPath);
        return this.writer.handleEvent(event);
    }

    private Event processEndDocument(Event event) {
        String[] res;
        event = this.writer.handleEvent(event);
        if (this.cli == null) {
            this.cli = new TransifexClient(this.ann.getProject().getHost());
            this.cli.setCredentials(this.ann.getProject().getUser(), this.ann.getProject().getPassword());
            this.cli.setProject(this.ann.getProject().getProjectId());
        }
        if ((res = this.cli.putTargetResource(this.outputPath, this.trgLoc, this.ann.getResourceInfo().getId(), this.ann.getResourceInfo().getName()))[0] == null) {
            throw new OkapiIOException("Error uploading file.\n" + res[1]);
        }
        return event;
    }
}

