/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.sessions;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SerializedString;
import java.util.HashMap;
import java.util.Map;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.JSONEncoder;
import net.sf.okapi.lib.beans.v0.PersistenceMapper;
import net.sf.okapi.lib.beans.v1.OkapiBeans;
import net.sf.okapi.lib.beans.v2.OkapiBeans2;
import net.sf.okapi.lib.persistence.VersionMapper;
import net.sf.okapi.lib.persistence.json.jackson.JSONPersistenceSession;

public class OkapiJsonSession
extends JSONPersistenceSession {
    public OkapiJsonSession(boolean compress) {
        super(compress);
        JsonFactory jsonFactory = this.getJsonFactory();
        jsonFactory.setCharacterEscapes(new JSONStringEncoder());
    }

    @Override
    public void registerVersions() {
        VersionMapper.registerVersion(PersistenceMapper.class);
        VersionMapper.registerVersion(OkapiBeans.class);
        VersionMapper.registerVersion(OkapiBeans2.class);
    }

    @Override
    protected Class<?> getDefItemClass() {
        return Event.class;
    }

    @Override
    protected String getDefItemLabel() {
        return "event";
    }

    @Override
    protected String getDefVersionId() {
        return "OKAPI 2.0";
    }

    private class JSONStringEncoder
    extends CharacterEscapes {
        private static final long serialVersionUID = 6753659638115445103L;
        JSONEncoder encoder = new JSONEncoder();
        Map<Integer, SerializableString> cache = new HashMap<Integer, SerializableString>();

        public JSONStringEncoder() {
            StringParameters params = new StringParameters();
            params.setBoolean("escapeExtendedChars", true);
            this.encoder.setOptions(params, "UTF-8", this.encoder.getLineBreak());
        }

        @Override
        public int[] getEscapeCodesForAscii() {
            int[] res = JSONStringEncoder.standardAsciiEscapesForJSON();
            res[127] = -1;
            return res;
        }

        @Override
        public SerializableString getEscapeSequence(int ch) {
            if (ch > 127) {
                return null;
            }
            SerializableString res = this.cache.get(ch);
            if (res == null) {
                res = new SerializedString(this.encoder.encode(ch, EncoderContext.TEXT));
                this.cache.put(ch, res);
            }
            return res;
        }
    }
}

