/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.persistence;

import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.lib.persistence.IPersistenceBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.ReferenceResolver;
import net.sf.okapi.lib.persistence.beans.FactoryBean;
import net.sf.okapi.lib.persistence.beans.ReferenceBean;

public abstract class PersistenceBean<PutCoreClassHere>
implements IPersistenceBean<PutCoreClassHere> {
    private long refId = ReferenceResolver.generateRefId();
    private boolean busy = false;

    protected abstract PutCoreClassHere createObject(IPersistenceSession var1);

    protected abstract void setObject(PutCoreClassHere var1, IPersistenceSession var2);

    protected abstract void fromObject(PutCoreClassHere var1, IPersistenceSession var2);

    protected PersistenceBean() {
    }

    @Override
    public long getRefId() {
        return this.refId;
    }

    @Override
    public void setRefId(long refId) {
        this.refId = refId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T get(Class<T> classRef, IPersistenceSession session) {
        if (this.busy) {
            throw new OkapiException(String.format("PersistenceBean: recursive get() in %s", ClassUtil.getQualifiedClassName(this.getClass())));
        }
        Object obj = session.getObject(this.refId);
        if (obj == null) {
            this.busy = true;
            try {
                obj = this.createObject(session);
            }
            finally {
                this.busy = false;
            }
        }
        if (obj != null && this.refId != 0L) {
            session.setRefIdForObject(obj, this.refId);
            this.setObject(obj, session);
        }
        return classRef.cast(obj);
    }

    @Override
    public IPersistenceBean<PutCoreClassHere> set(PutCoreClassHere obj, IPersistenceSession session) {
        boolean isRefBean;
        if (obj == null) {
            return this;
        }
        boolean bl = isRefBean = this instanceof ReferenceBean || this instanceof FactoryBean;
        if (!isRefBean) {
            long rid = session.getRefIdForObject(obj);
            if (rid != 0L && rid != this.getRefId()) {
                this.setRefId(rid);
            } else {
                session.cacheBean(obj, this);
                session.setRefIdForObject(obj, this.refId);
            }
        }
        this.fromObject(obj, session);
        return this;
    }
}

