/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.translation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.HTMLCharacterEntities;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filterwriter.XLIFFContent;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueryUtil {
    private static final Pattern HTML_OPENCLOSE = Pattern.compile("(\\<u(\\s+)id=['\"](.*?)['\"]>)|(\\</u\\>)", 2);
    private static final Pattern HTML_ISOLATED = Pattern.compile("\\<br(\\s+)id=['\"](.*?)['\"](\\s*?)/?>", 2);
    private static final Pattern HTML_SPAN = Pattern.compile("\\<span\\s(.*?)>|\\</span>", 34);
    private static final Pattern NCR = Pattern.compile("&#(\\S+?);");
    private static final Pattern CER = Pattern.compile("(&\\w*?;)");
    private StringBuilder codesMarkers = new StringBuilder();
    private List<Code> codes;
    private XLIFFContent fmt = new XLIFFContent();
    private HTMLCharacterEntities entities;

    public boolean hasCode() {
        if (this.codes == null) {
            return false;
        }
        return this.codes.size() > 0;
    }

    public String separateCodesFromText(TextFragment frag) {
        this.codesMarkers.setLength(0);
        this.codes = frag.getCodes();
        String text = frag.getCodedText();
        if (!frag.hasCode()) {
            return text;
        }
        StringBuilder tmp = new StringBuilder();
        block3: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    this.codesMarkers.append(text.charAt(i));
                    this.codesMarkers.append(text.charAt(++i));
                    continue block3;
                }
                default: {
                    tmp.append(text.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    public TextFragment createNewFragmentWithCodes(String plainText) {
        return new TextFragment(plainText + this.codesMarkers, this.codes);
    }

    public List<String> toCodedHTML(List<TextFragment> frags) {
        ArrayList<String> html = new ArrayList<String>();
        for (TextFragment frag : frags) {
            html.add(this.toCodedHTML(frag));
        }
        return html;
    }

    public String toCodedHTML(TextFragment fragment) {
        if (fragment == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String text = fragment.getCodedText();
        block12: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': {
                    Code code = fragment.getCode(text.charAt(++i));
                    sb.append(String.format("<u id='%d'>", code.getId()));
                    continue block12;
                }
                case '\ue102': {
                    ++i;
                    sb.append("</u>");
                    continue block12;
                }
                case '\ue103': {
                    Code code = fragment.getCode(text.charAt(++i));
                    switch (code.getTagType()) {
                        case OPENING: {
                            sb.append(String.format("<br id='b%d'/>", code.getId()));
                            break;
                        }
                        case CLOSING: {
                            sb.append(String.format("<br id='e%d'/>", code.getId()));
                            break;
                        }
                        case PLACEHOLDER: {
                            sb.append(String.format("<br id='p%d'/>", code.getId()));
                        }
                    }
                    continue block12;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block12;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block12;
                }
                default: {
                    sb.append(text.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    public TextFragment fromCodedHTMLToFragment(String text, TextFragment fragment) {
        String markers;
        int val;
        Matcher m;
        if (Util.isEmpty(text)) {
            if (fragment != null) {
                fragment.setCodedText("", true);
                return fragment;
            }
            return new TextFragment();
        }
        text = text.toString().replace("&apos;", "'");
        text = text.replace("&lt;", "<");
        text = text.replace("&gt;", ">");
        text = text.replace("&quot;", "\"");
        StringBuilder sb = new StringBuilder();
        sb.append(text.replace("&amp;", "&"));
        if (this.entities == null) {
            this.entities = new HTMLCharacterEntities();
            this.entities.ensureInitialization(false);
        }
        while ((m = CER.matcher(sb.toString())).find() && (val = this.entities.lookupReference(m.group(0))) != -1) {
            sb.replace(m.start(0), m.end(0), String.valueOf((char)val));
        }
        m = NCR.matcher(sb.toString());
        while (m.find()) {
            String val2 = m.group(1);
            int n = 63;
            try {
                n = val2.charAt(0) == 'x' ? Integer.valueOf(m.group(1).substring(1), 16).intValue() : Integer.valueOf(m.group(1)).intValue();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            sb.replace(m.start(0), m.end(0), String.valueOf((char)n));
            m = NCR.matcher(sb.toString());
        }
        ArrayList<Code> codes = new ArrayList<Code>();
        m = HTML_OPENCLOSE.matcher(sb.toString());
        Stack<Integer> stack = new Stack<Integer>();
        while (m.find()) {
            Code code;
            if (m.group(1) != null) {
                int id = Util.strToInt(m.group(3), -1);
                code = new Code(TextFragment.TagType.OPENING, "Xpt", null);
                code.setId(id);
                codes.add(code);
                markers = String.format("%c%c", 57601, Character.valueOf(TextFragment.toChar(codes.size() - 1)));
                sb.replace(m.start(), m.end(), markers);
                stack.push(id);
            } else {
                if (stack.isEmpty()) {
                    markers = "";
                } else {
                    code = new Code(TextFragment.TagType.CLOSING, "Xpt", null);
                    codes.add(code);
                    markers = String.format("%c%c", 57602, Character.valueOf(TextFragment.toChar(codes.size() - 1)));
                }
                sb.replace(m.start(), m.end(), markers);
            }
            m = HTML_OPENCLOSE.matcher(sb.toString());
        }
        m = HTML_ISOLATED.matcher(sb.toString());
        while (m.find()) {
            Code code;
            switch (m.group(2).charAt(0)) {
                case 'b': {
                    code = new Code(TextFragment.TagType.PLACEHOLDER, "Xph", null);
                    break;
                }
                case 'e': {
                    code = new Code(TextFragment.TagType.PLACEHOLDER, "Xph", null);
                    break;
                }
                case 'p': {
                    code = new Code(TextFragment.TagType.PLACEHOLDER, "Xph", null);
                    break;
                }
                default: {
                    throw new OkapiException("ID of isolated code modified.");
                }
            }
            int id = Util.strToInt(m.group(2).substring(1), -1);
            code.setId(id);
            codes.add(code);
            markers = String.format("%c%c", 57603, Character.valueOf(TextFragment.toChar(codes.size() - 1)));
            sb.replace(m.start(), m.end(), markers);
            m = HTML_ISOLATED.matcher(sb.toString());
        }
        m = HTML_SPAN.matcher(sb.toString());
        while (m.find()) {
            sb.replace(m.start(), m.end(), "");
            m = HTML_SPAN.matcher(sb.toString());
        }
        if (fragment != null) {
            fragment.setCodedText(sb.toString(), codes, true);
            return fragment;
        }
        return new TextFragment(sb.toString(), codes);
    }

    public String fromCodedHTML(String htmlText, TextFragment fragment, boolean addMissingCodes) {
        return this.fromCodedHTML(htmlText, fragment, addMissingCodes, true);
    }

    public String fromCodedHTML(String htmlText, TextFragment fragment, boolean addMissingCodes, boolean removeSpans) {
        int val;
        Matcher m;
        if (Util.isEmpty(htmlText)) {
            return "";
        }
        htmlText = htmlText.toString().replace("&apos;", "'");
        htmlText = htmlText.replace("&lt;", "<");
        htmlText = htmlText.replace("&gt;", ">");
        htmlText = htmlText.replace("&quot;", "\"");
        StringBuilder sb = new StringBuilder(htmlText.replace("&amp;", "&"));
        if (this.entities == null) {
            this.entities = new HTMLCharacterEntities();
            this.entities.ensureInitialization(false);
        }
        ArrayList<String> newCodes = new ArrayList<String>();
        ArrayList<String> oriCodes = new ArrayList<String>();
        for (Code code : fragment.getCodes()) {
            block1 : switch (code.getTagType()) {
                case OPENING: {
                    oriCodes.add(String.format("o%d", code.getId()));
                    break;
                }
                case CLOSING: {
                    oriCodes.add(String.format("c%d", code.getId()));
                    break;
                }
                case PLACEHOLDER: {
                    switch (code.getTagType()) {
                        case OPENING: {
                            oriCodes.add(String.format("b%d", code.getId()));
                            break block1;
                        }
                        case CLOSING: {
                            oriCodes.add(String.format("e%d", code.getId()));
                            break block1;
                        }
                        case PLACEHOLDER: {
                            oriCodes.add(String.format("p%d", code.getId()));
                        }
                    }
                }
            }
        }
        while ((m = CER.matcher(sb.toString())).find() && (val = this.entities.lookupReference(m.group(0))) != -1) {
            sb.replace(m.start(0), m.end(0), String.valueOf((char)val));
        }
        m = NCR.matcher(sb.toString());
        while (m.find()) {
            String val2 = m.group(1);
            int n = 63;
            try {
                n = val2.charAt(0) == 'x' ? Integer.valueOf(m.group(1).substring(1), 16).intValue() : Integer.valueOf(m.group(1)).intValue();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            sb.replace(m.start(0), m.end(0), String.valueOf((char)n));
            m = NCR.matcher(sb.toString());
        }
        m = HTML_OPENCLOSE.matcher(sb.toString());
        Stack<Integer> stack = new Stack<Integer>();
        while (m.find()) {
            String markers;
            if (m.group(1) != null) {
                int id = Util.strToInt(m.group(3), -1);
                markers = String.format("%c%c", 57601, Character.valueOf(TextFragment.toChar(fragment.getIndex(id))));
                sb.replace(m.start(), m.end(), markers);
                stack.push(id);
                newCodes.add(String.format("o%d", id));
            } else {
                if (stack.isEmpty()) {
                    markers = "";
                } else {
                    newCodes.add(String.format("c%d", stack.peek()));
                    markers = String.format("%c%c", 57602, Character.valueOf(TextFragment.toChar(fragment.getIndexForClosing((Integer)stack.pop()))));
                }
                sb.replace(m.start(), m.end(), markers);
            }
            m = HTML_OPENCLOSE.matcher(sb.toString());
        }
        m = HTML_ISOLATED.matcher(sb.toString());
        while (m.find()) {
            char isoType = m.group(2).charAt(0);
            int id = Util.strToInt(m.group(2).substring(1), -1);
            String markers = String.format("%c%c", 57603, Character.valueOf(TextFragment.toChar(fragment.getIndex(id))));
            sb.replace(m.start(), m.end(), markers);
            m = HTML_ISOLATED.matcher(sb.toString());
            newCodes.add(String.format("%c%d", Character.valueOf(isoType), id));
        }
        if (removeSpans) {
            m = HTML_SPAN.matcher(sb.toString());
            while (m.find()) {
                sb.replace(m.start(), m.end(), "");
                m = HTML_SPAN.matcher(sb.toString());
            }
        }
        if (addMissingCodes && newCodes.size() < oriCodes.size()) {
            for (String tmp : oriCodes) {
                if (newCodes.contains(tmp)) continue;
                switch (tmp.charAt(0)) {
                    case 'o': {
                        sb.append(String.format("%c%c", 57601, Character.valueOf(TextFragment.toChar(fragment.getIndex(Integer.parseInt(tmp.substring(1)))))));
                        break;
                    }
                    case 'c': {
                        sb.append(String.format("%c%c", 57602, Character.valueOf(TextFragment.toChar(fragment.getIndexForClosing(Integer.parseInt(tmp.substring(1)))))));
                        break;
                    }
                    case 'b': 
                    case 'e': 
                    case 'p': {
                        sb.append(String.format("%c%c", 57603, Character.valueOf(TextFragment.toChar(fragment.getIndex(Integer.parseInt(tmp.substring(1)))))));
                    }
                }
            }
        }
        return sb.toString();
    }

    public String fromPlainTextHTML(String text) {
        int val;
        Matcher m;
        if (Util.isEmpty(text)) {
            return "";
        }
        text = text.toString().replace("&apos;", "'");
        text = text.replace("&lt;", "<");
        text = text.replace("&gt;", ">");
        text = text.replace("&quot;", "\"");
        StringBuilder sb = new StringBuilder();
        sb.append(text.replace("&amp;", "&"));
        if (this.entities == null) {
            this.entities = new HTMLCharacterEntities();
            this.entities.ensureInitialization(false);
        }
        while ((m = CER.matcher(sb.toString())).find() && (val = this.entities.lookupReference(m.group(0))) != -1) {
            sb.replace(m.start(0), m.end(0), String.valueOf((char)val));
        }
        m = NCR.matcher(sb.toString());
        while (m.find()) {
            String val2 = m.group(1);
            int n = 63;
            try {
                n = val2.charAt(0) == 'x' ? Integer.valueOf(m.group(1).substring(1), 16).intValue() : Integer.valueOf(m.group(1)).intValue();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            sb.replace(m.start(0), m.end(0), String.valueOf((char)n));
            m = NCR.matcher(sb.toString());
        }
        return sb.toString();
    }

    public String toXLIFF(TextFragment fragment) {
        if (fragment == null) {
            return "";
        }
        this.fmt.setContent(fragment);
        return this.fmt.toString();
    }

    public TextFragment fromXLIFF(Element elem, TextFragment original) {
        NodeList list = elem.getChildNodes();
        int lastId = -1;
        int id = -1;
        Stack<Integer> stack = new Stack<Integer>();
        StringBuilder buffer = new StringBuilder();
        block4: for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            switch (node.getNodeType()) {
                case 3: {
                    buffer.append(node.getNodeValue());
                    continue block4;
                }
                case 1: {
                    NamedNodeMap map = node.getAttributes();
                    if (node.getNodeName().equals("bpt")) {
                        id = this.getRawIndex(lastId, map.getNamedItem("id"));
                        stack.push(id);
                        buffer.append(String.format("%c%c", 57601, Character.valueOf(TextFragment.toChar(original.getIndex(id)))));
                        continue block4;
                    }
                    if (node.getNodeName().equals("ept")) {
                        buffer.append(String.format("%c%c", 57602, Character.valueOf(TextFragment.toChar(original.getIndexForClosing((Integer)stack.pop())))));
                        continue block4;
                    }
                    if (node.getNodeName().equals("ph")) {
                        id = this.getRawIndex(lastId, map.getNamedItem("id"));
                        buffer.append(String.format("%c%c", 57603, Character.valueOf(TextFragment.toChar(original.getIndex(id)))));
                        continue block4;
                    }
                    if (!node.getNodeName().equals("it")) continue block4;
                    Node pos = map.getNamedItem("pos");
                    if (pos == null) {
                        id = this.getRawIndex(lastId, map.getNamedItem("id"));
                        buffer.append(String.format("%c%c", 57603, Character.valueOf(TextFragment.toChar(original.getIndex(id)))));
                        continue block4;
                    }
                    if (pos.getNodeValue().equals("begin")) {
                        id = this.getRawIndex(lastId, map.getNamedItem("id"));
                        buffer.append(String.format("%c%c", 57601, Character.valueOf(TextFragment.toChar(original.getIndex(id)))));
                        continue block4;
                    }
                    id = this.getRawIndex(lastId, map.getNamedItem("id"));
                    buffer.append(String.format("%c%c", 57602, Character.valueOf(TextFragment.toChar(original.getIndexForClosing(id)))));
                }
            }
        }
        return new TextFragment(buffer.toString(), original.getCodes());
    }

    public static ArrayList<QueryResult> removeDuplicates(List<QueryResult> queryResults) {
        LinkedHashSet<QueryResult> dupRemove = new LinkedHashSet<QueryResult>(queryResults.size());
        Collections.sort(queryResults);
        for (QueryResult qr : queryResults) {
            dupRemove.add(qr);
        }
        return new ArrayList<QueryResult>(dupRemove);
    }

    private int getRawIndex(int lastIndex, Node attr) {
        if (attr == null) {
            return ++lastIndex;
        }
        return Integer.valueOf(attr.getNodeValue());
    }
}

