/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.paraaligner;

import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.steps.gcaligner.AlignmentFunction;
import net.sf.okapi.steps.gcaligner.AlignmentScorer;
import net.sf.okapi.steps.gcaligner.DpMatrix;
import net.sf.okapi.steps.gcaligner.DpMatrixCell;
import net.sf.okapi.steps.gcaligner.Penalties;
import net.sf.okapi.steps.paraaligner.AlignedParagraphs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphAligner {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final long MAX_CELL_SIZE = 80000L;
    private List<AlignmentScorer<ITextUnit>> scorerList;

    public ParagraphAligner(List<AlignmentScorer<ITextUnit>> scorerList) {
        this.scorerList = scorerList;
    }

    public AlignedParagraphs align(List<ITextUnit> sourceParagraphs, List<ITextUnit> targetParagraphs, LocaleId srcLocale, LocaleId trgLocale, boolean outputOneTOneMatchesOnly) {
        return this.alignWithoutSkeletonAlignment(sourceParagraphs, targetParagraphs, srcLocale, trgLocale, outputOneTOneMatchesOnly);
    }

    private AlignedParagraphs alignWithoutSkeletonAlignment(List<ITextUnit> sourceParagraphs, List<ITextUnit> targetParagraphs, LocaleId srcLocale, LocaleId trgLocale, boolean outputOneTOneMatchesOnly) {
        AlignmentFunction<ITextUnit> alignmentFunction = new AlignmentFunction<ITextUnit>(srcLocale, trgLocale, this.scorerList, new Penalties());
        return this.alignSegments(sourceParagraphs, targetParagraphs, srcLocale, trgLocale, alignmentFunction, outputOneTOneMatchesOnly);
    }

    private AlignedParagraphs alignSegments(List<ITextUnit> sourceParagraphs, List<ITextUnit> targetParagraphs, LocaleId srcLocale, LocaleId trgLocale, AlignmentFunction<ITextUnit> alignmentFunction, boolean outputOneTOneMatchesOnly) {
        if ((long)(sourceParagraphs.size() * targetParagraphs.size()) > 80000L) {
            throw new IllegalArgumentException("Too many segments. Can only align " + Long.toString(80000L) + ". Where the number equals the source segments times the target segments.");
        }
        DpMatrix<ITextUnit> matrix = new DpMatrix<ITextUnit>(sourceParagraphs, targetParagraphs, alignmentFunction);
        List<DpMatrixCell> result = matrix.align();
        AlignedParagraphs alignedParas = new AlignedParagraphs(trgLocale);
        for (DpMatrixCell cell : result) {
            ITextUnit targetPara;
            ITextUnit sourcePara;
            if (outputOneTOneMatchesOnly) {
                if (cell.getState() != 3) continue;
                sourcePara = matrix.getAlignmentElementX(cell.getXindex());
                targetPara = matrix.getAlignmentElementY(cell.getYindex());
                alignedParas.addAlignment(sourcePara, targetPara);
                continue;
            }
            if (cell.getState() == 1) {
                sourcePara = matrix.getAlignmentElementX(cell.getXindex());
                alignedParas.addAlignment(sourcePara, null);
                this.LOGGER.warn("{}\nTarget segment deleted (TU ID: {}): Non 1-1 match. Please confirm alignment.", (Object)sourcePara.toString(), (Object)sourcePara.getName());
                continue;
            }
            if (cell.getState() == 2) {
                ITextUnit targetPara2 = matrix.getAlignmentElementY(cell.getYindex());
                alignedParas.addAlignment(null, targetPara2);
                this.LOGGER.warn("{}\nSource segment deleted (TU ID: {}): Non 1-1 match. Please confirm alignment.", (Object)targetPara2.toString(), (Object)targetPara2.getName());
                continue;
            }
            if (cell.getState() == 3) {
                sourcePara = matrix.getAlignmentElementX(cell.getXindex());
                targetPara = matrix.getAlignmentElementY(cell.getYindex());
                alignedParas.addAlignment(sourcePara, targetPara);
                continue;
            }
            if (cell.getState() != 4) continue;
            List<ITextUnit> sourceParas = matrix.getAlignmentElementsX(cell.getMultiMatchXIndexBegin(), cell.getMultiMatchXIndexEnd());
            List<ITextUnit> targetParas = matrix.getAlignmentElementsY(cell.getMultiMatchYIndexBegin(), cell.getMultiMatchYIndexEnd());
            alignedParas.addAlignment(sourceParas, targetParas);
            ITextUnit p = null;
            try {
                p = sourceParas.get(0);
            }
            catch (IndexOutOfBoundsException e) {
                p = targetParas.get(0);
            }
            this.LOGGER.warn("{}\nMulti-ITextUnit Match (TU ID: {}): Non 1-1 match. Please confirm alignment.", (Object)p.getSource().toString(), (Object)p.getName());
        }
        return alignedParas;
    }
}

