/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.simpletm2tmx;

import java.io.File;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.tm.simpletm.Database;

@UsingParameters
public class SimpleTM2TMXStep
extends BasePipelineStep {
    private Database db;
    private boolean isDone;

    @Override
    public String getDescription() {
        return "Generates a TMX document from a SimpleTM database. Expects: raw document. Sends back: raw document.";
    }

    @Override
    public String getName() {
        return "SimpleTM to TMX";
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    protected Event handleStartBatchItem(Event event) {
        this.isDone = false;
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Event handleRawDocument(Event event) {
        try {
            if (this.db == null) {
                this.db = new Database();
            } else {
                this.db.close();
            }
            RawDocument rd = (RawDocument)event.getResource();
            String path = new File(rd.getInputURI()).getPath();
            this.db.open(path);
            LocaleId srcLang = rd.getSourceLocale();
            LocaleId trgLang = rd.getTargetLocale();
            String outPath = path + ".tmx";
            this.db.exportToTMX(outPath, srcLang, trgLang);
            this.db.close();
            File file = new File(outPath);
            event.setResource(new RawDocument(file.toURI(), "UTF-8", srcLang, trgLang));
        }
        finally {
            this.isDone = true;
        }
        return event;
    }
}

