/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.translationcomparison;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.search.lucene.analysis.AlphabeticNgramTokenizer;
import net.sf.okapi.lib.translation.TextMatcher;
import net.sf.okapi.steps.translationcomparison.Parameters;
import net.sf.okapi.steps.wordcount.common.Metrics;
import net.sf.okapi.steps.wordcount.common.MetricsAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class TranslationComparisonStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String WIKIURL = "http://okapiframework.org/wiki/index.php?title=Translation_Comparison_Step";
    private Parameters params;
    private IFilter filter2;
    private IFilter filter3;
    private TextMatcher matcher;
    private XMLWriter writer;
    private TMXWriter tmx;
    private PrintWriter prnWriter;
    private boolean isBaseMultilingual;
    private boolean isInput2Multilingual;
    private boolean isInput3Multilingual;
    private String pathToOpen;
    private int options;
    private Property deScore1to2Prop;
    private Property deScore1to3Prop;
    private Property fmScore1to2Prop;
    private Property fmScore1to3Prop;
    private long deScoreTotal1to2;
    private long deScoreTotal1to3;
    private long deScoreTotal2to3;
    private long fmScoreTotal1to2;
    private long fmScoreTotal1to3;
    private long fmScoreTotal2to3;
    private int itemCount;
    private String baseDocumentPath;
    private String compDocumentPath;
    private IFilterConfigurationMapper fcMapper;
    private LocaleId targetLocale;
    private LocaleId targetLocale2Extra;
    private LocaleId targetLocale3Extra;
    private LocaleId sourceLocale;
    private URI inputURI;
    private RawDocument rawDoc2;
    private RawDocument rawDoc3;
    private GenericContent fmt;
    private String rootDir;
    private String inputRootDir;
    private AlphabeticNgramTokenizer tokenizer;
    private SimpleDateFormat df;
    private long wcTotal;
    private int[] edBrackets = new int[11];
    private int[] edWCBrackets = new int[11];
    private int[] fmBrackets = new int[11];
    private int[] fmWCBrackets = new int[11];
    private int edScoreWordTotal;
    private int fmScoreWordTotal;

    public TranslationComparisonStep() {
        this.params = new Parameters();
        this.fmt = new GenericContent();
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_URI)
    public void setInputURI(URI inputURI) {
        this.inputURI = inputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.rawDoc2 = secondInput;
    }

    @StepParameterMapping(parameterType=StepParameterType.THIRD_INPUT_RAWDOC)
    public void setThirdInput(RawDocument thirdInput) {
        this.rawDoc3 = thirdInput;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_ROOT_DIRECTORY)
    public void setInputRootDirectory(String inputRootDir) {
        this.inputRootDir = inputRootDir;
    }

    @Override
    public String getName() {
        return "Translation Comparison";
    }

    @Override
    public String getDescription() {
        return "Compare the translated text units between several documents. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.matcher = new TextMatcher(this.targetLocale, this.targetLocale);
        if (this.params.isGenerateTMX()) {
            String resolvedPath = Util.fillRootDirectoryVariable(this.params.getTmxPath(), this.rootDir);
            resolvedPath = Util.fillInputRootDirectoryVariable(resolvedPath, this.inputRootDir);
            resolvedPath = LocaleId.replaceVariables(resolvedPath, this.sourceLocale, this.targetLocale);
            this.tmx = new TMXWriter(resolvedPath);
            this.tmx.writeStartDocument(this.sourceLocale, this.targetLocale, this.getClass().getName(), null, null, null, null);
        }
        this.pathToOpen = null;
        this.deScore1to2Prop = new Property("Txt::EDScore", "", false);
        this.fmScore1to2Prop = new Property("Txt::FMScore", "", false);
        this.targetLocale2Extra = LocaleId.fromString(this.targetLocale.toString() + this.params.getTarget2Suffix());
        this.deScore1to3Prop = new Property("Txt::EDScore1to3", "", false);
        this.fmScore1to3Prop = new Property("Txt::FMScore1to3", "", false);
        this.targetLocale3Extra = LocaleId.fromString(this.targetLocale.toString() + this.params.getTarget3Suffix());
        this.options = 0;
        if (!this.params.isCaseSensitive()) {
            this.options |= 1;
        }
        if (!this.params.isWhitespaceSensitive()) {
            this.options |= 2;
        }
        if (!this.params.isPunctuationSensitive()) {
            this.options |= 4;
        }
        this.tokenizer = net.sf.okapi.lib.search.lucene.scorer.Util.createNgramTokenizer(3, this.targetLocale);
        this.df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
        this.df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        this.matcher = null;
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.prnWriter != null) {
            this.prnWriter.close();
            this.prnWriter = null;
        }
        if (this.tmx != null) {
            this.tmx.writeEndDocument();
            this.tmx.close();
            this.tmx = null;
        }
        Runtime.getRuntime().gc();
        if (this.params.isAutoOpen() && this.pathToOpen != null) {
            Util.openURL(new File(this.pathToOpen).getAbsolutePath());
        }
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event1) {
        StartDocument startDoc1 = (StartDocument)event1.getResource();
        this.initializeDocumentData();
        this.isBaseMultilingual = startDoc1.isMultilingual();
        Event event2 = this.synchronize(this.filter2, EventType.START_DOCUMENT);
        StartDocument startDoc2 = (StartDocument)event2.getResource();
        this.isInput2Multilingual = startDoc2.isMultilingual();
        if (this.filter3 != null) {
            Event event3 = this.synchronize(this.filter3, EventType.START_DOCUMENT);
            StartDocument startDoc3 = (StartDocument)event3.getResource();
            this.isInput3Multilingual = startDoc3.isMultilingual();
        }
        this.deScoreTotal1to2 = 0L;
        this.deScoreTotal1to3 = 0L;
        this.deScoreTotal2to3 = 0L;
        this.fmScoreTotal1to2 = 0L;
        this.fmScoreTotal1to3 = 0L;
        this.fmScoreTotal2to3 = 0L;
        this.wcTotal = 0L;
        this.edScoreWordTotal = 0;
        this.fmScoreWordTotal = 0;
        for (int i = 0; i < this.edBrackets.length; ++i) {
            this.edBrackets[i] = 0;
            this.edWCBrackets[i] = 0;
            this.fmBrackets[i] = 0;
            this.fmWCBrackets[i] = 0;
        }
        this.itemCount = 0;
        return event1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Event handleEndDocument(Event event) {
        float avgScore1to2 = 0.0f;
        float avgScore1to3 = 0.0f;
        float avgScore2to3 = 0.0f;
        float avgFuzzyScore1to2 = 0.0f;
        float avgFuzzyScore1to3 = 0.0f;
        float avgFuzzyScore2to3 = 0.0f;
        if (this.filter2 != null) {
            this.filter2.close();
        }
        if (this.filter3 != null) {
            this.filter3.close();
        }
        if (this.itemCount > 0) {
            avgScore1to2 = (float)this.deScoreTotal1to2 / (float)this.itemCount;
            avgScore1to3 = (float)this.deScoreTotal1to3 / (float)this.itemCount;
            avgScore2to3 = (float)this.deScoreTotal2to3 / (float)this.itemCount;
            avgFuzzyScore1to2 = (float)this.fmScoreTotal1to2 / (float)this.itemCount;
            avgFuzzyScore1to3 = (float)this.fmScoreTotal1to3 / (float)this.itemCount;
            avgFuzzyScore2to3 = (float)this.fmScoreTotal2to3 / (float)this.itemCount;
        }
        if (this.params.isGenerateHTML()) {
            this.writer.writeEndElement();
            this.writer.writeElementString("p", String.format("", this.itemCount));
            if (this.itemCount > 0) {
                this.writer.writeStartElement("h2");
                this.writer.writeAttributeString("id", "summary");
                this.writer.writeString("Summary");
                this.writer.writeEndElement();
                this.writer.writeElementString("p", String.format("Repartition for %s to %s:", this.params.getDocument1Label(), this.params.getDocument2Label()));
                this.writer.writeRawXML("<table border=1 cellspacing=0 cellpadding=5>");
                this.writer.writeRawXML("<tr><th rowspan=2>Scores</th><th colspan=4>ED-Scores</th><th colspan=4>FM-Scores</th></tr>");
                this.writer.writeRawXML("<tr><th style=\"text-align: right; width: 100px;\">Segments </th><th style=\"text-align: right; width: 100px;\">% </th><th style=\"text-align: right; width: 100px;\">Words </th><th style=\"text-align: right; width: 100px;\">% </th><th style=\"text-align: right; width: 100px;\">Segments </th><th style=\"text-align: right; width: 100px;\">% </th><th style=\"text-align: right; width: 100px;\">Words </th><th style=\"text-align: right; width: 100px;\">% </th></tr>");
                this.printBracket(10, "100");
                this.printBracket(9, "90 - 99");
                this.printBracket(8, "80 - 89");
                this.printBracket(7, "70 - 79");
                this.printBracket(6, "60 - 69");
                this.printBracket(5, "50 - 59");
                this.printBracket(4, "40 - 49");
                this.printBracket(3, "30 - 39");
                this.printBracket(2, "20 - 29");
                this.printBracket(1, "10 - 19");
                this.printBracket(0, "0 - 9");
                this.writer.writeRawXML("<tr><td>Total</td>");
                this.writer.writeRawXML(String.format("<td align='right'>%d</td>", this.itemCount));
                this.writer.writeRawXML("<td align='right'>100%</td>");
                this.writer.writeRawXML(String.format("<td align='right'>%d</td>", this.wcTotal));
                this.writer.writeRawXML("<td align='right'>100%</td>");
                this.writer.writeRawXML(String.format("<td align='right'>%d</td>", this.itemCount));
                this.writer.writeRawXML("<td align='right'>100%</td>");
                this.writer.writeRawXML(String.format("<td align='right'>%d</td>", this.wcTotal));
                this.writer.writeRawXML("<td align='right'>100%</td>");
                this.writer.writeRawXML("</tr>\n");
                this.writer.writeRawXML("</table>\n");
                this.writer.writeElementString("p", " ");
                this.writer.writeStartElement("table");
                this.writer.writeRawXML("<tr><td>");
                this.writer.writeString("Total Number of Segments:");
                this.writer.writeRawXML("</td><td><b>");
                this.writer.writeString(String.format("%d", this.itemCount));
                this.writer.writeRawXML("</b></td></tr>\n");
                this.writer.writeRawXML("<tr><td>");
                this.writer.writeString("Total Number of Words:");
                this.writer.writeRawXML("</td><td><b>");
                this.writer.writeString(String.format("%d", this.wcTotal));
                this.writer.writeRawXML("</b></td></tr>\n");
                this.writer.writeRawXML("<tr><td>");
                this.writer.writeString("Average word count per segment:");
                this.writer.writeRawXML("</td><td><b>");
                this.writer.writeString(String.format("%.2f", Float.valueOf((float)this.wcTotal / (float)this.itemCount)));
                this.writer.writeRawXML("</b></td></tr>\n");
                this.writer.writeRawXML("<tr><td>");
                this.writer.writeString("Average ED-Score (by segment):");
                this.writer.writeRawXML("</td><td><b>");
                this.writer.writeString(String.format("%s to %s = %.2f", this.params.getDocument1Label(), this.params.getDocument2Label(), Float.valueOf(avgScore1to2)));
                if (this.deScoreTotal1to3 > 0L) {
                    this.writer.writeString(String.format(",  %s to %s = %.2f,  ", this.params.getDocument1Label(), this.params.getDocument3Label(), Float.valueOf(avgScore1to3)));
                    this.writer.writeString(String.format("%s to %s = %.2f", this.params.getDocument2Label(), this.params.getDocument3Label(), Float.valueOf(avgScore2to3)));
                }
                this.writer.writeRawXML("</b></td></tr>\n");
                this.writer.writeRawXML("<tr><td>");
                this.writer.writeString("Average FM-Score (by segment):");
                this.writer.writeRawXML("</td><td><b>");
                this.writer.writeString(String.format("%s to %s = %.2f", this.params.getDocument1Label(), this.params.getDocument2Label(), Float.valueOf(avgFuzzyScore1to2)));
                if (this.deScoreTotal1to3 > 0L) {
                    this.writer.writeString(String.format(",  %s to %s = %.2f,  ", this.params.getDocument1Label(), this.params.getDocument3Label(), Float.valueOf(avgFuzzyScore1to3)));
                    this.writer.writeString(String.format("%s to %s = %.2f", this.params.getDocument2Label(), this.params.getDocument3Label(), Float.valueOf(avgFuzzyScore2to3)));
                }
                this.writer.writeRawXML("</b></td></tr>\n");
                float edScoreWordTotalAvg = (float)this.edScoreWordTotal / (float)this.wcTotal;
                this.writer.writeRawXML("<tr><td>");
                this.writer.writeString("Average ED-Score (by word):");
                this.writer.writeRawXML("</td><td><b>");
                this.writer.writeString(String.format("%s to %s = %.2f", this.params.getDocument1Label(), this.params.getDocument2Label(), Float.valueOf(edScoreWordTotalAvg)));
                this.writer.writeRawXML("</b></td></tr>\n");
                float fmScoreWordTotalAvg = (float)this.fmScoreWordTotal / (float)this.wcTotal;
                this.writer.writeRawXML("<tr><td>");
                this.writer.writeString("Average FM-Score (by word):");
                this.writer.writeRawXML("</td><td><b>");
                this.writer.writeString(String.format("%s to %s = %.2f", this.params.getDocument1Label(), this.params.getDocument2Label(), Float.valueOf(fmScoreWordTotalAvg)));
                this.writer.writeRawXML("</b></td></tr>\n");
                this.writer.writeRawXML("<tr><td>");
                this.writer.writeString("Edit Effort Score:");
                this.writer.writeRawXML("</td><td><b>");
                this.writer.writeString(String.format("%.2f", Float.valueOf(100.0f - (edScoreWordTotalAvg + fmScoreWordTotalAvg) / 2.0f)));
                this.writer.writeRawXML("</b></td></tr>\n");
                this.writer.writeEndElement();
                this.writer.writeElementString("p", " ");
            }
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.close();
        }
        if (this.itemCount > 0 && this.params.getUseDataLog()) {
            try (PrintWriter out = null;){
                out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.params.getDataLogPath(), true), "UTF-8")));
                out.println(String.format("%s\t%s\t%s\t%.2f\t%.2f", this.df.format(new Date()), this.baseDocumentPath, this.compDocumentPath, Float.valueOf(avgScore1to2), Float.valueOf(avgFuzzyScore1to2)));
            }
        }
        return event;
    }

    private void printBracket(int index, String range) {
        this.writer.writeRawXML("<tr " + (index % 2 == 0 ? "" : "bgcolor=#FFFFCC") + "><td>" + range + "</td>");
        this.writer.writeRawXML(String.format("<td align='right'>%d</td>", this.edBrackets[index]));
        this.writer.writeRawXML(this.itemCount == 0 ? "<td align='right'>NA</td>" : String.format("<td align='right'>%.0f</td>", Float.valueOf((float)this.edBrackets[index] / (float)this.itemCount * 100.0f)));
        this.writer.writeRawXML(String.format("<td align='right'>%d</td>", this.edWCBrackets[index]));
        this.writer.writeRawXML(this.wcTotal == 0L ? "<td align='right'>NA</td>" : String.format("<td align='right'>%.0f</td>", Float.valueOf((float)this.edWCBrackets[index] / (float)this.wcTotal * 100.0f)));
        this.writer.writeRawXML(String.format("<td align='right'>%d</td>", this.fmBrackets[index]));
        this.writer.writeRawXML(this.itemCount == 0 ? "<td align='right'>NA</td>" : String.format("<td align='right'>%.0f</td>", Float.valueOf((float)this.fmBrackets[index] / (float)this.itemCount * 100.0f)));
        this.writer.writeRawXML(String.format("<td align='right'>%d</td>", this.fmWCBrackets[index]));
        this.writer.writeRawXML(this.wcTotal == 0L ? "<td align='right'>NA</td>" : String.format("<td align='right'>%.0f</td>", Float.valueOf((float)this.fmWCBrackets[index] / (float)this.wcTotal * 100.0f)));
        this.writer.writeRawXML("</tr>\n");
    }

    @Override
    protected Event handleTextUnit(Event event1) {
        TextFragment trgFrag2;
        TextFragment trgFrag1;
        TextContainer trgCont;
        ITextUnit tu1 = event1.getTextUnit();
        Event event2 = this.synchronize(this.filter2, EventType.TEXT_UNIT);
        Event event3 = null;
        if (this.filter3 != null) {
            event3 = this.synchronize(this.filter3, EventType.TEXT_UNIT);
        }
        if (!tu1.isTranslatable()) {
            return event1;
        }
        ITextUnit tu2 = event2.getTextUnit();
        ITextUnit tu3 = null;
        if (event3 != null) {
            tu3 = event3.getTextUnit();
        }
        TextFragment srcFrag = null;
        if (this.isBaseMultilingual) {
            srcFrag = tu1.getSource().contentIsOneSegment() ? tu1.getSource().getFirstContent() : tu1.getSource().getUnSegmentedContentCopy();
        } else if (this.isInput2Multilingual) {
            srcFrag = tu2.getSource().contentIsOneSegment() ? tu2.getSource().getFirstContent() : tu2.getSource().getUnSegmentedContentCopy();
        } else if (tu3 != null && this.isInput3Multilingual) {
            srcFrag = tu3.getSource().contentIsOneSegment() ? tu3.getSource().getFirstContent() : tu3.getSource().getUnSegmentedContentCopy();
        }
        if (this.isBaseMultilingual) {
            trgCont = tu1.getTarget(this.targetLocale);
            if (trgCont == null) {
                throw new OkapiException(String.format("Missing '%s' entry for text unit id='%s' in base document.", this.targetLocale.toString(), tu1.getId()));
            }
            if (this.params.getUseAltTrans()) {
                AltTranslationsAnnotation ata = trgCont.getAnnotation(AltTranslationsAnnotation.class);
                trgFrag1 = null;
                if (ata != null) {
                    for (AltTranslation at : ata) {
                        if (at == null || !this.params.getAltTransOrigin().equals(at.getOrigin())) continue;
                        trgFrag1 = at.getTarget().getFirstContent();
                        break;
                    }
                }
                if (trgFrag1 == null) {
                    return event1;
                }
            } else {
                trgFrag1 = trgCont.contentIsOneSegment() ? trgCont.getFirstContent() : trgCont.getUnSegmentedContentCopy();
            }
        } else {
            trgFrag1 = tu1.getSource().contentIsOneSegment() ? tu1.getSource().getFirstContent() : tu1.getSource().getUnSegmentedContentCopy();
        }
        if (this.isInput2Multilingual) {
            trgCont = tu2.getTarget(this.targetLocale);
            if (trgCont == null) {
                throw new OkapiException(String.format("Missing '%s' entry for text unit id='%s' in document 2.", this.targetLocale.toString(), tu2.getId()));
            }
            trgFrag2 = trgCont.contentIsOneSegment() ? trgCont.getFirstContent() : trgCont.getUnSegmentedContentCopy();
        } else {
            trgFrag2 = tu2.getSource().contentIsOneSegment() ? tu2.getSource().getFirstContent() : tu2.getSource().getUnSegmentedContentCopy();
        }
        TextFragment trgFrag3 = null;
        if (tu3 != null) {
            if (this.isInput3Multilingual) {
                trgCont = tu3.getTarget(this.targetLocale);
                if (trgCont == null) {
                    throw new OkapiException(String.format("Missing '%s' entry for text unit id='%s' in document 3.", this.targetLocale.toString(), tu3.getId()));
                }
                trgFrag3 = trgCont.contentIsOneSegment() ? trgCont.getFirstContent() : trgCont.getUnSegmentedContentCopy();
            } else {
                trgFrag3 = tu3.getSource().contentIsOneSegment() ? tu3.getSource().getFirstContent() : tu3.getSource().getUnSegmentedContentCopy();
            }
        }
        if (trgFrag1 == null) {
            return event1;
        }
        if (trgFrag2 == null) {
            trgFrag2 = new TextFragment();
        }
        if (event3 != null && trgFrag3 == null) {
            trgFrag3 = new TextFragment();
        }
        int edScore1to2 = this.matcher.compare(trgFrag1, trgFrag2, this.options);
        int fmScore1to2 = Math.round(net.sf.okapi.lib.search.lucene.scorer.Util.calculateNgramDiceCoefficient(trgFrag1.getText(), trgFrag2.getText(), this.tokenizer));
        int edScore1to3 = -1;
        int fmScore1to3 = -1;
        int edScore2to3 = -1;
        int fmScore2to3 = -1;
        if (event3 != null) {
            edScore1to3 = this.matcher.compare(trgFrag1, trgFrag3, this.options);
            fmScore1to3 = Math.round(net.sf.okapi.lib.search.lucene.scorer.Util.calculateNgramDiceCoefficient(trgFrag1.getText(), trgFrag3.getText(), this.tokenizer));
            edScore2to3 = this.matcher.compare(trgFrag2, trgFrag3, this.options);
            fmScore2to3 = Math.round(net.sf.okapi.lib.search.lucene.scorer.Util.calculateNgramDiceCoefficient(trgFrag2.getText(), trgFrag3.getText(), this.tokenizer));
        }
        this.deScoreTotal1to2 += (long)edScore1to2;
        this.deScoreTotal1to3 += (long)edScore1to3;
        this.deScoreTotal2to3 += (long)edScore2to3;
        this.fmScoreTotal1to2 += (long)fmScore1to2;
        this.fmScoreTotal1to3 += (long)fmScore1to3;
        this.fmScoreTotal2to3 += (long)fmScore2to3;
        MetricsAnnotation sma = tu1.getSource().getAnnotation(MetricsAnnotation.class);
        long srcWC = 0L;
        if (sma != null) {
            Metrics m = sma.getMetrics();
            srcWC = m.getMetric("TotalWordCount");
            this.wcTotal += srcWC;
        }
        this.edScoreWordTotal = (int)((long)this.edScoreWordTotal + srcWC * (long)edScore1to2);
        this.fmScoreWordTotal = (int)((long)this.fmScoreWordTotal + srcWC * (long)fmScore1to2);
        if (edScore1to2 < 10) {
            this.edBrackets[0] = this.edBrackets[0] + 1;
            this.edWCBrackets[0] = (int)((long)this.edWCBrackets[0] + srcWC);
        } else if (edScore1to2 >= 10 && edScore1to2 < 20) {
            this.edBrackets[1] = this.edBrackets[1] + 1;
            this.edWCBrackets[1] = (int)((long)this.edWCBrackets[1] + srcWC);
        } else if (edScore1to2 >= 20 && edScore1to2 < 30) {
            this.edBrackets[2] = this.edBrackets[2] + 1;
            this.edWCBrackets[2] = (int)((long)this.edWCBrackets[2] + srcWC);
        } else if (edScore1to2 >= 30 && edScore1to2 < 40) {
            this.edBrackets[3] = this.edBrackets[3] + 1;
            this.edWCBrackets[3] = (int)((long)this.edWCBrackets[3] + srcWC);
        } else if (edScore1to2 >= 40 && edScore1to2 < 50) {
            this.edBrackets[4] = this.edBrackets[4] + 1;
            this.edWCBrackets[4] = (int)((long)this.edWCBrackets[4] + srcWC);
        } else if (edScore1to2 >= 50 && edScore1to2 < 60) {
            this.edBrackets[5] = this.edBrackets[5] + 1;
            this.edWCBrackets[5] = (int)((long)this.edWCBrackets[5] + srcWC);
        } else if (edScore1to2 >= 60 && edScore1to2 < 70) {
            this.edBrackets[6] = this.edBrackets[6] + 1;
            this.edWCBrackets[6] = (int)((long)this.edWCBrackets[6] + srcWC);
        } else if (edScore1to2 >= 70 && edScore1to2 < 80) {
            this.edBrackets[7] = this.edBrackets[7] + 1;
            this.edWCBrackets[7] = (int)((long)this.edWCBrackets[7] + srcWC);
        } else if (edScore1to2 >= 80 && edScore1to2 < 90) {
            this.edBrackets[8] = this.edBrackets[8] + 1;
            this.edWCBrackets[8] = (int)((long)this.edWCBrackets[8] + srcWC);
        } else if (edScore1to2 >= 90 && edScore1to2 < 100) {
            this.edBrackets[9] = this.edBrackets[9] + 1;
            this.edWCBrackets[9] = (int)((long)this.edWCBrackets[9] + srcWC);
        } else if (edScore1to2 >= 100) {
            this.edBrackets[10] = this.edBrackets[10] + 1;
            this.edWCBrackets[10] = (int)((long)this.edWCBrackets[10] + srcWC);
        }
        if (fmScore1to2 < 10) {
            this.fmBrackets[0] = this.fmBrackets[0] + 1;
            this.fmWCBrackets[0] = (int)((long)this.fmWCBrackets[0] + srcWC);
        } else if (fmScore1to2 >= 10 && fmScore1to2 < 20) {
            this.fmBrackets[1] = this.fmBrackets[1] + 1;
            this.fmWCBrackets[1] = (int)((long)this.fmWCBrackets[1] + srcWC);
        } else if (fmScore1to2 >= 20 && fmScore1to2 < 30) {
            this.fmBrackets[2] = this.fmBrackets[2] + 1;
            this.fmWCBrackets[2] = (int)((long)this.fmWCBrackets[2] + srcWC);
        } else if (fmScore1to2 >= 30 && fmScore1to2 < 40) {
            this.fmBrackets[3] = this.fmBrackets[3] + 1;
            this.fmWCBrackets[3] = (int)((long)this.fmWCBrackets[3] + srcWC);
        } else if (fmScore1to2 >= 40 && fmScore1to2 < 50) {
            this.fmBrackets[4] = this.fmBrackets[4] + 1;
            this.fmWCBrackets[4] = (int)((long)this.fmWCBrackets[4] + srcWC);
        } else if (fmScore1to2 >= 50 && fmScore1to2 < 60) {
            this.fmBrackets[5] = this.fmBrackets[5] + 1;
            this.fmWCBrackets[5] = (int)((long)this.fmWCBrackets[5] + srcWC);
        } else if (fmScore1to2 >= 60 && fmScore1to2 < 70) {
            this.fmBrackets[6] = this.fmBrackets[6] + 1;
            this.fmWCBrackets[6] = (int)((long)this.fmWCBrackets[6] + srcWC);
        } else if (fmScore1to2 >= 70 && fmScore1to2 < 80) {
            this.fmBrackets[7] = this.fmBrackets[7] + 1;
            this.fmWCBrackets[7] = (int)((long)this.fmWCBrackets[7] + srcWC);
        } else if (fmScore1to2 >= 80 && fmScore1to2 < 90) {
            this.fmBrackets[8] = this.fmBrackets[8] + 1;
            this.fmWCBrackets[8] = (int)((long)this.fmWCBrackets[8] + srcWC);
        } else if (fmScore1to2 >= 90 && fmScore1to2 < 100) {
            this.fmBrackets[9] = this.fmBrackets[9] + 1;
            this.fmWCBrackets[9] = (int)((long)this.fmWCBrackets[9] + srcWC);
        } else if (fmScore1to2 >= 100) {
            this.fmBrackets[10] = this.fmBrackets[10] + 1;
            this.fmWCBrackets[10] = (int)((long)this.fmWCBrackets[10] + srcWC);
        }
        ++this.itemCount;
        if (this.params.isGenerateHTML()) {
            this.writer.writeRawXML("<tr><td class='p'>");
            if (srcFrag != null) {
                this.writer.writeString("Src:");
                this.writer.writeRawXML("</td>");
                this.writer.writeRawXML("<td class='p'>");
                this.fmt.setContent(srcFrag);
                this.writer.writeString(this.fmt.toString(!this.params.getGenericCodes()));
                this.writer.writeRawXML("</td></tr>\n");
                this.writer.writeRawXML("<tr><td>");
            }
            this.writer.writeString(this.params.getDocument1Label() + ":");
            this.writer.writeRawXML("</td>");
            if (srcFrag != null) {
                this.writer.writeRawXML("<td>");
            } else {
                this.writer.writeRawXML("<td class='p'>");
            }
            this.fmt.setContent(trgFrag1);
            this.writer.writeString(this.fmt.toString(!this.params.getGenericCodes()));
            this.writer.writeRawXML("</td></tr>");
            this.writer.writeRawXML("<tr><td>");
            this.writer.writeString(this.params.getDocument2Label() + ":");
            this.writer.writeRawXML("</td><td>");
            this.fmt.setContent(trgFrag2);
            this.writer.writeString(this.fmt.toString(!this.params.getGenericCodes()));
            this.writer.writeRawXML("</td></tr>");
            if (this.filter3 != null) {
                this.writer.writeRawXML("<tr><td>");
                this.writer.writeString(this.params.getDocument3Label() + ":");
                this.writer.writeRawXML("</td><td>");
                this.fmt.setContent(trgFrag3);
                this.writer.writeString(this.fmt.toString(!this.params.getGenericCodes()));
                this.writer.writeRawXML("</td></tr>");
            }
            this.writer.writeRawXML("<tr><td>");
            this.writer.writeString("ED-Score:");
            this.writer.writeRawXML("</td><td><b>");
            this.writer.writeString(String.format("%s to %s = %d", this.params.getDocument1Label(), this.params.getDocument2Label(), edScore1to2));
            if (edScore1to3 > -1) {
                this.writer.writeString(String.format(",  %s to %s = %d", this.params.getDocument1Label(), this.params.getDocument3Label(), edScore1to3));
                this.writer.writeString(String.format(",  %s to %s = %d", this.params.getDocument2Label(), this.params.getDocument3Label(), edScore2to3));
            }
            this.writer.writeRawXML("</b></td></tr>\n");
            this.writer.writeRawXML("<tr><td>");
            this.writer.writeString("FM-Score:");
            this.writer.writeRawXML("</td><td><b>");
            this.writer.writeString(String.format("%s to %s = %d", this.params.getDocument1Label(), this.params.getDocument2Label(), fmScore1to2));
            if (edScore1to3 > -1) {
                this.writer.writeString(String.format(",  %s to %s = %d", this.params.getDocument1Label(), this.params.getDocument3Label(), fmScore1to3));
                this.writer.writeString(String.format(",  %s to %s = %d", this.params.getDocument2Label(), this.params.getDocument3Label(), fmScore2to3));
            }
            this.writer.writeRawXML("</b></td></tr>\n");
            if (sma != null) {
                this.writer.writeRawXML("<tr><td>Src Word Count:</td><td><b>");
                this.writer.writeString(String.format("%d", srcWC));
                this.writer.writeRawXML("</b></td></tr>\n");
            }
        }
        if (this.prnWriter != null) {
            this.prnWriter.println(String.format("%d\t%s\t%d", edScore1to2, fmScore1to2, srcWC));
        }
        if (this.params.isGenerateTMX()) {
            TextUnit tmxTu = new TextUnit(tu1.getId());
            if (this.isBaseMultilingual) {
                tmxTu.setSource(tu1.getSource());
            } else if (srcFrag != null) {
                tmxTu.setSourceContent(srcFrag);
            }
            tmxTu.setTargetContent(this.targetLocale, trgFrag1);
            tmxTu.setTargetContent(this.targetLocale2Extra, trgFrag2);
            this.deScore1to2Prop.setValue(String.format("%03d", edScore1to2));
            this.fmScore1to2Prop.setValue(String.format("%03d", fmScore1to2));
            tmxTu.setTargetProperty(this.targetLocale2Extra, this.deScore1to2Prop);
            tmxTu.setTargetProperty(this.targetLocale2Extra, this.fmScore1to2Prop);
            if (this.filter3 != null) {
                tmxTu.setTargetContent(this.targetLocale3Extra, trgFrag3);
                this.deScore1to3Prop.setValue(String.format("%03d", edScore1to3));
                this.fmScore1to3Prop.setValue(String.format("%03d", fmScore1to3));
                tmxTu.setTargetProperty(this.targetLocale3Extra, this.deScore1to3Prop);
                tmxTu.setTargetProperty(this.targetLocale3Extra, this.fmScore1to3Prop);
            }
            this.tmx.writeTUFull(tmxTu);
        }
        return event1;
    }

    private String getOutputFilename() {
        return this.inputURI.getPath() + ".html";
    }

    private String getStatsFilename() {
        return this.inputURI.getPath() + ".txt";
    }

    private void initializeDocumentData() {
        this.filter2 = this.fcMapper.createFilter(this.rawDoc2.getFilterConfigId(), this.filter2);
        this.filter2.open(this.rawDoc2);
        if (this.rawDoc3 != null) {
            this.filter3 = this.fcMapper.createFilter(this.rawDoc3.getFilterConfigId(), this.filter3);
            this.filter3.open(this.rawDoc3);
        }
        this.baseDocumentPath = this.inputURI.getPath();
        this.compDocumentPath = this.rawDoc2.getInputURI().getPath();
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.prnWriter != null) {
            this.prnWriter.close();
        }
        if (this.params.isGenerateHTML()) {
            if (this.pathToOpen == null) {
                this.pathToOpen = this.getOutputFilename();
            }
            this.writer = new XMLWriter(this.getOutputFilename());
            this.writer.writeStartDocument();
            this.writer.writeStartElement("html");
            this.writer.writeStartElement("head");
            this.writer.writeRawXML("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />");
            this.writer.writeRawXML("<style>td { font-family: monospace } td { vertical-align: top; white-space: pre } td.p { border-top-style: solid; border-top-width: 1px;}</style>");
            this.writer.writeEndElement();
            this.writer.writeStartElement("body");
            this.writer.writeStartElement("h1");
            this.writer.writeString("Translation Comparison");
            this.writer.writeEndElement();
            this.writer.writeStartElement("p");
            this.writer.writeString(String.format("Base document (%s): %s", this.params.getDocument1Label(), this.baseDocumentPath));
            this.writer.writeRawXML("<br>");
            this.writer.writeString(String.format("Comparison 1 (%s): %s", this.params.getDocument2Label(), this.compDocumentPath));
            if (this.rawDoc3 != null) {
                this.writer.writeRawXML("<br>");
                this.writer.writeString(String.format("Comparison 2 (%s): %s", this.params.getDocument3Label(), this.rawDoc3.getInputURI().getPath()));
            }
            this.writer.writeString(".");
            this.writer.writeEndElement();
            this.writer.writeRawXML("<p>ED-Score = Edit distance score, FM-Score = Fuzzy Match score.<br/>For details see: <a href='http://okapiframework.org/wiki/index.php?title=Translation_Comparison_Step'>http://okapiframework.org/wiki/index.php?title=Translation_Comparison_Step</a>.</p>");
            this.writer.writeRawXML("<p><a href='#summary'>Go to Summary</a></p>");
            this.writer.writeStartElement("table");
            try {
                this.prnWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getStatsFilename()), "UTF-8")));
            }
            catch (Throwable e) {
                this.logger.error("Cannot create the file '{}'\n" + e.getMessage(), (Object)this.getStatsFilename());
            }
            this.prnWriter.println("ED-Score\tFM-Score\tWordCount");
        }
    }

    private Event synchronize(IFilter filter, EventType untilType) {
        boolean found = false;
        Event event = null;
        while (!found && filter.hasNext()) {
            event = filter.next();
            found = event.getEventType() == untilType;
        }
        if (!found) {
            throw new OkapiException("The document to compare is de-synchronized.");
        }
        return event;
    }
}

