/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.whitespacecorrection;

import java.util.Collection;
import java.util.EnumSet;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.steps.whitespacecorrection.WhitespaceCorrector;

@EditorFor(value=WhitespaceCorrectionStepParameters.class)
public class WhitespaceCorrectionStepParameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String PUNCTUATION = "punctuation";
    private EnumSet<WhitespaceCorrector.Punctuation> punctuation = EnumSet.allOf(WhitespaceCorrector.Punctuation.class);

    @Override
    public void reset() {
        super.reset();
        this.punctuation = EnumSet.allOf(WhitespaceCorrector.Punctuation.class);
    }

    public void setPunctuation(Collection<WhitespaceCorrector.Punctuation> punctuation) {
        this.punctuation.clear();
        for (WhitespaceCorrector.Punctuation p : punctuation) {
            this.punctuation.add(p);
        }
    }

    public EnumSet<WhitespaceCorrector.Punctuation> getPunctuation() {
        return this.punctuation;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (WhitespaceCorrector.Punctuation p : this.punctuation) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(p.toString());
        }
        this.buffer.setString(PUNCTUATION, sb.toString());
        return super.toString();
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.loadPunctuation(this.buffer.getString(PUNCTUATION));
    }

    private void loadPunctuation(String s) {
        this.punctuation.clear();
        for (String ps : s.split(",")) {
            WhitespaceCorrector.Punctuation p = WhitespaceCorrector.Punctuation.valueOf(ps);
            if (ps == null) continue;
            this.punctuation.add(p);
        }
    }

    public boolean getFullStop() {
        return this.punctuation.contains((Object)WhitespaceCorrector.Punctuation.FULL_STOP);
    }

    public void setFullStop(boolean value) {
        this.set(WhitespaceCorrector.Punctuation.FULL_STOP, value);
    }

    public boolean getComma() {
        return this.punctuation.contains((Object)WhitespaceCorrector.Punctuation.COMMA);
    }

    public void setComma(boolean value) {
        this.set(WhitespaceCorrector.Punctuation.COMMA, value);
    }

    public boolean getExclamationPoint() {
        return this.punctuation.contains((Object)WhitespaceCorrector.Punctuation.EXCLAMATION_MARK);
    }

    public void setExclamationPoint(boolean value) {
        this.set(WhitespaceCorrector.Punctuation.EXCLAMATION_MARK, value);
    }

    public boolean getQuestionMark() {
        return this.punctuation.contains((Object)WhitespaceCorrector.Punctuation.QUESTION_MARK);
    }

    public void setQuestionMark(boolean value) {
        this.set(WhitespaceCorrector.Punctuation.QUESTION_MARK, value);
    }

    private void set(WhitespaceCorrector.Punctuation p, boolean value) {
        if (value) {
            this.punctuation.add(p);
        } else {
            this.punctuation.remove((Object)p);
        }
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add("fullStop", "Full Stop", null);
        desc.add("comma", "Comma", null);
        desc.add("exclamationPoint", "Exclamation Point", null);
        desc.add("questionMark", "Question Mark", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Correct whitespace following", true, false);
        desc.addCheckboxPart(paramDesc.get("fullStop"));
        desc.addCheckboxPart(paramDesc.get("comma"));
        desc.addCheckboxPart(paramDesc.get("exclamationPoint"));
        desc.addCheckboxPart(paramDesc.get("questionMark"));
        return desc;
    }
}

