/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.its;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filterwriter.ITSContent;
import nu.validator.htmlparser.dom.HtmlDocumentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.its.IProcessor;
import org.w3c.its.ITSException;
import org.w3c.its.ITSRule;
import org.w3c.its.ITSTrace;
import org.w3c.its.ITraversal;
import org.w3c.its.NSContextManager;
import org.w3c.its.VariableResolver;
import org.xml.sax.InputSource;

public class ITSEngine
implements IProcessor,
ITraversal {
    public static final String ITS_VERSION1 = "1.0";
    public static final String ITS_VERSION2 = "2.0";
    public static final String ITS_MIMETYPE = "application/its+xml";
    private static final String FLAGNAME = "\u00ff";
    private static final String FLAGSEP = "\u001c";
    private static final String FLAGDEFAULTDATA = "????????????????????\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c\u001c";
    private static final String PTRFLAG = "@@";
    private static final String REFFLAG = "\u0011";
    private static final String VALIDALLOWEDCHARS = "((\\\\[nrt\\\\|.?*+(){}\\u002D\\[\\u005D\\u005E]))|(\\[(([^\\u002D\\u005B\\u005D]|(\\\\[nrt\\\\|.?*+(){}\\u002D\\[\\u005D\\u005E]))-([^\\u002D\\u005B\\u005D]|(\\\\[nrt\\\\|.?*+(){}\\u002D\\[\\u005D\\u005E]))|[^\\u005B\\u005D]|((\\\\[nrt\\\\|.?*+(){}\\u002D\\[\\u005D\\u005E])))+\\])|(\\.)";
    private Pattern validAllowedChars;
    private final String HTML5_WITHINTEXT_YES = " abbr acronym br cite code dfn kbd q samp span strong var b em big hr i small sub sup tt del ins bdo img a font center s strike u isindex area audio bdi button canvas command datalist embed iframe input keygen label map mark math meter noscript object output progress ruby select svg textarea time video wbr ";
    private final String HTML5_WITHINTEXT_NESTED_STRICT = " script iframe noscript textarea ";
    private final String HTML5_WITHINTEXT_NESTED = " iframe noscript textarea ";
    private final String HTML5_TRANSATTR_STRICT = " abbr alt download label placeholder srcdoc style title lang ";
    private final String HTML5_TRANSATTR_PRACTICAL = " abbr alt download label placeholder title ";
    private static final int FP_TRANSLATE = 0;
    private static final int FP_DIRECTIONALITY = 1;
    private static final int FP_WITHINTEXT = 2;
    private static final int FP_TERMINOLOGY = 3;
    private static final int FP_LOCNOTE = 4;
    private static final int FP_PRESERVEWS = 5;
    private static final int FP_LANGINFO = 6;
    private static final int FP_DOMAIN = 7;
    private static final int FP_EXTERNALRES = 8;
    private static final int FP_LOCFILTER = 9;
    private static final int FP_LQISSUE = 10;
    private static final int FP_STORAGESIZE = 11;
    private static final int FP_ALLOWEDCHARS = 12;
    private static final int FP_SUBFILTER = 13;
    private static final int FP_TARGETPOINTER = 14;
    private static final int FP_ANNOTATORSREF = 15;
    private static final int FP_MTCONFIDENCE = 16;
    private static final int FP_TEXTANALYSIS = 17;
    private static final int FP_LQRATING = 18;
    private static final int FP_PROVENANCE = 19;
    private static final int FP_TERMINOLOGY_DATA = 0;
    private static final int FP_LOCNOTE_DATA = 1;
    private static final int FP_LANGINFO_DATA = 2;
    private static final int FP_TARGETPOINTER_DATA = 3;
    private static final int FP_IDVALUE_DATA = 4;
    private static final int FP_DOMAIN_DATA = 5;
    private static final int FP_EXTERNALRES_DATA = 6;
    private static final int FP_LOCFILTER_DATA = 7;
    private static final int FP_LQISSUE_DATA = 8;
    private static final int FP_STORAGESIZE_DATA = 9;
    private static final int FP_ALLOWEDCHARS_DATA = 10;
    private static final int FP_SUBFILTER_DATA = 11;
    private static final int FP_ANNOTATORSREF_DATA = 12;
    private static final int FP_MTCONFIDENCE_DATA = 13;
    private static final int FP_TEXTANALYSIS_DATA = 14;
    private static final int FP_LQRATING_DATA = 15;
    private static final int FP_PROVENANCE_DATA = 16;
    private static final int INFOTYPE_TEXT = 0;
    private static final int INFOTYPE_REF = 1;
    private static final int INFOTYPE_POINTER = 2;
    private static final int INFOTYPE_REFPOINTER = 3;
    private final boolean isHTML5;
    private DocumentBuilderFactory xmlFactory;
    private Document doc;
    private URI docURI;
    private XPath xpath;
    private boolean defaultIdsDone;
    private NSContextManager nsContext;
    private VariableResolver varResolver;
    private XPathFactory xpFact;
    private ArrayList<ITSRule> rules;
    private Node node;
    private boolean startTraversal;
    private Stack<ITSTrace> trace;
    private boolean backTracking;
    private boolean translatableAttributeRuleTriggered;
    private boolean targetPointerRuleTriggered;
    private String version;
    private IdGenerator idGen;
    private IdGenerator idProvGen;
    private String docEncoding;
    private boolean strictModeDone = false;
    private boolean strictMode = false;
    private String html5TransAttr = " abbr alt download label placeholder title ";
    private String html5WithinText = " iframe noscript textarea ";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ITSEngine(Document doc, URI docURI) {
        this(doc, docURI, false, null);
    }

    public ITSEngine(Document doc, URI docURI, String docEncoding, boolean isHTML5, Map<String, String> map) {
        this(doc, docURI, isHTML5, map);
        this.docEncoding = docEncoding;
    }

    public ITSEngine(Document doc, URI docURI, boolean isHTML5, Map<String, String> map) {
        this.doc = doc;
        this.docURI = docURI;
        this.isHTML5 = isHTML5;
        this.node = null;
        this.rules = new ArrayList();
        this.nsContext = new NSContextManager();
        this.nsContext.addNamespace("its", "http://www.w3.org/2005/11/its");
        this.nsContext.addNamespace("itsx", "http://www.w3.org/2008/12/its-extensions");
        if (isHTML5) {
            this.nsContext.addNamespace("h", "http://www.w3.org/1999/xhtml");
        }
        this.varResolver = new VariableResolver();
        if (!Util.isEmpty(map)) {
            for (String name : map.keySet()) {
                this.varResolver.add(new QName(name), map.get(name), true);
            }
        }
        this.xpFact = Util.createXPathFactory();
        this.xpath = this.xpFact.newXPath();
        this.xpath.setNamespaceContext(this.nsContext);
        this.xpath.setXPathVariableResolver(this.varResolver);
        this.defaultIdsDone = false;
        this.idGen = null;
        this.idProvGen = null;
    }

    public void setVariables(Map<String, String> map) {
    }

    public boolean getTranslatableAttributeRuleTriggered() {
        return this.translatableAttributeRuleTriggered;
    }

    public boolean getTargetPointerRuleTriggered() {
        return this.targetPointerRuleTriggered;
    }

    public XPath getXPath() {
        return this.xpath;
    }

    private void ensureDocumentBuilderFactoryExists() {
        if (this.xmlFactory == null) {
            this.xmlFactory = DocumentBuilderFactory.newInstance();
            this.xmlFactory.setNamespaceAware(true);
            this.xmlFactory.setValidating(false);
            this.xmlFactory.setExpandEntityReferences(false);
        }
    }

    private Document parseXMLDocument(String uriString) {
        this.ensureDocumentBuilderFactoryExists();
        try {
            return this.xmlFactory.newDocumentBuilder().parse(uriString);
        }
        catch (Throwable e) {
            throw new OkapiException("Error parsing an XML document.\n" + e.getMessage(), e);
        }
    }

    private Document parseXMLDocument(InputSource is) {
        this.ensureDocumentBuilderFactoryExists();
        try {
            return this.xmlFactory.newDocumentBuilder().parse(is);
        }
        catch (Throwable e) {
            throw new OkapiException("Error parsing an XML document.\n" + e.getMessage(), e);
        }
    }

    private Document parseHTMLDocument(String uriString) {
        HtmlDocumentBuilder docBuilder = new HtmlDocumentBuilder();
        try {
            return docBuilder.parse(uriString);
        }
        catch (Throwable e) {
            throw new OkapiException("Error parsing an HTML document.\n" + e.getMessage(), e);
        }
    }

    @Override
    public void addExternalRules(URI docURI) {
        try {
            Document rulesDoc = this.parseXMLDocument(docURI.toString());
            this.addExternalRules(rulesDoc, docURI);
        }
        catch (Throwable e) {
            throw new OkapiException(e);
        }
    }

    @Override
    public void addExternalRules(Document rulesDoc, URI docURI) {
        this.compileRules(rulesDoc, docURI, false);
    }

    private void compileRulesInScripts(Document hostDoc, URI docURI, boolean isInternal) {
        try {
            XPathExpression expr = this.xpath.compile("//h:script[@type='application/its+xml']");
            NodeList nl = (NodeList)expr.evaluate(hostDoc, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                Element elem = (Element)nl.item(i);
                String content = elem.getTextContent();
                if (content == null) continue;
                if ((content = content.trim()).startsWith("<!--")) {
                    content = content.substring(4);
                }
                if (content.endsWith("-->")) {
                    content = content.substring(0, content.length() - 3);
                }
                content = content.trim();
                InputSource is = new InputSource(new ByteArrayInputStream(this.docEncoding != null ? content.getBytes(this.docEncoding) : content.getBytes()));
                Document scriptDoc = this.parseXMLDocument(is);
                this.compileRules(scriptDoc, docURI, isInternal);
            }
        }
        catch (Throwable e) {
            throw new ITSException("Error processing ITS markup in HTML script.\n" + e.getMessage());
        }
    }

    private void compileRules(Document rulesDoc, URI docURI, boolean isInternal) {
        try {
            XPathExpression expr = this.xpath.compile("//*[@selector]//namespace::*");
            NodeList nl = (NodeList)expr.evaluate(rulesDoc, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                String prefix = nl.item(i).getLocalName();
                if ("xml".equals(prefix)) continue;
                String uri = nl.item(i).getNodeValue();
                this.nsContext.addNamespace(prefix, uri);
            }
            expr = this.xpath.compile("//its:rules");
            nl = (NodeList)expr.evaluate(rulesDoc, XPathConstants.NODESET);
            if (nl.getLength() == 0) {
                return;
            }
            for (int i = 0; i < nl.getLength(); ++i) {
                NodeList nl2;
                String href;
                String qlang;
                Element rulesElem = (Element)nl.item(i);
                String prev = this.version;
                this.version = rulesElem.getAttributeNS(null, "version");
                if (!this.version.equals(ITS_VERSION1) && !this.version.equals(ITS_VERSION2)) {
                    throw new ITSException(String.format("Invalid or missing ITS version (\"%s\")", this.version));
                }
                if (prev != null && !prev.equals("0") && !this.version.equals(prev)) {
                    throw new ITSException(String.format("Two different versions of ITS declared in the same document: '%s' and '%s'.", prev, this.version));
                }
                if (!this.strictModeDone) {
                    this.strictMode = rulesElem.getAttributeNS("http://www.w3.org/2008/12/its-extensions", "strict").equals("yes");
                    if (this.strictMode) {
                        this.html5TransAttr = " abbr alt download label placeholder srcdoc style title lang ";
                        this.html5WithinText = " script iframe noscript textarea ";
                    }
                    this.strictModeDone = true;
                }
                if (!Util.isEmpty(qlang = rulesElem.getAttributeNS(null, "queryLanguage"))) {
                    if (this.isHTML5) {
                        qlang = qlang.toLowerCase();
                    }
                    if (!qlang.startsWith("xpath")) {
                        throw new ITSException(String.format("ITS queryLanguage is '%s', but this implementation supports only XPath.", qlang));
                    }
                    if (!qlang.equals("xpath")) {
                        this.logger.warn("ITS queryLanguage is '{}', but this implementation supports only XPath 1.0: You may or may not run into problems.'", (Object)qlang);
                    }
                }
                if ((href = rulesElem.getAttributeNS("http://www.w3.org/1999/xlink", "href")).length() > 0) {
                    int n = href.lastIndexOf(35);
                    if (n > -1) {
                        href = href.substring(0, n);
                    }
                    String baseFolder = "";
                    if (docURI != null) {
                        baseFolder = FileUtil.getPartBeforeFile(docURI);
                    }
                    for (Node node = rulesElem; node != null; node = node.getParentNode()) {
                        String xmlBase;
                        if (node.getNodeType() != 1 || (xmlBase = node.getAttribute("xml:base")).length() <= 0) continue;
                        if (xmlBase.endsWith("/")) {
                            xmlBase = xmlBase.substring(0, xmlBase.length() - 1);
                        }
                        baseFolder = !baseFolder.startsWith("/") ? xmlBase + "/" + baseFolder : xmlBase + baseFolder;
                    }
                    if (baseFolder.length() > 0) {
                        if (baseFolder.endsWith("/")) {
                            baseFolder = baseFolder.substring(0, baseFolder.length() - 1);
                        }
                        href = !href.startsWith("/") ? baseFolder + "/" + href : baseFolder + href;
                    }
                    URI linkedDoc = new URI(href);
                    this.loadLinkedRules(linkedDoc, isInternal);
                }
                if ((nl2 = (NodeList)(expr = this.xpath.compile("//its:*|//itsx:*")).evaluate(rulesElem, XPathConstants.NODESET)).getLength() != 0) {
                    for (int j = 0; j < nl2.getLength(); ++j) {
                        Element ruleElem = (Element)nl2.item(j);
                        String locName = ruleElem.getLocalName();
                        if ("translateRule".equals(locName)) {
                            this.compileTranslateRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("withinTextRule".equals(locName)) {
                            this.compileWithinTextRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("langRule".equals(locName)) {
                            this.compileLangRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("dirRule".equals(locName)) {
                            this.compileDirRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("locNoteRule".equals(locName)) {
                            this.compileLocNoteRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("termRule".equals(locName)) {
                            this.compileTermRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("idValueRule".equals(locName)) {
                            this.compileIdValueRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("domainRule".equals(locName)) {
                            this.compileDomainRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("targetPointerRule".equals(locName)) {
                            this.compileTargetPointerRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("localeFilterRule".equals(locName)) {
                            this.compileLocaleFilterRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("preserveSpaceRule".equals(locName)) {
                            this.compilePrserveSpaceRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("externalResourceRefRule".equals(locName)) {
                            this.compileExternalResourceRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("locQualityIssueRule".equals(locName)) {
                            this.compileLocQualityIssueRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("provRule".equals(locName)) {
                            this.compileProvRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("storageSizeRule".equals(locName)) {
                            this.compileStorageSizeRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("allowedCharactersRule".equals(locName)) {
                            this.compileAllowedCharactersRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("mtConfidenceRule".equals(locName)) {
                            this.compileMtConfidenceRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("textAnalysisRule".equals(locName)) {
                            this.compileTextAnalysisRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("subFilterRule".equals(locName)) {
                            this.compileSubFilterRule(ruleElem, isInternal);
                            continue;
                        }
                        if ("param".equals(locName)) {
                            this.processParam(ruleElem);
                            continue;
                        }
                        if ("rules".equals(locName) || "span".equals(locName) || "locQualityIssues".equals(locName) || "locQualityIssue".equals(locName) || "locNote".equals(locName) || "provenanceRecords".equals(locName) || "provenanceRecord".equals(locName)) continue;
                        this.logger.warn("Unknown element '{}'.", (Object)ruleElem.getNodeName());
                    }
                    continue;
                }
                break;
            }
        }
        catch (XPathExpressionException e) {
            throw new OkapiException(e);
        }
        catch (URISyntaxException e) {
            throw new OkapiException(e);
        }
    }

    private void processParam(Element elem) {
        String value = elem.getTextContent();
        String name = elem.getAttribute("name");
        if (name.isEmpty()) {
            throw new ITSException("Invalid value for 'name' in param.");
        }
        this.varResolver.add(new QName(name), value, false);
    }

    private void loadLinkedRules(URI docURI, boolean isInternal) {
        try {
            Document rulesDoc = this.parseXMLDocument(docURI.toString());
            this.compileRules(rulesDoc, docURI, isInternal);
        }
        catch (Throwable e) {
            throw new OkapiException(e);
        }
    }

    private void compileTranslateRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(1L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("translate");
        if ("yes".equals(value)) {
            rule.flag = true;
        } else if ("no".equals(value)) {
            rule.flag = false;
        } else {
            throw new ITSException("Invalid value for 'translate'.");
        }
        value = elem.getAttributeNS("http://www.w3.org/2008/12/its-extensions", "idValue");
        if (!value.isEmpty()) {
            if (this.version.equals(ITS_VERSION2)) {
                this.logger.warn("This document uses the {}:idValue extension instead of the ITS 2.0 Id Value data category.", (Object)"http://www.w3.org/2008/12/its-extensions");
            }
            rule.idValue = value;
        }
        if (!(value = elem.getAttributeNS("http://www.w3.org/2008/12/its-extensions", "whiteSpaces")).isEmpty()) {
            if (this.version.equals(ITS_VERSION2)) {
                this.logger.warn("This document uses the {}:whiteSpaces extension instead of the ITS 2.0 Preserve Space data category.", (Object)"http://www.w3.org/2008/12/its-extensions");
            }
            if ("preserve".equals(value)) {
                rule.preserveWS = true;
            } else if ("default".equals(value)) {
                rule.preserveWS = false;
            } else {
                throw new ITSException("Invalid value for 'whiteSpaces'.");
            }
        }
        this.rules.add(rule);
    }

    private void compileDirRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(8L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("dir");
        if ("ltr".equals(value)) {
            rule.value = 0;
        } else if ("rtl".equals(value)) {
            rule.value = 1;
        } else if ("lro".equals(value)) {
            rule.value = 2;
        } else if ("rlo".equals(value)) {
            rule.value = 3;
        } else {
            throw new ITSException("Invalid value for 'dir'.");
        }
        this.rules.add(rule);
    }

    private void compileWithinTextRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(32L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("withinText");
        if ("yes".equals(value)) {
            rule.value = 1;
        } else if ("no".equals(value)) {
            rule.value = 0;
        } else if ("nested".equals(value)) {
            rule.value = 2;
        } else {
            throw new ITSException("Invalid value for 'withinText'.");
        }
        this.rules.add(rule);
    }

    private void compileIdValueRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(4096L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("idValue");
        if (value.isEmpty()) {
            throw new ITSException("Invalid value for 'idValue'.");
        }
        rule.idValue = value;
        this.rules.add(rule);
    }

    private void compileDomainRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(64L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String pointer = elem.getAttribute("domainPointer");
        if (pointer.isEmpty()) {
            throw new ITSException("Invalid value for 'domainPointer'.");
        }
        rule.info = pointer;
        rule.map = this.fromStringToMap(elem.getAttribute("domainMapping"));
        this.rules.add(rule);
    }

    private void compileExternalResourceRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(1024L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String pointer = elem.getAttribute("externalResourceRefPointer");
        if (pointer.isEmpty()) {
            throw new ITSException("Invalid value for 'externalResourceRefPointer'.");
        }
        rule.info = pointer;
        this.rules.add(rule);
    }

    private void compileStorageSizeRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(262144L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String[] np = this.retrieveStorageSizeData(elem, false, false);
        String storageSizeP = null;
        if (elem.hasAttribute("storageSizePointer")) {
            storageSizeP = elem.getAttribute("storageSizePointer");
        }
        String storageEncodingP = null;
        if (elem.hasAttribute("storageEncodingPointer")) {
            storageEncodingP = elem.getAttribute("storageEncodingPointer");
        }
        if (Util.isEmpty(np[0]) && Util.isEmpty(storageSizeP)) {
            throw new ITSException("You must have at least an attribute storageSize or storageSizePointer.");
        }
        rule.annotations = new GenericAnnotations();
        GenericAnnotation ann = rule.annotations.add("its-storagesize");
        if (!Util.isEmpty(np[0])) {
            if (!Util.isEmpty(storageSizeP)) {
                throw new ITSException("Cannot have both storageSize and storageSizePointer.");
            }
            ann.setString("storagesizeSize", np[0]);
        } else {
            ann.setString("storagesizeSize", PTRFLAG + storageSizeP);
        }
        if (!Util.isEmpty(storageEncodingP)) {
            ann.setString("storagesizeEncoding", PTRFLAG + storageEncodingP);
        } else {
            ann.setString("storagesizeEncoding", np[1]);
        }
        ann.setString("storagesizeLinebreak", np[2]);
        this.rules.add(rule);
    }

    private void compileAllowedCharactersRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(131072L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        rule.info = this.retrieveAllowedCharsData(elem, false, false);
        String allowedCharsP = null;
        if (elem.hasAttribute("allowedCharactersPointer")) {
            allowedCharsP = elem.getAttribute("allowedCharactersPointer");
        }
        if (Util.isEmpty(rule.info) && Util.isEmpty(allowedCharsP)) {
            throw new ITSException("You must have at least an attribute allowedCharacters or allowedCharactersPointer.");
        }
        if (!Util.isEmpty(rule.info)) {
            if (!Util.isEmpty(allowedCharsP)) {
                throw new ITSException("Cannot have both allowedCharacters and allowedCharactersPointer.");
            }
        } else {
            rule.info = allowedCharsP;
            rule.infoType = 2;
        }
        this.rules.add(rule);
    }

    private void compileMtConfidenceRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(65536L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        rule.info = this.retrieveMtconfidence(elem, false, false);
        if (rule.info == null) {
            return;
        }
        rule.infoType = 0;
        this.rules.add(rule);
    }

    private void compileLocQualityIssueRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(16384L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String[] np = this.retrieveLocQualityIssueData(elem, false, false);
        String issuesRefP = null;
        if (elem.hasAttribute("locQualityIssuesRefPointer")) {
            issuesRefP = elem.getAttribute("locQualityIssuesRefPointer");
        }
        String typeP = null;
        if (elem.hasAttribute("locQualityIssueTypePointer")) {
            typeP = elem.getAttribute("locQualityIssueTypePointer");
        }
        String commentP = null;
        if (elem.hasAttribute("locQualityIssueCommentPointer")) {
            commentP = elem.getAttribute("locQualityIssueCommentPointer");
        }
        if (Util.isEmpty(np[0]) && Util.isEmpty(issuesRefP) && Util.isEmpty(np[1]) && Util.isEmpty(typeP) && Util.isEmpty(np[2]) && Util.isEmpty(commentP)) {
            throw new ITSException("You must have at least a type or a comment or isses reference ainformation defined.");
        }
        rule.annotations = this.createLQIAnnotationSet();
        GenericAnnotation ann = this.addIssueItem(rule.annotations);
        if (!Util.isEmpty(np[0])) {
            if (!Util.isEmpty(issuesRefP)) {
                throw new ITSException("Cannot have both locQualityIssuesRef and locQualityIssuesRefPointer.");
            }
            rule.info = np[0];
            rule.infoType = 1;
        } else if (issuesRefP != null) {
            rule.info = issuesRefP;
            rule.infoType = 3;
        }
        if (!Util.isEmpty(np[1])) {
            if (!Util.isEmpty(typeP)) {
                throw new ITSException("Cannot have both locQualityIssueType and locQualityIssueTypePointer.");
            }
            ann.setString("lqiType", np[1]);
        } else if (typeP != null) {
            ann.setString("lqiType", PTRFLAG + typeP);
        }
        if (!Util.isEmpty(np[2])) {
            if (!Util.isEmpty(commentP)) {
                throw new ITSException("Cannot have both locQualityIssueComment and locQualityIssueCommentPointer.");
            }
            ann.setString("lqiComment", np[2]);
        } else if (commentP != null) {
            ann.setString("lqiComment", PTRFLAG + commentP);
        }
        String severityP = null;
        if (elem.hasAttribute("locQualityIssueSeverityPointer")) {
            severityP = elem.getAttribute("locQualityIssueSeverityPointer");
        }
        if (!Util.isEmpty(np[3])) {
            if (!Util.isEmpty(severityP)) {
                throw new ITSException("Cannot have both locQualityIssueSeverity and locQualityIssueSeverityPointer.");
            }
            ann.setString("lqiSeverity", np[3]);
        } else if (severityP != null) {
            ann.setString("lqiSeverity", PTRFLAG + severityP);
        }
        String profileRefP = null;
        if (elem.hasAttribute("locQualityIssueProfileRefPointer")) {
            profileRefP = elem.getAttribute("locQualityIssueProfileRefPointer");
        }
        if (!Util.isEmpty(np[4])) {
            if (!Util.isEmpty(profileRefP)) {
                throw new ITSException("Cannot have both locQualityIssueProfileRef and locQualityIssueProfileRefPointer.");
            }
            ann.setString("lqiProfileRef", np[4]);
        } else if (profileRefP != null) {
            ann.setString("lqiProfileRef", PTRFLAG + profileRefP);
        }
        String enabledP = null;
        if (elem.hasAttribute("locQualityIssueEnabledPointer")) {
            profileRefP = elem.getAttribute("locQualityIssueEnabledPointer");
            ann.setString("lqiEnabled", PTRFLAG + enabledP);
        } else {
            ann.setString("lqiEnabled", np[5]);
        }
        this.rules.add(rule);
    }

    private void compileProvRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(512L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String pointer = elem.getAttribute("provenanceRecordsRefPointer");
        if (Util.isEmpty(pointer)) {
            throw new ITSException("You must have a provenanceRecordsRefPointer attribute defined.");
        }
        rule.info = pointer;
        rule.infoType = 3;
        this.rules.add(rule);
    }

    private GenericAnnotations createLQIAnnotationSet() {
        GenericAnnotations anns = new GenericAnnotations();
        if (this.idGen == null) {
            this.idGen = new IdGenerator(null, "lqi");
        }
        anns.setData(this.idGen.createId());
        return anns;
    }

    private GenericAnnotations createProvenanceAnnotationSet() {
        GenericAnnotations anns = new GenericAnnotations();
        if (this.idProvGen == null) {
            this.idProvGen = new IdGenerator(null, "prov");
        }
        anns.setData(this.idProvGen.createId());
        return anns;
    }

    private void compileTextAnalysisRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(128L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String[] np = this.retrieveTextAnalysisData(elem, false, false);
        String classRefP = null;
        if (elem.hasAttribute("taClassRefPointer")) {
            classRefP = elem.getAttribute("taClassRefPointer");
        }
        String sourceP = null;
        if (elem.hasAttribute("taSourcePointer")) {
            sourceP = elem.getAttribute("taSourcePointer");
        }
        String identP = null;
        if (elem.hasAttribute("taIdentPointer")) {
            identP = elem.getAttribute("taIdentPointer");
        }
        String identRefP = null;
        if (elem.hasAttribute("taIdentRefPointer")) {
            identRefP = elem.getAttribute("taIdentRefPointer");
        }
        rule.annotations = new GenericAnnotations();
        GenericAnnotation ann = rule.annotations.add("its-ta");
        if (classRefP != null) {
            ann.setString("taClass", "@@\u0011" + classRefP);
        } else if (np[0] != null) {
            ann.setString("taClass", np[0]);
        }
        if (sourceP != null) {
            ann.setString("taSource", PTRFLAG + sourceP);
        } else if (np[1] != null) {
            ann.setString("taSource", np[1]);
        }
        if (identP != null) {
            ann.setString("taIdent", PTRFLAG + identP);
        } else if (np[2] != null) {
            ann.setString("taIdent", np[2]);
        }
        if (identRefP != null) {
            ann.setString("taIdent", "@@\u0011" + identRefP);
        } else if (np[3] != null) {
            ann.setString("taIdent", np[3]);
        }
        this.rules.add(rule);
    }

    private void compileLocaleFilterRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(256L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        rule.info = this.retrieveLocaleFilterList(elem, false, false);
        this.rules.add(rule);
    }

    private void compileSubFilterRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(524288L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        rule.info = this.retrieveSubFilter(elem, false, false);
        this.rules.add(rule);
    }

    private void compilePrserveSpaceRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(8192L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String value = elem.getAttribute("space");
        if (!"preserve".equals(value) && !"default".equals(value)) {
            throw new ITSException("Invalid value for 'space'.");
        }
        rule.preserveWS = "preserve".equals(value);
        this.rules.add(rule);
    }

    private void compileTargetPointerRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(2048L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String pointer = elem.getAttribute("targetPointer");
        if (pointer.isEmpty()) {
            throw new ITSException("Invalid value for 'targetPointer'.");
        }
        rule.info = this.varResolver.replaceVariables(pointer);
        this.rules.add(rule);
    }

    private Map<String, String> fromStringToMap(String mapping) {
        if (mapping.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> map = null;
        if (!mapping.isEmpty()) {
            String[] pairs = mapping.split(",", 0);
            char endQuote = '\u0000';
            boolean state = false;
            for (String pair : pairs) {
                pair = pair.trim();
                StringBuilder left = new StringBuilder();
                StringBuilder right = new StringBuilder();
                StringBuilder str = left;
                block6: for (int i = 0; i < pair.length(); ++i) {
                    char ch = pair.charAt(i);
                    switch (ch) {
                        case '\"': {
                            if (!state) {
                                endQuote = ch;
                                state = true;
                                continue block6;
                            }
                            if (ch == endQuote) {
                                state = false;
                                continue block6;
                            }
                            str.append(ch);
                            continue block6;
                        }
                        case '\'': {
                            if (!state) {
                                endQuote = ch;
                                state = true;
                                continue block6;
                            }
                            if (ch == endQuote) {
                                state = false;
                                continue block6;
                            }
                            str.append(ch);
                            continue block6;
                        }
                        case ' ': {
                            if (state) {
                                str.append(' ');
                                continue block6;
                            }
                            str = right;
                            continue block6;
                        }
                        default: {
                            str.append(pair.charAt(i));
                        }
                    }
                }
                if (left.length() == 0 || right.length() == 0) {
                    throw new ITSException("Invalid pair in mapping value.");
                }
                if (map == null) {
                    map = new LinkedHashMap<String, String>();
                }
                map.put(left.toString(), right.toString());
            }
        }
        return map;
    }

    private void compileTermRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(4L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        String[] np = this.retrieveTerminologyData(elem, false, false);
        rule.flag = np[0] != null;
        this.rules.add(rule);
        if (!rule.flag) {
            return;
        }
        String infoRefP = null;
        if (elem.hasAttribute("termInfoRefPointer")) {
            infoRefP = elem.getAttribute("termInfoRefPointer");
        }
        String infoP = null;
        if (elem.hasAttribute("termInfoPointer")) {
            infoP = elem.getAttribute("termInfoPointer");
        }
        rule.annotations = new GenericAnnotations();
        GenericAnnotation ann = rule.annotations.add("its-term");
        if (infoRefP != null) {
            ann.setString("termInfo", "@@\u0011" + infoRefP);
        }
        if (infoP != null) {
            ann.setString("termInfo", PTRFLAG + infoP);
        }
        if (np[1] != null) {
            ann.setString("termInfo", np[1]);
        }
        this.rules.add(rule);
    }

    private void compileLocNoteRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(2L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        rule.flag = this.retrieveLocNoteType(elem, false, true, false);
        String value1 = null;
        NodeList list = elem.getElementsByTagNameNS("http://www.w3.org/2005/11/its", "locNote");
        if (list.getLength() > 0) {
            value1 = ITSEngine.getTextContent(list.item(0));
        }
        String value2 = elem.getAttribute("locNotePointer");
        String value3 = elem.getAttribute("locNoteRef");
        String value4 = elem.getAttribute("locNoteRefPointer");
        if (value1 != null) {
            rule.infoType = 0;
            rule.info = value1;
            if (value2.length() > 0 || value3.length() > 0 || value4.length() > 0) {
                throw new ITSException("Too many locNote attributes specified");
            }
        } else if (value2.length() > 0) {
            rule.infoType = 2;
            rule.info = value2;
            if (value3.length() > 0 || value4.length() > 0) {
                throw new ITSException("Too many locNote attributes specified");
            }
        } else if (value3.length() > 0) {
            rule.infoType = 1;
            rule.info = value3;
            if (value4.length() > 0) {
                throw new ITSException("Too many locNote attributes specified");
            }
        } else if (value4.length() > 0) {
            rule.infoType = 3;
            rule.info = value4;
        }
        this.rules.add(rule);
    }

    private void compileLangRule(Element elem, boolean isInternal) {
        ITSRule rule = new ITSRule(16L);
        rule.selector = elem.getAttribute("selector");
        rule.isInternal = isInternal;
        rule.info = elem.getAttribute("langPointer");
        if (rule.info.isEmpty()) {
            throw new ITSException("langPointer attribute missing.");
        }
        this.rules.add(rule);
    }

    @Override
    public void applyRules(long dataCategories) {
        this.translatableAttributeRuleTriggered = false;
        this.targetPointerRuleTriggered = false;
        this.version = "0";
        this.processGlobalRules(dataCategories);
        this.processLocalRules(dataCategories);
    }

    private void removeFlag(Node node) {
        if (node == null) {
            return;
        }
        node.setUserData(FLAGNAME, null, null);
        if (node.hasChildNodes()) {
            this.removeFlag(node.getFirstChild());
        }
        if (node.getNextSibling() != null) {
            this.removeFlag(node.getNextSibling());
        }
    }

    @Override
    public void disapplyRules() {
        this.removeFlag(this.doc.getDocumentElement());
        this.translatableAttributeRuleTriggered = false;
        this.targetPointerRuleTriggered = false;
    }

    @Override
    public boolean backTracking() {
        return this.backTracking;
    }

    @Override
    public Node nextNode() {
        if (this.startTraversal) {
            this.startTraversal = false;
            ITSTrace startTrace = new ITSTrace();
            this.backTracking = false;
            startTrace.translate = true;
            startTrace.isChildDone = true;
            this.trace.push(startTrace);
            this.node = this.doc.getFirstChild();
            this.trace.push(new ITSTrace(this.trace.peek(), false));
            this.updateTraceData(this.node);
            return this.node;
        }
        if (this.node != null) {
            this.backTracking = false;
            if (!this.trace.peek().isChildDone && this.node.hasChildNodes()) {
                ITSTrace tmp = new ITSTrace(this.trace.peek(), true);
                this.trace.pop();
                this.trace.push(tmp);
                this.node = this.node.getFirstChild();
                this.trace.push(new ITSTrace(this.trace.peek(), false));
            } else {
                Node tmpNode = this.node.getNextSibling();
                if (tmpNode == null) {
                    this.node = this.node.getParentNode();
                    this.trace.pop();
                    this.backTracking = true;
                } else {
                    this.node = tmpNode;
                    this.trace.pop();
                    this.trace.push(new ITSTrace(this.trace.peek(), false));
                }
            }
        }
        this.updateTraceData(this.node);
        return this.node;
    }

    private void updateTraceData(Node newNode) {
        String value;
        if (newNode == null) {
            return;
        }
        String data = (String)newNode.getUserData(FLAGNAME);
        if (data == null) {
            if (this.isHTML5) {
                this.applyHTML5Defaults(newNode);
            }
            return;
        }
        if (data.charAt(0) != '?') {
            boolean bl = this.trace.peek().translate = data.charAt(0) == 'y';
        }
        if (!(value = this.getFlagData(data, 4)).isEmpty()) {
            this.trace.peek().idValue = value;
        }
        if (data.charAt(7) != '?') {
            this.trace.peek().domains = this.getFlagData(data, 5);
        }
        if (data.charAt(8) != '?') {
            this.trace.peek().externalRes = this.getFlagData(data, 6);
        }
        if (data.charAt(9) != '?') {
            this.trace.peek().localeFilter = this.getFlagData(data, 7);
        }
        if (data.charAt(10) == 'y') {
            this.trace.peek().lqIssues = new GenericAnnotations(this.getFlagData(data, 8));
        }
        if (data.charAt(19) == 'y') {
            this.trace.peek().prov = new GenericAnnotations(this.getFlagData(data, 16));
        }
        if (data.charAt(17) == 'y') {
            this.trace.peek().ta = new GenericAnnotations(this.getFlagData(data, 14));
        }
        if (data.charAt(18) == 'y') {
            this.trace.peek().lqRating = new GenericAnnotations(this.getFlagData(data, 15));
        }
        if (data.charAt(3) == 'y') {
            this.trace.peek().termino = new GenericAnnotations(this.getFlagData(data, 0));
        }
        if (data.charAt(11) != '?') {
            this.trace.peek().storageSize = new GenericAnnotations(this.getFlagData(data, 9));
        }
        if (data.charAt(16) != '?') {
            value = this.getFlagData(data, 13);
            this.trace.peek().mtConfidence = Double.parseDouble(value);
        }
        if (data.charAt(12) != '?') {
            this.trace.peek().allowedChars = this.getFlagData(data, 10);
        }
        if (data.charAt(14) != '?') {
            this.trace.peek().targetPointer = this.getFlagData(data, 3);
        }
        if (data.charAt(1) != '?') {
            switch (data.charAt(1)) {
                case '0': {
                    this.trace.peek().dir = 0;
                    break;
                }
                case '1': {
                    this.trace.peek().dir = 1;
                    break;
                }
                case '2': {
                    this.trace.peek().dir = 2;
                    break;
                }
                case '3': {
                    this.trace.peek().dir = 2;
                }
            }
        }
        if (data.charAt(2) == '?') {
            if (this.isHTML5) {
                this.applyHTML5Defaults(newNode);
            }
        } else {
            switch (data.charAt(2)) {
                case '0': {
                    this.trace.peek().withinText = 0;
                    break;
                }
                case '1': {
                    this.trace.peek().withinText = 1;
                    break;
                }
                case '2': {
                    this.trace.peek().withinText = 2;
                }
            }
        }
        if (data.charAt(4) != '?') {
            this.trace.peek().locNote = this.getFlagData(data, 1);
            String string = this.trace.peek().locNoteType = data.charAt(4) == 'a' ? "alert" : "description";
        }
        if (data.charAt(5) != '?') {
            boolean bl = this.trace.peek().preserveWS = data.charAt(5) == 'y';
        }
        if (data.charAt(6) != '?') {
            this.trace.peek().language = this.getFlagData(data, 2);
        }
        if (data.charAt(13) != '?') {
            this.trace.peek().subFilter = this.getFlagData(data, 11);
        }
        if (data.charAt(15) != '?') {
            this.trace.peek().annotatorsRef = ITSContent.updateAnnotatorsRef(this.trace.peek().annotatorsRef, this.getFlagData(data, 12));
        }
    }

    private void applyHTML5Defaults(Node newNode) {
        if (newNode.getNodeType() == 1) {
            String search = " " + newNode.getNodeName().toLowerCase() + " ";
            if (" abbr acronym br cite code dfn kbd q samp span strong var b em big hr i small sub sup tt del ins bdo img a font center s strike u isindex area audio bdi button canvas command datalist embed iframe input keygen label map mark math meter noscript object output progress ruby select svg textarea time video wbr ".indexOf(search) != -1) {
                this.trace.peek().withinText = 1;
            } else if (this.html5WithinText.indexOf(search) != -1) {
                this.trace.peek().withinText = 2;
            }
        }
    }

    @Override
    public void startTraversal() {
        this.node = null;
        this.trace = new Stack();
        this.startTraversal = true;
    }

    private void clearInternalGlobalRules() {
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!this.rules.get((int)i).isInternal) continue;
            this.rules.remove(i);
            --i;
        }
    }

    private void processGlobalRules(long dataCategories) {
        try {
            this.clearInternalGlobalRules();
            if (this.isHTML5) {
                this.compileRulesInScripts(this.doc, this.docURI, true);
            } else {
                this.compileRules(this.doc, this.docURI, true);
            }
            for (ITSRule rule : this.rules) {
                if ((dataCategories & rule.ruleType) == 0L) continue;
                XPathExpression expr = this.xpath.compile(rule.selector);
                NodeList NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (int i = 0; i < NL.getLength(); ++i) {
                    String oriRef;
                    String value;
                    String data1;
                    GenericAnnotation ann;
                    GenericAnnotations anns;
                    if (rule.ruleType == 1L) {
                        this.setFlag(NL.item(i), 0, rule.flag ? (char)'y' : 'n', true);
                        if (NL.item(i).getNodeType() == 2 && rule.flag) {
                            this.translatableAttributeRuleTriggered = true;
                        }
                        if (rule.idValue != null) {
                            this.setFlag(NL.item(i), 4, this.resolveExpressionAsString(NL.item(i), rule.idValue), true);
                        }
                        this.setFlag(NL.item(i), 5, rule.preserveWS ? (char)'y' : '?', true);
                        continue;
                    }
                    if (rule.ruleType == 8L) {
                        this.setFlag(NL.item(i), 1, String.valueOf(rule.value).charAt(0), true);
                        continue;
                    }
                    if (rule.ruleType == 32L) {
                        this.setFlag(NL.item(i), 2, String.valueOf(rule.value).charAt(0), true);
                        continue;
                    }
                    if (rule.ruleType == 4L) {
                        if (!rule.flag) {
                            this.setFlag(NL.item(i), 3, 'n', true);
                            continue;
                        }
                        anns = rule.annotations;
                        ann = anns.getAnnotations("its-term").get(0);
                        data1 = ann.getString("termInfo");
                        if (data1 != null) {
                            if (data1.startsWith(PTRFLAG)) {
                                boolean ref = (data1 = data1.substring(PTRFLAG.length())).startsWith(REFFLAG);
                                if (ref) {
                                    data1 = data1.substring(REFFLAG.length());
                                }
                                data1 = (ref ? "REF:" : "") + this.resolvePointer(NL.item(i), data1);
                            }
                            ann.setString("termInfo", data1);
                        }
                        this.setFlag(NL.item(i), 3, 'y', true);
                        this.setFlag(NL.item(i), 0, anns.toString(), true);
                        continue;
                    }
                    if (rule.ruleType == 2L) {
                        boolean setFlag = true;
                        switch (rule.infoType) {
                            case 0: {
                                this.setFlag(NL.item(i), 1, rule.info, true);
                                break;
                            }
                            case 2: {
                                String value2 = this.resolvePointer(NL.item(i), rule.info);
                                if (value2 != null) {
                                    this.setFlag(NL.item(i), 1, value2, true);
                                    break;
                                }
                                setFlag = false;
                                break;
                            }
                            case 1: {
                                this.setFlag(NL.item(i), 1, "REF:" + rule.info, true);
                                break;
                            }
                            case 3: {
                                String value2 = this.resolvePointer(NL.item(i), rule.info);
                                if (value2 != null) {
                                    this.setFlag(NL.item(i), 1, "REF:" + value2, true);
                                    break;
                                }
                                setFlag = false;
                            }
                        }
                        if (!setFlag) continue;
                        this.setFlag(NL.item(i), 4, rule.flag ? (char)'a' : 'd', true);
                        continue;
                    }
                    if (rule.ruleType == 16L) {
                        value = this.resolvePointer(NL.item(i), rule.info);
                        if (value == null) continue;
                        this.setFlag(NL.item(i), 6, 'y', true);
                        this.setFlag(NL.item(i), 2, value, true);
                        continue;
                    }
                    if (rule.ruleType == 1024L) {
                        value = this.resolvePointer(NL.item(i), rule.info);
                        if (value == null) continue;
                        this.setFlag(NL.item(i), 8, 'y', true);
                        this.setFlag(NL.item(i), 6, value, true);
                        continue;
                    }
                    if (rule.ruleType == 256L) {
                        this.setFlag(NL.item(i), 9, 'y', true);
                        this.setFlag(NL.item(i), 7, rule.info, true);
                        continue;
                    }
                    if (rule.ruleType == 8192L) {
                        this.setFlag(NL.item(i), 5, rule.preserveWS ? (char)'y' : '?', true);
                        continue;
                    }
                    if (rule.ruleType == 4096L) {
                        if (rule.idValue == null) continue;
                        this.setFlag(NL.item(i), 4, this.resolveExpressionAsString(NL.item(i), rule.idValue), true);
                        continue;
                    }
                    if (rule.ruleType == 64L) {
                        List<String> list = this.resolveExpressionAsList(NL.item(i), rule.info);
                        if (list.isEmpty()) continue;
                        StringBuilder tmp = new StringBuilder();
                        List<String> values = null;
                        for (String item : list) {
                            values = this.fromDomainItemToValues(item, rule.map, values);
                        }
                        for (String value3 : values) {
                            if (tmp.length() > 0) {
                                tmp.append(", ");
                            }
                            tmp.append(value3);
                        }
                        this.setFlag(NL.item(i), 7, 'y', true);
                        this.setFlag(NL.item(i), 5, tmp.toString(), true);
                        continue;
                    }
                    if (rule.ruleType == 2048L) {
                        this.targetPointerRuleTriggered = true;
                        this.setFlag(NL.item(i), 14, 'y', true);
                        this.setFlag(NL.item(i), 3, rule.info, true);
                        continue;
                    }
                    if (rule.ruleType == 16384L) {
                        anns = null;
                        oriRef = data1 = rule.info;
                        if (data1 != null) {
                            if (rule.infoType == 3) {
                                oriRef = data1 = this.resolvePointer(NL.item(i), data1);
                            }
                            anns = this.fetchLocQualityStandoffData(data1, oriRef);
                        } else {
                            GenericAnnotation ann2 = rule.annotations.getAnnotations("its-lqi").get(0);
                            anns = this.createLQIAnnotationSet();
                            GenericAnnotation upd = this.addIssueItem(anns);
                            data1 = ann2.getString("lqiType");
                            if (data1 != null) {
                                if (data1.startsWith(PTRFLAG)) {
                                    data1 = this.resolvePointer(NL.item(i), data1.substring(PTRFLAG.length()));
                                }
                                upd.setString("lqiType", data1);
                            }
                            if ((data1 = ann2.getString("lqiComment")) != null) {
                                if (data1.startsWith(PTRFLAG)) {
                                    data1 = this.resolvePointer(NL.item(i), data1.substring(PTRFLAG.length()));
                                }
                                upd.setString("lqiComment", data1);
                            }
                            if ((data1 = ann2.getString("lqiSeverity")) != null) {
                                if (data1.startsWith(PTRFLAG)) {
                                    data1 = this.resolvePointer(NL.item(i), data1.substring(PTRFLAG.length()));
                                }
                                upd.setDouble("lqiSeverity", Double.parseDouble(data1));
                            }
                            if ((data1 = ann2.getString("lqiProfileRef")) != null) {
                                if (data1.startsWith(PTRFLAG)) {
                                    data1 = this.resolvePointer(NL.item(i), data1.substring(PTRFLAG.length()));
                                }
                                upd.setString("lqiProfileRef", data1);
                            }
                            if ((data1 = ann2.getString("lqiEnabled")) != null) {
                                if (data1.startsWith(PTRFLAG)) {
                                    data1 = this.resolvePointer(NL.item(i), data1.substring(PTRFLAG.length()));
                                }
                                upd.setBoolean("lqiEnabled", data1.equals("yes"));
                            }
                        }
                        this.validateLQIData(anns);
                        this.setFlag(NL.item(i), 10, 'y', true);
                        this.setFlag(NL.item(i), 8, anns.toString(), true);
                        continue;
                    }
                    if (rule.ruleType == 512L) {
                        anns = null;
                        oriRef = data1 = rule.info;
                        if (data1 != null) {
                            if (rule.infoType == 3) {
                                oriRef = data1 = this.resolvePointer(NL.item(i), data1);
                            }
                            anns = this.fetchProvenanceStandoffData(data1, oriRef);
                        } else {
                            anns = rule.annotations;
                        }
                        this.setFlag(NL.item(i), 19, 'y', true);
                        this.setFlag(NL.item(i), 16, anns.toString(), true);
                        continue;
                    }
                    if (rule.ruleType == 128L) {
                        anns = rule.annotations;
                        ann = anns.getAnnotations("its-ta").get(0);
                        data1 = ann.getString("taClass");
                        if (data1 != null) {
                            if (data1.startsWith(PTRFLAG)) {
                                boolean ref = (data1 = data1.substring(PTRFLAG.length())).startsWith(REFFLAG);
                                if (ref) {
                                    data1 = data1.substring(REFFLAG.length());
                                }
                                data1 = (ref ? "REF:" : "") + this.resolvePointer(NL.item(i), data1);
                            }
                            ann.setString("taClass", data1);
                        }
                        if ((data1 = ann.getString("taSource")) != null) {
                            if (data1.startsWith(PTRFLAG)) {
                                data1 = this.resolvePointer(NL.item(i), data1.substring(PTRFLAG.length()));
                            }
                            ann.setString("taSource", data1);
                        }
                        if ((data1 = ann.getString("taIdent")) != null) {
                            if (data1.startsWith(PTRFLAG)) {
                                boolean ref = (data1 = data1.substring(PTRFLAG.length())).startsWith(REFFLAG);
                                if (ref) {
                                    data1 = data1.substring(REFFLAG.length());
                                }
                                data1 = (ref ? "REF:" : "") + this.resolvePointer(NL.item(i), data1);
                            }
                            ann.setString("taIdent", data1);
                        }
                        this.setFlag(NL.item(i), 17, 'y', true);
                        this.setFlag(NL.item(i), 14, anns.toString(), true);
                        continue;
                    }
                    if (rule.ruleType == 131072L) {
                        data1 = rule.infoType == 2 ? this.resolvePointer(NL.item(i), rule.info) : rule.info;
                        this.setFlag(NL.item(i), 12, 'y', true);
                        this.setFlag(NL.item(i), 10, data1, true);
                        continue;
                    }
                    if (rule.ruleType == 262144L) {
                        GenericAnnotation ann3 = rule.annotations.getFirstAnnotation("its-storagesize");
                        GenericAnnotations anns2 = new GenericAnnotations();
                        GenericAnnotation upd = anns2.add("its-storagesize");
                        data1 = ann3.getString("storagesizeSize");
                        if (data1.startsWith(PTRFLAG)) {
                            data1 = this.resolvePointer(NL.item(i), data1.substring(PTRFLAG.length()));
                        }
                        upd.setInteger("storagesizeSize", Integer.parseInt(data1));
                        data1 = ann3.getString("storagesizeEncoding");
                        if (data1.startsWith(PTRFLAG)) {
                            data1 = data1.substring(PTRFLAG.length());
                            data1 = this.resolvePointer(NL.item(i), data1);
                        }
                        upd.setString("storagesizeEncoding", data1);
                        upd.setString("storagesizeLinebreak", ann3.getString("storagesizeLinebreak"));
                        this.setFlag(NL.item(i), 11, 'y', true);
                        this.setFlag(NL.item(i), 9, anns2.toString(), true);
                        continue;
                    }
                    if (rule.ruleType == 524288L) {
                        this.setFlag(NL.item(i), 13, 'y', true);
                        this.setFlag(NL.item(i), 11, rule.info, true);
                        continue;
                    }
                    if (rule.ruleType != 65536L) continue;
                    this.setFlag(NL.item(i), 16, 'y', true);
                    this.setFlag(NL.item(i), 13, rule.info, true);
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new OkapiException(e);
        }
    }

    private GenericAnnotation addIssueItem(GenericAnnotations anns) {
        GenericAnnotation ann = anns.add("its-lqi");
        ann.setBoolean("lqiEnabled", true);
        return ann;
    }

    private List<String> fromDomainItemToValues(String text, Map<String, String> map, List<String> list) {
        if (list == null) {
            list = new ArrayList<String>();
        }
        String[] parts = text.split(",", 0);
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].trim();
            if (parts[i].startsWith("'") || parts[i].startsWith("\"")) {
                parts[i] = parts[i].substring(1);
            }
            if (!parts[i].endsWith("'") && !parts[i].endsWith("\"")) continue;
            parts[i] = parts[i].substring(0, parts[i].length() - 1);
        }
        for (String part : parts) {
            if (map != null && map.containsKey(part)) {
                part = map.get(part);
            }
            if (list.contains(part)) continue;
            list.add(part);
        }
        return list;
    }

    private void processLocalRules(long dataCategories) {
        try {
            String value;
            GenericAnnotation ann;
            String[] values;
            Attr attr;
            int i;
            NodeList NL;
            XPathExpression expr;
            if ((dataCategories & 1L) > 0L) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@translate") : this.xpath.compile("//*/@its:translate|//its:span/@translate");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if ("http://www.w3.org/2005/11/its".equals(attr.getOwnerElement().getNamespaceURI()) && "translateRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    String value2 = attr.getValue();
                    if (this.isHTML5) {
                        value2 = value2.isEmpty() ? "yes" : value2.toLowerCase();
                    }
                    if (!"yes".equals(value2) && !"no".equals(value2)) {
                        throw new ITSException("Invalid value for 'translate'.");
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 0, value2.charAt(0), attr.getSpecified());
                }
            }
            if ((dataCategories & 8L) > 0L) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@dir") : this.xpath.compile("//*/@its:dir|//its:span/@dir");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if ("http://www.w3.org/2005/11/its".equals(attr.getOwnerElement().getNamespaceURI()) && "dirRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    int n = 0;
                    if ("ltr".equals(attr.getValue())) {
                        n = 0;
                    } else if ("rtl".equals(attr.getValue())) {
                        n = 1;
                    } else if ("lro".equals(attr.getValue())) {
                        n = 3;
                    } else if ("rlo".equals(attr.getValue())) {
                        n = 2;
                    } else {
                        throw new ITSException("Invalid value for 'dir'.");
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 1, String.format("%d", n).charAt(0), attr.getSpecified());
                }
            }
            if ((dataCategories & 4L) > 0L) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-term") : this.xpath.compile("//*/@its:term|//its:span/@term");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if ("http://www.w3.org/2005/11/its".equals(attr.getOwnerElement().getNamespaceURI()) && "termRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        boolean bl = qualified = !ns.equals("http://www.w3.org/2005/11/its");
                    }
                    if ((values = this.retrieveTerminologyData(attr.getOwnerElement(), qualified, this.isHTML5))[0] == null) {
                        this.setFlag((Node)attr.getOwnerElement(), 3, 'n', attr.getSpecified());
                        continue;
                    }
                    GenericAnnotations anns = new GenericAnnotations();
                    ann = anns.add("its-term");
                    if (values[1] != null) {
                        ann.setString("termInfo", values[1]);
                    }
                    if (values[2] != null) {
                        ann.setDouble("termConfidence", Double.parseDouble(values[2]));
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 3, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 0, anns.toString(), attr.getSpecified());
                }
            }
            if ((dataCategories & 2L) > 0L) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-loc-note|//*/@its-loc-note-ref") : this.xpath.compile("//*/@its:locNote|//its:span/@locNote|//*/@its:locNoteRef|//its:span/@locNoteRef");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (int i2 = 0; i2 < NL.getLength(); ++i2) {
                    attr = (Attr)NL.item(i2);
                    String localName = attr.getLocalName();
                    if ("http://www.w3.org/2005/11/its".equals(attr.getOwnerElement().getNamespaceURI()) && "locNoteRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        qualified = !ns.equals("http://www.w3.org/2005/11/its");
                    }
                    boolean alert = this.retrieveLocNoteType(attr.getOwnerElement(), qualified, false, this.isHTML5);
                    this.setFlag((Node)attr.getOwnerElement(), 4, alert ? (char)'a' : 'd', attr.getSpecified());
                    if (localName.equals("locNote") || localName.equals("its-loc-note")) {
                        this.setFlag((Node)attr.getOwnerElement(), 1, attr.getValue(), attr.getSpecified());
                        continue;
                    }
                    if (!localName.equals("locNoteRef") && !localName.equals("its-loc-note-ref")) continue;
                    this.setFlag((Node)attr.getOwnerElement(), 1, "REF:" + attr.getValue(), attr.getSpecified());
                }
            }
            if ((dataCategories & 0x10L) > 0L) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@lang|//*/@xmlU00003Alang") : this.xpath.compile("//*/@xml:lang");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    Attr xlang;
                    attr = (Attr)NL.item(i);
                    if (this.isHTML5 && attr.getNodeName().equals("lang") && (xlang = (Attr)attr.getOwnerElement().getAttributes().getNamedItem("xmlU00003Alang")) != null) {
                        if (!attr.getValue().equals(xlang.getValue())) {
                            this.logger.warn("You should not have lang and xml:lang with different values ('{}' and '{}') on the same node.", (Object)attr.getValue(), (Object)xlang.getValue());
                        }
                        attr = xlang;
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 6, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 2, attr.getValue(), attr.getSpecified());
                }
            }
            if ((dataCategories & 0x20L) > 0L && this.isVersion2()) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-within-text") : this.xpath.compile("//*/@its:withinText|//its:span/@withinText");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    char ch;
                    attr = (Attr)NL.item(i);
                    if ("http://www.w3.org/2005/11/its".equals(attr.getOwnerElement().getNamespaceURI()) && "withinTextRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    String value3 = attr.getValue();
                    if (this.isHTML5) {
                        value3 = value3.toLowerCase();
                    }
                    if ("no".equals(value3)) {
                        ch = '0';
                    } else if ("yes".equals(value3)) {
                        ch = '1';
                    } else if ("nested".equals(value3)) {
                        ch = '2';
                    } else {
                        throw new ITSException("Invalid value for 'withinText'.");
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 2, ch, attr.getSpecified());
                }
            }
            expr = this.xpath.compile("//*/@xml:space");
            NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            for (i = 0; i < NL.getLength(); ++i) {
                attr = (Attr)NL.item(i);
                String value4 = attr.getValue();
                if (!"preserve".equals(value4) && !"default".equals(value4)) {
                    throw new ITSException("Invalid value for 'xml:space'.");
                }
                this.setFlag((Node)attr.getOwnerElement(), 5, "preserve".equals(value4) ? (char)'y' : 'n', attr.getSpecified());
            }
            expr = this.isHTML5 ? this.xpath.compile("//*/@its-annotators-ref") : this.xpath.compile("//*/@its:annotatorsRef|//its:span/@annotatorsRef");
            NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            for (i = 0; i < NL.getLength(); ++i) {
                attr = (Attr)NL.item(i);
                String value5 = attr.getValue();
                Map<String, String> map = ITSContent.annotatorsRefToMap(value5);
                for (String dc : map.keySet()) {
                    this.validateDataCategoryNames(dc);
                }
                this.setFlag((Node)attr.getOwnerElement(), 15, value5 != null ? (char)'y' : '?', attr.getSpecified());
                this.setFlag((Node)attr.getOwnerElement(), 12, value5, attr.getSpecified());
            }
            if ((dataCategories & 0x100L) > 0L && this.isVersion2()) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-locale-filter-list") : this.xpath.compile("//*/@its:localeFilterList|//its:span/@localeFilterList");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if ("http://www.w3.org/2005/11/its".equals(attr.getOwnerElement().getNamespaceURI()) && "localeFilterRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        qualified = !ns.equals("http://www.w3.org/2005/11/its");
                    }
                    value = this.retrieveLocaleFilterList(attr.getOwnerElement(), qualified, this.isHTML5);
                    this.setFlag((Node)attr.getOwnerElement(), 9, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 7, value, attr.getSpecified());
                }
            }
            expr = this.xpath.compile("//*/@xml:id");
            NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            for (i = 0; i < NL.getLength(); ++i) {
                attr = (Attr)NL.item(i);
                String value6 = attr.getValue();
                if (value6 == null || value6.length() <= 0) continue;
                this.setFlag((Node)attr.getOwnerElement(), 4, value6, attr.getSpecified());
            }
            if ((dataCategories & 0x4000L) > 0L && this.isVersion2()) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-loc-quality-issue-type|//*/@its-loc-quality-issue-comment|//*/@its-loc-quality-issues-ref") : this.xpath.compile("//*/@its:locQualityIssueType|//its:span/@locQualityIssueType|//*/@its:locQualityIssueComment|//its:span/@locQualityIssueComment|//*/@its:locQualityIssuesRef|//its:span/@locQualityIssuesRef");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if ("http://www.w3.org/2005/11/its".equals(attr.getOwnerElement().getNamespaceURI()) && "locQualityIssueRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        qualified = !ns.equals("http://www.w3.org/2005/11/its");
                    }
                    values = this.retrieveLocQualityIssueData(attr.getOwnerElement(), qualified, this.isHTML5);
                    GenericAnnotations anns = null;
                    if (values[0] != null) {
                        anns = this.fetchLocQualityStandoffData(values[0], values[0]);
                    } else {
                        anns = this.createLQIAnnotationSet();
                        ann = this.addIssueItem(anns);
                        if (values[1] != null) {
                            ann.setString("lqiType", values[1]);
                        }
                        if (values[2] != null) {
                            ann.setString("lqiComment", values[2]);
                        }
                        if (values[3] != null) {
                            ann.setDouble("lqiSeverity", Double.parseDouble(values[3]));
                        }
                        if (values[4] != null) {
                            ann.setString("lqiProfileRef", values[4]);
                        }
                        if (values[5] != null) {
                            ann.setBoolean("lqiEnabled", values[5].equals("yes"));
                        }
                    }
                    this.validateLQIData(anns);
                    this.setFlag((Node)attr.getOwnerElement(), 10, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 8, anns.toString(), attr.getSpecified());
                }
            }
            if (this.isVersion2() && (dataCategories & 0x200L) > 0L) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-person|//*/@its-org|//*/@its-tool|//*/@its-person-ref|//*/@its-org-ref|//*/@its-tool-ref|//*/@its-rev-person|//*/@its-rev-org|//*/@its-rev-tool|//*/@its-rev-person-ref|//*/@its-rev-org-ref|//*/@its-rev-tool-ref|//*/@its-prov-ref|//*/@its-provenance-records-ref") : this.xpath.compile("//*/@its:person|//its:span/@person|//*/@its:personRef|//its:span/@personRef|//*/@its:org|//its:span/@org|//*/@its:orgRef|//its:span/@orgRef|//*/@its:tool|//its:span/@tool|//*/@its:toolRef|//its:span/@toolRef|//*/@its:revPerson|//its:span/@revPerson|//*/@its:revPersonRef|//its:span/@revPersonRef|//*/@its:revOrg|//its:span/@revOrg|//*/@its:revOrgRef|//its:span/@revOrgRef|//*/@its:revTool|//its:span/@revTool|//*/@its:revToolRef|//its:span/@revToolRef|//*/@its:provRef|//its:span/@provRef|//*/@its:provenanceRecordsRef|//its:span/@provenanceRecordsRef");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if ("http://www.w3.org/2005/11/its".equals(attr.getOwnerElement().getNamespaceURI()) && "provRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        qualified = !ns.equals("http://www.w3.org/2005/11/its");
                    }
                    values = this.retrieveProvenanceData(attr.getOwnerElement(), qualified, this.isHTML5);
                    GenericAnnotations anns = null;
                    if (values[0] != null) {
                        anns = this.fetchProvenanceStandoffData(values[0], values[0]);
                    } else {
                        anns = this.createProvenanceAnnotationSet();
                        ann = anns.add("its-prov");
                        if (values[1] != null) {
                            ann.setString("provPerson", values[1]);
                        }
                        if (values[2] != null) {
                            ann.setString("provOrg", values[2]);
                        }
                        if (values[3] != null) {
                            ann.setString("provTool", values[3]);
                        }
                        if (values[4] != null) {
                            ann.setString("provRevPerson", values[4]);
                        }
                        if (values[5] != null) {
                            ann.setString("provRevOrg", values[5]);
                        }
                        if (values[6] != null) {
                            ann.setString("provRevTool", values[6]);
                        }
                        if (values[7] != null) {
                            ann.setString("provRef", values[7]);
                        }
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 19, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 16, anns.toString(), attr.getSpecified());
                }
            }
            if ((dataCategories & 0x80L) > 0L && this.isVersion2()) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-ta-class-ref|//*/@its-ta-ident|//*/@its-ta-ident-ref") : this.xpath.compile("//*/@its:taClassRef|//its:span/@taClassRef|//*/@its:taIdent|//its:span/@taIdent|//*/@its:taIdentRef|//its:span/@taIdentRef");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if ("http://www.w3.org/2005/11/its".equals(attr.getOwnerElement().getNamespaceURI()) && "textAnalysisRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        qualified = !ns.equals("http://www.w3.org/2005/11/its");
                    }
                    values = this.retrieveTextAnalysisData(attr.getOwnerElement(), qualified, this.isHTML5);
                    GenericAnnotations anns = new GenericAnnotations();
                    ann = anns.add("its-ta");
                    if (values[0] != null) {
                        ann.setString("taClass", values[0]);
                    }
                    if (values[1] != null) {
                        ann.setString("taSource", values[1]);
                    }
                    if (values[2] != null) {
                        ann.setString("taIdent", values[2]);
                    }
                    if (values[3] != null) {
                        ann.setDouble("taConfidence", Double.parseDouble(values[3]));
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 17, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 14, anns.toString(), attr.getSpecified());
                }
            }
            if ((dataCategories & 0x8000L) > 0L && this.isVersion2()) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-loc-quality-rating-score|//*/@its-loc-quality-rating-vote") : this.xpath.compile("//*/@its:locQualityRatingScore|//its:span/@locQualityRatingScore|//*/@its:locQualityRatingVote|//its:span/@locQualityRatingVote");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        qualified = !ns.equals("http://www.w3.org/2005/11/its");
                    }
                    values = this.retrieveLocQualityRatingData(attr.getOwnerElement(), qualified, this.isHTML5);
                    GenericAnnotations anns = new GenericAnnotations();
                    ann = anns.add("its-lqr");
                    if (values[0] != null) {
                        ann.setDouble("lqrScore", Double.parseDouble(values[0]));
                    }
                    if (values[1] != null) {
                        ann.setInteger("lqrVote", Integer.parseInt(values[1]));
                    }
                    if (values[2] != null) {
                        ann.setDouble("lqrScoreThreshold", Double.parseDouble(values[2]));
                    }
                    if (values[3] != null) {
                        ann.setInteger("lqrVoteThreshold", Integer.parseInt(values[3]));
                    }
                    if (values[4] != null) {
                        ann.setString("lqrProfileRef", values[4]);
                    }
                    this.setFlag((Node)attr.getOwnerElement(), 18, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 15, anns.toString(), attr.getSpecified());
                }
            }
            if ((dataCategories & 0x20000L) > 0L && this.isVersion2()) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-allowed-characters") : this.xpath.compile("//*/@its:allowedCharacters|//its:span/@allowedCharacters");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if ("http://www.w3.org/2005/11/its".equals(attr.getOwnerElement().getNamespaceURI()) && "allowedCharactersRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        qualified = !ns.equals("http://www.w3.org/2005/11/its");
                    }
                    value = this.retrieveAllowedCharsData(attr.getOwnerElement(), qualified, this.isHTML5);
                    this.setFlag((Node)attr.getOwnerElement(), 12, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 10, value, attr.getSpecified());
                }
            }
            if ((dataCategories & 0x40000L) > 0L && this.isVersion2()) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-storage-size") : this.xpath.compile("//*/@its:storageSize|//its:span/@storageSize");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if ("http://www.w3.org/2005/11/its".equals(attr.getOwnerElement().getNamespaceURI()) && "storageSizeRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        qualified = !ns.equals("http://www.w3.org/2005/11/its");
                    }
                    values = this.retrieveStorageSizeData(attr.getOwnerElement(), qualified, this.isHTML5);
                    GenericAnnotations anns = new GenericAnnotations(new GenericAnnotation("its-storagesize", "storagesizeSize", Integer.parseInt(values[0]), "storagesizeEncoding", values[1], "storagesizeLinebreak", values[2]));
                    this.setFlag((Node)attr.getOwnerElement(), 11, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 9, anns.toString(), attr.getSpecified());
                }
            }
            if ((dataCategories & 0x10000L) > 0L && this.isVersion2()) {
                expr = this.isHTML5 ? this.xpath.compile("//*/@its-mt-confidence") : this.xpath.compile("//*/@its:mtConfidence|//its:span/@mtConfidence");
                NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
                for (i = 0; i < NL.getLength(); ++i) {
                    attr = (Attr)NL.item(i);
                    if ("http://www.w3.org/2005/11/its".equals(attr.getOwnerElement().getNamespaceURI()) && "mtConfidenceRule".equals(attr.getOwnerElement().getLocalName())) continue;
                    boolean qualified = true;
                    String ns = attr.getOwnerElement().getNamespaceURI();
                    if (!Util.isEmpty(ns)) {
                        boolean bl = qualified = !ns.equals("http://www.w3.org/2005/11/its");
                    }
                    if ((value = this.retrieveMtconfidence(attr.getOwnerElement(), qualified, this.isHTML5)) == null) continue;
                    this.setFlag((Node)attr.getOwnerElement(), 16, 'y', attr.getSpecified());
                    this.setFlag((Node)attr.getOwnerElement(), 13, value, attr.getSpecified());
                }
            }
        }
        catch (XPathExpressionException e) {
            throw new OkapiException(e);
        }
    }

    private boolean validateDouble(String value, Double minimum, Double maximum, String name) {
        try {
            Double f = Double.parseDouble(value);
            if (f < minimum || f > maximum) {
                this.logger.error("Invalid value for {}: {}. It should be between [{} and {}]", name, value, minimum, maximum);
            }
            return true;
        }
        catch (NullPointerException e) {
            this.logger.error("Not value defined for '{}'.", (Object)name);
            return false;
        }
        catch (NumberFormatException e) {
            this.logger.error("Invalid rational value for {}: {}", (Object)name, (Object)value);
            return false;
        }
    }

    private void validateLQIData(GenericAnnotations anns) {
        for (GenericAnnotation ann : anns) {
            String type;
            if (!ann.getType().equals("its-lqi") || (type = ann.getString("lqiType")) == null || !type.equals("uncategorized") || !Util.isEmpty(ann.getString("lqiComment"))) continue;
            this.logger.error("Issue of type '{}' must have a comment.", (Object)type);
        }
    }

    private void validateDataCategoryNames(String dc) {
        if (Util.isEmpty(dc) || "translate|localization-note|terminology|directionality|ruby|language-information|elements-within-text|domain|text-analysis|locale-filter|provenance|external-resource|target-pointer|id-value|preserve-space|localization-quality-issue|localization-quality-rating|mt-confidence|allowed-characters|storage-size".indexOf(dc) == -1) {
            this.logger.error("Invalid data category name: '{}'.", (Object)dc);
        }
    }

    private String retrieveLocaleFilterList(Element elem, boolean qualified, boolean useHTML5) {
        String[] data = new String[2];
        if (useHTML5) {
            data[0] = elem.getAttribute("its-locale-filter-list").trim();
            if (elem.hasAttribute("its-locale-filter-type")) {
                data[1] = elem.getAttribute("its-locale-filter-type").toLowerCase();
            }
        } else if (qualified) {
            data[0] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "localeFilterList").trim();
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "localeFilterType")) {
                data[1] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "localeFilterType");
            }
        } else {
            data[0] = elem.getAttribute("localeFilterList").trim();
            if (elem.hasAttribute("localeFilterType")) {
                data[1] = elem.getAttribute("localeFilterType");
            }
        }
        if (data[1] == null) {
            data[1] = "include";
        } else if (!data[1].equals("include") && !data[1].equals("exclude")) {
            this.logger.error("Invalid locale filter type '{}'.", (Object)data[1]);
            return "*";
        }
        if (data[1].equals("exclude")) {
            return "!" + data[0];
        }
        return data[0];
    }

    private String[] retrieveTerminologyData(Element elem, boolean qualified, boolean useHTML5) {
        String[] data = new String[3];
        if (useHTML5) {
            if (elem.hasAttribute("its-term")) {
                data[0] = elem.getAttribute("its-term").toLowerCase();
            }
            if (elem.hasAttribute("its-term-info-ref")) {
                data[1] = "REF:" + elem.getAttribute("its-term-info-ref");
            }
            if (elem.hasAttribute("its-term-confidence")) {
                data[2] = elem.getAttribute("its-term-confidence");
            }
        } else if (qualified) {
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "term")) {
                data[0] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "term");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "termInfoRef")) {
                data[1] = "REF:" + elem.getAttributeNS("http://www.w3.org/2005/11/its", "termInfoRef");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "termConfidence")) {
                data[2] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "termConfidence");
            }
        } else {
            if (elem.hasAttribute("term")) {
                data[0] = elem.getAttribute("term");
            }
            if (elem.hasAttribute("termInfoRef")) {
                data[1] = "REF:" + elem.getAttribute("termInfoRef");
            }
            if (elem.hasAttribute("termConfidence")) {
                data[2] = elem.getAttribute("termConfidence");
            }
        }
        if (data[0] != null && !data[0].equals("yes")) {
            data[0] = null;
        }
        return data;
    }

    private String retrieveSubFilter(Element elem, boolean qualified, boolean useHTML5) {
        if (useHTML5) {
            return elem.getAttribute("data-itsx-sub-filter").trim();
        }
        if (qualified) {
            return elem.getAttributeNS("http://www.w3.org/2008/12/its-extensions", "subFilter").trim();
        }
        return elem.getAttribute("subFilter").trim();
    }

    private boolean retrieveLocNoteType(Element elem, boolean qualified, boolean required, boolean useHTML5) {
        String type = useHTML5 ? elem.getAttribute("its-loc-note-type").toLowerCase() : (qualified ? elem.getAttributeNS("http://www.w3.org/2005/11/its", "locNoteType") : elem.getAttribute("locNoteType"));
        if (type.isEmpty() && required) {
            throw new ITSException(String.format("%s attribute missing.", this.isHTML5 ? "its-loc-note-type" : "locNoteType"));
        }
        if (type.equals("alert")) {
            return true;
        }
        if (!type.equals("description") && !type.isEmpty()) {
            throw new ITSException(String.format("Invalide value '%s' for localozation note type.", type));
        }
        return false;
    }

    private String retrieveAllowedCharsData(Element elem, boolean qualified, boolean useHTML5) {
        String regex = null;
        if (useHTML5) {
            if (elem.hasAttribute("its-allowed-characters")) {
                regex = elem.getAttribute("its-allowed-characters");
            }
        } else if (qualified) {
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "allowedCharacters")) {
                regex = elem.getAttributeNS("http://www.w3.org/2005/11/its", "allowedCharacters");
            }
        } else if (elem.hasAttribute("allowedCharacters")) {
            regex = elem.getAttribute("allowedCharacters");
        }
        if (regex != null) {
            if (this.validAllowedChars == null) {
                this.validAllowedChars = Pattern.compile(VALIDALLOWEDCHARS);
            }
            if (!this.validAllowedChars.matcher(regex).matches()) {
                this.logger.error("The pattern '{}' is not valid for the Allowed Characters data category.", (Object)regex);
            }
        }
        return regex;
    }

    private String retrieveMtconfidence(Element elem, boolean qualified, boolean useHTML5) {
        String value = null;
        String name = "mtConfidence";
        if (useHTML5) {
            name = "its-mt-confidence";
            if (elem.hasAttribute(name)) {
                value = elem.getAttribute(name);
            }
        } else if (qualified) {
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", name)) {
                value = elem.getAttributeNS("http://www.w3.org/2005/11/its", name);
            }
        } else if (elem.hasAttribute(name)) {
            value = elem.getAttribute(name);
        }
        if (this.validateDouble(value, 0.0, 1.0, name)) {
            return value;
        }
        return null;
    }

    private String[] retrieveStorageSizeData(Element elem, boolean qualified, boolean useHTML5) {
        String[] data = new String[3];
        if (useHTML5) {
            if (elem.hasAttribute("its-storage-size")) {
                data[0] = elem.getAttribute("its-storage-size");
            }
            if (elem.hasAttribute("its-storage-encoding")) {
                data[1] = elem.getAttribute("its-storage-encoding");
            }
            if (elem.hasAttribute("its-line-break-type")) {
                data[2] = elem.getAttribute("its-line-break-type").toLowerCase();
            }
        } else if (qualified) {
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "storageSize")) {
                data[0] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "storageSize");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "storageEncoding")) {
                data[1] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "storageEncoding");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "lineBreakType")) {
                data[2] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "lineBreakType");
            }
        } else {
            if (elem.hasAttribute("storageSize")) {
                data[0] = elem.getAttribute("storageSize");
            }
            if (elem.hasAttribute("storageEncoding")) {
                data[1] = elem.getAttribute("storageEncoding");
            }
            if (elem.hasAttribute("lineBreakType")) {
                data[2] = elem.getAttribute("lineBreakType");
            }
        }
        if (data[1] == null) {
            data[1] = "UTF-8";
        }
        if (data[2] == null) {
            data[2] = "lf";
        }
        return data;
    }

    private XPath createXPath() {
        XPath xpath = this.xpFact.newXPath();
        NSContextManager nsc = new NSContextManager();
        nsc.addNamespace("its", "http://www.w3.org/2005/11/its");
        nsc.addNamespace("h", "http://www.w3.org/1999/xhtml");
        nsc.addNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        xpath.setNamespaceContext(nsc);
        return xpath;
    }

    private String[] retrieveLocQualityIssueData(Element elem, boolean qualified, boolean useHTML5) {
        String[] data = new String[6];
        if (useHTML5) {
            if (elem.hasAttribute("its-loc-quality-issues-ref")) {
                data[0] = elem.getAttribute("its-loc-quality-issues-ref");
            }
            if (elem.hasAttribute("its-loc-quality-issue-type")) {
                data[1] = elem.getAttribute("its-loc-quality-issue-type").toLowerCase();
            }
            if (elem.hasAttribute("its-loc-quality-issue-comment")) {
                data[2] = elem.getAttribute("its-loc-quality-issue-comment");
            }
            if (elem.hasAttribute("its-loc-quality-issue-severity")) {
                data[3] = elem.getAttribute("its-loc-quality-issue-severity");
            }
            if (elem.hasAttribute("its-loc-quality-issue-profile-ref")) {
                data[4] = elem.getAttribute("its-loc-quality-issue-profile-ref");
            }
            data[5] = elem.hasAttribute("its-loc-quality-issue-enabled") ? elem.getAttribute("its-loc-quality-issue-enabled").toLowerCase() : "yes";
        } else if (qualified) {
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "locQualityIssuesRef")) {
                data[0] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "locQualityIssuesRef");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "locQualityIssueType")) {
                data[1] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "locQualityIssueType");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "locQualityIssueComment")) {
                data[2] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "locQualityIssueComment");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "locQualityIssueSeverity")) {
                data[3] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "locQualityIssueSeverity");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "locQualityIssueProfileRef")) {
                data[4] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "locQualityIssueProfileRef");
            }
            data[5] = elem.hasAttributeNS("http://www.w3.org/2005/11/its", "locQualityIssueEnabled") ? elem.getAttributeNS("http://www.w3.org/2005/11/its", "locQualityIssueEnabled") : "yes";
        } else {
            if (elem.hasAttribute("locQualityIssuesRef")) {
                data[0] = elem.getAttribute("locQualityIssuesRef");
            }
            if (elem.hasAttribute("locQualityIssueType")) {
                data[1] = elem.getAttribute("locQualityIssueType");
            }
            if (elem.hasAttribute("locQualityIssueComment")) {
                data[2] = elem.getAttribute("locQualityIssueComment");
            }
            if (elem.hasAttribute("locQualityIssueSeverity")) {
                data[3] = elem.getAttribute("locQualityIssueSeverity");
            }
            if (elem.hasAttribute("locQualityIssueProfileRef")) {
                data[4] = elem.getAttribute("locQualityIssueProfileRef");
            }
            data[5] = elem.hasAttribute("locQualityIssueEnabled") ? elem.getAttribute("locQualityIssueEnabled") : "yes";
        }
        return data;
    }

    private String[] retrieveProvenanceData(Element elem, boolean qualified, boolean useHTML5) {
        String[] data = new String[8];
        if (useHTML5) {
            if (elem.hasAttribute("its-provenance-records-ref")) {
                data[0] = elem.getAttribute("its-provenance-records-ref");
            }
            if (elem.hasAttribute("its-person")) {
                data[1] = elem.getAttribute("its-person");
            } else if (elem.hasAttribute("its-person-ref")) {
                data[1] = "REF:" + elem.getAttribute("its-person-ref");
            }
            if (elem.hasAttribute("its-org")) {
                data[2] = elem.getAttribute("its-org");
            } else if (elem.hasAttribute("its-org-ref")) {
                data[2] = "REF:" + elem.getAttribute("its-org-ref");
            }
            if (elem.hasAttribute("its-tool")) {
                data[3] = elem.getAttribute("its-tool");
            } else if (elem.hasAttribute("its-tool-ref")) {
                data[3] = "REF:" + elem.getAttribute("its-tool-ref");
            }
            if (elem.hasAttribute("its-rev-person")) {
                data[4] = elem.getAttribute("its-rev-person");
            } else if (elem.hasAttribute("its-rev-person-ref")) {
                data[4] = "REF:" + elem.getAttribute("its-rev-person-ref");
            }
            if (elem.hasAttribute("its-rev-org")) {
                data[5] = elem.getAttribute("its-rev-org");
            } else if (elem.hasAttribute("its-rev-org-ref")) {
                data[5] = "REF:" + elem.getAttribute("its-rev-org-ref");
            }
            if (elem.hasAttribute("its-rev-tool")) {
                data[6] = elem.getAttribute("its-rev-tool");
            } else if (elem.hasAttribute("its-rev-tool-ref")) {
                data[6] = "REF:" + elem.getAttribute("its-rev-tool-ref");
            }
            if (elem.hasAttribute("its-prov-ref")) {
                data[7] = elem.getAttribute("its-prov-ref");
            }
        } else if (qualified) {
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "provenanceRecordsRef")) {
                data[0] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "provenanceRecordsRef");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "person")) {
                data[1] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "person");
            } else if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "personRef")) {
                data[1] = "REF:" + elem.getAttributeNS("http://www.w3.org/2005/11/its", "personRef");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "org")) {
                data[2] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "org");
            } else if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "orgRef")) {
                data[2] = "REF:" + elem.getAttributeNS("http://www.w3.org/2005/11/its", "orgRef");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "tool")) {
                data[3] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "tool");
            } else if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "toolRef")) {
                data[3] = "REF:" + elem.getAttributeNS("http://www.w3.org/2005/11/its", "toolRef");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "revPerson")) {
                data[4] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "revPerson");
            } else if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "revPersonRef")) {
                data[4] = "REF:" + elem.getAttributeNS("http://www.w3.org/2005/11/its", "revPersonRef");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "revOrg")) {
                data[5] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "revOrg");
            } else if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "revOrgRef")) {
                data[5] = "REF:" + elem.getAttributeNS("http://www.w3.org/2005/11/its", "revOrgRef");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "revTool")) {
                data[6] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "revTool");
            } else if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "revToolRef")) {
                data[6] = "REF:" + elem.getAttributeNS("http://www.w3.org/2005/11/its", "revToolRef");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "provRef")) {
                data[7] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "provRef");
            }
        } else {
            if (elem.hasAttribute("provenanceRecordsRef")) {
                data[0] = elem.getAttribute("provenanceRecordsRef");
            }
            if (elem.hasAttribute("person")) {
                data[1] = elem.getAttribute("person");
            } else if (elem.hasAttribute("personRef")) {
                data[1] = "REF:" + elem.getAttribute("personRef");
            }
            if (elem.hasAttribute("org")) {
                data[2] = elem.getAttribute("org");
            } else if (elem.hasAttribute("orgRef")) {
                data[2] = "REF:" + elem.getAttribute("orgRef");
            }
            if (elem.hasAttribute("tool")) {
                data[3] = elem.getAttribute("tool");
            } else if (elem.hasAttribute("toolRef")) {
                data[3] = "REF:" + elem.getAttribute("toolRef");
            }
            if (elem.hasAttribute("revPerson")) {
                data[4] = elem.getAttribute("revPerson");
            } else if (elem.hasAttribute("revPersonRef")) {
                data[4] = "REF:" + elem.getAttribute("revPersonRef");
            }
            if (elem.hasAttribute("revOrg")) {
                data[5] = elem.getAttribute("revOrg");
            } else if (elem.hasAttribute("revOrgRef")) {
                data[5] = "REF:" + elem.getAttribute("revOrgRef");
            }
            if (elem.hasAttribute("revTool")) {
                data[6] = elem.getAttribute("revTool");
            } else if (elem.hasAttribute("revToolRef")) {
                data[6] = "REF:" + elem.getAttribute("revToolRef");
            }
            if (elem.hasAttribute("provRef")) {
                data[7] = elem.getAttribute("provRef");
            }
        }
        return data;
    }

    private String[] retrieveTextAnalysisData(Element elem, boolean qualified, boolean useHTML5) {
        String[] data = new String[5];
        if (useHTML5) {
            if (elem.hasAttribute("its-ta-class-ref")) {
                data[0] = "REF:" + elem.getAttribute("its-ta-class-ref");
            }
            if (elem.hasAttribute("its-ta-source")) {
                data[1] = elem.getAttribute("its-ta-source");
            }
            if (elem.hasAttribute("its-ta-ident")) {
                data[2] = elem.getAttribute("its-ta-ident");
            } else if (elem.hasAttribute("its-ta-ident-ref")) {
                data[2] = "REF:" + elem.getAttribute("its-ta-ident-ref");
            }
            if (elem.hasAttribute("its-ta-confidence")) {
                data[3] = elem.getAttribute("its-ta-confidence");
            }
        } else if (qualified) {
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "taClassRef")) {
                data[0] = "REF:" + elem.getAttributeNS("http://www.w3.org/2005/11/its", "taClassRef");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "taSource")) {
                data[1] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "taSource");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "taIdent")) {
                data[2] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "taIdent");
            } else if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "taIdentRef")) {
                data[2] = "REF:" + elem.getAttributeNS("http://www.w3.org/2005/11/its", "taIdentRef");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "taConfidence")) {
                data[3] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "taConfidence");
            }
        } else {
            if (elem.hasAttribute("taClassRef")) {
                data[0] = "REF:" + elem.getAttribute("taClassRef");
            }
            if (elem.hasAttribute("taSource")) {
                data[1] = elem.getAttribute("taSource");
            }
            if (elem.hasAttribute("taIdent")) {
                data[2] = elem.getAttribute("taIdent");
            } else if (elem.hasAttribute("taIdentRef")) {
                data[2] = "REF:" + elem.getAttribute("taIdentRef");
            }
            if (elem.hasAttribute("taConfidence")) {
                data[3] = elem.getAttribute("taConfidence");
            }
        }
        return data;
    }

    private String[] retrieveLocQualityRatingData(Element elem, boolean qualified, boolean useHTML5) {
        String[] data = new String[5];
        if (useHTML5) {
            if (elem.hasAttribute("its-loc-quality-rating-score")) {
                data[0] = elem.getAttribute("its-loc-quality-rating-score");
            }
            if (elem.hasAttribute("its-loc-quality-rating-vote")) {
                data[1] = elem.getAttribute("its-loc-quality-rating-vote");
            }
            if (elem.hasAttribute("its-loc-quality-rating-score-threshold")) {
                data[2] = elem.getAttribute("its-loc-quality-rating-score-threshold");
            }
            if (elem.hasAttribute("its-loc-quality-rating-vote-threshold")) {
                data[3] = elem.getAttribute("its-loc-quality-rating-vote-threshold");
            }
            if (elem.hasAttribute("its-loc-quality-rating-profile-ref")) {
                data[4] = elem.getAttribute("its-loc-quality-rating-profile-ref");
            }
        } else if (qualified) {
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "locQualityRatingScore")) {
                data[0] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "locQualityRatingScore");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "locQualityRatingVote")) {
                data[1] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "locQualityRatingVote");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "locQualityRatingScoreThreshold")) {
                data[2] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "locQualityRatingScoreThreshold");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "locQualityRatingVoteThreshold")) {
                data[3] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "locQualityRatingVoteThreshold");
            }
            if (elem.hasAttributeNS("http://www.w3.org/2005/11/its", "locQualityRatingProfileRef")) {
                data[4] = elem.getAttributeNS("http://www.w3.org/2005/11/its", "locQualityRatingProfileRef");
            }
        } else {
            if (elem.hasAttribute("locQualityRatingScore")) {
                data[0] = elem.getAttribute("locQualityRatingScore");
            }
            if (elem.hasAttribute("locQualityRatingVote")) {
                data[1] = elem.getAttribute("locQualityRatingVote");
            }
            if (elem.hasAttribute("locQualityRatingScoreThreshold")) {
                data[2] = elem.getAttribute("locQualityRatingScoreThreshold");
            }
            if (elem.hasAttribute("locQualityRatingVoteThreshold")) {
                data[3] = elem.getAttribute("locQualityRatingVoteThreshold");
            }
            if (elem.hasAttribute("locQualityRatingProfileRef")) {
                data[4] = elem.getAttribute("locQualityRatingProfileRef");
            }
        }
        if (data[0] != null && data[1] != null) {
            this.logger.error("Cannot have localization quality rating score and vote at the same time.");
            data[1] = null;
        }
        if (data[0] != null && data[3] != null) {
            this.logger.error("Cannot have localization quality rating score with a vote threshold.");
            data[3] = null;
        }
        if (data[1] != null && data[2] != null) {
            this.logger.error("Cannot have localization quality rating vote with a score threshold.");
            data[2] = null;
        }
        return data;
    }

    private GenericAnnotations fetchLocQualityStandoffData(String ref, String originalRef) {
        Element elem1;
        XPath issuesXPath;
        Document issuesDoc;
        GenericAnnotations anns;
        String id;
        block25: {
            if (Util.isEmpty(ref)) {
                throw new InvalidParameterException("The reference URI cannot be null or empty.");
            }
            int n = ref.lastIndexOf(35);
            id = null;
            String firstPart = null;
            if (n <= -1) {
                throw new OkapiException(String.format("URI to standoff markup does not have an id: '%s'.", ref));
            }
            id = ref.substring(n + 1);
            firstPart = ref.substring(0, n);
            boolean useHTML5 = this.isHTML5;
            Document containerDoc = null;
            XPath containerXPath = null;
            if (!Util.isEmpty(firstPart)) {
                try {
                    int p;
                    String baseFolder = "";
                    if (this.docURI != null) {
                        baseFolder = FileUtil.getPartBeforeFile(this.docURI);
                    }
                    if (baseFolder.length() > 0) {
                        if (baseFolder.endsWith("/")) {
                            baseFolder = baseFolder.substring(0, baseFolder.length() - 1);
                        }
                        ref = !ref.startsWith("/") ? baseFolder + "/" + ref : baseFolder + ref;
                    }
                    if ((p = ref.lastIndexOf(35)) > -1) {
                        ref = ref.substring(0, p);
                    }
                    useHTML5 = ref.endsWith(".html") || ref.endsWith(".htm");
                    containerDoc = useHTML5 ? this.parseHTMLDocument(ref) : this.parseXMLDocument(ref);
                    containerXPath = this.createXPath();
                }
                catch (Throwable e) {
                    throw new OkapiException(String.format("Error with URI '%s'.\n" + e.getMessage(), ref));
                }
            } else {
                containerDoc = this.doc;
                containerXPath = this.xpath;
            }
            anns = this.createLQIAnnotationSet();
            issuesDoc = null;
            issuesXPath = null;
            if (useHTML5) {
                try {
                    String tmp = String.format("//%s:script[@id='%s']", "h", id);
                    XPathExpression expr = containerXPath.compile(tmp);
                    Element scriptElem = (Element)expr.evaluate(containerDoc, XPathConstants.NODE);
                    if (scriptElem == null) {
                        this.logger.warn("Cannot find standoff script element for '{}'", (Object)id);
                        GenericAnnotation ann = this.addIssueItem(anns);
                        ann.setString("lqiIssuesRef", ref);
                        return anns;
                    }
                    String content = scriptElem.getTextContent();
                    content = content.trim();
                    issuesXPath = this.createXPath();
                    try {
                        InputSource is = new InputSource(new ByteArrayInputStream(this.docEncoding != null ? content.getBytes(this.docEncoding) : content.getBytes()));
                        issuesDoc = this.parseXMLDocument(is);
                        break block25;
                    }
                    catch (Throwable e) {
                        throw new OkapiException("Error parsing a script element.", e);
                    }
                }
                catch (XPathExpressionException e) {
                    throw new OkapiException("XPath error.", e);
                }
            }
            issuesDoc = containerDoc;
            issuesXPath = containerXPath;
        }
        try {
            String tmp = String.format("//%s:locQualityIssues[@xml:id='%s']", "its", id);
            XPathExpression expr = issuesXPath.compile(tmp);
            elem1 = (Element)expr.evaluate(issuesDoc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new OkapiException("XPath error.", e);
        }
        if (elem1 == null) {
            this.logger.warn("Cannot find standoff markup for '{}'", (Object)originalRef);
            GenericAnnotation ann = this.addIssueItem(anns);
            ann.setString("lqiIssuesRef", originalRef);
            return anns;
        }
        NodeList items = elem1.getElementsByTagNameNS("http://www.w3.org/2005/11/its", "locQualityIssue");
        for (int i = 0; i < items.getLength(); ++i) {
            Element elem2 = (Element)items.item(i);
            GenericAnnotation ann = this.addIssueItem(anns);
            ann.setString("lqiIssuesRef", originalRef);
            String[] values = this.retrieveLocQualityIssueData(elem2, false, false);
            if (values[0] != null) {
                this.logger.warn("Cannot have a standoff reference in a standoff element (reference='{}').", (Object)ref);
            }
            if (values[1] != null) {
                ann.setString("lqiType", values[1]);
            }
            if (values[2] != null) {
                ann.setString("lqiComment", values[2]);
            }
            if (values[3] != null) {
                ann.setDouble("lqiSeverity", Double.parseDouble(values[3]));
            }
            if (values[4] != null) {
                ann.setString("lqiProfileRef", values[4]);
            }
            if (values[5] == null) continue;
            ann.setBoolean("lqiEnabled", values[5].equals("yes"));
        }
        return anns;
    }

    private GenericAnnotations fetchProvenanceStandoffData(String ref, String originalRef) {
        Element elem1;
        XPath issuesXPath;
        Document issuesDoc;
        GenericAnnotations anns;
        String id;
        block27: {
            if (Util.isEmpty(ref)) {
                throw new InvalidParameterException("The reference URI cannot be null or empty.");
            }
            int n = ref.lastIndexOf(35);
            id = null;
            String firstPart = null;
            if (n <= -1) {
                throw new OkapiException(String.format("URI to standoff markup does not have an id: '%s'.", ref));
            }
            id = ref.substring(n + 1);
            firstPart = ref.substring(0, n);
            boolean useHTML5 = this.isHTML5;
            Document containerDoc = null;
            XPath containerXPath = null;
            if (!Util.isEmpty(firstPart)) {
                try {
                    int p;
                    String baseFolder = "";
                    if (this.docURI != null) {
                        baseFolder = FileUtil.getPartBeforeFile(this.docURI);
                    }
                    if (baseFolder.length() > 0) {
                        if (baseFolder.endsWith("/")) {
                            baseFolder = baseFolder.substring(0, baseFolder.length() - 1);
                        }
                        ref = !ref.startsWith("/") ? baseFolder + "/" + ref : baseFolder + ref;
                    }
                    if ((p = ref.lastIndexOf(35)) > -1) {
                        ref = ref.substring(0, p);
                    }
                    useHTML5 = ref.endsWith(".html") || ref.endsWith(".htm");
                    containerDoc = useHTML5 ? this.parseHTMLDocument(ref) : this.parseXMLDocument(ref);
                    containerXPath = this.createXPath();
                }
                catch (Throwable e) {
                    throw new OkapiException(String.format("Error with URI '%s'.\n" + e.getMessage(), ref));
                }
            } else {
                containerDoc = this.doc;
                containerXPath = this.xpath;
            }
            anns = this.createProvenanceAnnotationSet();
            issuesDoc = null;
            issuesXPath = null;
            if (useHTML5) {
                try {
                    String tmp = String.format("//%s:script[@id='%s']", "h", id);
                    XPathExpression expr = containerXPath.compile(tmp);
                    Element scriptElem = (Element)expr.evaluate(containerDoc, XPathConstants.NODE);
                    if (scriptElem == null) {
                        this.logger.warn("Cannot find standoff script element for '{}'", (Object)id);
                        GenericAnnotation ann = anns.add("its-prov");
                        ann.setString("provRecsRef", ref);
                        return anns;
                    }
                    String content = scriptElem.getTextContent();
                    content = content.trim();
                    issuesXPath = this.createXPath();
                    try {
                        InputSource is = new InputSource(new ByteArrayInputStream(this.docEncoding != null ? content.getBytes(this.docEncoding) : content.getBytes()));
                        issuesDoc = this.parseXMLDocument(is);
                        break block27;
                    }
                    catch (Throwable e) {
                        throw new OkapiException("Error parsing a script element: ." + e.getMessage(), e);
                    }
                }
                catch (XPathExpressionException e) {
                    throw new OkapiException("XPath error.", e);
                }
            }
            issuesDoc = containerDoc;
            issuesXPath = containerXPath;
        }
        try {
            String tmp = String.format("//%s:provenanceRecords[@xml:id='%s']", "its", id);
            XPathExpression expr = issuesXPath.compile(tmp);
            elem1 = (Element)expr.evaluate(issuesDoc, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new OkapiException("XPath error.", e);
        }
        if (elem1 == null) {
            this.logger.warn("Cannot find standoff markup for '{}'", (Object)originalRef);
            GenericAnnotation ann = anns.add("its-prov");
            ann.setString("provRecsRef", originalRef);
            return anns;
        }
        NodeList items = elem1.getElementsByTagNameNS("http://www.w3.org/2005/11/its", "provenanceRecord");
        for (int i = 0; i < items.getLength(); ++i) {
            Element elem2 = (Element)items.item(i);
            GenericAnnotation ann = anns.add("its-prov");
            ann.setString("provRecsRef", originalRef);
            String[] values = this.retrieveProvenanceData(elem2, false, false);
            if (values[0] != null) {
                this.logger.warn("Cannot have a standoff reference in a standoff element (reference='{}').", (Object)ref);
            }
            if (values[1] != null) {
                ann.setString("provPerson", values[1]);
            }
            if (values[2] != null) {
                ann.setString("provOrg", values[2]);
            }
            if (values[3] != null) {
                ann.setString("provTool", values[3]);
            }
            if (values[4] != null) {
                ann.setString("provRevPerson", values[4]);
            }
            if (values[5] != null) {
                ann.setString("provRevOrg", values[5]);
            }
            if (values[6] != null) {
                ann.setString("provRevTool", values[6]);
            }
            if (values[7] == null) continue;
            ann.setString("provRef", values[7]);
        }
        return anns;
    }

    private boolean isVersion2() throws XPathExpressionException {
        if (this.version.equals("0")) {
            XPathExpression expr = this.xpath.compile("//*/@its:version|//its:span/@version");
            NodeList NL = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
            if (NL == null || NL.getLength() == 0) {
                this.version = ITS_VERSION2;
            } else {
                if (NL.getLength() > 0) {
                    this.version = ((Attr)NL.item(0)).getValue();
                    if (!this.version.equals(ITS_VERSION1) && !this.version.equals(ITS_VERSION2)) {
                        throw new ITSException(String.format("Invalid or missing ITS version (\"%s\")", this.version));
                    }
                }
                if (NL.getLength() > 1) {
                    throw new ITSException("More than one ITS version is defined in this document.");
                }
            }
        }
        return this.version.equals(ITS_VERSION2);
    }

    public static String getTextContent(Node node) {
        Node tmp = node.getFirstChild();
        while (tmp != null) {
            if (tmp.getNodeType() == 3) {
                return tmp.getNodeValue();
            }
            tmp = tmp.getNextSibling();
        }
        return "";
    }

    private String resolvePointer(Node node, String pointer) {
        try {
            XPathExpression expr;
            NodeList list;
            if (pointer.contains("id(")) {
                this.markDefaultIdentifiers();
            }
            if ((list = (NodeList)(expr = this.xpath.compile(pointer)).evaluate(node, XPathConstants.NODESET)) == null || list.getLength() == 0) {
                this.logger.debug("No node match the pointer '{}'.", (Object)pointer);
                return null;
            }
            switch (list.item(0).getNodeType()) {
                case 1: {
                    return ITSEngine.getTextContent(list.item(0));
                }
                case 2: {
                    return list.item(0).getNodeValue();
                }
            }
        }
        catch (XPathExpressionException e) {
            this.logger.error("Bad XPath expression in pointer '{}:\n{}'.", (Object)pointer, (Object)e.getMessage());
        }
        return null;
    }

    private void markDefaultIdentifiers() throws XPathExpressionException {
        Element elem;
        int i;
        if (this.defaultIdsDone) {
            return;
        }
        XPathExpression expr = this.xpath.compile("//*[@xml:id]");
        NodeList list = (NodeList)expr.evaluate(this.doc, XPathConstants.NODESET);
        if (list != null) {
            for (i = 0; i < list.getLength(); ++i) {
                elem = (Element)list.item(i);
                elem.setIdAttributeNS("http://www.w3.org/XML/1998/namespace", "id", true);
            }
        }
        if (this.isHTML5 && (list = (NodeList)(expr = this.xpath.compile("//*[@xml:id]")).evaluate(this.doc, XPathConstants.NODESET)) != null) {
            for (i = 0; i < list.getLength(); ++i) {
                elem = (Element)list.item(i);
                elem.setIdAttributeNS("http://www.w3.org/1999/xhtml", "id", true);
            }
        }
        this.defaultIdsDone = true;
    }

    private String resolveExpressionAsString(Node node, String expression) {
        try {
            if (expression.contains("id(")) {
                this.markDefaultIdentifiers();
            }
            XPathExpression expr = this.xpath.compile(expression);
            return (String)expr.evaluate(node, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            return "Bad XPath expression \"" + expression + "\".";
        }
    }

    private List<String> resolveExpressionAsList(Node node, String expression) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            if (expression.contains("id(")) {
                this.markDefaultIdentifiers();
            }
            XPathExpression expr = this.xpath.compile(expression);
            NodeList nl = (NodeList)expr.evaluate(node, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                Node tmpNode = nl.item(i);
                if (tmpNode.getNodeType() == 1) {
                    list.add(tmpNode.getTextContent());
                    continue;
                }
                list.add(tmpNode.getNodeValue());
            }
        }
        catch (XPathExpressionException e) {
            list.add("Bad XPath expression \"" + expression + "\".");
        }
        return list;
    }

    private void setFlag(Node node, int position, char value, boolean override) {
        StringBuilder data = new StringBuilder();
        if (node.getUserData(FLAGNAME) == null) {
            data.append(FLAGDEFAULTDATA);
        } else {
            data.append((String)node.getUserData(FLAGNAME));
        }
        if (override || data.charAt(position) != '?') {
            data.setCharAt(position, value);
        }
        node.setUserData(FLAGNAME, data.toString(), null);
    }

    private void setFlag(Node node, int position, String value, boolean override) {
        StringBuilder data = new StringBuilder();
        if (node.getUserData(FLAGNAME) == null) {
            data.append(FLAGDEFAULTDATA);
        } else {
            data.append((String)node.getUserData(FLAGNAME));
        }
        int n1 = 0;
        int n2 = data.indexOf(FLAGSEP, 0);
        for (int i = 0; i <= position; ++i) {
            n1 = n2;
            n2 = data.indexOf(FLAGSEP, n1 + 1);
        }
        if (override || n2 > n1 + 1) {
            data.replace(n1 + 1, n2, value);
        }
        node.setUserData(FLAGNAME, data.toString(), null);
    }

    private String getFlagData(String data, int position) {
        int n1 = 0;
        int n2 = data.indexOf(FLAGSEP, 0);
        for (int i = 0; i <= position; ++i) {
            n1 = n2;
            n2 = data.indexOf(FLAGSEP, n1 + 1);
        }
        if (n2 > n1 + 1) {
            return data.substring(n1 + 1, n2);
        }
        return "";
    }

    @Override
    public boolean getTranslate(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().translate;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            if (!this.isHTML5) {
                return false;
            }
            String name = attribute.getName().toLowerCase();
            if (this.html5TransAttr.indexOf(" " + name + " ") != -1) {
                return this.trace.peek().translate;
            }
            if (name.equals("content")) {
                String nameValue = attribute.getOwnerElement().getAttribute("name");
                if (" keywords description ".indexOf(" " + nameValue.toLowerCase() + " ") != -1) {
                    return this.trace.peek().translate;
                }
                return false;
            }
            return false;
        }
        return tmp.charAt(0) == 'y';
    }

    @Override
    public String getTargetPointer(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().targetPointer;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(14) != 'y') {
            return null;
        }
        return this.getFlagData(tmp, 3);
    }

    @Override
    public String getIdValue(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().idValue;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        return this.getFlagData(tmp, 4);
    }

    @Override
    public int getDirectionality(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().dir;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return this.trace.peek().dir;
        }
        return tmp.charAt(1);
    }

    @Override
    public int getWithinText() {
        return this.trace.peek().withinText;
    }

    @Override
    public boolean getTerm(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().termino != null;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return false;
        }
        return tmp.charAt(3) == 'y';
    }

    @Override
    public String getTermInfo(Attr attribute) {
        if (attribute == null) {
            if (this.trace.peek().termino == null) {
                return null;
            }
            return this.trace.peek().termino.getAnnotations("its-term").get(0).getString("termInfo");
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(3) != 'y') {
            return null;
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 0));
        return anns.getAnnotations("its-term").get(0).getString("termInfo");
    }

    @Override
    public Double getTermConfidence(Attr attribute) {
        if (attribute == null) {
            if (this.trace.peek().termino == null) {
                return null;
            }
            return this.trace.peek().termino.getAnnotations("its-term").get(0).getDouble("termConfidence");
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(3) != 'y') {
            return null;
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 0));
        return anns.getAnnotations("its-term").get(0).getDouble("termConfidence");
    }

    public GenericAnnotations getTerminologyAnnotation(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().termino;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(3) != 'y') {
            return null;
        }
        return new GenericAnnotations(this.getFlagData(tmp, 0));
    }

    @Override
    public String getLocNote(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().locNote;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(4) == '?') {
            return null;
        }
        return this.getFlagData(tmp, 1);
    }

    @Override
    public String getLocNoteType(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().locNoteType;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(4) == '?') {
            return null;
        }
        if (tmp.charAt(4) == 'a') {
            return "alert";
        }
        return "description";
    }

    @Override
    public String getDomains(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().domains;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return this.trace.peek().domains;
        }
        if (tmp.charAt(7) != 'y') {
            return this.trace.peek().domains;
        }
        return this.getFlagData(tmp, 5);
    }

    @Override
    public boolean preserveWS(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().preserveWS;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return this.trace.peek().preserveWS;
        }
        return tmp.charAt(5) == 'y';
    }

    @Override
    public String getLanguage() {
        return this.trace.peek().language;
    }

    @Override
    public String getExternalResourceRef(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().externalRes;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(8) != 'y') {
            return null;
        }
        return this.getFlagData(tmp, 6);
    }

    @Override
    public String getLocaleFilter() {
        return this.trace.peek().localeFilter;
    }

    @Override
    public String getLocQualityIssuesRef(Attr attribute) {
        return this.getLQIValue("lqiIssuesRef", attribute, 0);
    }

    @Override
    public int getLocQualityIssueCount(Attr attribute) {
        if (attribute == null) {
            GenericAnnotations lqi = this.trace.peek().lqIssues;
            if (lqi == null) {
                return 0;
            }
            return lqi.size();
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return 0;
        }
        if (tmp.charAt(10) != 'y') {
            return 0;
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 8));
        return anns.getAnnotations("its-lqi").size();
    }

    public GenericAnnotations getLocQualityIssueAnnotations(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().lqIssues;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(10) != 'y') {
            return null;
        }
        return new GenericAnnotations(this.getFlagData(tmp, 8));
    }

    @Override
    public String getLocQualityIssueType(Attr attribute, int index) {
        return this.getLQIValue("lqiType", attribute, index);
    }

    @Override
    public String getLocQualityIssueComment(Attr attribute, int index) {
        return this.getLQIValue("lqiComment", attribute, index);
    }

    @Override
    public Double getLocQualityIssueSeverity(Attr attribute, int index) {
        if (attribute == null) {
            if (this.trace.peek().lqIssues == null) {
                return null;
            }
            return this.trace.peek().lqIssues.getAnnotations("its-lqi").get(index).getDouble("lqiSeverity");
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(10) != 'y') {
            return null;
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 8));
        return anns.getAnnotations("its-lqi").get(index).getDouble("lqiSeverity");
    }

    @Override
    public String getLocQualityIssueProfileRef(Attr attribute, int index) {
        return this.getLQIValue("lqiProfileRef", attribute, index);
    }

    @Override
    public Boolean getLocQualityIssueEnabled(Attr attribute, int index) {
        if (attribute == null) {
            if (this.trace.peek().lqIssues == null) {
                return null;
            }
            return this.trace.peek().lqIssues.getAnnotations("its-lqi").get(index).getBoolean("lqiEnabled");
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(10) != 'y') {
            return null;
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 8));
        return anns.getAnnotations("its-lqi").get(index).getBoolean("lqiEnabled");
    }

    private String getLQIValue(String fieldName, Attr attribute, int index) {
        if (attribute == null) {
            if (this.trace.peek().lqIssues == null) {
                return null;
            }
            return this.trace.peek().lqIssues.getAnnotations("its-lqi").get(index).getString(fieldName);
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(10) != 'y') {
            return null;
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 8));
        return anns.getAnnotations("its-lqi").get(index).getString(fieldName);
    }

    public GenericAnnotations getTextAnalysisAnnotation(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().ta;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(17) != 'y') {
            return null;
        }
        return new GenericAnnotations(this.getFlagData(tmp, 14));
    }

    @Override
    public String getTextAnalysisClass(Attr attribute) {
        return this.getTAValue("taClass", attribute);
    }

    @Override
    public String getTextAnalysisSource(Attr attribute) {
        return this.getTAValue("taSource", attribute);
    }

    @Override
    public String getTextAnalysisIdent(Attr attribute) {
        return this.getTAValue("taIdent", attribute);
    }

    @Override
    public Double getTextAnalysisConfidence(Attr attribute) {
        if (attribute == null) {
            if (this.trace.peek().ta == null) {
                return null;
            }
            return this.trace.peek().ta.getAnnotations("its-ta").get(0).getDouble("taConfidence");
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(17) != 'y') {
            return null;
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 14));
        return anns.getAnnotations("its-ta").get(0).getDouble("taConfidence");
    }

    private String getTAValue(String fieldName, Attr attribute) {
        if (attribute == null) {
            if (this.trace.peek().ta == null) {
                return null;
            }
            return this.trace.peek().ta.getAnnotations("its-ta").get(0).getString(fieldName);
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(17) != 'y') {
            return null;
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 14));
        return anns.getAnnotations("its-ta").get(0).getString(fieldName);
    }

    public GenericAnnotations getLocQualityRatingAnnotation() {
        return this.trace.peek().lqRating;
    }

    @Override
    public Double getLocQualityRatingScore(Attr attribute) {
        if (attribute != null) {
            return null;
        }
        if (this.trace.peek().lqRating == null) {
            return null;
        }
        return this.trace.peek().lqRating.getAnnotations("its-lqr").get(0).getDouble("lqrScore");
    }

    @Override
    public Integer getLocQualityRatingVote(Attr attribute) {
        if (attribute != null) {
            return null;
        }
        if (this.trace.peek().lqRating == null) {
            return null;
        }
        return this.trace.peek().lqRating.getAnnotations("its-lqr").get(0).getInteger("lqrVote");
    }

    @Override
    public Double getLocQualityRatingScoreThreshold(Attr attribute) {
        if (attribute != null) {
            return null;
        }
        if (this.trace.peek().lqRating == null) {
            return null;
        }
        return this.trace.peek().lqRating.getAnnotations("its-lqr").get(0).getDouble("lqrScoreThreshold");
    }

    @Override
    public Integer getLocQualityRatingVoteThreshold(Attr attribute) {
        if (attribute != null) {
            return null;
        }
        if (this.trace.peek().lqRating == null) {
            return null;
        }
        return this.trace.peek().lqRating.getAnnotations("its-lqr").get(0).getInteger("lqrVoteThreshold");
    }

    @Override
    public String getLocQualityRatingProfileRef(Attr attribute) {
        if (attribute != null) {
            return null;
        }
        if (this.trace.peek().lqRating == null) {
            return null;
        }
        return this.trace.peek().lqRating.getAnnotations("its-lqr").get(0).getString("lqrProfileRef");
    }

    public GenericAnnotations getStorageSizeAnnotation(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().storageSize;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(11) != 'y') {
            return null;
        }
        return new GenericAnnotations(this.getFlagData(tmp, 9));
    }

    @Override
    public Integer getStorageSize(Attr attribute) {
        if (attribute == null) {
            if (this.trace.peek().storageSize == null) {
                return null;
            }
            return this.trace.peek().storageSize.getFirstAnnotation("its-storagesize").getInteger("storagesizeSize");
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(11) != 'y') {
            return null;
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 9));
        return anns.getFirstAnnotation("its-storagesize").getInteger("storagesizeSize");
    }

    @Override
    public String getStorageEncoding(Attr attribute) {
        if (attribute == null) {
            if (this.trace.peek().storageSize == null) {
                return "UTF-8";
            }
            return this.trace.peek().storageSize.getFirstAnnotation("its-storagesize").getString("storagesizeEncoding");
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return "UTF-8";
        }
        if (tmp.charAt(11) != 'y') {
            return "UTF-8";
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 9));
        return anns.getFirstAnnotation("its-storagesize").getString("storagesizeEncoding");
    }

    @Override
    public String getLineBreakType(Attr attribute) {
        if (attribute == null) {
            if (this.trace.peek().storageSize == null) {
                return "lf";
            }
            return this.trace.peek().storageSize.getFirstAnnotation("its-storagesize").getString("storagesizeLinebreak");
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return "lf";
        }
        if (tmp.charAt(11) != 'y') {
            return "lf";
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 9));
        return anns.getFirstAnnotation("its-storagesize").getString("storagesizeLinebreak");
    }

    @Override
    public String getAllowedCharacters(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().allowedChars;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(12) != '?') {
            return this.getFlagData(tmp, 10);
        }
        return null;
    }

    public String getSubFilter(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().subFilter;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(13) != 'y') {
            return null;
        }
        return this.getFlagData(tmp, 11);
    }

    @Override
    public String getAnnotatorsRef() {
        return this.trace.peek().annotatorsRef;
    }

    @Override
    public String getAnnotatorRef(String dc) {
        this.validateDataCategoryNames(dc);
        String tmp = this.trace.peek().annotatorsRef;
        if (tmp == null) {
            return null;
        }
        Map<String, String> map = ITSContent.annotatorsRefToMap(tmp);
        return map.get(dc);
    }

    @Override
    public Double getMtConfidence(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().mtConfidence;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return null;
        }
        if (tmp.charAt(16) != 'y') {
            return this.trace.peek().mtConfidence;
        }
        return Double.parseDouble(this.getFlagData(tmp, 13));
    }

    public GenericAnnotations getProvenanceAnnotations(Attr attribute) {
        if (attribute == null) {
            return this.trace.peek().prov;
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            return this.trace.peek().prov;
        }
        if (tmp.charAt(19) != 'y') {
            return null;
        }
        return new GenericAnnotations(this.getFlagData(tmp, 16));
    }

    @Override
    public String getProvRecordsRef(Attr attribute) {
        return this.getProvValue("provRecsRef", attribute, 0);
    }

    @Override
    public int getProvRecordCount(Attr attribute) {
        if (attribute == null) {
            GenericAnnotations anns = this.trace.peek().prov;
            if (anns == null) {
                return 0;
            }
            return anns.size();
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            GenericAnnotations anns = this.trace.peek().prov;
            if (anns == null) {
                return 0;
            }
            return anns.size();
        }
        if (tmp.charAt(19) != 'y') {
            return 0;
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 16));
        return anns.getAnnotations("its-prov").size();
    }

    @Override
    public String getProvPerson(Attr attribute, int index) {
        return this.getProvValue("provPerson", attribute, index);
    }

    @Override
    public String getProvOrg(Attr attribute, int index) {
        return this.getProvValue("provOrg", attribute, index);
    }

    @Override
    public String getProvTool(Attr attribute, int index) {
        return this.getProvValue("provTool", attribute, index);
    }

    @Override
    public String getProvRevPerson(Attr attribute, int index) {
        return this.getProvValue("provRevPerson", attribute, index);
    }

    @Override
    public String getProvRevOrg(Attr attribute, int index) {
        return this.getProvValue("provRevOrg", attribute, index);
    }

    @Override
    public String getProvRevTool(Attr attribute, int index) {
        return this.getProvValue("provRevTool", attribute, index);
    }

    @Override
    public String getProvRef(Attr attribute, int index) {
        return this.getProvValue("provRef", attribute, index);
    }

    private String getProvValue(String fieldName, Attr attribute, int index) {
        if (attribute == null) {
            if (this.trace.peek().prov == null) {
                return null;
            }
            return this.trace.peek().prov.getAnnotations("its-prov").get(index).getString(fieldName);
        }
        String tmp = (String)attribute.getUserData(FLAGNAME);
        if (tmp == null) {
            if (this.trace.peek().prov == null) {
                return null;
            }
            return this.trace.peek().prov.getAnnotations("its-prov").get(index).getString(fieldName);
        }
        if (tmp.charAt(19) != 'y') {
            return null;
        }
        GenericAnnotations anns = new GenericAnnotations(this.getFlagData(tmp, 16));
        return anns.getAnnotations("its-prov").get(index).getString(fieldName);
    }
}

