/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.plaintext.ui;

import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.abstracteditor.IDialogPage;
import net.sf.okapi.common.ui.abstracteditor.SWTUtil;
import net.sf.okapi.common.ui.filters.InlineCodeFinderPanel;
import net.sf.okapi.filters.plaintext.base.Parameters;
import net.sf.okapi.lib.extra.filters.WrapMode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class OptionsTab
extends Composite
implements IDialogPage {
    private Button lead;
    private Button trail;
    private Group grpTextUnitProcessing;
    private Group grpInlineCodes;
    private Button inlines;
    private Group multi;
    private Button separate;
    private Button unwrap;
    private Button codes;
    private Button convert;
    private InlineCodeFinderPanel panel;
    private Button allow;
    private Label label;

    public OptionsTab(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new GridLayout(2, false));
        FormData formData_4 = new FormData();
        formData_4.right = new FormAttachment(100, -169);
        this.grpTextUnitProcessing = new Group(this, 0);
        this.grpTextUnitProcessing.setLayout(new GridLayout(2, false));
        this.grpTextUnitProcessing.setLayoutData(new GridData(4, 4, true, false, 1, 1));
        this.grpTextUnitProcessing.setText("Text unit processing");
        this.allow = new Button(this.grpTextUnitProcessing, 32);
        this.allow.setLayoutData(new GridData(16384, 0x1000000, true, false, 2, 1));
        this.allow.setData("name", "allow");
        this.allow.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                OptionsTab.this.interop(e.widget);
            }
        });
        this.allow.setText("Allow trimming");
        this.label = new Label(this.grpTextUnitProcessing, 0);
        this.label.setData("name", "label");
        this.label.setText("    ");
        this.lead = new Button(this.grpTextUnitProcessing, 32);
        this.lead.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        this.lead.setData("name", "lead");
        this.lead.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.lead.setText("Trim leading spaces and tabs");
        new Label(this.grpTextUnitProcessing, 0);
        this.trail = new Button(this.grpTextUnitProcessing, 32);
        this.trail.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        this.trail.setData("name", "trail");
        this.trail.setText("Trim trailing spaces and tabs");
        this.convert = new Button(this.grpTextUnitProcessing, 32);
        this.convert.setLayoutData(new GridData(16384, 0x1000000, true, false, 2, 1));
        this.convert.setText("Convert \\t, \\n, \\\\, \\uXXXX into characters            ");
        this.multi = new Group(this, 0);
        this.multi.setData("name", "multi");
        this.multi.setLayout(new GridLayout(1, false));
        this.multi.setLayoutData(new GridData(4, 4, true, false, 1, 1));
        this.multi.setText("Multi-line text units");
        this.separate = new Button(this.multi, 16);
        this.separate.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        this.separate.setText("Separate lines with line-feeds (\\n)");
        this.unwrap = new Button(this.multi, 16);
        this.unwrap.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        this.unwrap.setText("Unwrap lines (replace line breaks with spaces)         ");
        this.codes = new Button(this.multi, 16);
        this.codes.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        this.codes.setText("Create inline codes for line breaks");
        this.grpInlineCodes = new Group(this, 0);
        this.grpInlineCodes.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.grpInlineCodes.setLayout(new GridLayout(1, false));
        this.grpInlineCodes.setText("Inline codes");
        this.inlines = new Button(this.grpInlineCodes, 32);
        this.inlines.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.inlines.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                OptionsTab.this.interop(e.widget);
            }
        });
        this.inlines.setText("Has inline codes as defined below:");
        this.panel = new InlineCodeFinderPanel(this.grpInlineCodes, 0);
        this.panel.setLayoutData(new GridData(1808));
    }

    @Override
    public void interop(Widget speaker) {
        if (this.allow.getSelection()) {
            this.lead.setEnabled(true);
            this.trail.setEnabled(true);
        } else {
            this.lead.setSelection(false);
            this.trail.setSelection(false);
            this.lead.setEnabled(false);
            this.trail.setEnabled(false);
        }
        this.panel.setEnabled(this.inlines.getSelection());
    }

    @Override
    public boolean load(Object data) {
        if (data instanceof Parameters) {
            Parameters params = (Parameters)data;
            this.allow.setSelection(!params.preserveWS);
            this.lead.setSelection(params.trimLeading);
            this.trail.setSelection(params.trimTrailing);
            this.convert.setSelection(params.unescapeSource);
            this.inlines.setSelection(params.useCodeFinder);
            this.panel.setRules(params.codeFinderRules);
            SWTUtil.unselectAll(this.multi);
            switch (params.wrapMode) {
                case NONE: {
                    this.separate.setSelection(true);
                    break;
                }
                case SPACES: {
                    this.unwrap.setSelection(true);
                    break;
                }
                case PLACEHOLDERS: {
                    this.codes.setSelection(true);
                }
            }
        }
        return true;
    }

    @Override
    public boolean save(Object data) {
        if (data instanceof Parameters) {
            Parameters params = (Parameters)data;
            params.preserveWS = !this.allow.getSelection();
            params.trimLeading = this.lead.getSelection();
            params.trimTrailing = this.trail.getSelection();
            params.unescapeSource = this.convert.getSelection();
            params.useCodeFinder = this.inlines.getSelection();
            params.codeFinderRules = this.panel.getRules();
            if (this.separate.getSelection()) {
                params.wrapMode = WrapMode.NONE;
            } else if (this.unwrap.getSelection()) {
                params.wrapMode = WrapMode.SPACES;
            } else if (this.codes.getSelection()) {
                params.wrapMode = WrapMode.PLACEHOLDERS;
            }
        }
        return true;
    }

    @Override
    public boolean canClose(boolean isOK) {
        if (this.panel.inEditMode() && isOK) {
            Dialogs.showWarning(this.getShell(), "Cannot close the window while the rules for inline codes are being edited.\nPlease accept or discard changes first.", null);
            return false;
        }
        return true;
    }
}

