/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.properties.ui;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.filters.InlineCodeFinderPanel;
import net.sf.okapi.common.ui.filters.LDPanel;
import net.sf.okapi.filters.properties.Parameters;
import net.sf.okapi.filters.properties.ui.Res;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

@EditorFor(value=Parameters.class)
public class Editor
implements IParametersEditor {
    private Shell shell;
    private boolean result = false;
    private Button chkUseKeyFilter;
    private Button rdExtractOnlyMatchingKey;
    private Button rdExcludeMatchingKey;
    private Text edKeyCondition;
    private Button chkExtraComments;
    private Button chkCommentsAreNotes;
    private Button chkIdLikeResname;
    private LDPanel pnlLD;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private Button chkEscapeExtendedChars;
    private Button chkUseCodeFinder;
    private InlineCodeFinderPanel pnlCodeFinder;
    private IHelp help;
    private Button chkConvertLFAndTab;
    private Text edSubFilter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters p_Options, boolean readOnly, IContext context) {
        this.help = (IHelp)context.getObject("help");
        boolean bRes = false;
        this.shell = null;
        this.params = (Parameters)p_Options;
        try {
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception E) {
            Dialogs.showError(this.shell, E.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    private void create(Shell p_Parent, boolean readOnly) {
        this.shell.setText(Res.getString("EditorCaption"));
        if (p_Parent != null) {
            this.shell.setImage(p_Parent.getImage());
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout(layTmp);
        TabFolder tfTmp = new TabFolder(this.shell, 0);
        GridData gdTmp = new GridData(1808);
        tfTmp.setLayoutData(gdTmp);
        Composite cmpTmp = new Composite(tfTmp, 0);
        layTmp = new GridLayout();
        cmpTmp.setLayout(layTmp);
        Group grpTmp = new Group(cmpTmp, 0);
        layTmp = new GridLayout();
        grpTmp.setLayout(layTmp);
        grpTmp.setText(Res.getString("LodDirTitle"));
        gdTmp = new GridData(768);
        grpTmp.setLayoutData(gdTmp);
        this.pnlLD = new LDPanel(grpTmp, 0);
        grpTmp = new Group(cmpTmp, 0);
        layTmp = new GridLayout();
        grpTmp.setLayout(layTmp);
        grpTmp.setText(Res.getString("KeyCondTitle"));
        gdTmp = new GridData(768);
        grpTmp.setLayoutData(gdTmp);
        this.chkUseKeyFilter = new Button(grpTmp, 32);
        this.chkUseKeyFilter.setText(Res.getString("chkUseKeyFilter"));
        this.chkUseKeyFilter.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Editor.this.updateKeyFilter();
            }
        });
        this.rdExtractOnlyMatchingKey = new Button(grpTmp, 16);
        this.rdExtractOnlyMatchingKey.setText(Res.getString("rdExtractOnlyMatchingKey"));
        gdTmp = new GridData();
        gdTmp.horizontalIndent = 16;
        this.rdExtractOnlyMatchingKey.setLayoutData(gdTmp);
        this.rdExcludeMatchingKey = new Button(grpTmp, 16);
        this.rdExcludeMatchingKey.setText(Res.getString("rdExcludeMatchingKey"));
        this.rdExcludeMatchingKey.setLayoutData(gdTmp);
        this.edKeyCondition = new Text(grpTmp, 2048);
        gdTmp = new GridData(768);
        gdTmp.horizontalIndent = 16;
        this.edKeyCondition.setLayoutData(gdTmp);
        Label label = new Label(grpTmp, 64);
        label.setText(Res.getString("KeyCondNote"));
        gdTmp = new GridData(1808);
        gdTmp.horizontalIndent = 16;
        gdTmp.widthHint = 300;
        label.setLayoutData(gdTmp);
        Label stSubFilter = new Label(cmpTmp, 0);
        stSubFilter.setText("Configuration identifier of the sub-filter to use on the content (empty for none):");
        this.edSubFilter = new Text(cmpTmp, 2048);
        this.edSubFilter.setLayoutData(new GridData(768));
        this.chkExtraComments = new Button(cmpTmp, 32);
        this.chkExtraComments.setText(Res.getString("chkExtraComments"));
        this.chkCommentsAreNotes = new Button(cmpTmp, 32);
        this.chkCommentsAreNotes.setText(Res.getString("chkCommentsAreNotes"));
        this.chkConvertLFAndTab = new Button(cmpTmp, 32);
        this.chkConvertLFAndTab.setText(Res.getString("chkConvertLFAndTab"));
        this.chkIdLikeResname = new Button(cmpTmp, 32);
        this.chkIdLikeResname.setText(Res.getString("chkIdLikeResname"));
        TabItem tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText(Res.getString("tabOptions"));
        tiTmp.setControl(cmpTmp);
        cmpTmp = new Composite(tfTmp, 0);
        layTmp = new GridLayout();
        cmpTmp.setLayout(layTmp);
        this.chkUseCodeFinder = new Button(cmpTmp, 32);
        this.chkUseCodeFinder.setText("Has inline codes as defined below:");
        this.chkUseCodeFinder.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Editor.this.updateInlineCodes();
            }
        });
        this.pnlCodeFinder = new InlineCodeFinderPanel(cmpTmp, 0);
        this.pnlCodeFinder.setLayoutData(new GridData(1808));
        tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Inline Codes");
        tiTmp.setControl(cmpTmp);
        cmpTmp = new Composite(tfTmp, 0);
        layTmp = new GridLayout();
        cmpTmp.setLayout(layTmp);
        grpTmp = new Group(cmpTmp, 0);
        layTmp = new GridLayout();
        grpTmp.setLayout(layTmp);
        grpTmp.setText(Res.getString("grpExtendedChars"));
        gdTmp = new GridData(768);
        grpTmp.setLayoutData(gdTmp);
        this.chkEscapeExtendedChars = new Button(grpTmp, 32);
        this.chkEscapeExtendedChars.setText(Res.getString("chkEscapeExtendedChars"));
        tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText(Res.getString("tabOutput"));
        tiTmp.setControl(cmpTmp);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Editor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (Editor.this.help != null) {
                        Editor.this.help.showWiki("Properties Filter");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!Editor.this.saveData()) {
                        return;
                    }
                    Editor.this.result = true;
                }
                Editor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel(this.shell, 0, OKCancelActions, true);
        gdTmp = new GridData(768);
        this.pnlActions.setLayoutData(gdTmp);
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.shell.pack();
        Rectangle Rect = this.shell.getBounds();
        this.shell.setMinimumSize(Rect.width, Rect.height);
        Dialogs.centerWindow(this.shell, p_Parent);
        this.setData();
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData() {
        this.pnlLD.setOptions(this.params.locDir.useLD(), this.params.locDir.localizeOutside());
        this.edKeyCondition.setText(this.params.getKeyCondition());
        this.rdExtractOnlyMatchingKey.setSelection(this.params.isExtractOnlyMatchingKey());
        this.rdExcludeMatchingKey.setSelection(!this.params.isExtractOnlyMatchingKey());
        this.chkUseKeyFilter.setSelection(this.params.isUseKeyCondition());
        this.chkExtraComments.setSelection(this.params.isExtraComments());
        this.chkCommentsAreNotes.setSelection(this.params.isCommentsAreNotes());
        this.chkEscapeExtendedChars.setSelection(this.params.isEscapeExtendedChars());
        this.chkIdLikeResname.setSelection(this.params.isIdLikeResname());
        this.chkUseCodeFinder.setSelection(this.params.isUseCodeFinder());
        this.pnlCodeFinder.setRules(this.params.codeFinder.toString());
        this.chkConvertLFAndTab.setSelection(this.params.isConvertLFandTab());
        String tmp = this.params.getSubfilter();
        this.edSubFilter.setText(Util.isEmpty((String)tmp) ? "" : tmp);
        this.updateInlineCodes();
        this.pnlCodeFinder.updateDisplay();
        this.pnlLD.updateDisplay();
        this.updateKeyFilter();
    }

    private boolean saveData() {
        String tmp = this.pnlCodeFinder.getRules();
        if (tmp == null) {
            return false;
        }
        this.params.codeFinder.fromString(tmp);
        this.params.locDir.setOptions(this.pnlLD.getUseLD(), this.pnlLD.getLocalizeOutside());
        this.params.setUseKeyCondition(this.chkUseKeyFilter.getSelection());
        this.params.setKeyCondition(this.edKeyCondition.getText());
        this.params.setExtractOnlyMatchingKey(this.rdExtractOnlyMatchingKey.getSelection());
        this.params.setExtraComments(this.chkExtraComments.getSelection());
        this.params.setCommentsAreNotes(this.chkCommentsAreNotes.getSelection());
        this.params.setEscapeExtendedChars(this.chkEscapeExtendedChars.getSelection());
        this.params.setIdLikeResname(this.chkIdLikeResname.getSelection());
        this.params.setUseCodeFinder(this.chkUseCodeFinder.getSelection());
        this.params.setConvertLFandTab(this.chkConvertLFAndTab.getSelection());
        this.params.setSubfilter(this.edSubFilter.getText().trim());
        return true;
    }

    private void updateKeyFilter() {
        this.edKeyCondition.setEnabled(this.chkUseKeyFilter.getSelection());
        this.rdExtractOnlyMatchingKey.setEnabled(this.chkUseKeyFilter.getSelection());
        this.rdExcludeMatchingKey.setEnabled(this.chkUseKeyFilter.getSelection());
    }

    private void updateInlineCodes() {
        this.pnlCodeFinder.setEnabled(this.chkUseCodeFinder.getSelection());
    }
}

