/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.textmodification.ui;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.ISWTEmbeddableParametersEditor;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.steps.textmodification.Parameters;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

@EditorFor(value=Parameters.class)
public class ParametersEditor
implements IParametersEditor,
ISWTEmbeddableParametersEditor {
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private List lbTypes;
    private Button chkAddPrefix;
    private Text edPrefix;
    private Button chkAddSuffix;
    private Text edSuffix;
    private boolean inInit = true;
    private Button chkApplyToExistingTarget;
    private Button chkAddID;
    private Button chkAddName;
    private Button chkMarkSegments;
    private Button chkExpand;
    private Button chkApplyToBlankEntries;
    private IHelp help;
    private Composite mainComposite;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters params, boolean readOnly, IContext context) {
        boolean bRes = false;
        try {
            this.shell = null;
            this.help = (IHelp)context.getObject("help");
            this.params = (Parameters)params;
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    @Override
    public void initializeEmbeddableEditor(Composite parent, IParameters paramsObject, IContext context) {
        this.params = (Parameters)paramsObject;
        this.shell = (Shell)context.getObject("shell");
        this.createComposite(parent);
        this.setData();
        this.inInit = false;
    }

    public String validateAndSaveParameters() {
        if (!this.saveData()) {
            return null;
        }
        return this.params.toString();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText("Text Rewriting");
        if (parent != null) {
            UIUtil.inheritIcon(this.shell, parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout(layTmp);
        this.createComposite(this.shell);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (ParametersEditor.this.help != null) {
                        ParametersEditor.this.help.showWiki("Text Modification Step");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    ParametersEditor.this.saveData();
                }
                ParametersEditor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel(this.shell, 0, OKCancelActions, true);
        this.pnlActions.setLayoutData(new GridData(768));
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 600) {
            startSize.x = 600;
        }
        this.shell.setSize(startSize);
        this.setData();
        this.inInit = false;
        Dialogs.centerWindow(this.shell, parent);
    }

    private void createComposite(Composite parent) {
        this.mainComposite = new Composite(parent, 2048);
        this.mainComposite.setLayoutData(new GridData(1808));
        this.mainComposite.setLayout(new GridLayout());
        Label stTmp = new Label(this.mainComposite, 0);
        stTmp.setText("Type of change to perform:");
        GridData gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        stTmp.setLayoutData(gdTmp);
        this.lbTypes = new List(this.mainComposite, 2560);
        this.lbTypes.add("Keep the original text");
        this.lbTypes.add("Replace letters with Xs and digits with Ns");
        this.lbTypes.add("Remove text but keep inline codes");
        this.lbTypes.add("Replace selected ASCII characters with Extended Latin characters");
        this.lbTypes.add("Replace selected ASCII characters with Cyrillic characters");
        this.lbTypes.add("Replace selected ASCII characters with Arabic characters");
        this.lbTypes.add("Replace selected ASCII characters with Chinese characters");
        gdTmp = new GridData(1808);
        gdTmp.heightHint = 70;
        gdTmp.horizontalSpan = 2;
        this.lbTypes.setLayoutData(gdTmp);
        this.chkAddPrefix = new Button(this.mainComposite, 32);
        this.chkAddPrefix.setText("Add the following prefix:");
        this.chkAddPrefix.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.edPrefix.setEnabled(ParametersEditor.this.chkAddPrefix.getSelection());
            }
        });
        this.edPrefix = new Text(this.mainComposite, 2048);
        this.edPrefix.setLayoutData(new GridData(768));
        this.chkAddSuffix = new Button(this.mainComposite, 32);
        this.chkAddSuffix.setText("Add the following suffix:");
        this.chkAddSuffix.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ParametersEditor.this.edSuffix.setEnabled(ParametersEditor.this.chkAddSuffix.getSelection());
            }
        });
        this.edSuffix = new Text(this.mainComposite, 2048);
        this.edSuffix.setLayoutData(new GridData(768));
        this.chkAddName = new Button(this.mainComposite, 32);
        this.chkAddName.setText("Append the name of the item.");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkAddName.setLayoutData(gdTmp);
        this.chkAddID = new Button(this.mainComposite, 32);
        this.chkAddID.setText("Append the extraction ID of the item.");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkAddID.setLayoutData(gdTmp);
        this.chkMarkSegments = new Button(this.mainComposite, 32);
        this.chkMarkSegments.setText("Mark segments with '[' and ']' delimiters");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkMarkSegments.setLayoutData(gdTmp);
        this.chkExpand = new Button(this.mainComposite, 32);
        this.chkExpand.setText("Expand the text");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkExpand.setLayoutData(gdTmp);
        Label separator = new Label(this.mainComposite, 2048);
        gdTmp = new GridData(768);
        gdTmp.heightHint = 1;
        gdTmp.horizontalSpan = 2;
        separator.setLayoutData(gdTmp);
        this.chkApplyToBlankEntries = new Button(this.mainComposite, 32);
        this.chkApplyToBlankEntries.setText("Modify also the items without text");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkApplyToBlankEntries.setLayoutData(gdTmp);
        this.chkApplyToExistingTarget = new Button(this.mainComposite, 32);
        this.chkApplyToExistingTarget.setText("Modify also the items with an existing translation");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkApplyToExistingTarget.setLayoutData(gdTmp);
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData() {
        int n = this.params.getType();
        if (n == 3) {
            n += this.params.getScript();
        }
        this.lbTypes.setSelection(n);
        this.chkAddPrefix.setSelection(this.params.getAddPrefix());
        this.edPrefix.setText(this.params.getPrefix());
        this.chkAddSuffix.setSelection(this.params.getAddSuffix());
        this.edSuffix.setText(this.params.getSuffix());
        this.chkApplyToBlankEntries.setSelection(this.params.getApplyToBlankEntries());
        this.chkApplyToExistingTarget.setSelection(this.params.getApplyToExistingTarget());
        this.chkAddName.setSelection(this.params.getAddName());
        this.chkAddID.setSelection(this.params.getAddID());
        this.chkMarkSegments.setSelection(this.params.getMarkSegments());
        this.chkExpand.setSelection(this.params.getExpand());
        this.edPrefix.setEnabled(this.chkAddPrefix.getSelection());
        this.edSuffix.setEnabled(this.chkAddSuffix.getSelection());
    }

    private boolean saveData() {
        if (this.inInit) {
            return true;
        }
        int n = this.lbTypes.getSelectionIndex();
        if (n >= 3) {
            this.params.setScript(n - 3);
            n = 3;
        }
        this.params.setType(n);
        this.params.setAddPrefix(this.chkAddPrefix.getSelection());
        this.params.setPrefix(this.edPrefix.getText());
        this.params.setAddSuffix(this.chkAddSuffix.getSelection());
        this.params.setSuffix(this.edSuffix.getText());
        this.params.setApplyToBlankEntries(this.chkApplyToBlankEntries.getSelection());
        this.params.setApplyToExistingTarget(this.chkApplyToExistingTarget.getSelection());
        this.params.setAddName(this.chkAddName.getSelection());
        this.params.setAddID(this.chkAddID.getSelection());
        this.params.setMarkSegments(this.chkMarkSegments.getSelection());
        this.params.setExpand(this.chkExpand.getSelection());
        this.result = true;
        return true;
    }
}

