/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast.util;

import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.NodeVisitor;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ast.VisitHandler;
import com.vladsch.flexmark.ast.Visitor;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequenceBuilder;

public class TextCollectingVisitor {
    private SegmentedSequenceBuilder out;
    private final NodeVisitor myVisitor = new NodeVisitor(new VisitHandler[]{new VisitHandler(Text.class, (Visitor)new Visitor<Text>(){

        public void visit(Text node) {
            TextCollectingVisitor.this.visit(node);
        }
    }), new VisitHandler(TextBase.class, (Visitor)new Visitor<TextBase>(){

        public void visit(TextBase node) {
            TextCollectingVisitor.this.visit(node);
        }
    }), new VisitHandler(HtmlEntity.class, (Visitor)new Visitor<HtmlEntity>(){

        public void visit(HtmlEntity node) {
            TextCollectingVisitor.this.visit(node);
        }
    }), new VisitHandler(SoftLineBreak.class, (Visitor)new Visitor<SoftLineBreak>(){

        public void visit(SoftLineBreak node) {
            TextCollectingVisitor.this.visit(node);
        }
    }), new VisitHandler(HardLineBreak.class, (Visitor)new Visitor<HardLineBreak>(){

        public void visit(HardLineBreak node) {
            TextCollectingVisitor.this.visit(node);
        }
    })});

    public String getText() {
        return this.out.toString();
    }

    public void collect(Node node) {
        this.out = new SegmentedSequenceBuilder(node.getChars());
        this.myVisitor.visit(node);
    }

    public String collectAndGetText(Node node) {
        this.collect(node);
        return this.out.toString();
    }

    public BasedSequence[] collectAndGetSegments(Node node) {
        this.collect(node);
        return this.out.toSegments();
    }

    public BasedSequence collectAndGetSequence(Node node) {
        this.collect(node);
        return this.out.toBasedSequence();
    }

    private void visit(SoftLineBreak node) {
        this.out.append(node.getChars());
    }

    private void visit(HardLineBreak node) {
        BasedSequence chars = node.getChars();
        this.out.append(chars.subSequence(chars.length() - 1, chars.length()));
    }

    private void visit(HtmlEntity node) {
        this.out.append(node.getChars().unescape());
    }

    private void visit(Text node) {
        this.out.append(node.getChars());
    }

    private void visit(TextBase node) {
        this.out.append(node.getChars());
    }
}

