/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.validation;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.lib.xliff2.core.BaseList;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.IWithExtAttributes;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.validation.Issue;
import net.sf.okapi.lib.xliff2.validation.Rule;

public class Validation
extends BaseList<Rule>
implements IWithExtAttributes {
    private ExtAttributes xattrs;
    private int declarationCount;

    public Validation() {
    }

    public Validation(Validation original, boolean markAsInherited) {
        super(original);
        if (original.hasExtAttribute()) {
            this.xattrs = new ExtAttributes(original.xattrs);
        }
        for (Rule rule : this) {
            rule.setInherited(true);
        }
    }

    @Override
    public void setExtAttributes(ExtAttributes attributes) {
        this.xattrs = attributes;
    }

    @Override
    public ExtAttributes getExtAttributes() {
        if (this.xattrs == null) {
            this.xattrs = new ExtAttributes();
        }
        return this.xattrs;
    }

    @Override
    public boolean hasExtAttribute() {
        if (this.xattrs == null) {
            return false;
        }
        return !this.xattrs.isEmpty();
    }

    @Override
    public String getExtAttributeValue(String namespaceURI, String localName) {
        if (this.xattrs == null) {
            return null;
        }
        return this.xattrs.getAttributeValue(namespaceURI, localName);
    }

    public boolean hasNonInheritedRule() {
        for (Rule rule : this) {
            if (rule.isInherited()) continue;
            return true;
        }
        return false;
    }

    public void prepare() {
        for (Rule rule : this) {
            rule.prepare();
        }
    }

    public List<Issue> processRules(Unit unit, String fileId) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        String target = unit.getPlainText(true, false);
        String source = null;
        String unitId = unit.getId();
        int ruleCount = 0;
        for (Rule rule : this) {
            if (!rule.isEnabled() || rule.getType() == Rule.Type.CUSTOM) continue;
            ++ruleCount;
            String effectiveText = this.applyOptions(target, rule);
            switch (rule.getType()) {
                case ENDSWITH: {
                    if (effectiveText.endsWith(rule.getEffectiveData())) break;
                    issues.add(new Issue(fileId, unitId, "endsWith", String.format("Target does not ends with '%s'", rule.getEffectiveData()), rule.getDisplay()));
                    break;
                }
                case ISNOTPRESENT: {
                    if (effectiveText.indexOf(rule.getEffectiveData()) == -1) break;
                    issues.add(new Issue(fileId, unitId, "isNotPresent", String.format("The text '%s' is present in the target", rule.getEffectiveData()), rule.getDisplay()));
                    break;
                }
                case ISPRESENT: {
                    int count = 0;
                    String tmp = effectiveText;
                    int n = tmp.indexOf(rule.getEffectiveData());
                    while (n > -1) {
                        tmp = tmp.replace(rule.getEffectiveData(), "");
                        ++count;
                        n = tmp.indexOf(rule.getEffectiveData());
                    }
                    if (rule.getExistsInSource()) {
                        String src;
                        if (source == null) {
                            source = unit.getPlainText(false, false);
                        }
                        if ((src = this.applyOptions(source, rule)).indexOf(rule.getEffectiveData()) == -1) {
                            issues.add(new Issue(fileId, unitId, "isPresent-NotInSource", String.format("The text '%s' is not present in the source", rule.getEffectiveData()), rule.getDisplay()));
                            break;
                        }
                    }
                    if (rule.getOccurs() == 0) {
                        if (count >= 1) break;
                        issues.add(new Issue(fileId, unitId, "isPresent-NotInTarget", String.format("The text '%s' is not present in the target", rule.getEffectiveData()), rule.getDisplay()));
                        break;
                    }
                    if (rule.getOccurs() == count) break;
                    issues.add(new Issue(fileId, unitId, "isPresent-WrongCount", String.format("Occurences of text '%s' the target: %d, expected: %d", rule.getEffectiveData(), count, rule.getOccurs()), rule.getDisplay()));
                    break;
                }
                case STARTSWITH: {
                    if (effectiveText.startsWith(rule.getEffectiveData())) break;
                    issues.add(new Issue(fileId, unitId, "startsWith", String.format("Target does not starts with '%s'.", rule.getEffectiveData()), rule.getDisplay()));
                    break;
                }
            }
        }
        if (ruleCount == 0) {
            return null;
        }
        return issues;
    }

    private String applyOptions(String text, Rule rule) {
        String effectiveText = text;
        if (!rule.isCaseSensitive()) {
            effectiveText = effectiveText.toLowerCase();
        }
        switch (rule.getNormalization()) {
            case NFC: {
                effectiveText = Normalizer.normalize(effectiveText, Normalizer.Form.NFC);
                break;
            }
            case NFD: {
                effectiveText = Normalizer.normalize(effectiveText, Normalizer.Form.NFD);
                break;
            }
        }
        return effectiveText;
    }

    public int getDeclarationCount() {
        return this.declarationCount;
    }

    public void addDeclaration() {
        ++this.declarationCount;
    }
}

