/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.ISWTEmbeddableParametersEditor;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.TextAndBrowsePanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.common.ui.genericeditor.GenericEditor;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.steps.rainbowkit.creation.Parameters;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

@EditorFor(value=Parameters.class)
public class CreationParametersEditor
implements IParametersEditor,
ISWTEmbeddableParametersEditor {
    private static String SEPARATOR = "  -->  ";
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private IHelp help;
    private TabFolder tabs;
    private Text edPackageName;
    private TextAndBrowsePanel pnlPackageDir;
    private Button btCreateZip;
    private Composite mainComposite;
    private org.eclipse.swt.widgets.List lbTypes;
    private Button btOptions;
    private Button btHelp;
    private Text edDescription;
    private GenericEditor gedit;
    private ArrayList<String> optEditors;
    private ArrayList<String> writers;
    private ArrayList<IParameters> optStrings;
    private ArrayList<String> optMoreInfo;
    private IContext context;
    private Button chkSendOutput;
    private Text edAncilOrigin;
    private Text edAncilDestination;
    private Button btAddAncilFile;
    private Button btRemoveAncilFile;
    private org.eclipse.swt.widgets.List lbAncilList;
    private boolean supportFileMode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters params, boolean readOnly, IContext context) {
        boolean bRes = false;
        try {
            this.shell = null;
            this.context = context;
            this.help = (IHelp)context.getObject("help");
            this.params = (Parameters)params;
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    @Override
    public void initializeEmbeddableEditor(Composite parent, IParameters paramsObject, IContext context) {
        this.shell = (Shell)context.getObject("shell");
        this.help = (IHelp)context.getObject("help");
        this.context = context;
        this.params = (Parameters)paramsObject;
        this.createComposite(parent);
        this.setData();
    }

    public String validateAndSaveParameters() {
        if (this.supportFileMode) {
            return null;
        }
        if (!this.saveData()) {
            return null;
        }
        return this.params.toString();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText("Translation Kit Creation");
        if (parent != null) {
            UIUtil.inheritIcon(this.shell, parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout(layTmp);
        this.createComposite(this.shell);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                CreationParametersEditor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (CreationParametersEditor.this.help != null) {
                        CreationParametersEditor.this.help.showWiki("Translation Kit Creation Step");
                    }
                    return;
                }
                if (CreationParametersEditor.this.supportFileMode) {
                    e.doit = false;
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    CreationParametersEditor.this.saveData();
                }
                CreationParametersEditor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel(this.shell, 0, OKCancelActions, true);
        this.pnlActions.setLayoutData(new GridData(768));
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.setData();
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Dialogs.centerWindow(this.shell, parent);
    }

    private void createComposite(Composite parent) {
        this.optEditors = new ArrayList();
        this.optStrings = new ArrayList();
        this.optMoreInfo = new ArrayList();
        this.writers = new ArrayList();
        this.optEditors.add("net.sf.okapi.steps.rainbowkit.xliff.Options");
        this.optStrings.add(this.createParameters(this.optEditors.get(this.optEditors.size() - 1)));
        this.optMoreInfo.add("Rainbow TKit - Generic XLIFF");
        this.writers.add("net.sf.okapi.steps.rainbowkit.xliff.XLIFFPackageWriter");
        this.optEditors.add(null);
        this.optStrings.add(null);
        this.optMoreInfo.add("Rainbow TKit - PO Package");
        this.writers.add("net.sf.okapi.steps.rainbowkit.po.POPackageWriter");
        this.optEditors.add(null);
        this.optStrings.add(null);
        this.optMoreInfo.add("Rainbow TKit - Original with RTF");
        this.writers.add("net.sf.okapi.steps.rainbowkit.rtf.RTFPackageWriter");
        this.optEditors.add(null);
        this.optStrings.add(null);
        this.optMoreInfo.add("Rainbow TKit - XLIFF with RTF");
        this.writers.add("net.sf.okapi.steps.rainbowkit.xliffrtf.XLIFFRTFPackageWriter");
        this.optEditors.add("net.sf.okapi.steps.rainbowkit.omegat.Options");
        this.optStrings.add(this.createParameters(this.optEditors.get(this.optEditors.size() - 1)));
        this.optMoreInfo.add("Rainbow TKit - OmegaT Project");
        this.writers.add("net.sf.okapi.steps.rainbowkit.omegat.OmegaTPackageWriter");
        this.optEditors.add("net.sf.okapi.steps.rainbowkit.transifex.Parameters");
        this.optStrings.add(this.createParameters(this.optEditors.get(this.optEditors.size() - 1)));
        this.optMoreInfo.add("Rainbow TKit - Transifex Project");
        this.writers.add("net.sf.okapi.steps.rainbowkit.transifex.TransifexPackageWriter");
        this.optEditors.add(null);
        this.optStrings.add(null);
        this.optMoreInfo.add("Rainbow TKit - ONTRAM XINI");
        this.writers.add("net.sf.okapi.steps.rainbowkit.ontram.OntramPackageWriter");
        this.optEditors.add("net.sf.okapi.steps.rainbowkit.xliff.XLIFF2Options");
        this.optStrings.add(this.createParameters(this.optEditors.get(this.optEditors.size() - 1)));
        this.optMoreInfo.add("Rainbow TKit - XLIFF 2.0");
        this.writers.add("net.sf.okapi.steps.rainbowkit.xliff.XLIFF2PackageWriter");
        this.optEditors.add(null);
        this.optStrings.add(null);
        this.optMoreInfo.add("Rainbow TKit - Versified with RTF");
        this.writers.add("net.sf.okapi.steps.rainbowkit.versified.VersifiedRtfPackageWriter");
        this.optEditors.add("net.sf.okapi.filters.transtable.Parameters");
        this.optStrings.add(this.createParameters(this.optEditors.get(this.optEditors.size() - 1)));
        this.optMoreInfo.add("Rainbow TKit - Translation Table");
        this.writers.add("net.sf.okapi.steps.rainbowkit.table.TablePackageWriter");
        this.mainComposite = new Composite(parent, 2048);
        this.mainComposite.setLayoutData(new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.mainComposite.setLayout(layout);
        this.tabs = new TabFolder(this.mainComposite, 0);
        this.tabs.setLayout(new GridLayout());
        GridData gdTmp = new GridData(1808);
        gdTmp.heightHint = 430;
        this.tabs.setLayoutData(gdTmp);
        Composite cmpTmp = new Composite(this.tabs, 0);
        cmpTmp.setLayout(new GridLayout(2, false));
        TabItem tiTmp = new TabItem(this.tabs, 0);
        tiTmp.setText("Package Format");
        tiTmp.setControl(cmpTmp);
        Label label = new Label(cmpTmp, 0);
        label.setText("Type of package to create:");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        label.setLayoutData(gdTmp);
        this.lbTypes = new org.eclipse.swt.widgets.List(cmpTmp, 2560);
        this.lbTypes.add("Generic XLIFF");
        this.lbTypes.setData("0", "net.sf.okapi.steps.rainbowkit.xliff.XLIFFPackageWriter");
        this.lbTypes.add("PO Package");
        this.lbTypes.setData("1", "net.sf.okapi.steps.rainbowkit.po.POPackageWriter");
        this.lbTypes.add("Original with RTF");
        this.lbTypes.setData("2", "net.sf.okapi.steps.rainbowkit.rtf.RTFPackageWriter");
        this.lbTypes.add("XLIFF with RTF");
        this.lbTypes.setData("3", "net.sf.okapi.steps.rainbowkit.xliffrtf.XLIFFRTFPackageWriter");
        this.lbTypes.add("OmegaT Project");
        this.lbTypes.setData("4", "net.sf.okapi.steps.rainbowkit.omegat.OmegaTPackageWriter");
        this.lbTypes.add("Transifex Project");
        this.lbTypes.setData("5", "net.sf.okapi.steps.rainbowkit.transifex.TransifexPackageWriter");
        this.lbTypes.add("ONTRAM XINI");
        this.lbTypes.setData("6", "net.sf.okapi.steps.rainbowkit.ontram.OntramPackageWriter");
        this.lbTypes.add("XLIFF 2.0 (Experimental - output only)");
        this.lbTypes.setData("7", "net.sf.okapi.steps.rainbowkit.xliff.XLIFF2PackageWriter");
        this.lbTypes.add("Versified with RTF (Beta)");
        this.lbTypes.setData("8", "net.sf.okapi.steps.rainbowkit.versified.VersifiedRtfPackageWriter");
        this.lbTypes.add("Translation Table (Beta)");
        this.lbTypes.setData("9", "net.sf.okapi.steps.rainbowkit.table.TablePackageWriter");
        gdTmp = new GridData(1808);
        gdTmp.heightHint = 50;
        gdTmp.verticalSpan = 2;
        this.lbTypes.setLayoutData(gdTmp);
        this.lbTypes.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                CreationParametersEditor.this.updatePackageType();
            }
        });
        int btnWidth = 95;
        this.btOptions = new Button(cmpTmp, 8);
        this.btOptions.setText("&Options...");
        gdTmp = new GridData(2);
        this.btOptions.setLayoutData(gdTmp);
        UIUtil.ensureWidth(this.btOptions, 95);
        this.btOptions.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                CreationParametersEditor.this.editOptions();
            }
        });
        this.btHelp = new Button(cmpTmp, 8);
        this.btHelp.setText("&More Info");
        gdTmp = new GridData(2);
        this.btHelp.setLayoutData(gdTmp);
        UIUtil.ensureWidth(this.btHelp, 95);
        this.btHelp.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                CreationParametersEditor.this.callMoreInfo();
            }
        });
        this.edDescription = new Text(cmpTmp, 2626);
        this.edDescription.setEditable(false);
        gdTmp = new GridData(768);
        gdTmp.heightHint = 100;
        gdTmp.horizontalSpan = 2;
        this.edDescription.setLayoutData(gdTmp);
        this.chkSendOutput = new Button(cmpTmp, 32);
        this.chkSendOutput.setText("Send the prepared files to the next step");
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.chkSendOutput.setLayoutData(gdTmp);
        cmpTmp = new Composite(this.tabs, 0);
        cmpTmp.setLayout(new GridLayout(2, false));
        tiTmp = new TabItem(this.tabs, 0);
        tiTmp.setText("Output Location");
        tiTmp.setControl(cmpTmp);
        label = new Label(cmpTmp, 0);
        label.setText("Root of the output directory:");
        new Label(cmpTmp, 0);
        this.pnlPackageDir = new TextAndBrowsePanel(cmpTmp, 0, true);
        gdTmp = new GridData(4, 0x1000000, true, false, 2, 1);
        this.pnlPackageDir.setLayoutData(gdTmp);
        label = new Label(cmpTmp, 0);
        label.setText("Name of the package:");
        new Label(cmpTmp, 0);
        this.edPackageName = new Text(cmpTmp, 2048);
        this.edPackageName.setLayoutData(new GridData(4, 0x1000000, true, false, 2, 1));
        this.btCreateZip = new Button(cmpTmp, 32);
        this.btCreateZip.setText("Create a ZIP file for the package");
        cmpTmp = new Composite(this.tabs, 0);
        cmpTmp.setLayout(new GridLayout(1, false));
        tiTmp = new TabItem(this.tabs, 0);
        tiTmp.setText("Support Material");
        tiTmp.setControl(cmpTmp);
        label = new Label(cmpTmp, 0);
        label.setText("List of the files to include in the package");
        this.lbAncilList = new org.eclipse.swt.widgets.List(cmpTmp, 2560);
        gdTmp = new GridData(1808);
        gdTmp.heightHint = 100;
        this.lbAncilList.setLayoutData(gdTmp);
        Composite cmpTmp2 = new Composite(cmpTmp, 0);
        cmpTmp2.setLayout(new GridLayout(3, false));
        gdTmp = new GridData(768);
        cmpTmp2.setLayoutData(gdTmp);
        this.btAddAncilFile = UIUtil.createGridButton(cmpTmp2, 8, "Add...", 80, 1);
        this.btAddAncilFile.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (CreationParametersEditor.this.supportFileMode) {
                    CreationParametersEditor.this.endSupportFileMode(true);
                } else {
                    CreationParametersEditor.this.startSupportFileMode();
                }
            }
        });
        label = new Label(cmpTmp2, 0);
        label.setText("File(s) path");
        this.edAncilOrigin = new Text(cmpTmp2, 2048);
        this.edAncilOrigin.setLayoutData(new GridData(768));
        this.btRemoveAncilFile = UIUtil.createGridButton(cmpTmp2, 8, "Remove", 80, 1);
        this.btRemoveAncilFile.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (CreationParametersEditor.this.supportFileMode) {
                    CreationParametersEditor.this.endSupportFileMode(false);
                } else {
                    CreationParametersEditor.this.removeAncillaryFile();
                }
            }
        });
        label = new Label(cmpTmp2, 0);
        label.setText("Destination");
        this.edAncilDestination = new Text(cmpTmp2, 2048);
        this.edAncilDestination.setLayoutData(new GridData(768));
        this.endSupportFileMode(false);
    }

    private void removeAncillaryFile() {
        try {
            int n = this.lbAncilList.getSelectionIndex();
            if (n == -1) {
                return;
            }
            this.lbAncilList.remove(n);
            if (n >= this.lbAncilList.getItemCount()) {
                n = this.lbAncilList.getItemCount() - 1;
            }
            this.lbAncilList.select(n);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void startSupportFileMode() {
        try {
            this.supportFileMode = true;
            this.btAddAncilFile.setText("Accept");
            this.btRemoveAncilFile.setText("Discard");
            this.edAncilOrigin.setEnabled(true);
            this.edAncilDestination.setEnabled(true);
            this.edAncilDestination.setText(File.separator + Parameters.SUPPORTFILE_SAMENAME);
            this.edAncilOrigin.setFocus();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private boolean endSupportFileMode(boolean saveData) {
        try {
            if (saveData) {
                String origin = this.edAncilOrigin.getText().trim();
                if (origin.isEmpty()) {
                    Dialogs.showError(this.shell, "You must specify a file or a pattern.", null);
                    this.edAncilOrigin.setFocus();
                    return false;
                }
                String destination = this.edAncilDestination.getText().trim();
                if (destination.isEmpty()) {
                    Dialogs.showError(this.shell, "You must specify a destination.", null);
                    this.edAncilDestination.setFocus();
                    return false;
                }
                this.lbAncilList.add(origin + SEPARATOR + destination);
                this.lbAncilList.select(this.lbAncilList.getItemCount() - 1);
            }
            this.btAddAncilFile.setText("Add...");
            this.btRemoveAncilFile.setText("Remove");
            this.edAncilOrigin.setEnabled(false);
            this.edAncilOrigin.setText("");
            this.edAncilDestination.setEnabled(false);
            this.edAncilDestination.setText("");
            this.supportFileMode = false;
            return true;
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
            return false;
        }
    }

    private void updatePackageType() {
        int n = this.lbTypes.getSelectionIndex();
        if (n == -1) {
            this.btOptions.setEnabled(false);
            this.edDescription.setText("");
            return;
        }
        switch (n) {
            case 0: {
                this.btOptions.setEnabled(this.optEditors.get(n) != null);
                this.edDescription.setText("Simple package where translatable files are extracted into XLIFF documents.\nYou can translate this package with any XLIFF editor and many XML-enabled tools.");
                break;
            }
            case 1: {
                this.btOptions.setEnabled(false);
                this.edDescription.setText("Simple package where translatable files are extracted into PO files.\nYou can translate this package with any PO editor.");
                break;
            }
            case 2: {
                this.btOptions.setEnabled(false);
                this.edDescription.setText("Package where the files to translate are converted into an RTF file with Trados-compatible styles.\nYou can translate this package with Trados Translator's Workbench or any compatible tool.");
                break;
            }
            case 3: {
                this.btOptions.setEnabled(false);
                this.edDescription.setText("Package where the files are extracted to XLIFF then converted into an Trados-compatible RTF file.\nYou can translate this package with Trados Translator's Workbench or any compatible tool.");
                break;
            }
            case 4: {
                this.btOptions.setEnabled(this.optEditors.get(n) != null);
                this.edDescription.setText("OmegaT project with all its files and directory structure in place.\nYou can translate this package with OmegaT.");
                break;
            }
            case 5: {
                this.btOptions.setEnabled(this.optEditors.get(n) != null);
                this.edDescription.setText("Package where translatable files are uploaded to an online Transifex project.\nYou can translate this package with the online Transifex editor or locally with PO editors. You can also use OmegaT to access the remote project directly.");
                break;
            }
            case 6: {
                this.btOptions.setEnabled(false);
                this.edDescription.setText("Simple package where translatable files are extracted into a XINI document.\nYou can translate this package with ONTRAM.");
                break;
            }
            case 7: {
                this.btOptions.setEnabled(this.optEditors.get(n) != null);
                this.edDescription.setText("Simple package with XLIFF 2.0 experimental files.\nNot for real projects. The XLIFF 2.0 format is defined yet. See XLIFF TC for more information or to provide feedback.");
                break;
            }
            case 8: {
                this.btOptions.setEnabled(false);
                this.edDescription.setText("Package where the files to translate are converted into a Versified RTF file with Trados-compatible styles.\nYou can translate this package with Trados Translator's Workbench, WordFast or any RTF compatible editor.");
                break;
            }
            case 9: {
                this.btOptions.setEnabled(this.optEditors.get(n) != null);
                this.edDescription.setText("Package where the files to translate are converted into tab-delimited tables.\nYou can translate this package with a spreadsheet application.");
            }
        }
    }

    private IParameters createParameters(String className) {
        IParameters p = null;
        try {
            p = (IParameters)Class.forName(className).newInstance();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
        }
        return p;
    }

    private void editOptions() {
        try {
            IParameters p;
            int n = this.lbTypes.getSelectionIndex();
            if (n == -1) {
                return;
            }
            IEditorDescriptionProvider descProv = (IEditorDescriptionProvider)Class.forName(this.optEditors.get(n)).newInstance();
            if (this.gedit == null) {
                this.gedit = new GenericEditor();
            }
            if (!this.gedit.edit(p = this.optStrings.get(n), descProv, false, this.context)) {
                return;
            }
            this.optStrings.set(n, p);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void callMoreInfo() {
        try {
            int n = this.lbTypes.getSelectionIndex();
            if (n == -1) {
                return;
            }
            Util.openWikiTopic((String)this.optMoreInfo.get(n));
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData() {
        this.pnlPackageDir.setText(this.params.getPackageDirectory());
        this.edPackageName.setText(this.params.getPackageName());
        this.btCreateZip.setSelection(this.params.getCreateZip());
        this.chkSendOutput.setSelection(this.params.getSendOutput());
        String current = this.params.getWriterClass();
        int n = 0;
        for (String str : this.writers) {
            if (str.equals(current)) break;
            ++n;
        }
        this.lbTypes.select(n);
        IParameters p = this.optStrings.get(n);
        if (p != null) {
            p.fromString(this.params.getWriterOptions());
        }
        List list = this.params.convertSupportFilesToList(this.params.getSupportFiles());
        for (String item : list) {
            this.lbAncilList.add(item.replace(Parameters.SUPPORTFILEDEST_SEP, SEPARATOR));
        }
        this.updatePackageType();
    }

    private boolean saveData() {
        this.result = false;
        if (this.pnlPackageDir.getText().trim().length() == 0) {
            return this.result;
        }
        if (this.edPackageName.getText().trim().length() == 0) {
            return this.result;
        }
        this.params.setPackageDirectory(this.pnlPackageDir.getText().trim());
        this.params.setPackageName(this.edPackageName.getText().trim());
        this.params.setCreateZip(this.btCreateZip.getSelection());
        int n = this.lbTypes.getSelectionIndex();
        this.params.setWriterClass((String)this.lbTypes.getData(String.valueOf(n)));
        IParameters p = this.optStrings.get(n);
        if (p != null) {
            this.params.setWriterOptions(p.toString());
        } else {
            this.params.setWriterOptions(null);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String item : this.lbAncilList.getItems()) {
            list.add(item.replace(SEPARATOR, Parameters.SUPPORTFILEDEST_SEP));
        }
        String tmp = "";
        if (!list.isEmpty()) {
            tmp = this.params.convertSupportFilesToString(list);
        }
        this.params.setSupportFiles(tmp);
        this.params.setSendOutput(this.chkSendOutput.getSelection());
        this.result = true;
        return this.result;
    }
}

