/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.pipeline;

import java.io.File;
import java.net.URI;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.okapi.applications.rainbow.Input;
import net.sf.okapi.applications.rainbow.Project;
import net.sf.okapi.applications.rainbow.pipeline.PipelineStorage;
import net.sf.okapi.applications.rainbow.pipeline.StepInfo;
import net.sf.okapi.common.ExecutionContext;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditorMapper;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.ParametersEditorMapper;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipeline;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IPipelineDriver;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.plugins.PluginItem;
import net.sf.okapi.common.plugins.PluginsManager;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.leveraging.LeveragingStep;
import net.sf.okapi.steps.leveraging.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineWrapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, StepInfo> availableSteps;
    private Map<String, ClassLoader> pluginConnectors;
    private String path;
    private ArrayList<StepInfo> steps;
    private IPipelineDriver driver;
    private IFilterConfigurationMapper fcMapper;
    private IParametersEditorMapper peMapper;
    private PluginsManager pm;

    public PipelineWrapper(IFilterConfigurationMapper fcMapper, String appFolder, PluginsManager pm, String rootDir, String inputRootDir, String outputDir, Object uiParent, ExecutionContext context) {
        this.fcMapper = fcMapper;
        this.pm = pm;
        this.steps = new ArrayList();
        this.driver = new PipelineDriver();
        this.driver.setFilterConfigurationMapper(this.fcMapper);
        this.driver.setRootDirectories(rootDir, inputRootDir);
        this.driver.setOutputDirectory(outputDir == null ? inputRootDir : outputDir);
        this.driver.setUIParent(uiParent);
        this.driver.setExecutionContext(context);
        this.refreshAvailableStepsList();
    }

    public void refreshAvailableStepsList() {
        this.buildStepList();
        this.addFromPlugins(this.pm);
    }

    public void addFromPlugins(PluginsManager pm) {
        try {
            this.pluginConnectors = new LinkedHashMap<String, ClassLoader>();
            List<PluginItem> plugins = pm.getList();
            URLClassLoader classLoader = pm.getClassLoader();
            for (PluginItem item : plugins) {
                if (item.getType() == 32) {
                    this.pluginConnectors.put(item.getClassName(), classLoader);
                    continue;
                }
                if (item.getType() != 2) continue;
                try {
                    IPipelineStep ps = (IPipelineStep)Class.forName(item.getClassName(), true, classLoader).newInstance();
                    IParameters params = ps.getParameters();
                    StepInfo stepInfo = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), classLoader, params == null ? null : params.getClass().getName());
                    if (params != null) {
                        stepInfo.paramsData = params.toString();
                        if (item.getEditorDescriptionProvider() != null) {
                            this.peMapper.addDescriptionProvider(item.getEditorDescriptionProvider(), stepInfo.paramsClass);
                        }
                        if (item.getParamsEditor() != null) {
                            this.peMapper.addEditor(item.getParamsEditor(), stepInfo.paramsClass);
                        }
                    }
                    this.availableSteps.put(stepInfo.stepClass, stepInfo);
                }
                catch (Throwable e) {
                    this.logger.warn("Could not instantiate step '{}' because of error.\n{}", (Object)item.getClassName(), (Object)e.getMessage());
                }
            }
            if (this.fcMapper instanceof FilterConfigurationMapper) {
                ((FilterConfigurationMapper)this.fcMapper).addFromPlugins(pm);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Error when creating the plug-ins lists.\n" + e.getMessage(), e);
        }
    }

    public void setRootDirectories(String rootDir, String inputRootDir) {
        this.driver.setRootDirectories(rootDir, inputRootDir);
    }

    private void buildStepList() {
        this.availableSteps = new LinkedHashMap<String, StepInfo>();
        this.peMapper = new ParametersEditorMapper();
        try {
            IPipelineStep ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.common.RawDocumentToFilterEventsStep").newInstance();
            StepInfo step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, null);
            IParameters params = ps.getParameters();
            if (params != null) {
                step.paramsData = params.toString();
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.common.FilterEventsToRawDocumentStep").newInstance();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, null);
            params = ps.getParameters();
            if (params != null) {
                step.paramsData = params.toString();
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.leveraging.BatchTmLeveragingStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.leveraging.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.batchtranslation.BatchTranslationStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.batchtranslation.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.bomconversion.BOMConversionStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addEditor("net.sf.okapi.steps.bomconversion.ui.ParametersEditor", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.charlisting.CharListingStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.charlisting.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.codesremoval.CodesRemovalStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.codesremoval.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.common.codesimplifier.CodeSimplifierStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.common.codesimplifier.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.cleanup.CleanupStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.cleanup.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.common.ConvertSegmentsToTextUnitsStep").newInstance();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, null);
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.common.createtarget.CreateTargetStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.common.createtarget.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.desegmentation.DesegmentationStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.desegmentation.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.diffleverage.DiffLeverageStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.diffleverage.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.encodingconversion.EncodingConversionStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addEditor("net.sf.okapi.steps.encodingconversion.ui.ParametersEditor", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.enrycher.EnrycherStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.enrycher.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.externalcommand.ExternalCommandStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.externalcommand.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.common.ExtractionVerificationStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.common.ExtractionVerificationStepParameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.formatconversion.FormatConversionStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.formatconversion.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.fullwidthconversion.FullWidthConversionStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addEditor("net.sf.okapi.steps.fullwidthconversion.ui.ParametersEditor", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.generatesimpletm.GenerateSimpleTmStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.generatesimpletm.ParametersUI", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.gttbatchtranslation.GTTBatchTranslationStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.gttbatchtranslation.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.idaligner.IdBasedAlignerStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.idaligner.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.idbasedcopy.IdBasedCopyStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.idbasedcopy.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.imagemodification.ImageModificationStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.imagemodification.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.inconsistencycheck.InconsistencyCheckStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.inconsistencycheck.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.leveraging.LeveragingStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addEditor("net.sf.okapi.steps.leveraging.ui.ParametersEditor", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.linebreakconversion.LineBreakConversionStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.linebreakconversion.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.moses.ExtractionStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.filters.mosestext.FilterWriterParameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.moses.MergingStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.moses.MergingParameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.msbatchtranslation.MSBatchTranslationStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.msbatchtranslation.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.msbatchtranslation.MSBatchSubmissionStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.msbatchtranslation.SubmissionParameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.paraaligner.ParagraphAlignerStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.paraaligner.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.qualitycheck.QualityCheckStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addEditor("net.sf.okapi.lib.ui.verification.ParametersEditor", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.rainbowkit.creation.ExtractionStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addEditor("net.sf.okapi.steps.rainbowkit.ui.CreationParametersEditor", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.rainbowkit.postprocess.MergingStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.rainbowkit.postprocess.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.common.removetarget.RemoveTargetStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.common.removetarget.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.repetitionanalysis.RepetitionAnalysisStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.repetitionanalysis.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.common.ResourceSimplifierStep").newInstance();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, null);
            params = ps.getParameters();
            if (params != null) {
                step.paramsData = params.toString();
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.rtfconversion.RTFConversionStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.rtfconversion.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.scopingreport.ScopingReportStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.scopingreport.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.searchandreplace.SearchAndReplaceStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addEditor("net.sf.okapi.steps.searchandreplace.ui.ParametersEditor", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.segmentation.SegmentationStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addEditor("net.sf.okapi.steps.segmentation.ui.ParametersEditor", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.sentencealigner.SentenceAlignerStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.sentencealigner.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.simpletm2tmx.SimpleTM2TMXStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, null);
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.spacecheck.SpaceCheckStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, null);
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.termextraction.TermExtractionStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.termextraction.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.textmodification.TextModificationStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addEditor("net.sf.okapi.steps.textmodification.ui.ParametersEditor", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.tmimport.TMImportStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.tmimport.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.tokenization.TokenizationStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addEditor("net.sf.okapi.steps.tokenization.ui.ParametersEditor", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.translationcomparison.TranslationComparisonStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.translationcomparison.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.uriconversion.UriConversionStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addEditor("net.sf.okapi.steps.uriconversion.ui.ParametersEditor", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.wordcount.WordCountStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.wordcount.common.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.wordcount.SimpleWordCountStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, null);
            if (params != null) {
                step.paramsData = params.toString();
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.xmlcharfixing.XMLCharFixingStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.xmlcharfixing.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.xliffsplitter.XliffJoinerStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.xliffsplitter.XliffJoinerParameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.xliffsplitter.XliffSplitterStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.xliffsplitter.XliffSplitterParameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.xmlanalysis.XMLAnalysisStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.xmlanalysis.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.xmlvalidation.XMLValidationStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addDescriptionProvider("net.sf.okapi.steps.xmlvalidation.Parameters", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
            ps = (IPipelineStep)Class.forName("net.sf.okapi.steps.xsltransform.XSLTransformStep").newInstance();
            params = ps.getParameters();
            step = new StepInfo(ps.getName(), ps.getDescription(), ps.getClass().getName(), null, params.getClass().getName());
            if (params != null) {
                step.paramsData = params.toString();
                this.peMapper.addEditor("net.sf.okapi.steps.xsltransform.ui.ParametersEditor", step.paramsClass);
            }
            this.availableSteps.put(step.stepClass, step);
        }
        catch (InstantiationException e) {
            this.logger.warn("Could not instantiate a step.\n{}", (Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.warn("Illegal access for a step.\n{}", (Object)e.getMessage());
        }
        catch (ClassNotFoundException e) {
            this.logger.warn("Step class not found.\n{}", (Object)e.getMessage());
        }
        catch (Throwable e) {
            this.logger.warn("Error creating one of the step.\n{}", (Object)e.getMessage());
        }
    }

    public void clear() {
        this.steps.clear();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public IParametersEditorMapper getEditorMapper() {
        return this.peMapper;
    }

    public Map<String, StepInfo> getAvailableSteps() {
        return this.availableSteps;
    }

    public String getStringStorage() {
        this.copyInfoStepsToPipeline();
        PipelineStorage store = new PipelineStorage(this.availableSteps);
        store.write(this.driver.getPipeline());
        return store.getStringOutput();
    }

    public void reset() {
        this.clear();
        this.path = null;
        this.driver.setPipeline(new Pipeline());
    }

    public void loadFromStringStorageOrReset(String data) {
        if (Util.isEmpty(data)) {
            this.reset();
            return;
        }
        PipelineStorage store = new PipelineStorage(this.availableSteps, (CharSequence)data);
        this.loadPipeline(store.read(), null);
    }

    public void loadPipeline(IPipeline newPipeline, String path) {
        this.driver.setPipeline(newPipeline);
        this.steps.clear();
        for (IPipelineStep step : this.driver.getPipeline().getSteps()) {
            StepInfo infoStep = new StepInfo(step.getName(), step.getDescription(), step.getClass().getName(), step.getClass().getClassLoader(), null);
            IParameters params = step.getParameters();
            if (params != null) {
                infoStep.paramsData = params.toString();
                infoStep.paramsClass = params.getClass().getName();
            }
            this.steps.add(infoStep);
        }
        this.path = path;
    }

    public void load(String path) {
        PipelineStorage store = new PipelineStorage(this.availableSteps, path);
        this.loadPipeline(store.read(), path);
    }

    public void save(String path) {
        PipelineStorage store = new PipelineStorage(this.availableSteps, path);
        this.copyInfoStepsToPipeline();
        store.write(this.driver.getPipeline());
        this.path = path;
    }

    public IPipeline getPipeline() {
        this.copyInfoStepsToPipeline();
        return this.driver.getPipeline();
    }

    public PluginsManager getPluginsManager() {
        return this.pm;
    }

    private void copyInfoStepsToPipeline() {
        try {
            this.driver.setPipeline(new Pipeline());
            for (StepInfo stepInfo : this.steps) {
                IPipelineStep step = stepInfo.loader == null ? (IPipelineStep)Class.forName(stepInfo.stepClass).newInstance() : (IPipelineStep)Class.forName(stepInfo.stepClass, true, stepInfo.loader).newInstance();
                IParameters params = step.getParameters();
                if (params != null && stepInfo.paramsData != null) {
                    params.fromString(stepInfo.paramsData);
                }
                if (step instanceof LeveragingStep) {
                    LeveragingStep ls = (LeveragingStep)step;
                    Parameters lsParams = (Parameters)ls.getParameters();
                    String connectorClassName = lsParams.getResourceClassName();
                    ClassLoader connectorLoader = this.pluginConnectors.get(connectorClassName);
                    ls.setConnectorContext(connectorLoader);
                }
                this.driver.addStep(step);
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void copyParametersToPipeline(IPipeline pipeline) {
        List<IPipelineStep> destSteps = pipeline.getSteps();
        if (destSteps.size() != this.steps.size()) {
            throw new RuntimeException("Parameters and destination do not match.");
        }
        for (int i = 0; i < destSteps.size(); ++i) {
            StepInfo stepInfo = this.steps.get(i);
            IParameters params = destSteps.get(i).getParameters();
            if (params == null) continue;
            params.fromString(stepInfo.paramsData);
        }
    }

    public void execute(Project prj) {
        this.execute(prj, null);
    }

    public void execute(Project prj, List<LocaleId> targetLocales) {
        this.copyInfoStepsToPipeline();
        this.driver.clearItems();
        int f = -1;
        int inputRequested = this.driver.getRequestedInputCount();
        for (Input item : prj.getList(0)) {
            ++f;
            URI outURI = new File(prj.buildTargetPath(0, item.relativePath)).toURI();
            URI inpURI = new File(prj.getInputRoot(0) + File.separator + item.relativePath).toURI();
            RawDocument rawDoc = new RawDocument(inpURI, prj.buildSourceEncoding(item), prj.getSourceLanguage(), prj.getTargetLanguage());
            rawDoc.setFilterConfigId(item.filterConfigId);
            rawDoc.setId(Util.makeId(item.relativePath));
            if (targetLocales != null) {
                rawDoc.setTargetLocales(targetLocales);
            }
            BatchItemContext bic = new BatchItemContext(rawDoc, outURI, prj.buildTargetEncoding(item));
            for (int j = 1; j < 3 && j < inputRequested; ++j) {
                ArrayList<Input> list;
                if (3 <= j || (list = prj.getList(j)).size() <= f) continue;
                Input item2 = (Input)list.get(f);
                outURI = new File(prj.buildTargetPath(j, item2.relativePath)).toURI();
                inpURI = new File(prj.getInputRoot(j) + File.separator + item2.relativePath).toURI();
                rawDoc = new RawDocument(inpURI, prj.buildSourceEncoding(item), prj.getSourceLanguage(), prj.getTargetLanguage());
                rawDoc.setFilterConfigId(item2.filterConfigId);
                rawDoc.setId(Util.makeId(item2.relativePath));
                if (targetLocales != null) {
                    rawDoc.setTargetLocales(targetLocales);
                }
                bic.add(rawDoc, outURI, prj.buildTargetEncoding(item2));
            }
            this.driver.addBatchItem(bic);
        }
        this.driver.processBatch();
    }

    public void addStep(StepInfo step) {
        this.steps.add(step);
    }

    public void insertStep(int index, StepInfo step) {
        if (index == -1) {
            this.steps.add(step);
        } else {
            this.steps.add(index, step);
        }
    }

    public void removeStep(int index) {
        this.steps.remove(index);
    }

    public List<StepInfo> getSteps() {
        return this.steps;
    }
}

