/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.utilities.alignment;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.query.IQuery;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.InvalidContentException;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.ui.ClosePanel;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.connectors.google.GoogleMTv2Connector;
import net.sf.okapi.connectors.google.GoogleMTv2Parameters;
import net.sf.okapi.lib.ui.segmentation.SRXEditor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Aligner {
    protected static final String ALIGNSTATUS_KEY = "Att::AlignStatus";
    protected static final String ALIGNSTATUS_TOREVIEW = "TO-REVIEW";
    private Shell shell;
    private int result = 0;
    private ClosePanel pnlActions;
    private List srcList;
    private List trgList;
    private Text edDocument;
    private Text edName;
    private Text edCause;
    private Button btMoveUp;
    private Button btMoveDown;
    private Button btMerge;
    private Button btSplit;
    private Button btAccept;
    private Button btSkip;
    private Button btEditRules;
    private Button btEditSeg;
    private Button btToReview;
    private Button btAutoCorrect;
    private List lbIssues;
    private Text edSource;
    private Text edTarget;
    private Text edSrcSeg;
    private Text edTrgSeg;
    private Font textFont;
    private Text edCounter;
    private Button chkShowInlineCodes;
    private Button chkSyncScrolling;
    private Button chkCheckSingleSegUnit;
    private Button chkUseAutoCorrection;
    private TextContainer source;
    private TextContainer target;
    private boolean splitMode = false;
    private boolean editMode = false;
    private int indexActiveSegment;
    private GenericContent genericCont;
    private String targetSrxPath;
    private Color colorGreen;
    private Color colorAmber;
    private Color colorRed;
    private boolean canAcceptUnit;
    private int issueType;
    private boolean warnOnClosing;
    private Pattern anchors;
    private ArrayList<String> anchorList = new ArrayList();
    private boolean manualCorrection;
    private LocaleId srcLang;
    private LocaleId trgLang;
    private IHelp help;
    private IQuery mtQuery;

    protected void finalize() {
        this.dispose();
    }

    public void dispose() {
        if (this.textFont != null) {
            this.textFont.dispose();
            this.textFont = null;
        }
        if (this.shell != null) {
            this.shell.close();
            this.shell = null;
        }
        if (this.colorGreen != null) {
            this.colorGreen.dispose();
            this.colorGreen = null;
        }
        if (this.colorAmber != null) {
            this.colorAmber.dispose();
            this.colorAmber = null;
        }
        if (this.colorRed != null) {
            this.colorRed.dispose();
            this.colorRed = null;
        }
        if (this.mtQuery != null) {
            this.mtQuery.close();
            this.mtQuery = null;
        }
    }

    public void closeWithoutWarning() {
        this.warnOnClosing = false;
        this.close();
    }

    public Aligner(Shell parent, IHelp helpParam) {
        this.help = helpParam;
        this.warnOnClosing = true;
        this.anchors = Pattern.compile("((\\d+[\\.,])*\\d+)");
        this.colorGreen = new Color(null, 0, 128, 0);
        this.colorAmber = new Color(null, 255, 153, 0);
        this.colorRed = new Color(null, 220, 20, 60);
        this.genericCont = new GenericContent();
        this.shell = new Shell(parent, 66800);
        this.shell.setText("Alignment Verification");
        UIUtil.inheritIcon(this.shell, parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        this.shell.setLayout((Layout)layout);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
                if (!Aligner.this.confirmCancel()) {
                    return;
                }
                Aligner.this.result = 0;
                Aligner.this.hide();
            }
        });
        SashForm sashTop = new SashForm((Composite)this.shell, 512);
        sashTop.setLayoutData((Object)new GridData(1808));
        sashTop.setSashWidth(3);
        sashTop.setBackground(this.shell.getDisplay().getSystemColor(18));
        Composite cmpTop = new Composite((Composite)sashTop, 0);
        layout = new GridLayout(4, true);
        layout.marginWidth = 0;
        cmpTop.setLayout((Layout)layout);
        cmpTop.setLayoutData((Object)new GridData(1808));
        this.edDocument = new Text(cmpTop, 2048);
        GridData gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 4;
        this.edDocument.setLayoutData((Object)gdTmp);
        this.edDocument.setEditable(false);
        this.edCounter = new Text(cmpTop, 2048);
        gdTmp = new GridData(768);
        this.edCounter.setLayoutData((Object)gdTmp);
        this.edCounter.setEditable(false);
        this.edName = new Text(cmpTop, 2048);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 3;
        this.edName.setLayoutData((Object)gdTmp);
        this.edName.setEditable(false);
        Font font = this.edName.getFont();
        FontData[] fontData = font.getFontData();
        fontData[0].setHeight(11);
        this.textFont = new Font(font.getDevice(), fontData[0]);
        this.srcList = new List(cmpTop, 2816);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 2;
        this.srcList.setLayoutData((Object)gdTmp);
        this.srcList.setFont(this.textFont);
        this.srcList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Aligner.this.chkSyncScrolling.getSelection()) {
                    Aligner.this.synchronizeFromSource();
                } else {
                    Aligner.this.updateSourceSegmentDisplay();
                }
            }
        });
        this.trgList = new List(cmpTop, 2816);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 2;
        this.trgList.setLayoutData((Object)gdTmp);
        this.trgList.setFont(this.textFont);
        this.trgList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Aligner.this.chkSyncScrolling.getSelection()) {
                    Aligner.this.synchronizeFromTarget();
                } else {
                    Aligner.this.updateTargetSegmentDisplay();
                }
            }
        });
        this.createListContextMenus();
        SashForm sashBottom = new SashForm((Composite)sashTop, 512);
        sashBottom.setLayoutData((Object)new GridData(1808));
        sashBottom.setSashWidth(3);
        sashBottom.setBackground(this.shell.getDisplay().getSystemColor(18));
        sashTop.setWeights(new int[]{30, 70});
        Composite cmpMiddle = new Composite((Composite)sashBottom, 0);
        layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        cmpMiddle.setLayout((Layout)layout);
        cmpMiddle.setLayoutData((Object)new GridData(768));
        Composite cmpOptions = new Composite(cmpMiddle, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        cmpOptions.setLayout((Layout)layout);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 1;
        cmpOptions.setLayoutData((Object)gdTmp);
        this.chkSyncScrolling = new Button(cmpOptions, 32);
        this.chkSyncScrolling.setText("Synchronize scrolling");
        this.chkSyncScrolling.setSelection(true);
        this.chkSyncScrolling.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Aligner.this.chkSyncScrolling.getSelection()) {
                    Aligner.this.synchronizeFromTarget();
                }
            }
        });
        this.chkShowInlineCodes = new Button(cmpOptions, 32);
        this.chkShowInlineCodes.setText("Display in-line codes with generic markers");
        this.chkShowInlineCodes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Aligner.this.fillSourceList(Aligner.this.srcList.getSelectionIndex());
                Aligner.this.updateSourceDisplay();
                Aligner.this.fillTargetList(Aligner.this.trgList.getSelectionIndex());
                Aligner.this.updateTargetDisplay();
            }
        });
        this.chkUseAutoCorrection = new Button(cmpOptions, 32);
        this.chkUseAutoCorrection.setText("Try an auto-correction automatically");
        this.chkCheckSingleSegUnit = new Button(cmpOptions, 32);
        this.chkCheckSingleSegUnit.setText("Verify in-line codes for text-unit with a single segment");
        int buttonWidth = 100;
        Composite cmpButtons = new Composite(cmpMiddle, 0);
        layout = new GridLayout(5, false);
        layout.marginWidth = 0;
        cmpButtons.setLayout((Layout)layout);
        gdTmp = new GridData(770);
        gdTmp.horizontalSpan = 3;
        cmpButtons.setLayoutData((Object)gdTmp);
        this.btAutoCorrect = UIUtil.createGridButton(cmpButtons, 8, "Try Auto-Fix", buttonWidth, -1);
        this.btAutoCorrect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Aligner.this.autoCorrect();
            }
        });
        this.btEditRules = UIUtil.createGridButton(cmpButtons, 8, "Edit Rules...", buttonWidth, -1);
        this.btEditRules.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Aligner.this.editRules();
            }
        });
        this.btMoveUp = UIUtil.createGridButton(cmpButtons, 8, "Move Up", buttonWidth, -1);
        this.btMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Aligner.this.moveSegment(-1);
            }
        });
        this.btMerge = UIUtil.createGridButton(cmpButtons, 8, "Join Next", buttonWidth, -1);
        this.btMerge.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Aligner.this.mergeWithNext();
            }
        });
        this.btAccept = UIUtil.createGridButton(cmpButtons, 8, "Accept", buttonWidth, -1);
        this.btAccept.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Aligner.this.splitMode) {
                    Aligner.this.endSplitMode(true);
                } else if (Aligner.this.editMode) {
                    Aligner.this.endEditMode(true);
                } else {
                    Aligner.this.result = 1;
                    if (!Aligner.this.saveData()) {
                        return;
                    }
                    Aligner.this.hide();
                }
            }
        });
        this.btToReview = UIUtil.createGridButton(cmpButtons, 32, "To review later", buttonWidth, -1);
        this.btToReview.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Aligner.this.toggleToReview();
            }
        });
        this.btEditSeg = UIUtil.createGridButton(cmpButtons, 8, "Edit Segment...", buttonWidth, -1);
        this.btEditSeg.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Aligner.this.startEditMode();
            }
        });
        this.btMoveDown = UIUtil.createGridButton(cmpButtons, 8, "Move Down", buttonWidth, -1);
        this.btMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Aligner.this.moveSegment(1);
            }
        });
        this.btSplit = UIUtil.createGridButton(cmpButtons, 8, "Split...", buttonWidth, -1);
        this.btSplit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Aligner.this.startSplitMode();
            }
        });
        this.btSkip = UIUtil.createGridButton(cmpButtons, 8, "Skip", buttonWidth, -1);
        this.btSkip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Aligner.this.splitMode) {
                    Aligner.this.endSplitMode(false);
                    return;
                }
                if (Aligner.this.editMode) {
                    Aligner.this.endEditMode(false);
                    return;
                }
                Aligner.this.result = 2;
                Aligner.this.hide();
            }
        });
        this.edCause = new Text(cmpMiddle, 2048);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 4;
        this.edCause.setLayoutData((Object)gdTmp);
        this.edCause.setEditable(false);
        this.edCause.setForeground(this.shell.getDisplay().getSystemColor(1));
        this.lbIssues = new List(cmpMiddle, 2816);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 4;
        gdTmp.heightHint = 32;
        this.lbIssues.setLayoutData((Object)gdTmp);
        this.lbIssues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Aligner.this.gotoIssue();
            }
        });
        Composite cmpBottom = new Composite((Composite)sashBottom, 0);
        sashBottom.setWeights(new int[]{14, 86});
        layout = new GridLayout();
        layout.marginWidth = 0;
        cmpBottom.setLayout((Layout)layout);
        cmpBottom.setLayoutData((Object)new GridData(1808));
        this.edSrcSeg = new Text(cmpBottom, 2882);
        this.edSrcSeg.setEditable(false);
        gdTmp = new GridData(1808);
        gdTmp.heightHint = 16;
        this.edSrcSeg.setLayoutData((Object)gdTmp);
        this.edSrcSeg.setFont(this.textFont);
        this.edTrgSeg = new Text(cmpBottom, 2882);
        this.edTrgSeg.setEditable(false);
        gdTmp = new GridData(1808);
        gdTmp.heightHint = 16;
        this.edTrgSeg.setLayoutData((Object)gdTmp);
        this.edTrgSeg.setFont(this.textFont);
        this.edTrgSeg.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 13) {
                    e.doit = true;
                }
            }
        });
        Label label = new Label(cmpBottom, 0);
        label.setText("Full text unit:");
        gdTmp = new GridData();
        label.setLayoutData((Object)gdTmp);
        this.edSource = new Text(cmpBottom, 2882);
        this.edSource.setEditable(false);
        gdTmp = new GridData(1808);
        gdTmp.heightHint = 32;
        this.edSource.setLayoutData((Object)gdTmp);
        this.edSource.setFont(this.textFont);
        this.edTarget = new Text(cmpBottom, 2882);
        this.edTarget.setEditable(false);
        gdTmp = new GridData(1808);
        gdTmp.heightHint = 32;
        this.edTarget.setLayoutData((Object)gdTmp);
        this.edTarget.setFont(this.textFont);
        SelectionAdapter CloseActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.getData().equals("h")) {
                    if (Aligner.this.help != null) {
                        Aligner.this.help.showWiki("Rainbow - Alignment Verification");
                    }
                    return;
                }
                if (e.widget.getData().equals("c")) {
                    if (!Aligner.this.confirmCancel()) {
                        return;
                    }
                    Aligner.this.result = 0;
                    Aligner.this.hide();
                }
            }
        };
        this.pnlActions = new ClosePanel((Composite)this.shell, 0, CloseActions, true);
        gdTmp = new GridData(768);
        this.pnlActions.setLayoutData(gdTmp);
        this.pnlActions.btClose.setText("Cancel");
        this.shell.setDefaultButton(this.btAccept);
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 700) {
            startSize.x = 700;
        }
        if (startSize.y < 700) {
            startSize.y = 700;
        }
        this.shell.setSize(startSize);
        Dialogs.centerWindow(this.shell, parent);
    }

    private void createListContextMenus() {
        Menu contextMenu = new Menu((Decorations)this.shell, 8);
        MenuItem menuItem = new MenuItem(contextMenu, 8);
        menuItem.setText("Get Machine Translation of &Source");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Aligner.this.getGist(false);
            }
        });
        menuItem = new MenuItem(contextMenu, 8);
        menuItem.setText("Get Machine Translation of &Target");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Aligner.this.getGist(true);
            }
        });
        this.srcList.setMenu(contextMenu);
        this.trgList.setMenu(contextMenu);
    }

    public boolean wasModifiedManually() {
        return this.manualCorrection;
    }

    private boolean confirmCancel() {
        try {
            if (!this.warnOnClosing) {
                return true;
            }
            MessageBox dlg = new MessageBox(this.shell, 452);
            dlg.setMessage("Do you really want to interrupt this alignment?");
            dlg.setText(this.shell.getText());
            return dlg.open() == 64;
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
            return false;
        }
    }

    public void setInfo(String targetSrxPath, boolean checkSingleSegUnit, boolean useAutoCorrection, LocaleId sourceLanguage, LocaleId targetLanguage, String mtKey) {
        this.srcLang = sourceLanguage;
        this.trgLang = targetLanguage;
        this.targetSrxPath = targetSrxPath;
        this.chkCheckSingleSegUnit.setSelection(checkSingleSegUnit);
        this.chkUseAutoCorrection.setSelection(useAutoCorrection);
        if (this.mtQuery == null && !Util.isEmpty(mtKey)) {
            this.mtQuery = new GoogleMTv2Connector();
            GoogleMTv2Parameters prm = new GoogleMTv2Parameters();
            prm.setApiKey(mtKey);
            this.mtQuery.open();
        }
    }

    private void gotoIssue() {
        try {
            int n = this.lbIssues.getSelectionIndex();
            if (n == -1) {
                return;
            }
            int p = this.lbIssues.getItem(n).indexOf(58);
            if (p != -1) {
                p = Integer.valueOf(this.lbIssues.getItem(n).substring(0, p));
                this.trgList.setSelection(p - 1);
                this.synchronizeFromTarget();
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void synchronizeFromSource() {
        this.updateSourceSegmentDisplay();
        int n = this.srcList.getSelectionIndex();
        if (n >= this.trgList.getItemCount()) {
            this.edTrgSeg.setText("");
            return;
        }
        this.trgList.setSelection(n);
        this.updateTargetSegmentDisplay();
    }

    private void synchronizeFromTarget() {
        this.updateTargetSegmentDisplay();
        int n = this.trgList.getSelectionIndex();
        if (n >= this.srcList.getItemCount()) {
            this.edSrcSeg.setText("");
            return;
        }
        this.srcList.setSelection(n);
        this.updateSourceSegmentDisplay();
    }

    private void updateSourceDisplay() {
        this.edSource.setText(this.genericCont.printSegmentedContent(this.source, true, !this.chkShowInlineCodes.getSelection()));
    }

    private void updateTargetDisplay() {
        this.edTarget.setText(this.genericCont.printSegmentedContent(this.target, true, !this.chkShowInlineCodes.getSelection()));
    }

    private void updateSourceSegmentDisplay() {
        int n = this.srcList.getSelectionIndex();
        if (n < 0) {
            this.edSrcSeg.setText("");
        } else {
            this.edSrcSeg.setText(this.srcList.getItem(n));
        }
    }

    private void updateTargetSegmentDisplay() {
        int n = this.trgList.getSelectionIndex();
        if (n < 0) {
            this.edTrgSeg.setText("");
        } else {
            this.edTrgSeg.setText(this.trgList.getItem(n));
        }
        n = this.trgList.getSelectionIndex();
        int count = this.trgList.getItemCount();
        this.btMoveUp.setEnabled(n > 0);
        this.btMoveDown.setEnabled(n < count - 1 && n > -1);
        this.btMerge.setEnabled(n < count - 1 && n > -1);
        this.btSplit.setEnabled(count > 0 && n > -1);
    }

    private void toggleToReview() {
        if (this.target.hasProperty(ALIGNSTATUS_KEY)) {
            this.target.removeProperty(ALIGNSTATUS_KEY);
        } else {
            this.target.setProperty(new Property(ALIGNSTATUS_KEY, ALIGNSTATUS_TOREVIEW));
        }
    }

    private void moveSegment(int direction) {
        try {
            int n = this.trgList.getSelectionIndex();
            if (direction != 1 && direction != -1) {
                return;
            }
            if (direction == 1 ? n + 1 > this.trgList.getItemCount() : n < 1) {
                return;
            }
            this.target.getSegments().swap(n + direction, n);
            this.updateTargetDisplay();
            this.fillTargetList(n + direction);
            this.trgList.setFocus();
            this.hasIssue(true, true, false);
            this.synchronizeFromTarget();
            this.manualCorrection = true;
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void mergeWithNext() {
        try {
            int n = this.trgList.getSelectionIndex();
            if (n < 0) {
                return;
            }
            this.target.getSegments().joinWithNext(n);
            this.updateTargetDisplay();
            this.fillTargetList(n);
            this.trgList.setFocus();
            this.hasIssue(true, true, true);
            this.manualCorrection = true;
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void splitSegment(int segIndex, int start, int end) {
        if (start == end && start == 0) {
            return;
        }
        int partIndex = this.target.getSegments().getPartIndex(segIndex);
        this.target.split(partIndex, start, end, false);
        this.manualCorrection = true;
    }

    public void close() {
        this.shell.close();
    }

    private int showDialog(ITextUnit tu) {
        this.edName.setText("");
        if (tu != null && tu.getName().length() > 0) {
            this.edName.setText(tu.getName());
        }
        this.shell.setVisible(true);
        this.trgList.setFocus();
        Display Disp = this.shell.getDisplay();
        while (this.shell.isVisible()) {
            if (Disp.readAndDispatch()) continue;
            Disp.sleep();
        }
        return this.result;
    }

    public void setDocumentName(String name) {
        this.edDocument.setText(name);
    }

    public int align(ITextUnit tu, int currentSource, int totalTarget) {
        this.manualCorrection = false;
        if (!tu.hasTarget(this.trgLang)) {
            return 2;
        }
        this.source = tu.getSource();
        this.target = tu.getTarget(this.trgLang);
        this.btToReview.setSelection(false);
        if (this.source.contentIsOneSegment() && this.target.contentIsOneSegment()) {
            return 1;
        }
        if (this.hasIssue(false, true, true)) {
            this.setData();
            if (this.issueType == 1) {
                this.lbIssues.setSelection(0);
                this.gotoIssue();
            }
            if (this.chkUseAutoCorrection.getSelection()) {
                this.autoCorrect();
            }
            this.edCounter.setText(String.format("Source: #%d / Targets: %d", currentSource, totalTarget));
            return this.showDialog(tu);
        }
        return 1;
    }

    private void hide() {
        this.shell.setVisible(false);
        if (this.shell.getMinimized()) {
            this.shell.setMinimized(false);
        }
    }

    private void fillTargetList(int selection) {
        this.trgList.removeAll();
        boolean useGeneric = this.chkShowInlineCodes.getSelection();
        for (Segment seg : this.target.getSegments()) {
            if (useGeneric) {
                this.trgList.add(this.genericCont.setContent(seg.text).toString());
                continue;
            }
            this.trgList.add(seg.text.toText());
        }
        if (this.trgList.getItemCount() > 0 && selection < this.trgList.getItemCount()) {
            this.trgList.setSelection(selection);
        }
        if (!this.edTrgSeg.getEditable()) {
            this.updateTargetSegmentDisplay();
        }
    }

    private void fillSourceList(int selection) {
        this.srcList.removeAll();
        boolean useGeneric = this.chkShowInlineCodes.getSelection();
        for (Segment seg : this.source.getSegments()) {
            if (useGeneric) {
                this.srcList.add(this.genericCont.setContent(seg.text).toString());
                continue;
            }
            this.srcList.add(seg.toString());
        }
        if (this.srcList.getItemCount() > 0 && selection < this.srcList.getItemCount()) {
            this.srcList.setSelection(selection);
        }
        this.updateSourceSegmentDisplay();
    }

    private void setData() {
        this.updateSourceDisplay();
        this.fillSourceList(0);
        this.updateTargetDisplay();
        this.fillTargetList(0);
    }

    private boolean saveData() {
        if (this.splitMode) {
            return false;
        }
        int i = 0;
        for (Segment seg : this.source.getSegments()) {
            seg.id = String.valueOf(i);
            ++i;
        }
        i = 0;
        for (Segment seg : this.target.getSegments()) {
            seg.id = String.valueOf(i);
            ++i;
        }
        return true;
    }

    private void startSplitMode() {
        this.indexActiveSegment = this.trgList.getSelectionIndex();
        if (this.indexActiveSegment == -1) {
            return;
        }
        this.splitMode = true;
        this.toggleFields(true);
    }

    private Range conv(Point point) {
        return new Range(point.x, point.y);
    }

    private void endSplitMode(boolean accept) {
        try {
            if (accept) {
                Range sel = this.genericCont.getCodedTextPosition(this.conv(this.edTrgSeg.getSelection()));
                this.splitSegment(this.indexActiveSegment, sel.start, sel.end);
            }
            this.hasIssue(true, true, true);
            this.splitMode = false;
            this.toggleFields(false);
            if (accept) {
                this.updateTargetDisplay();
                this.fillTargetList(this.indexActiveSegment);
            } else {
                this.updateTargetSegmentDisplay();
            }
            this.trgList.setFocus();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void editRules() {
        try {
            SRXEditor editor = new SRXEditor(this.shell, true, this.help);
            editor.showDialog(this.targetSrxPath);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void startEditMode() {
        this.indexActiveSegment = this.trgList.getSelectionIndex();
        if (this.indexActiveSegment == -1) {
            return;
        }
        this.editMode = true;
        this.toggleFields(true);
    }

    private void endEditMode(boolean accept) {
        try {
            if (accept) {
                try {
                    GenericContent.updateFragment(this.edTrgSeg.getText(), this.target.getSegments().get((int)this.indexActiveSegment).text, true);
                }
                catch (InvalidContentException e) {
                    Dialogs.showError(this.shell, e.getMessage(), null);
                    return;
                }
                this.manualCorrection = true;
            }
            this.hasIssue(true, true, true);
            this.editMode = false;
            this.toggleFields(false);
            if (accept) {
                this.updateTargetDisplay();
                this.fillTargetList(this.indexActiveSegment);
            } else {
                this.updateTargetSegmentDisplay();
            }
            this.trgList.setFocus();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void toggleFields(boolean specialMode) {
        if (specialMode) {
            this.genericCont.setContent(this.target.getSegments().get((int)this.indexActiveSegment).text);
            this.edTrgSeg.setText(this.genericCont.toString());
            this.edTrgSeg.setFocus();
            this.btAccept.setEnabled(true);
        } else {
            this.btAccept.setEnabled(this.canAcceptUnit);
        }
        this.edTrgSeg.setEditable(specialMode);
        this.srcList.setEnabled(!specialMode);
        this.trgList.setEnabled(!specialMode);
        this.btEditRules.setVisible(!specialMode);
        this.btEditSeg.setVisible(!specialMode);
        this.btMoveUp.setVisible(!specialMode);
        this.btMoveDown.setVisible(!specialMode);
        this.btMerge.setVisible(!specialMode);
        this.btSplit.setVisible(!specialMode);
        this.btAutoCorrect.setVisible(!specialMode);
        this.btToReview.setVisible(!specialMode);
        this.chkSyncScrolling.setVisible(!specialMode);
        this.lbIssues.setEnabled(!specialMode);
        if (specialMode) {
            if (this.splitMode) {
                this.btAccept.setText("Accept Split");
            } else {
                this.btAccept.setText("Accept Changes");
            }
            this.btSkip.setText("Discard");
        } else {
            this.btAccept.setText("Accept");
            this.btSkip.setText("Skip");
        }
    }

    private void resetIssues() {
        this.issueType = 0;
        this.lbIssues.removeAll();
    }

    private boolean hasIssue(boolean forceIssueDisplay, boolean resetList, boolean gotoIssue) {
        try {
            int trgSegCount;
            int srcSegCount;
            if (resetList) {
                this.resetIssues();
            }
            if ((srcSegCount = this.source.getSegments().count()) != (trgSegCount = this.target.getSegments().count())) {
                this.addIssue(2, "Error- Different number of segments in source and target.");
                return this.updateIssueStatus(gotoIssue);
            }
            if (srcSegCount == 1 && !this.chkCheckSingleSegUnit.getSelection()) {
                if (forceIssueDisplay) {
                    this.addIssue(0, null);
                }
                return this.updateIssueStatus(gotoIssue);
            }
            int i = 0;
            ISegments trgSegs = this.target.getSegments();
            for (Segment srcSeg : this.source.getSegments()) {
                Segment trgSeg = trgSegs.get(i);
                if (trgSeg == null) {
                    this.addIssue(1, String.format("%d: Warning- No target segment for the source segment.", i + 1));
                }
                if (srcSeg.text.getCodes().size() != trgSeg.text.getCodes().size()) {
                    this.addIssue(1, String.format("%d: Warning- Different number of inline codes in source and target.", i + 1));
                }
                this.checkAnchors(srcSeg.text, trgSeg.text, i);
                ++i;
            }
            if (forceIssueDisplay) {
                this.addIssue(0, null);
            }
            return this.updateIssueStatus(gotoIssue);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
            return false;
        }
    }

    private void checkAnchors(TextFragment source, TextFragment target, int index) {
        this.anchorList.clear();
        for (Code code : source.getCodes()) {
            this.anchorList.add(code.getData());
        }
        for (Code code : target.getCodes()) {
            if (!this.anchorList.contains(code.getData())) {
                this.addIssue(1, String.format("%d: Warning- Target inline code '%s' is not in the source.", index + 1, code.getData()));
                continue;
            }
            this.anchorList.set(this.anchorList.indexOf(code.getData()), "");
        }
        boolean extra = false;
        StringBuilder tmp = new StringBuilder();
        for (String str : this.anchorList) {
            if (str.length() == 0) continue;
            if (tmp.length() > 0) {
                tmp.append(", ");
            }
            tmp.append("'" + str + "'");
            extra = true;
        }
        if (extra) {
            this.addIssue(1, String.format("%d: Warning- Source inline codes not found in the target: %s", index + 1, tmp.toString()));
        }
        Matcher m = this.anchors.matcher(source.getCodedText());
        this.anchorList.clear();
        while (m.find()) {
            this.anchorList.add(m.group());
        }
        m = this.anchors.matcher(target.getCodedText());
        while (m.find()) {
            if (!this.anchorList.contains(m.group())) {
                this.addIssue(1, String.format("%d: Warning- Extra pattern '%s' in target.", index + 1, m.group()));
                continue;
            }
            this.anchorList.remove(m.group());
        }
        if (this.anchorList.size() > 0) {
            tmp = new StringBuilder();
            for (String str : this.anchorList) {
                if (tmp.length() > 0) {
                    tmp.append(", ");
                }
                tmp.append("'" + str + "'");
            }
            this.addIssue(1, String.format("%d: Warning- One or more missing patterns in target: %s", index + 1, tmp.toString()));
        }
    }

    private boolean autoCorrect() {
        boolean modified = false;
        int n = this.trgList.getSelectionIndex();
        if (n == -1) {
            n = 0;
        }
        try {
            int toJoin;
            ISegments sourceSegments = this.source.getSegments();
            ISegments targetSegments = this.target.getSegments();
            int lastMatch = -1;
            int trgStart = 0;
            int srcNoMatchCount = 0;
            for (Segment srcSeg : sourceSegments) {
                boolean matchFound = false;
                String srcText = srcSeg.toString();
                for (int j = trgStart; j < targetSegments.count(); ++j) {
                    String s2 = targetSegments.get(j).toString();
                    if (!srcText.equals(s2)) continue;
                    if (srcNoMatchCount == 1) {
                        toJoin = lastMatch == -1 ? j - 1 : j - 1 - lastMatch - 1;
                        if (toJoin > 0) {
                            for (int k = 0; k < toJoin; ++k) {
                                targetSegments.joinWithNext(lastMatch + 1);
                            }
                            if (!modified) {
                                this.resetIssues();
                                modified = true;
                            }
                            this.addIssue(1, String.format("%d: Warning- Segment auto-corrected by joining two or more.", lastMatch + 1 + 1));
                            j -= toJoin;
                        }
                        lastMatch = j;
                        trgStart = j + 1;
                        srcNoMatchCount = 0;
                        matchFound = true;
                        break;
                    }
                    lastMatch = j;
                    trgStart = j + 1;
                    srcNoMatchCount = 0;
                    matchFound = true;
                    break;
                }
                if (matchFound) continue;
                ++srcNoMatchCount;
            }
            if (srcNoMatchCount == 1) {
                if (lastMatch == -1) {
                    if (targetSegments.count() > 1) {
                        targetSegments.joinAll();
                        if (!modified) {
                            this.resetIssues();
                            modified = true;
                        }
                        this.addIssue(1, "Warning- All target segments have been merged into one by auto-correction.");
                    }
                } else {
                    toJoin = targetSegments.count() - 1 - lastMatch - 1;
                    if (toJoin > 0) {
                        for (int k = 0; k < toJoin; ++k) {
                            targetSegments.joinWithNext(lastMatch + 1);
                        }
                        if (!modified) {
                            this.resetIssues();
                            modified = true;
                        }
                        this.addIssue(1, String.format("%d: Warning- Segment auto-corrected by joining two or more.", lastMatch + 1 + 1));
                    }
                }
            }
            this.updateTargetDisplay();
            if (modified) {
                this.fillTargetList(0);
                if (this.chkSyncScrolling.getSelection()) {
                    this.synchronizeFromTarget();
                }
                this.trgList.setFocus();
                this.hasIssue(true, false, true);
            }
        }
        catch (Throwable e) {
            this.addIssue(2, "Error- Auto-correction error occured.");
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
        return modified;
    }

    private void addIssue(int type, String causeText) {
        switch (type) {
            case 1: {
                this.lbIssues.add(causeText);
                if (this.issueType >= 1) break;
                this.issueType = 1;
                break;
            }
            case 2: {
                this.lbIssues.add(causeText);
                this.issueType = 2;
            }
        }
    }

    private boolean updateIssueStatus(boolean gotoIssue) {
        switch (this.issueType) {
            case 0: {
                this.edCause.setText("No issue automatically detected.");
                this.edCause.setBackground(this.colorGreen);
                break;
            }
            case 1: {
                this.edCause.setText("One or more WARNINGS detected.");
                this.edCause.setBackground(this.colorAmber);
                if (this.lbIssues.getItemCount() <= 0) break;
                this.lbIssues.setSelection(0);
                if (!gotoIssue) break;
                this.gotoIssue();
                break;
            }
            case 2: {
                this.edCause.setText("One or more ERRORS detected.");
                this.edCause.setBackground(this.colorRed);
            }
        }
        this.canAcceptUnit = this.issueType < 2;
        this.btAccept.setEnabled(this.canAcceptUnit);
        return this.issueType > 0;
    }

    private void getGist(boolean targetToSource) {
        try {
            String text;
            if (this.mtQuery != null) {
                TextFragment oriFrag;
                int n;
                if (targetToSource) {
                    n = this.trgList.getSelectionIndex();
                    if (n == -1) {
                        return;
                    }
                    this.mtQuery.setLanguages(this.trgLang, this.srcLang);
                    oriFrag = this.target.getSegments().get((int)n).text;
                } else {
                    n = this.srcList.getSelectionIndex();
                    if (n == -1) {
                        return;
                    }
                    this.mtQuery.setLanguages(this.srcLang, this.trgLang);
                    oriFrag = this.source.getSegments().get((int)n).text;
                }
                this.mtQuery.query(oriFrag);
                text = this.mtQuery.hasNext() ? "Original segment:\n" + oriFrag.toText() + "\n\nPossible translation:\n" + this.mtQuery.next().target.toText() : "No translation found for the select segment.";
            } else {
                text = "No MT key has been specified. This function is disabled.";
            }
            MessageBox dlg = new MessageBox(this.shell, 34);
            dlg.setMessage(text);
            dlg.setText("Translation Query");
            dlg.open();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }
}

