/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.utilities.alignment;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.TextContainer;

public class DbStore {
    public static final int GROUP_PK = 0;
    public static final int GROUP_NAME = 0;
    public static final int GROUP_TYPE = 0;
    public static final int GROUP_PREWS = 0;
    public static final int GROUP_TRANS = 0;
    public static final String TBLNAME_SOURCE = "Source";
    public static final int SOURCE_KEY = 0;
    public static final String SOURCE_NKEY = "Key";
    public static final int SOURCE_GKEY = 1;
    public static final String SOURCE_NTMP = "Tmp";
    public static final int SOURCE_TMP = 2;
    public static final String SOURCE_NGKEY = "GKey";
    public static final int SOURCE_XKEY = 3;
    public static final String SOURCE_NXKEY = "XKey";
    public static final int SOURCE_SEGKEY = 4;
    public static final String SOURCE_NSEGKEY = "SegKey";
    public static final int SOURCE_NAME = 5;
    public static final String SOURCE_NNAME = "Name";
    public static final int SOURCE_TYPE = 6;
    public static final String SOURCE_NTYPE = "Type";
    public static final int SOURCE_TEXT = 7;
    public static final String SOURCE_NTEXT = "Text";
    public static final int SOURCE_CODES = 8;
    public static final String SOURCE_NCODES = "Codes";
    public static final int SOURCE_PREWS = 9;
    public static final String SOURCE_NPREWS = "PreWS";
    public static final int SOURCE_TRANS = 10;
    public static final String SOURCE_NTRANS = "Trans";
    public static final int TARGET_PK = 0;
    public static final int TARGET_XKEY = 0;
    public static final int TARGET_SKEY = 0;
    public static final int TARGET_TEXT = 0;
    public static final int TARGET_CODES = 0;
    private static final String DATAFILE_EXT = ".h2.db";
    private Connection conn = null;

    public DbStore() {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void create(String folder, String dbName, boolean deleteExistingDB) {
        Statement stm = null;
        try {
            this.close();
            String path = folder + File.separatorChar + dbName;
            if (new File(path + DATAFILE_EXT).exists()) {
                if (!deleteExistingDB) {
                    return;
                }
                Util.deleteDirectory(folder, false);
            } else {
                Util.createDirectories(path);
            }
            this.conn = DriverManager.getConnection("jdbc:h2:" + path, "sa", "");
            stm = this.conn.createStatement();
            stm.execute("CREATE TABLE Source (Key INTEGER IDENTITY PRIMARY KEY,Tmp INTEGER,GKey INTEGER,XKey VARCHAR,SegKey INTEGER,Name VARCHAR,Type VARCHAR,Text VARCHAR,Codes VARCHAR,PreWS BOOLEAN,Trans BOOLEAN)");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                    stm = null;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void open(String path) {
        try {
            this.close();
            if (!new File(path + DATAFILE_EXT).exists()) {
                return;
            }
            this.conn = DriverManager.getConnection("jdbc:h2:" + path, "sa", "");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int getTextUnitCount() {
        Statement stm = null;
        try {
            stm = this.conn.createStatement();
            String query = "SELECT COUNT(Key) FROM Source";
            ResultSet result = stm.executeQuery(query);
            if (!result.first()) {
                int n = 0;
                return n;
            }
            int n = result.getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stm != null) {
                    stm.close();
                    stm = null;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void addSourceEntry(TextContainer tc, int gKey, String tuId, String tuName, String tuType) {
        Statement pstm = null;
        try {
            pstm = this.conn.prepareStatement(String.format("INSERT INTO %s (%s,%s,%s,%s,%s,%s,%s,%s) VALUES(?,?,?,?,?,?,?,?);", TBLNAME_SOURCE, SOURCE_NTMP, SOURCE_NGKEY, SOURCE_NXKEY, SOURCE_NSEGKEY, SOURCE_NNAME, SOURCE_NTYPE, SOURCE_NTEXT, SOURCE_NCODES));
            pstm.setInt(1, 0);
            pstm.setInt(2, gKey);
            pstm.setString(3, tuId);
            pstm.setInt(4, 0);
            pstm.setString(5, tuName);
            pstm.setString(6, tuType);
            pstm.setString(7, TextContainer.contentToString(tc));
            pstm.setString(8, "");
            pstm.execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (pstm != null) {
                    pstm.close();
                    pstm = null;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public TextContainer findEntry(String name) {
        Statement pstm = null;
        try {
            TextContainer tc;
            pstm = this.conn.prepareStatement(String.format("SELECT %s,%s FROM %s WHERE %s=? ORDER BY %s", SOURCE_NTEXT, SOURCE_NCODES, TBLNAME_SOURCE, SOURCE_NNAME, SOURCE_NSEGKEY));
            pstm.setString(1, name);
            ResultSet result = pstm.executeQuery();
            if (!result.first()) {
                TextContainer textContainer = null;
                return textContainer;
            }
            TextContainer textContainer = tc = TextContainer.stringToContent(result.getString(1));
            return textContainer;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (pstm != null) {
                    pstm.close();
                    pstm = null;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

