/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.utilities.extraction;

import java.io.File;
import net.sf.okapi.applications.rainbow.packages.IWriter;
import net.sf.okapi.applications.rainbow.packages.omegat.Writer;
import net.sf.okapi.applications.rainbow.utilities.BaseFilterDrivenUtility;
import net.sf.okapi.applications.rainbow.utilities.extraction.HTMLReporter;
import net.sf.okapi.applications.rainbow.utilities.extraction.Parameters;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.lib.segmentation.SRXDocument;
import net.sf.okapi.lib.translation.QueryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utility
extends BaseFilterDrivenUtility {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private IWriter writer;
    private int id;
    private ISegmenter sourceSeg;
    private ISegmenter targetSeg;
    private QueryManager qm;
    private String resolvedOutputDir;
    private HTMLReporter htmlRpt;
    private boolean downgradeIdenticalBestMatches;
    private static final String HTML_REPORT_NAME = "report.html";

    public Utility() {
        this.needsSelfOutput = false;
    }

    @Override
    public String getName() {
        return "oku_extraction";
    }

    @Override
    public void preprocess() {
        if (this.params.preSegment) {
            String trg;
            String src = this.params.sourceSRX.replace("${ProjDir}", this.projectDir);
            SRXDocument doc = new SRXDocument();
            doc.loadRules(src);
            if (doc.hasWarning()) {
                this.logger.warn(doc.getWarning());
            }
            this.sourceSeg = doc.compileLanguageRules(this.srcLang, null);
            if (!Util.isEmpty(this.params.targetSRX) && !src.equalsIgnoreCase(trg = this.params.targetSRX.replace("${ProjDir}", this.projectDir))) {
                doc.loadRules(trg);
                if (doc.hasWarning()) {
                    this.logger.warn(doc.getWarning());
                }
            }
            this.targetSeg = doc.compileLanguageRules(this.trgLang, null);
        }
        this.downgradeIdenticalBestMatches = false;
        if (this.params.pkgType.equals("xliff")) {
            this.writer = new net.sf.okapi.applications.rainbow.packages.xliff.Writer();
            this.writer.setParameters(this.params.xliffOptions);
        } else if (this.params.pkgType.equals("omegat")) {
            this.writer = new Writer();
        } else if (this.params.pkgType.equals("rtf")) {
            this.writer = new net.sf.okapi.applications.rainbow.packages.rtf.Writer();
            this.downgradeIdenticalBestMatches = true;
        } else {
            throw new RuntimeException("Unknown package type: " + this.params.pkgType);
        }
        if (this.params.preTranslate) {
            this.qm = new QueryManager();
            this.qm.setLanguages(this.srcLang, this.trgLang);
            this.qm.setThreshold(this.params.threshold);
            this.qm.setRootDirectory(this.projectDir);
            this.qm.addAndInitializeResource(this.params.transResClass, null, this.params.transResParams);
            if (this.params.useTransRes2) {
                this.qm.addAndInitializeResource(this.params.transResClass2, null, this.params.transResParams2);
            }
            this.qm.setOptions(this.params.threshold, false, false, this.downgradeIdenticalBestMatches, null, 0, false);
        }
        this.resolvedOutputDir = this.params.outputFolder + File.separator + this.params.pkgName;
        this.resolvedOutputDir = this.resolvedOutputDir.replace("${ProjDir}", this.projectDir);
        Util.deleteDirectory(this.resolvedOutputDir, false);
        this.id = 0;
        String pkgId = this.params.makePackageID();
        this.writer.setInformation(this.srcLang, this.trgLang, Util.makeId(this.inputRoot), this.resolvedOutputDir, pkgId, this.inputRoot, this.params.preSegment, "rainbow");
        this.writer.writeStartPackage();
        this.htmlRpt = new HTMLReporter();
        this.htmlRpt.create(this.resolvedOutputDir + File.separator + HTML_REPORT_NAME);
    }

    @Override
    public void postprocess() {
        if (this.writer != null) {
            this.writer.writeEndPackage(this.params.createZip);
            this.writer = null;
        }
        if (this.qm != null) {
            this.qm.close();
            this.qm = null;
        }
        if (this.htmlRpt != null) {
            this.htmlRpt.close();
            this.htmlRpt = null;
        }
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean needsRoots() {
        return true;
    }

    @Override
    public void setParameters(IParameters paramsObject) {
        this.params = (Parameters)paramsObject;
    }

    @Override
    public boolean isFilterDriven() {
        return true;
    }

    public int requestInputCount() {
        return 1;
    }

    @Override
    public String getFolderAfterProcess() {
        return this.resolvedOutputDir;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument((StartDocument)event.getResource());
                break;
            }
            case END_DOCUMENT: {
                this.htmlRpt.endDocument();
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event.getTextUnit());
                break;
            }
            case RAW_DOCUMENT: {
                this.processFileResource((RawDocument)event.getResource());
                break;
            }
        }
        return this.writer.handleEvent(event);
    }

    private void processFileResource(RawDocument fr) {
        String relativeInput = this.getInputPath(0).substring(this.inputRoot.length() + 1);
        this.writer.createCopies(++this.id, relativeInput);
    }

    private void processStartDocument(StartDocument resource) {
        this.htmlRpt.startDocument(this.getInputPath(0));
        if (this.qm != null && this.params.useFileName) {
            this.qm.setAttribute("FileName", Util.getFilename(this.getInputPath(0), true));
        }
        String relativeInput = this.getInputPath(0).substring(this.inputRoot.length() + 1);
        String relativeOutput = this.getOutputPath(0).substring(this.outputRoot.length() + 1);
        String[] res = FilterConfigurationMapper.splitFilterFromConfiguration(this.getInputFilterSettings(0));
        if (this.params.pkgType.equals("rtf")) {
            ((net.sf.okapi.applications.rainbow.packages.rtf.Writer)this.writer).setSkeletonWriter(this.filter.createSkeletonWriter());
        }
        this.writer.createOutput(++this.id, relativeInput, relativeOutput, this.getInputEncoding(0), this.getOutputEncoding(0), res[0], resource.getFilterParameters(), resource.getFilterWriter().getEncoderManager());
    }

    private void processTextUnit(ITextUnit tu) {
        int n;
        if (!tu.isTranslatable()) {
            return;
        }
        boolean approved = false;
        Property prop = tu.getTargetProperty(this.trgLang, "approved");
        if (prop != null && "yes".equals(prop.getValue())) {
            approved = true;
        }
        TextContainer cont = null;
        if (this.params.preSegment && !approved) {
            try {
                cont = tu.getSource();
                if (!cont.hasBeenSegmented()) {
                    this.sourceSeg.computeSegments(cont);
                    cont.getSegments().create(this.sourceSeg.getRanges());
                }
                if (tu.hasTarget(this.trgLang) && !(cont = tu.getTarget(this.trgLang)).hasBeenSegmented()) {
                    this.targetSeg.computeSegments(cont);
                    cont.getSegments().create(this.targetSeg.getRanges());
                }
            }
            catch (Throwable e) {
                this.logger.error("Error segmenting text unit id={}: {}", (Object)tu.getId(), (Object)e.getMessage());
            }
        }
        this.htmlRpt.addSegmentCount((n = tu.getSource().getSegments().count()) == 0 ? 1 : n);
        if (this.qm != null && !approved) {
            if (this.params.useGroupName && tu.getName() != null) {
                this.qm.setAttribute("GroupName", tu.getName());
            }
            this.qm.leverage(tu);
            cont = tu.getTarget(this.trgLang);
            if (cont != null) {
                this.tallyResults(cont.getAnnotation(AltTranslationsAnnotation.class));
                for (Segment seg : cont.getSegments()) {
                    this.tallyResults(seg.getAnnotation(AltTranslationsAnnotation.class));
                }
            }
        }
    }

    private void tallyResults(AltTranslationsAnnotation atAnn) {
        if (atAnn == null) {
            return;
        }
        AltTranslation best = atAnn.getFirst();
        if (best != null) {
            if (best.getCombinedScore() > 99) {
                this.htmlRpt.addExactMatch(1);
            } else if (best.getCombinedScore() != 0) {
                this.htmlRpt.addFuzzyMatch(1);
            }
        }
    }
}

