/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.RegexUtil;
import net.sf.okapi.common.Util;

public final class StringUtil {
    private static int max(int x1, int x2) {
        return x1 > x2 ? x1 : x2;
    }

    private static int max(int x1, int x2, int x3, int x4) {
        return StringUtil.max(StringUtil.max(x1, x2), StringUtil.max(x3, x4));
    }

    private static TraceBack next(TraceBack tb, TraceBack[][] tba) {
        TraceBack tb2 = tb;
        return tba[tb2.i][tb2.j];
    }

    private static float calculateDiceCoefficient(int intersection, int size1, int size2) {
        return 2.0f * (float)intersection / (float)(size1 + size2) * 100.0f;
    }

    public static float LcsEditDistance(CharSequence seq1, CharSequence seq2) {
        int matches = 0;
        int d = 1;
        int n = seq1.length();
        int m = seq2.length();
        int[][] F = new int[n + 1][m + 1];
        TraceBack[][] T = new TraceBack[n + 1][m + 1];
        int s = 0;
        int maxi = n;
        int maxj = m;
        int maxval = Integer.MIN_VALUE;
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                int val;
                s = 0;
                if (seq1.charAt(i - 1) == seq2.charAt(j - 1)) {
                    s = 2;
                }
                F[i][j] = val = StringUtil.max(0, F[i - 1][j - 1] + s, F[i - 1][j] - d, F[i][j - 1] - d);
                if (val == 0) {
                    T[i][j] = null;
                } else if (val == F[i - 1][j - 1] + s) {
                    T[i][j] = new TraceBack(i - 1, j - 1);
                } else if (val == F[i - 1][j] - d) {
                    T[i][j] = new TraceBack(i - 1, j);
                } else if (val == F[i][j - 1] - d) {
                    T[i][j] = new TraceBack(i, j - 1);
                }
                if (val <= maxval) continue;
                maxval = val;
                maxi = i;
                maxj = j;
            }
        }
        TraceBack start = new TraceBack(maxi, maxj);
        matches = 0;
        TraceBack tb = start;
        int i = tb.i;
        int j = tb.j;
        while ((tb = StringUtil.next(tb, T)) != null) {
            i = tb.i;
            j = tb.j;
            if (seq1.charAt(i) != seq2.charAt(j)) continue;
            ++matches;
        }
        return StringUtil.calculateDiceCoefficient(matches, seq1.length(), seq2.length());
    }

    public static String titleCase(String st) {
        if (Util.isEmpty(st)) {
            return st;
        }
        return st.substring(0, 1).toUpperCase() + st.substring(1).toLowerCase();
    }

    public static String removeQualifiers(String st, String startQualifier, String endQualifier) {
        if (Util.isEmpty(st)) {
            return st;
        }
        if (Util.isEmpty(startQualifier)) {
            return st;
        }
        if (Util.isEmpty(endQualifier)) {
            return st;
        }
        int startQualifierLen = startQualifier.length();
        int endQualifierLen = endQualifier.length();
        if (st.startsWith(startQualifier) && st.endsWith(endQualifier)) {
            return st.substring(startQualifierLen, Util.getLength(st) - endQualifierLen);
        }
        return st;
    }

    public static String removeQualifiers(String st, String qualifier) {
        if (Util.isEmpty(st) || Util.isEmpty(qualifier)) {
            return st;
        }
        int qualifierLen = qualifier.length();
        if (st.startsWith(qualifier) && st.endsWith(qualifier)) {
            return st.substring(qualifierLen, Util.getLength(st) - qualifierLen);
        }
        return st;
    }

    public static String removeQualifiers(String st) {
        return StringUtil.removeQualifiers(st, "\"");
    }

    public static String normalizeLineBreaks(String string) {
        String res = string;
        if (!Util.isEmpty(res)) {
            res = res.replaceAll("\r\r\n", "\n");
            res = res.replace("\r\n", "\n");
            res = res.replace("\r", "\n");
        }
        return res;
    }

    private static boolean checkRegex(String regex) {
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    public static String normalizeWildcards(String string) {
        if (Util.isEmpty(string)) {
            return string;
        }
        if (!StringUtil.containsWildcards(string)) {
            return string;
        }
        String normalized = string.replaceAll("\\?", ".").replaceAll("\\*", ".*?");
        return StringUtil.checkRegex(normalized) ? normalized : string;
    }

    public static boolean containsWildcards(String string) {
        if (Util.isEmpty(string)) {
            return false;
        }
        return string.indexOf(42) != -1 || string.indexOf(63) != -1;
    }

    public static boolean matchesWildcard(String string, String pattern, boolean filenameMode) {
        if (filenameMode) {
            String filename = Util.getFilename(string, true);
            String patternFilename = Util.getFilename(pattern, true);
            String filePath = Util.getDirectoryName(string);
            String patternFilePath = Util.getDirectoryName(pattern);
            boolean pathMatches = Util.isEmpty(patternFilePath) ? true : Pattern.matches(StringUtil.normalizeWildcards(patternFilePath), filePath);
            boolean filenameMatches = Pattern.matches(StringUtil.normalizeWildcards(patternFilename), filename);
            return pathMatches && filenameMatches;
        }
        return Pattern.matches(StringUtil.normalizeWildcards(pattern), string);
    }

    public static boolean matchesWildcard(String string, String pattern) {
        return StringUtil.matchesWildcard(string, pattern, false);
    }

    public static String[] split(String string, String delimRegex, int group) {
        String delimPlaceholder = "<delimiter>";
        string = RegexUtil.replaceAll(string, delimRegex, group, delimPlaceholder);
        return ListUtil.stringAsArray(string, delimPlaceholder);
    }

    public static String[] split(String string, String delimRegex) {
        return StringUtil.split(string, delimRegex, 0);
    }

    public static int getNumOccurrences(String str, String substr) {
        String temp = str;
        int count = 0;
        int i = temp.indexOf(substr);
        while (i >= 0) {
            ++count;
            temp = temp.substring(i + 1);
            i = temp.indexOf(substr);
        }
        return count;
    }

    public static boolean isWhitespace(String str) {
        if (Util.isEmpty(str)) {
            return false;
        }
        return "".equals(str.trim());
    }

    public static String getString(int length, char c) {
        if (length < 0) {
            length = 0;
        }
        char[] chars = new char[length];
        Arrays.fill(chars, c);
        return new String(chars);
    }

    public static String padString(String string, int startPos, int endPos, char padder) {
        if (startPos < 0) {
            startPos = 0;
        }
        char[] chars = string.toCharArray();
        for (int i = startPos; i < Math.min(endPos, string.length()); ++i) {
            chars[i] = padder;
        }
        return new String(chars);
    }

    public static String substring(String string, int start, int end) {
        int len = string.length();
        if (start < 0) {
            return null;
        }
        if (end < 0) {
            return null;
        }
        if (start > len) {
            return null;
        }
        if (end > len) {
            end = len;
        }
        if (start > end) {
            return null;
        }
        return string.substring(start, end);
    }

    public static String charsToString(Set<Character> set) {
        char[] chars = new char[set.size()];
        int i = 0;
        for (Character ch : set) {
            chars[i++] = ch.charValue();
        }
        return String.valueOf(chars);
    }

    public static String mirrorString(String str) {
        StringBuffer buffer = new StringBuffer(str).reverse();
        return buffer.toString();
    }

    private static class TraceBack {
        public int i;
        public int j;

        public TraceBack(int i, int j) {
            this.i = i;
            this.j = j;
        }
    }
}

