/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.json;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;

public class Parameters
extends BaseParameters {
    private static final String EXTRACTISOLATEDSTRINGS = "extractIsolatedStrings";
    private static final String EXTRACTALLPAIRS = "extractAllPairs";
    private static final String EXCEPTIONS = "exceptions";
    private static final String USEKEYASNAME = "useKeyAsName";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private boolean extractStandalone;
    private boolean extractAllPairs;
    private String exceptions;
    private boolean useKeyAsName;
    private boolean useCodeFinder;
    private InlineCodeFinder codeFinder = new InlineCodeFinder();

    public Parameters() {
        this.reset();
        this.toString();
    }

    public boolean getExtractStandalone() {
        return this.extractStandalone;
    }

    public void setExtractStandalone(boolean extractStandalone) {
        this.extractStandalone = extractStandalone;
    }

    public boolean getExtractAllPairs() {
        return this.extractAllPairs;
    }

    public void setExtractAllPairs(boolean extractAllPairs) {
        this.extractAllPairs = extractAllPairs;
    }

    public String getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(String exceptions) {
        this.exceptions = exceptions;
    }

    public boolean getUseKeyAsName() {
        return this.useKeyAsName;
    }

    public void setUseKeyAsName(boolean useKeyAsName) {
        this.useKeyAsName = useKeyAsName;
    }

    public boolean getUseCodeFinder() {
        return this.useCodeFinder;
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.useCodeFinder = useCodeFinder;
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public String getCodeFinderData() {
        return this.codeFinder.toString();
    }

    public void setCodeFinderData(String data) {
        this.codeFinder.fromString(data);
    }

    @Override
    public void reset() {
        this.extractStandalone = false;
        this.extractAllPairs = true;
        this.exceptions = "";
        this.useKeyAsName = true;
        this.useCodeFinder = false;
        this.codeFinder.reset();
        this.codeFinder.setSample("&name; <tag></at><tag/> <tag attr='val'> </tag=\"val\">");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("</?([A-Z0-9a-z]*)\\b[^>]*>");
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.extractStandalone = this.buffer.getBoolean(EXTRACTISOLATEDSTRINGS, this.extractStandalone);
        this.extractAllPairs = this.buffer.getBoolean(EXTRACTALLPAIRS, this.extractAllPairs);
        this.exceptions = this.buffer.getString(EXCEPTIONS, this.exceptions);
        this.useKeyAsName = this.buffer.getBoolean(USEKEYASNAME, this.useKeyAsName);
        this.useCodeFinder = this.buffer.getBoolean(USECODEFINDER, this.useCodeFinder);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(EXTRACTISOLATEDSTRINGS, this.extractStandalone);
        this.buffer.setBoolean(EXTRACTALLPAIRS, this.extractAllPairs);
        this.buffer.setString(EXCEPTIONS, this.exceptions);
        this.buffer.setBoolean(USEKEYASNAME, this.useKeyAsName);
        this.buffer.setBoolean(USECODEFINDER, this.useCodeFinder);
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return this.buffer.toString();
    }
}

