/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mosestext;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=FilterWriterParameters.class)
public class FilterWriterParameters
extends BaseParameters
implements IEditorDescriptionProvider {
    public static final String NAME = "Moses InlineText Extraction";
    private static final String SOURCEANDTARGET = "sourceAndTarget";
    private boolean sourceAndTarget;

    public FilterWriterParameters() {
        this.reset();
    }

    public boolean getSourceAndTarget() {
        return this.sourceAndTarget;
    }

    public void setSourceAndTarget(boolean sourceAndTarget) {
        this.sourceAndTarget = sourceAndTarget;
    }

    @Override
    public void reset() {
        this.sourceAndTarget = false;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.sourceAndTarget = this.buffer.getBoolean(SOURCEANDTARGET, this.sourceAndTarget);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(SOURCEANDTARGET, this.sourceAndTarget);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(SOURCEANDTARGET, "Create two outputs: one for the source and one for the target", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription(NAME, true, false);
        desc.addCheckboxPart(paramDesc.get(SOURCEANDTARGET));
        return desc;
    }
}

