/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.ttx;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    public static final int MODE_AUTO = 0;
    public static final int MODE_EXISTINGSEGMENTS = 1;
    public static final int MODE_ALL = 2;
    private static final String SEGMENTMODE = "segmentMode";
    private boolean escapeGT;
    private int segmentMode;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public boolean getEscapeGT() {
        return this.escapeGT;
    }

    public void setEscapeGT(boolean escapeGT) {
        this.escapeGT = escapeGT;
    }

    public int getSegmentMode() {
        return this.segmentMode;
    }

    public void setSegmentMode(int segmentMode) {
        this.segmentMode = segmentMode;
    }

    @Override
    public void reset() {
        this.escapeGT = false;
        this.segmentMode = 0;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.escapeGT = this.buffer.getBoolean("escapeGT", this.escapeGT);
        this.segmentMode = this.buffer.getInteger(SEGMENTMODE, this.segmentMode);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean("escapeGT", this.escapeGT);
        this.buffer.setInteger(SEGMENTMODE, this.segmentMode);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add("escapeGT", "Escape the greater-than characters in output", null);
        desc.add(SEGMENTMODE, "Extraction mode", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("TTX Filter Parameters", true, false);
        String[] values = new String[]{String.valueOf(0), String.valueOf(1), String.valueOf(2)};
        String[] labels = new String[]{"Auto-detect existing segments (If found: extract only those, otherwise extract all)", "Extract only existing segments", "Extract all (existing segments and un-segmented text parts)"};
        ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(SEGMENTMODE), values);
        lsp.setChoicesLabels(labels);
        desc.addCheckboxPart(paramDesc.get("escapeGT"));
        return desc;
    }
}

