/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.transifex;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String SERVER = "server";
    private static final String PROJECTID = "projectId";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private String server;
    private String projectId;
    private String user;
    private String password;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public Parameters(String initialData) {
        this.fromString(initialData);
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.server = this.buffer.getString(SERVER, this.server);
        this.projectId = this.buffer.getString(PROJECTID, this.projectId);
        this.user = this.buffer.getString(USER, this.user);
        this.password = this.buffer.getEncodedString(PASSWORD, this.password);
    }

    @Override
    public void reset() {
        this.server = "http://www.transifex.net/";
        this.projectId = "";
        this.user = "";
        this.password = "";
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(SERVER, this.server);
        this.buffer.setString(PROJECTID, this.projectId);
        this.buffer.setString(USER, this.user);
        this.buffer.setEncodedString(PASSWORD, this.password);
        return this.buffer.toString();
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        if (server.endsWith("\\")) {
            server = server.substring(0, server.length() - 1) + "/";
        } else if (!server.endsWith("/")) {
            server = server + "/";
        }
        this.server = server;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(SERVER, "Server URL", "Full URL of the server (e.g. http://www.transifex.net/)");
        desc.add(USER, "User name", "User name to login");
        desc.add(PASSWORD, "Password", "Password to login");
        desc.add(PROJECTID, "Project ID", "Identifier of the project (case sensitive)");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Transifex Settings");
        desc.addTextInputPart(paramsDesc.get(SERVER));
        desc.addTextInputPart(paramsDesc.get(USER));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(PASSWORD));
        tip.setPassword(true);
        desc.addTextInputPart(paramsDesc.get(PROJECTID));
        return desc;
    }
}

